// --------------------------------------------------------------
// SAS Institute, Inc.
// Copyright (c) 2004-2007 SAS Institute, Inc.  All rights reserved.
//
// Name:    citation_builder.js
// Purpose: JavaScript functions for edit report page of 
//          Web Report Studio 
// --------------------------------------------------------------
wrsRequire("citation", SCRIPT_DIR, "citation_builder");
wrsRequire("citation_dialogUtils", SCRIPT_DIR, "citation_builder");
wrsProvide("citation_builder");

// ++++++++++++++++++++++++++ begin Namespace objects   +++++++++++++++++++++
var WrsEdit = { };
WrsEdit.dialog = { };
WrsEdit.layout = { };
WrsEdit.buttons = { };
WrsEdit.popups = { };
WrsEdit.menu = { };
// ++++++++++++++++++++++++++ end Namespace objects     +++++++++++++++++++++

WRSReportBuilder.prototype.getForm = function()
{
    return document.forms["reportBuilderForm"];
}
WRSReportBuilder.prototype.getBase = function ()
{
     return this._actionPathBase;
}
WRSReportBuilder.prototype.getContextPath = function ()
{
     return this._contextPath;
}
function WRSReportBuilder() 
{
    this._contextPath = null;
    this._actionPathBase = null;
    this._builderForm = null;
    this._selectionState = null;
}
WRSReportBuilder.prototype.submitForm = function (actionHandlerPath) {
    var objForm = this.getForm();
    var context = this.getContextPath();
    if (dojo.lang.isObject(objForm))
    {
        showDebugMsgs("rsSubmit", "calling " + context + actionHandlerPath);  
        objForm.action = context + actionHandlerPath;
        objForm.target = "_self";
        objForm.submit();
    } 
}
WRSReportBuilder.prototype.getCells = function () {
   return g_layoutCells;
}   
WRSReportBuilder.prototype.getElements = function () {
   return g_layoutElements;
}

// The report builder instance for the current page 
// Instance variables to be filled in by the JSP.
g_wrsReportBuilder = new WRSReportBuilder(); 

// =======================================================
// rsSubmit - used extensively to submit the builder form
// asynchronously, usually to transmit editor state before
// opening a dialog.  
// =======================================================
function rsSubmit(actionHandlerPath, 
                  callbackFunctionName, // a string, not a function object;
                  callbackFunctionArg1, // both args are passed to the 
                  callbackFunctionArg2) // callback function
{
    var objForm = g_wrsReportBuilder.getForm();
    if ( objForm == null ) {
         showDebugMsgs("rsSubmit", "invalid form object for submission");
       return;
    }  
    
    if (actionHandlerPath.indexOf("/") == 0)
       actionHandlerPath = actionHandlerPath.substring(1,actionHandlerPath.length);
       
    var ajaxURL = ReportControl.attachUrlParms(actionHandlerPath, "session=required");
    dojo.io.bind( {
         method: "POST",
         url: ajaxURL,
         preventCache: true,
         formNode: objForm,
         error: function (type, data, evt) {
                     showDebugMsgs(
                        "ERROR: rsSubmit", 
                        "ERROR Returned from call." + data.message + evt);
                },
         load: function(type, data, evt) {
                    showDebugMsgs("Back from rsSubmit ", callbackFunctionName);
                    if (handleSessionTimeout(data, evt)) return;
                    (eval(callbackFunctionName))(callbackFunctionArg1, callbackFunctionArg2);
                    showDebugMsgs("Back from rsSubmit and from:", callbackFunctionName);
                    // alert("check messages");
                 }
         });          
    return;
}

var g_forceReloadCurrentPage = new Object();

function forceReloadCurrentPage() 
{
    if (g_forceReloadCurrentPage && g_forceReloadCurrentPage.newLocation) { // S0421920
        var newLocation = g_forceReloadCurrentPage.newLocation;
        // need unique value of some kind to override caching.
        newLocation = newLocation.replace(/\.do\s*$/i,
                                          (".do?N" + (new Date()).getTime().toString() + "=true"));
        location.href = newLocation;
    }
}

WrsEdit.toViewFromBuilder = function()
{
    g_wrsReportBuilder.submitForm("/builderToView.do"); //see builderContent.jsp
    onLeavePage(); //see citation.js
}
WrsEdit.addLayoutElement = function(elementType) 
{
    // first...see if there is a cell we can assign to this
    // new element before we just send it off to the server
    // to redraw the page.
    for (var iCellInfo = 0; iCellInfo < g_layoutCellInfo.length; iCellInfo++)
    {
        var info = g_layoutCellInfo[iCellInfo];
        if (info != null & info.empty == true) {
            WrsEdit.layout.addElementAt(elementType, iCellInfo);
            return;
        }
    }
    // do it the hard way...needs more cells in the layout.
    document.body.style.cursor = "wait";
    findDOM("dndLayoutGridArea").style.cursor = "wait";
    rsSubmit("/sendEditorState.do", "WrsEdit.addLayoutElementRedraw", elementType);
}
WrsEdit.addLayoutElementRedraw = function (elementType) {
    var addUrl = 'builderAddLayoutElement.do?type='+elementType;
    dojo.io.bind({
        method: "POST",
        url: addUrl
    });
    location.href = 'openRBCurrent.do';
}
WrsEdit.addLayoutElementAtRedraw = function (elementType, dropZone)  {
    var addUrl = 'builderAddLayoutElement.do?type=' + elementType + "&zone=" + dropZone;
    dojo.io.bind({
        method: "POST",
        url: addUrl
    });
    location.href = 'openRBCurrent.do';
}
WrsEdit.dialog.GraphLinkPrompts = function () {
    rsSubmit("/sendEditorState.do", 
         "WrsEdit.dialog.linkPromptsDialog", 
            cwDialogManager.BUILDER_DEFINE_GRAPH_PROMPT, 
         "builderGraphLinkPrompts.do?dialogCommand=openDialog" );
}
WrsEdit.dialog.tableLinkPrompts = function () {
    rsSubmit("/sendEditorState.do", 
         "WrsEdit.dialog.linkPromptsDialog", 
            cwDialogManager.BUILDER_DEFINE_TABLE_PROMPT, 
         "builderTableLinkPrompts.do?dialogCommand=openDialog");
}
WrsEdit.dialog.groupLinkPrompts = function () {
    rsSubmit("/sendEditorState.do", 
         "WrsEdit.dialog.linkPromptsDialog", 
            cwDialogManager.BUILDER_DEFINE_GROUP_PROMPT, 
         "builderGroupLinkPrompts.do?dialogCommand=openDialog");
}
WrsEdit.dialog.textLinkPrompts = function () {
    rsSubmit("/sendEditorState.do", 
         "WrsEdit.dialog.linkPromptsDialog", 
            cwDialogManager.BUILDER_DEFINE_TEXT_PROMPT, 
         "builderTextLinkPrompts.do?dialogCommand=openDialog");
}
WrsEdit.dialog.imageLinkPrompts = function () {
    rsSubmit("/sendEditorState.do", 
         "WrsEdit.dialog.linkPromptsDialog", 
            cwDialogManager.BUILDER_DEFINE_IMAGE_PROMPT, 
         "builderImageLinkPrompts.do?dialogCommand=openDialog");
}
WrsEdit.dialog.mapLinkPrompts = function () {
    rsSubmit("/sendEditorState.do", 
         "WrsEdit.dialog.linkPromptsDialog", 
            cwDialogManager.BUILDER_DEFINE_IMAGE_PROMPT, 
         "builderImageLinkPrompts.do?dialogCommand=openDialog");
}
WrsEdit.dialog.linkPromptsDialog = function(name, url) {
   cwDialogManager.openDialog(
      url, //dlgUrl
      name, //dlgName
      cwDialogManager.BUILDER_DEFINE_PROMPT, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal
      false //bReplaceIfOpen
   );
}
// Following is called from either the section menu or from section tabs 
WrsEdit.changeSection = function (sectionNumber){
    var changeSectionUrl = g_wrsReportBuilder._changeSectionUrl + sectionNumber;
    // showDebugMsgs("WrsEdit.changeSection", changeSectionUrl);
    g_reportControl.updateWindow(changeSectionUrl);
}
WrsEdit.menu.saveReport = function () { 
   if (g_wrsReportBuilder._isReportSavable) { 
      alert(g_wrsReportBuilder._isReportSavableMsg);
   } else {
      rsSubmit("/sendEditorState.do", "WrsEdit.dialog.save", "");
   }
}
WrsEdit.dialog.save = function (args) { 
    openSaveDialog(WrsEdit.dialog.saveComplete);
}
WrsEdit.dialog.saveComplete = function (closingEvt) {

/* -------------------
 cout script below as it is redundant as long as window.location.replace is called in final step

    if (closingEvt != null) {
        var dlgClosing = closingEvt.sas_target;
        var dlgWindow = dlgClosing.dlgWindow;
        var refreshConversionType = dlgWindow.g_refreshConversionType;
        var reportName = dlgWindow.g_reportName;
        redrawReportName(reportName);        
    } 
------------ */
    forceReloadCurrentPage();
}
WrsEdit.imageLinking = function (index) {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.imageLinking", index);
}
WrsEdit.dialog.imageLinking = function (index) {
   cwDialogManager.openDialog(
      "builderImageLinking.do?index="+index+"&dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_IMAGE_LINK, //dlgName
      cwDialogManager.BUILDER_IMAGE_LINK, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal
      false //bReplaceIfOpen
   );
}
WrsEdit.groupBreakLinking = function () {
   WrsEdit.layout.deselectAll();
   rsSubmit("/sendEditorState.do", "WrsEdit.dialog.groupBreakLinking");
}
WrsEdit.dialog.groupBreakLinking = function () {
   cwDialogManager.openDialog(
      "builderByGroupLinking.do?dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_BY_GROUP_LINK, //dlgName
      cwDialogManager.BUILDER_BY_GROUP_LINK, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal
      false //bReplaceIfOpen
   );
}
WrsEdit.tableLinking = function (index) {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.tableLinking", index);
}
WrsEdit.dialog.tableLinking = function (index) {
   cwDialogManager.openDialog(
      "builderTableLinking.do?index="+index+"&dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_TABLE_LINK, //dlgName
      cwDialogManager.BUILDER_TABLE_LINK, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal
      false, //bReplaceIfOpen
      null,
      WrsEdit.sendStateReplaceGrid // in case visual indication is given that table has link
   );
}
WrsEdit.graphLinking = function (index) {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.graphLinking", index);
}
WrsEdit.dialog.graphLinking = function (index) {
   cwDialogManager.openDialog(
      "builderGraphLinking.do?index="+index+"&dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_GRAPH_LINK, //dlgName
      cwDialogManager.BUILDER_GRAPH_LINK, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal
      false, //bReplaceIfOpen
      null,
      WrsEdit.sendStateReplaceGrid // in case visual indication is given that table has link
   );
}
WrsEdit.mapLinking = function(index) {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.mapLinking", index);
}
WrsEdit.dialog.mapLinking = function (index) {
   cwDialogManager.openDialog(
      "builderMapLinking.do?index="+index+"&dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_MAP_LINK, //dlgName
      cwDialogManager.BUILDER_MAP_LINK, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal
      false //bReplaceIfOpen
   );
}
WrsEdit.editImage = function (index) {
   cwDialogManager.openDialog(
      "builderImageProperties.do?index="+index+"&dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_EDIT_IMAGE, //dlgName
      cwDialogManager.BUILDER_EDIT_IMAGE, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal
      false, //bReplaceIfOpen
      null,
      WrsEdit.sendStateReplaceGrid
   );
}
WrsEdit.sendStateReplaceGrid = function (evt) {
   showDebugMsgs("sendStateReplaceGrid", evt);
   window.setTimeout( (function(evt){WrsEdit.sendStateReplaceGrid2(evt);}), 100);
}
WrsEdit.sendStateReplaceGrid2 = function (evt) {
   var sendUrl = "getEditorLayoutGrid.do";
   var sendForm = g_wrsReportBuilder.getForm();
   if ( sendForm == null ) {
      showDebugMsgs("sendStateReplaceGrid", "invalid form object for submission");
      return;
   }  
   dojo.io.bind({
      method: "POST",
      transport: "XMLHTTPTransport",
      url: sendUrl,
      preventCache: true,
      formNode: sendForm,
      error: function (type, data, evt) {
                  showDebugMsgs(
                     "ERROR: WrsEdit.sendStateReplaceGrid", 
                     "ERROR Returned from call." + data.message + evt);
             },
      load: function (type, data, evt) { 
                  showDebugMsgs("WrsEdit.sendStateReplaceGrid", "Successful return from call.");
                  WrsEdit.layout.replaceLayoutGrid(data);
              }         
      });  
}
WrsEdit.editText = function (index) {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.editText", index);
}
WrsEdit.dialog.editText = function (index) {
   cwDialogManager.openDialog(
      "builderEditText.do?index="+index+"&dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_EDIT_TEXT, //dlgName
      cwDialogManager.BUILDER_EDIT_TEXT, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal
      false, //bReplaceIfOpen
      null, //onDlgClosing
      WrsEdit.sendStateReplaceGrid //function instance to call when dlg successfully closed                        
   );
}
WrsEdit.graphProperties = function (index) {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.graphProperties", index);
}
WrsEdit.dialog.graphProperties = function (index) {
    cwDialogManager.openDialog(
      "builderGraphProperties.do?index="+index+"&dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_GRAPH_PROPERTIES, //dlgName
      cwDialogManager.BUILDER_GRAPH_PROPERTIES, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      WrsEdit.sendStateReplaceGrid //forceReloadCurrentPage //function instance to call when dlg successfully closed                        
   );
}
WrsEdit.mapProperties = function (index) {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.mapProperties", index);
}
WrsEdit.dialog.mapProperties = function (index) {
   cwDialogManager.openDialog(
      "builderMapProperties.do?index="+index+"&dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_MAP_PROPERTIES, //dlgName
      cwDialogManager.BUILDER_MAP_PROPERTIES, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      WrsEdit.sendStateReplaceGrid //function instance to call when dlg successfully closed                        
   );
}
WrsEdit.tileProperties = function (index) {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.tileProperties", index);
}
WrsEdit.dialog.tileProperties = function (index) {
   cwDialogManager.openDialog(
      "builderTileProperties.do?index="+index+"&dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_TILE_PROPERTIES, //dlgName
      cwDialogManager.BUILDER_TILE_PROPERTIES, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      WrsEdit.sendStateReplaceGrid //function instance to call when dlg successfully closed                        
   );
}
WrsEdit.tableProperties = function (index) {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.tableProperties", index);
}
WrsEdit.dialog.tableProperties = function (index) {
   cwDialogManager.openDialog(
      "builderTableProperties.do?index="+index+"&dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_TABLE_PROPERTIES, //dlgName
      cwDialogManager.BUILDER_TABLE_PROPERTIES, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      WrsEdit.sendStateReplaceGrid //function instance to call when dlg successfully closed                        
   );
}
WrsEdit.sort = function (index) {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.sortData", index);
}
WrsEdit.dialog.sortData = function (index) {
   cwDialogManager.openDialog(
      "builderSort.do?index="+index+"&dialogCommand=openDialog", //dlgUrl
      cwDialogManager.SORT, //dlgName
      cwDialogManager.SORT, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      WrsEdit.sendStateReplaceGrid //function instance to call when dlg successfully closed
   );
}
WrsEdit.sortSynchronized = function() {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.sortDataSynchronized");
}
WrsEdit.dialog.sortDataSynchronized = function() {
   cwDialogManager.openDialog(
      "builderSort.do?index=0&dialogCommand=openDialog", //dlgUrl
      cwDialogManager.SORT, //dlgName
      cwDialogManager.SORT, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      WrsEdit.sendStateReplaceGrid //function instance to call when dlg successfully closed
   );
}
WrsEdit.exceptionHighlighting = function (index) {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.exceptionHighlighting", index);
}
WrsEdit.dialog.exceptionHighlighting = function (index) {
   cwDialogManager.openDialog(
      "launchExceptionHighlighting.do?index="+index+"&dialogCommand=openDialog", //dlgUrl
      cwDialogManager.EXCEPTION_HIGHLIGHTING, //dlgName
      cwDialogManager.EXCEPTION_HIGHLIGHTING, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      WrsEdit.sendStateReplaceGrid //function instance to call when dlg successfully closed
   );
}
WrsEdit.exceptionHighlightingChart = function (index) {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.exceptionHighlightingChart", index);
}
WrsEdit.dialog.exceptionHighlightingChart = function (index) {
   cwDialogManager.openDialog(
      "launchExceptionHighlightingChart.do?index="+index+"&dialogCommand=openDialog", //dlgUrl
      cwDialogManager.EXCEPTION_HIGHLIGHTING_CHART, //dlgName
      cwDialogManager.EXCEPTION_HIGHLIGHTING_CHART, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      WrsEdit.sendStateReplaceGrid //function instance to call when dlg successfully closed
   );
}
WrsEdit.filterRank = function (index) {
   rsSubmit('/sendEditorState.do', 'WrsEdit.filterRankReturn', index);   
}
WrsEdit.filterRankReturn = function (index) {
    WrsEdit.dialog.filterRank('launchFilterRank.do?index=' + index);
}
// This function has to reload the page in order to get synchronize status correct
WrsEdit.dialog.filterRank = function (actionUrl) {
   cwDialogManager.openDialog(
      actionUrl, //dlgUrl
      cwDialogManager.RANK_FILTER, // 'cwBuilderRankFilter', //dlgName
      cwDialogManager.RANK_FILTER, //dlgFeatures
      true, //bReplaceUrl
      true, //modal
      false, //bReplaceIfOpen
      null, //onDlgClosing
      WrsEdit.sendStateReplaceGrid //function instance to call when dlg successfully closed
   );
}
WrsEdit.total = function (index, dlgFeaturesAndName) {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.total", index, dlgFeaturesAndName);
}
WrsEdit.dialog.total = function (index, dlgFeaturesAndName) {
   
   var dlgFeatures = cwDialogManager.TOTALS;
   var dlgName = cwDialogManager.TOTALS;
   
   if (dlgFeaturesAndName != 'undefined' && dlgFeaturesAndName != null )
   {
      dlgFeatures = dlgFeaturesAndName; 
      dlgName = dlgFeaturesAndName;
   }
   
   cwDialogManager.openDialog(
      "builderTableTotalsDialog.do?index="+index+"&dialogCommand=openDialog", //dlgUrl
      dlgName, //dlgName
      dlgFeatures, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      WrsEdit.sendStateReplaceGrid //function instance to call when dlg successfully closed
   );
}

WrsEdit.percentTotalSynchronizedWarn = function (warningMessage) 
{
   if (!confirm(warningMessage))
      return;

   //var radioMenuItem = new WrsMenuItem(citationDataButton_popup, "dataIndependentMenuItem");
   //radioMenuItem.setRadioChecked();
   // S0647708:
   var checkboxMenuItem = new WrsMenuItem(citationDataButton_popup, "dataSynchronizedMenuItem");
   checkboxMenuItem.setCheckboxChecked(false);
   
   rsSubmit('/sendEditorState.do','cwMenuBarIndependantSectionConfirmed');  
}

WrsEdit.dialog.percentTotal = function (index) {
   cwDialogManager.openDialog(
      "percentItem.do?index="+index+"&dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_PERCENT_DATA, //dlgName
      cwDialogManager.BUILDER_PERCENT_DATA, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      WrsEdit.sendStateReplaceGrid //function instance to call when dlg successfully closed
   );
}
WrsEdit.tableData = function (index) {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.tableData", index);
}
WrsEdit.dialog.tableData = function (index) {
   cwDialogManager.openDialog(
      "builderTableData.do?index="+index+"&dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_TABLE_DATA, //dlgName
      cwDialogManager.BUILDER_TABLE_DATA, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      WrsEdit.sendStateReplaceGrid //function instance to call when dlg successfully closed
   );
}
WrsEdit.graphData = function (index) {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.graphData", index);
}
WrsEdit.dialog.graphData = function (index) {
   cwDialogManager.openDialog(
      "builderGraphData.do?index="+index+"&dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_GRAPH_DATA, //dlgName
      cwDialogManager.BUILDER_GRAPH_DATA, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      WrsEdit.sendStateReplaceGrid //function instance to call when dlg successfully closed
   );
}
WrsEdit.geomapData = function (index) {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.geomapData", index);
}
WrsEdit.dialog.geomapData = function (index) {
   cwDialogManager.openDialog(
      "builderGeomapData.do?index="+index+"&dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_GEOMAP_DATA, //dlgName
      cwDialogManager.BUILDER_GEOMAP_DATA, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      WrsEdit.sendStateReplaceGrid //function instance to call when dlg successfully closed
   );
}
WrsEdit.groupBreaks = function () {
    WrsEdit.layout.deselectAll()
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.groupBreaks");
}
WrsEdit.dialog.groupBreaks = function () {
   cwDialogManager.openDialog(
      "builderGroupBreaks.do?dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_GROUP_BREAKS, //dlgName
      cwDialogManager.BUILDER_GROUP_BREAKS, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      forceReloadCurrentPage //function instance to call when dlg successfully closed                             
   );
}
WrsEdit.sendStateReplaceArea = function (evt, part) {
   var sendUrl = 
      (part == "header") ? "getEditorLayoutHeader.do" : "getEditorLayoutFooter.do";
   var sendForm = g_wrsReportBuilder.getForm();
   if ( sendForm == null ) {
      showDebugMsgs("sendStateReplacePart", "invalid form object for submission");
      return;
   }  
   dojo.io.bind({
      method: "POST",
      transport: "XMLHTTPTransport",
      url: sendUrl,
      preventCache: true,
      formNode: sendForm,
      error: function (type, data, evt) {
                  showDebugMsgs(
                     "ERROR: WrsEdit.sendStateReplacePart " + part, 
                     "ERROR Returned from call." + data.message + evt);
             },
      load: function (type, data, evt) { 
                  showDebugMsgs("WrsEdit.sendStateReplacePart " + part, "Successful return from call.");
                  try {
                     if (part == "header") {
                           // WrsEdit.layout.replaceLayoutHeader(data);
                     } else if (part == "footer") {
                           // WrsEdit.layout.replaceLayoutFooter(data);
                     }
                     WrsEdit.layout.replaceHeaderFooter(part,data);
                  } catch (e) {
                     showDebugMsgs("WrsEdit.sendStateReplacePart " + part, "error in replace" + e.message + "\n" + data);
                  }
              }         
      });  
}
WrsEdit.header = function () {
    WrsEdit.layout.deselectAll();
    // rsSubmit("/sendEditorState.do", "WrsEdit.dialog.header");
    // }
    // WrsEdit.dialog.header = function () {
   cwDialogManager.openDialog(
      "builderHeader.do?dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_HEADER_FOOTER, //dlgName
      cwDialogManager.BUILDER_HEADER_FOOTER, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      // forceReloadCurrentPage
      WrsEdit.sendStateReplaceHeader //function instance to call when dlg successfully closed                            
   );
}
WrsEdit.sendStateReplaceHeader = function (evt) {
   showDebugMsgs("sendStateReplaceHeader", evt);
   window.setTimeout( (function(evt){WrsEdit.sendStateReplaceArea(evt, "header");}), 500);
}
WrsEdit.footer = function () {
    WrsEdit.layout.deselectAll();
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.footer");
}
WrsEdit.dialog.footer = function () {
   cwDialogManager.openDialog(
      "builderFooter.do?dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_HEADER_FOOTER, //dlgName
      cwDialogManager.BUILDER_HEADER_FOOTER, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      // forceReloadCurrentPage
      WrsEdit.sendStateReplaceFooter //function instance to call when dlg successfully closed                           
   );
}
WrsEdit.sendStateReplaceFooter = function (evt) {
   showDebugMsgs("sendStateReplaceFooter", evt);
   window.setTimeout( (function(evt){WrsEdit.sendStateReplaceArea(evt, "footer");}), 500);
}
WrsEdit.newSection = function () {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.newSection");
}
WrsEdit.dialog.newSection = function () {
   cwDialogManager.openDialog(
      "builderNewSection.do?dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_NEW_SECTION, //dlgName
      cwDialogManager.BUILDER_NEW_SECTION, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      forceReloadCurrentPage //function instance to call when dlg successfully closed
   );
}
WrsEdit.renameSection = function () {   
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.renameSection");
}
WrsEdit.dialog.renameSection = function () {
   cwDialogManager.openDialog(
      "builderRenameSection.do?dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_RENAME_SECTION, //dlgName
      cwDialogManager.BUILDER_RENAME_SECTION, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      forceReloadCurrentPage //function instance to call when dlg successfully closed
   );
}
WrsEdit.copySection = function () {   
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.copySection");
}
WrsEdit.dialog.copySection = function () {
   cwDialogManager.openDialog(
      "copySection.do?dialogCommand=openDialog", //dlgUrl
      cwDialogManager.COPY_SECTION, //dlgName
      cwDialogManager.COPY_SECTION, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      forceReloadCurrentPage //function instance to call when dlg successfully closed
   );
}
WrsEdit.reorderSections = function () {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.reorderSections");
}
WrsEdit.dialog.reorderSections = function () {
   cwDialogManager.openDialog(
      "builderReorderSections.do?dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_REORDER_SECTIONS, //dlgName
      cwDialogManager.BUILDER_REORDER_SECTIONS, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      forceReloadCurrentPage //function instance to call when dlg successfully closed                        
   );                        
}
WrsEdit.globalFilters = function () {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.globalFilters");
}
WrsEdit.dialog.globalFilters = function () {    
   cwDialogManager.openDialog(
      "manageGlobalFilters.do?dialogCommand=openDialog", //dlgUrl
      cwDialogManager.GLOBAL_FILTERS, //dlgName
      cwDialogManager.GLOBAL_FILTERS, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false //bReplaceIfOpen
   );
}
WrsEdit.aggregationDetail = function () {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.aggregationDetail");
}
WrsEdit.dialog.aggregationDetail = function () {
   cwDialogManager.openDialog(    
      "builderAggregationDetail.do?dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_AGGREGATION_DETAIL, //dlgName
      cwDialogManager.BUILDER_AGGREGATION_DETAIL, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false //bReplaceIfOpen
   );
}
// To change contents of a stored process container:
WrsEdit.editProcess = function (element) {
    WrsEdit.layout.deselectAll();
    WrsEdit.dialog.insertStoredProcess(element);
}
WrsEdit.dialog.insertStoredProcess = function (element) {
   var cmd = "builderInsertStoredProcess.do?dialogCommand=openDialog";
   if (element >= 0) {
     cmd += "&index=" + element;
   }
   cwDialogManager.openDialog(
      cmd, //dlgUrl
      cwDialogManager.INSERT_STORED_PROCESS, //dlgName
      cwDialogManager.INSERT_STORED_PROCESS, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      WrsEdit.sendStateReplaceGrid //function instance to call when dlg successfully closed
   );
}
// To assign group breaks to a stored process container:
WrsEdit.assignGroupBreaksToStoredProcess = function (element) {
    WrsEdit.layout.deselectAll();
    WrsEdit.dialog.assignGroupBreaksToStoredProcess(element);
}
WrsEdit.dialog.assignGroupBreaksToStoredProcess = function (element) {
   var cmd = "builderAssignGroupBreaksToStoredProcess.do?dialogCommand=openDialog";
   if (element >= 0) {
     cmd += "&index=" + element;
   }
   cwDialogManager.openDialog(
      cmd, //dlgUrl
      cwDialogManager.ASSIGN_GROUP_BREAKS_TO_STORED_PROCESS, //dlgName
      cwDialogManager.ASSIGN_GROUP_BREAKS_TO_STORED_PROCESS, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null, //onDlgClosing
      WrsEdit.sendStateReplaceGrid //function instance to call when dlg successfully closed
   );
}
WrsEdit.selectData = function () {
    WrsEdit.layout.deselectAll();
    WrsEdit.dialog.selectData();
}
WrsEdit.dialog.selectData = function () {
   cwDialogManager.openDialog(
      "builderSelectData.do?dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_SELECT_DATA, //dlgName
      cwDialogManager.BUILDER_SELECT_DATA, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false //bReplaceIfOpen
   );
}
WrsEdit.defineFormat = function (rowNum,formatType) {
    WrsEdit.layout.deselectAll();
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.defineFormat", rowNum, formatType);
}
WrsEdit.dialog.defineFormat = function (rowNum,formatType) {
   var dlgUrl = 'builderDefineFormat.do?dialogCommand=openDialog&index='+rowNum+'&formatType='+formatType;
   cwDialogManager.openDialog(
      dlgUrl,
      cwDialogManager.DEFINE_FORMAT, //dlgName
      cwDialogManager.DEFINE_FORMAT, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false //bReplaceIfOpen
   );
}
WrsEdit.previewData = function () {
   WrsEdit.layout.deselectAll();
   rsSubmit("/sendEditorState.do", "WrsEdit.dialog.previewData");
}
WrsEdit.dialog.previewData = function () {
   cwDialogManager.openDialog(
      "previewBuilderData.do", //dlgUrl
      cwDialogManager.PREVIEW_WIZARD_DATA, //dlgName
      cwDialogManager.PREVIEW_WIZARD_DATA, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false //bReplaceIfOpen
   );
}
WrsEdit.applyTemplate = function () {
    WrsEdit.layout.deselectAll();  // don't leave behind a selection that may not apply after applying template
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.openTemplateDialog");
}
WrsEdit.filterInfo = function (elementIndex) {
    rsSubmit('/sendEditorState.do', 'WrsEdit.dialog.filterInfo', elementIndex );
}

WrsEdit.memberProperties = function (index) {
    rsSubmit("/sendEditorState.do", "WrsEdit.dialog.memberProperties", index);
}
WrsEdit.dialog.memberProperties = function (index) {
   cwDialogManager.openDialog(
      "openViewModeMemberPropertiesDialog.do?index="+index+"&dialogCommand=openDialog", //dlgUrl
      cwDialogManager.MEMBER_PROPERTIES, //dlgName
      cwDialogManager.MEMBER_PROPERTIES, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false //bReplaceIfOpen
   );
}
WrsEdit.dialog.openTemplateDialog = function () {
   cwDialogManager.openDialog(
      "builderGalleryLayout.do?dialogCommand=openDialog", //dlgUrl
      cwDialogManager.BUILDER_GALLERY_LAYOUT, //dlgName
      cwDialogManager.BUILDER_GALLERY_LAYOUT, //dlgFeatures
      true, //bReplaceUrl
      true, //bModal - doesn't have to be modal though
      false, //bReplaceIfOpen
      null,
      forceReloadCurrentPage
   );
}
WrsEdit.dialog.filterInfo = function (elementIndex) {
    var filterInfoAction =  g_editDialogActionFilterInfo + elementIndex; // global declared in calling jsp.
    cwDialogManager.openDialog(
         filterInfoAction, //dlgUrl
         cwDialogManager.FILTER_INFORMATION, //dlgName
         cwDialogManager.FILTER_INFORMATION, //dlgFeatures
         true, //bReplaceUrl
         true, //bModal - doesn't have to be modal though
         false //bReplaceIfOpen
     );
}
// =====================================================================
// Buttons and popup state maintenance
// =====================================================================
WrsEdit.buttons.activate = function (isActive) {
   if (g_layoutSideButtonStates) {
      for (var actionName in g_layoutSideButtonStates) {
         // there may actually be no "button" but just an image.
         // even so, we keep tract of the state so we show the
         // right image on rollover and such.
         g_layoutSideButtonStates[actionName].active = isActive;
         var sideButton = g_layoutSideButtonStates[actionName].buttonElement;
         // Firefox will not show tooltips for disabled items, but we have to disable them for
         // accessibility issues - S0370288
         if (sideButton) {
            sideButton.style.cursor = "default";
         }
      }
   }
}

WrsEdit.buttons.setRollover = function (button, action, mode, rolloverStyle, normalStyle) {
   if (true == g_layoutSideButtonStates[action].active && mode == 'over') 
     button.className = rolloverStyle;
   else
      button.className = normalStyle;
}


WrsEdit.buttons.setImage = function (button, mode, action) {
    var imageSrc = WrsEdit.buttons.getImage(mode, action);
    if (imageSrc != '')
    button.src = WrsEdit.buttons.getImage(mode, action);
}
WrsEdit.buttons.getImage = function (mode, action) {
    if (false == g_layoutSideButtonStates[action].active ) {
        return g_layoutSideButtonStates[action].disabled.src;
    } else if (mode == 'over' || mode == 'down') {
        return g_layoutSideButtonStates[action].rollover.src;
    }
    return g_layoutSideButtonStates[action].normal.src;
}
WrsEdit.buttons.setStates = function (uniformState) {
    for (var actionName in g_layoutSideButtonStates) {
        // buttonElements are initialized after the HTML for the buttons below.
        var sideButton = g_layoutSideButtonStates[actionName].buttonElement;
        if (sideButton) {
           if (uniformState != undefined && uniformState != null) {
               var imageSrc = WrsEdit.buttons.getImage(uniformState, actionName);
               if (imageSrc != '')
               sideButton.src = WrsEdit.buttons.getImage(uniformState, actionName);
           } else if (g_layoutSideButtonStates[actionName].active == false) {
               var substitute = findDOM(sideButton.id + "_disabled");
               if (substitute != null) {
                   sideButton.style.visibility = "hidden";
                   sideButton.style.display = "none";
                   substitute.style.visibility = "visible";
                   substitute.style.display = "block";
               } else {
                  // must override S0430299 because of accessibility issues - S0370288
                  sideButton.disabled = true;
                  sideButton.style.cursor = "default";
                  var imageSrc = WrsEdit.buttons.getImage("disabled", actionName);
                  if (imageSrc != '')
                  sideButton.src = WrsEdit.buttons.getImage("disabled", actionName);
                   // showDebugMsgs("sideBarButtonState", "disabling " + sideButton.id + "," + sideButton.src);
               }
           } else {
               sideButton.disabled = false;
               sideButton.style.cursor = "pointer";
               var imageSrc = WrsEdit.buttons.getImage("normal", actionName);
               if (imageSrc != '')
               sideButton.src = WrsEdit.buttons.getImage("normal", actionName);
           }
           sideButton.style.visibility = "visible";
        }
    }
}
// --------------------------------------------------------------------
// On each selection/deselection the side button states are 
// changed to reflect valid actions on the select cells or
// report elements.
// --------------------------------------------------------------------
WrsEdit.buttons.updateStates = function () {  
   if (undefined != window.g_layoutSectionIsEditable && g_layoutSectionIsEditable == false) {
      WrsEdit.buttons.activate(false);
      WrsEdit.buttons.setStates("disabled");
   } else {
      // Assume all off unless otherwise allowed to be active
      for (var buttonName in g_layoutSideButtonStates) {
         g_layoutSideButtonStates[buttonName].active = false;
      }
      // Delete applies when one or more elements are selected.
      if (g_countSelectedElements > 0) {
         g_layoutSideButtonStates['remove'].active = true;
      }
      // Insert column/row (before, after) apply when cell(s) are selected
      if (g_countSelectedCells > 0) {
          g_layoutSideButtonStates['insertColumnBefore'].active = true;
          g_layoutSideButtonStates['insertColumnAfter'].active = true;
          g_layoutSideButtonStates['insertRowBefore'].active = true;
          g_layoutSideButtonStates['insertRowAfter'].active = true;
      }
      // Alignments (left, center, right) apply when cell(s) selected
      if (g_countSelectedElements > 0 
            || (g_countSelectedCells > 0 
                && !WrsEdit.layout.isCellSelectionAllEmpty())) {
         // Alignments have no effect on text results so don't allow changing them.
         if (!WrsEdit.layout.doesSelectionIncludeTextElements()) {
            g_layoutSideButtonStates['alignLeft'].active = true;
            g_layoutSideButtonStates['alignCenter'].active = true;
            g_layoutSideButtonStates['alignRight'].active = true;
         }    
         g_layoutSideButtonStates['alignBottom'].active = true;
         g_layoutSideButtonStates['alignMiddle'].active = true;
         g_layoutSideButtonStates['alignTop'].active = true;
      }    
      // Merge applies when two adjacent cells selected
      if (g_countSelectedCells > 1 && WrsEdit.layout.validateCellMerge() != null) {
         g_layoutSideButtonStates['mergeCells'].active = true;
      }
      // Split applies when one cell is selected
      if (g_countSelectedCells == 1) {
         g_layoutSideButtonStates['splitRows'].active = true;
         g_layoutSideButtonStates['splitColumns'].active = true;
      }
      // Deleting full rows or columns is OK but not lesser blocks
      // or non-empty cells (have to select the elements)
      if (g_countSelectedCells > 0) {
         var returnRows = new Array();
         var returnCols = new Array();
         if ((WrsEdit.layout.checkCellDelete(returnRows, returnCols) == true) 
               && WrsEdit.layout.isCellSelectionAllEmpty()) {
            g_layoutSideButtonStates['remove'].active = true;
         }
      }
      // Apply the states 
      WrsEdit.buttons.setStates();
      // Update menu ribbon popup menu states
      WrsEdit.popups.setDataMenuStates();
      WrsEdit.popups.setEditMenuStates();
   }
}

WrsEdit.popups.setDataMenuStates = function ()
{

    if (citationDataButton_popup)
    {
       // Data->Assign Data
       var assignDataPopup = new WrsMenuItem(citationDataButton_popup, "dataAssignDataMenuItem");
   
       // Data->Totals
       var totalsPopup = new WrsMenuItem(citationDataButton_popup, "dataTotalsMenuItem");
   
       // Data->Filter and Rank
       var filterRankPopup = new WrsMenuItem(citationDataButton_popup, "dataFilterRankMenuItem");
   
       // Data->Conditional Highlighting
       var condHighlightingPopup = new WrsMenuItem(citationDataButton_popup, "dataConditionalHighlightingMenuItem");
   
       // Data->Report Linking
       if(g_isReportLinkingAllowed)
       {
          var reportLinkingPopup = new WrsMenuItem(citationDataButton_popup, "dataReportLinkingMenuItem");
       }
       
       if (g_countSelectedElements > 1 || g_countSelectedCells > 0)
       {
          assignDataPopup.setDisabled(true);
          totalsPopup.setDisabled(true);
          filterRankPopup.setDisabled(true);
          condHighlightingPopup.setDisabled(true);
          if(g_isReportLinkingAllowed)
          {
             reportLinkingPopup.setDisabled(true);
          }
          return;
       }   
             
       var elementType = "";
       var hasData = false;
       var isComplete = false;

       if (g_countSelectedElements > 0)
       {
          var checkElementOrdinal = -1;
          var iElement = g_arraySelectedElements[0];
          var index = WrsEdit.layout.getElementOrdinal(iElement);
             
          if (!dojo.lang.isEmpty(index) && index != -1)
          {
             elementType = g_layoutElements[index].elementType;
             hasData = g_layoutElements[index].sectionHasData;
             isComplete = g_layoutElements[index].isComplete == "true" ? true : false;
          }   
       }
                 
       if ( (!dojo.lang.isEmpty(elementType)) && hasData == "true")
       {
          if (elementType == "table" || elementType == "Table" || elementType == "Crosstab")
          {
             assignDataPopup.setDisabled(false);
             filterRankPopup.setDisabled(!isComplete);
             condHighlightingPopup.setDisabled(!isComplete);
             if(g_isReportLinkingAllowed)
             {             
                reportLinkingPopup.setDisabled(!isComplete);
             }
             totalsPopup.setDisabled(!isComplete);
             
          }
          else if (elementType == "graph" || elementType == "Bar_Graph" || elementType == "Bar_Line_Graph" ||
                 elementType == "Scatter_Plot" || elementType == "Waterfall" || elementType == "Pie_Graph" ||
                 elementType == "Line_Graph")
          {
             assignDataPopup.setDisabled(false);
             filterRankPopup.setDisabled(!isComplete);
             condHighlightingPopup.setDisabled(!isComplete);
             if(g_isReportLinkingAllowed)
             {
                reportLinkingPopup.setDisabled(!isComplete);
             }
             totalsPopup.setDisabled(true);
          }
          else if (elementType == "tile" || elementType == "Tile")
          {
             assignDataPopup.setDisabled(false);
             filterRankPopup.setDisabled(!isComplete);
             condHighlightingPopup.setDisabled(!isComplete);
             if(g_isReportLinkingAllowed)
             {             
                reportLinkingPopup.setDisabled(!isComplete);
             }
             totalsPopup.setDisabled(true);
          }
          else if (elementType == "map" || elementType == "ESRI_Map")
          {
             assignDataPopup.setDisabled(false);
             filterRankPopup.setDisabled(!isComplete);
             condHighlightingPopup.setDisabled(!isComplete);
             if(g_isReportLinkingAllowed)
             {             
                reportLinkingPopup.setDisabled(!isComplete);
             }
             totalsPopup.setDisabled(true);
          }
          else if (elementType == "image" || elementType == "Image")
          {
             assignDataPopup.setDisabled(true);
             filterRankPopup.setDisabled(true);
             condHighlightingPopup.setDisabled(true);
             if(g_isReportLinkingAllowed)
             {                    
                reportLinkingPopup.setDisabled(false);
             }
             totalsPopup.setDisabled(true);
          } 
          else
          {
             assignDataPopup.setDisabled(true);
             filterRankPopup.setDisabled(true);
             condHighlightingPopup.setDisabled(true);
             if(g_isReportLinkingAllowed)
             {                    
                reportLinkingPopup.setDisabled(true);
             }
             totalsPopup.setDisabled(true);
          }
       }
       else 
       {
          assignDataPopup.setDisabled(true);
          totalsPopup.setDisabled(true);
          filterRankPopup.setDisabled(true);
          condHighlightingPopup.setDisabled(true);
          if(g_isReportLinkingAllowed)
          {                 
             reportLinkingPopup.setDisabled(true);
          }
      }
   }
}

WrsEdit.popups.setEditMenuStates = function ()
{
   if (citationEditButton_popup)
   {
      // Edit->Delete
      var deleteSelectionPopup = new WrsMenuItem(citationEditButton_popup, "editDeleteSelection");
      
      // Edit->Change Table To (cascade)
      var changeTableToPopup = new WrsMenuItem(citationEditButton_popup, "editChangeTableToMenuItem");
      
      // Edit->Change Table To List
      var changeTableToListPopup = new WrsMenuItem(citationEditButton_popup, ["editChangeTableToMenuItem","editChangeTableToListMenuItem"]);
      
      // Edit->Change Table To Crosstab
      var changeTableToCrosstabPopup = new WrsMenuItem(citationEditButton_popup, ["editChangeTableToMenuItem","editChangeTableToCrosstabMenuItem"]);
      
      // Edit->Change Graph To (cascade)
      var changeGraphToPopup = new WrsMenuItem(citationEditButton_popup, "editChangeGraphToMenuItem");
      
      // Edit->Change Graph To Bar
      var changeGraphToBarPopup = new WrsMenuItem(citationEditButton_popup, ["editChangeGraphToMenuItem","editChangeGraphToBarMenuItem"]);
      
      // Edit->Change Graph To Pie
      var changeGraphToPiePopup = new WrsMenuItem(citationEditButton_popup, ["editChangeGraphToMenuItem","editChangeGraphToPieMenuItem"]);
      
      // Edit->Change Graph To Line
      var changeGraphToLinePopup = new WrsMenuItem(citationEditButton_popup, ["editChangeGraphToMenuItem","editChangeGraphToLineMenuItem"]);
      
      // Edit->Change Graph To Bar Line
      var changeGraphToBarLinePopup = new WrsMenuItem(citationEditButton_popup, ["editChangeGraphToMenuItem","editChangeGraphToBarLineMenuItem"]);
      
      // Edit->Change Graph To Progressive Bar
      var changeGraphToProgressiveBarPopup = new WrsMenuItem(citationEditButton_popup, ["editChangeGraphToMenuItem","editChangeGraphToProgressiveBarMenuItem"]);
      
      // Edit->Change Graph To Scatter
      var changeGraphToScatterPopup = new WrsMenuItem(citationEditButton_popup, ["editChangeGraphToMenuItem","editChangeGraphToScatterMenuItem"]);
      
      // Edit->Properties
      var propertiesPopup = new WrsMenuItem(citationEditButton_popup, "editPropertiesMenuItem");
      
      // Edit->Delete 
      deleteSelectionPopup.setDisabled((g_countSelectedElements > 0) ? false : true);
      if (g_countSelectedCells > 0) {
         var returnRows = new Array();
         var returnCols = new Array();  
         if ( (WrsEdit.layout.checkCellDelete(returnRows, returnCols) == true) 
                  && WrsEdit.layout.isCellSelectionAllEmpty()) {
            deleteSelectionPopup.setDisabled(false);
         }
      } 
      if (g_countSelectedElements > 1 || g_countSelectedCells > 0) {
         changeTableToPopup.setDisabled(true);
         changeGraphToPopup.setDisabled(true);
         propertiesPopup.setDisabled(true);
         var editPropertiesPopupMenuItemModel = propertiesPopup.getPopupItemModel();
         editPropertiesPopupMenuItemModel.setJavascript("cwUnimplemented()");
         return;
      }   
             
      var elementType = "";
      var isOLAP = false;
      var index = -1;
      if (g_countSelectedElements > 0)
      {
         var checkElementOrdinal = -1;
         var iElement = g_arraySelectedElements[0];
         index = WrsEdit.layout.getElementOrdinal(iElement);
          
         if (!dojo.lang.isEmpty(index) && index != -1)
         {
            elementType = g_layoutElements[index].elementType;
            var isOLAPElem = g_layoutElements[index].isOLAP;
         }   
      }
                 
       if (!dojo.lang.isEmpty(elementType))
       {
          // uncheck all radio buttons first (S0422853)
          for (var i=0; i<6; i++)
          {
             changeGraphToBarPopup.uncheckRadioMenuItemAtIndex(i)
          }
          for (var i=0; i<2; i++)
          {
             changeTableToCrosstabPopup.uncheckRadioMenuItemAtIndex(i)
          }
          
          if (elementType == "table" || elementType == "Table" || elementType == "Crosstab")
          {
             changeTableToPopup.setDisabled(false);
             changeGraphToPopup.setDisabled(true);
             propertiesPopup.setDisabled(false);
             var editPropertiesPopupMenuItemModel = propertiesPopup.getPopupItemModel();
             editPropertiesPopupMenuItemModel.setJavascript("WrsEdit.tableProperties(" + index + ")");

             if (isOLAPElem == "true")
             {
                    changeTableToListPopup.setDisabled(true);
                    changeTableToCrosstabPopup.setRadioChecked();
                    changeTableToCrosstabPopup.uncheckOtherGroupRadioMenuItems();
             }
             else if (elementType == "Crosstab")
             {
                    changeTableToCrosstabPopup.setRadioChecked();
                    changeTableToCrosstabPopup.uncheckOtherGroupRadioMenuItems();
             }
             else if (elementType == "Table")
             {
                    changeTableToListPopup.setRadioChecked();
                    changeTableToListPopup.uncheckOtherGroupRadioMenuItems();
             }
             
          }
          else if (elementType == "Bar_Graph")
          {
             propertiesPopup.setDisabled(false);
             changeTableToPopup.setDisabled(true);
             changeGraphToPopup.setDisabled(false);
             changeGraphToBarPopup.setRadioChecked();
             changeGraphToBarPopup.uncheckOtherGroupRadioMenuItems();
             var editPropertiesPopupMenuItemModel = propertiesPopup.getPopupItemModel();
             editPropertiesPopupMenuItemModel.setJavascript("WrsEdit.graphProperties(" + index + ")");
          }
          else if (elementType == "Pie_Graph")
          {
             propertiesPopup.setDisabled(false);
             changeTableToPopup.setDisabled(true);
             changeGraphToPopup.setDisabled(false);
             changeGraphToPiePopup.setRadioChecked();
             changeGraphToPiePopup.uncheckOtherGroupRadioMenuItems();
             var editPropertiesPopupMenuItemModel = propertiesPopup.getPopupItemModel();
             editPropertiesPopupMenuItemModel.setJavascript("WrsEdit.graphProperties(" + index + ")");
          }
          else if (elementType == "Bar_Line_Graph")
          {
             propertiesPopup.setDisabled(false);
             changeTableToPopup.setDisabled(true);
             changeGraphToPopup.setDisabled(false);
             changeGraphToBarLinePopup.setRadioChecked();
             changeGraphToBarLinePopup.uncheckOtherGroupRadioMenuItems();
             var editPropertiesPopupMenuItemModel = propertiesPopup.getPopupItemModel();
             editPropertiesPopupMenuItemModel.setJavascript("WrsEdit.graphProperties(" + index + ")");
          }
          else if (elementType == "Line_Graph")
          {
             propertiesPopup.setDisabled(false);
             changeTableToPopup.setDisabled(true);
             changeGraphToPopup.setDisabled(false);
             changeGraphToLinePopup.setRadioChecked();
             changeGraphToLinePopup.uncheckOtherGroupRadioMenuItems();
             var editPropertiesPopupMenuItemModel = propertiesPopup.getPopupItemModel();
             editPropertiesPopupMenuItemModel.setJavascript("WrsEdit.graphProperties(" + index + ")");
          }
          else if (elementType == "Scatter_Plot")
          {
             propertiesPopup.setDisabled(false);
             changeTableToPopup.setDisabled(true);
             changeGraphToPopup.setDisabled(false);
             changeGraphToScatterPopup.setRadioChecked();
             changeGraphToScatterPopup.uncheckOtherGroupRadioMenuItems();
             var editPropertiesPopupMenuItemModel = propertiesPopup.getPopupItemModel();
             editPropertiesPopupMenuItemModel.setJavascript("WrsEdit.graphProperties(" + index + ")");
          }
          else if (elementType == "Waterfall")
          {
             propertiesPopup.setDisabled(false);
             changeTableToPopup.setDisabled(true);
             changeGraphToPopup.setDisabled(false);
             changeGraphToProgressiveBarPopup.setRadioChecked();
             changeGraphToProgressiveBarPopup.uncheckOtherGroupRadioMenuItems();
             var editPropertiesPopupMenuItemModel = propertiesPopup.getPopupItemModel();
             editPropertiesPopupMenuItemModel.setJavascript("WrsEdit.graphProperties(" + index + ")");
          }
          else if (elementType == "Tile")
          {
             propertiesPopup.setDisabled(false);
             changeTableToPopup.setDisabled(true);
             changeGraphToPopup.setDisabled(true);
             var editPropertiesPopupMenuItemModel = propertiesPopup.getPopupItemModel();
             editPropertiesPopupMenuItemModel.setJavascript("WrsEdit.tileProperties(" + index + ")");
          }
          else if (elementType == "ESRI_Map")
          {
             propertiesPopup.setDisabled(false);
             changeTableToPopup.setDisabled(true);
             changeGraphToPopup.setDisabled(true);
             var editPropertiesPopupMenuItemModel = propertiesPopup.getPopupItemModel();
             editPropertiesPopupMenuItemModel.setJavascript("WrsEdit.mapProperties(" + index + ")");
          }
          else
          {
             propertiesPopup.setDisabled(true);
             changeTableToPopup.setDisabled(true);
             changeGraphToPopup.setDisabled(true);
             var editPropertiesPopupMenuItemModel = propertiesPopup.getPopupItemModel();
             editPropertiesPopupMenuItemModel.setJavascript("cwUnimplemented()");
          }
       }
       else 
       {
          propertiesPopup.setDisabled(true);
          changeTableToPopup.setDisabled(true);
          changeGraphToPopup.setDisabled(true);
          var editPropertiesPopupMenuItemModel = propertiesPopup.getPopupItemModel();
          editPropertiesPopupMenuItemModel.setJavascript("cwUnimplemented()");
       }
   }
 }
// ------------------------------------------------------------------
// Get control over the order these onLoad initializations are done.
// ------------------------------------------------------------------
WrsEdit.initEditPage = function (evt, doLayoutInit){
    //  Now that buttons are in the DOM, set up references to them in the global lookup table 
    g_layoutSideButtonStates['remove'].buttonElement = findDOM('removeLayoutSideButton');
    g_layoutSideButtonStates['alignLeft'].buttonElement = findDOM('alignLeftLayoutSideButton');
    g_layoutSideButtonStates['alignCenter'].buttonElement = findDOM('alignCenterLayoutSideButton');
    g_layoutSideButtonStates['alignRight'].buttonElement = findDOM('alignRightLayoutSideButton');
    g_layoutSideButtonStates['alignBottom'].buttonElement = findDOM('alignBottomLayoutSideButton');
    g_layoutSideButtonStates['alignMiddle'].buttonElement = findDOM('alignMiddleLayoutSideButton');
    g_layoutSideButtonStates['alignTop'].buttonElement = findDOM('alignTopLayoutSideButton');
    g_layoutSideButtonStates['insertColumnBefore'].buttonElement = findDOM('insertColumnBeforeLayoutSideButton');
    g_layoutSideButtonStates['insertColumnAfter'].buttonElement = findDOM('insertColumnAfterLayoutSideButton');
    g_layoutSideButtonStates['insertRowBefore'].buttonElement = findDOM('insertRowBeforeLayoutSideButton');
    g_layoutSideButtonStates['insertRowAfter'].buttonElement = findDOM('insertRowAfterLayoutSideButton');
    g_layoutSideButtonStates['mergeCells'].buttonElement = findDOM('mergeCellsLayoutSideButton');
    g_layoutSideButtonStates['splitColumns'].buttonElement = findDOM('splitColumnsLayoutSideButton');
    g_layoutSideButtonStates['splitRows'].buttonElement = findDOM('splitRowsLayoutSideButton');
    if (doLayoutInit) {
       onLoadLayoutPaneInitialize();
       WrsEdit.layout.selectInitialCellsOrElements();
       if (window.WrsEdit.layout.generateGridDropZones) {
           WrsEdit.layout.generateGridDropZones(evt, "init", true);
       }
    }    
}
// -------------------------------------------------------------------
// Should be called on resize of window or toggle of panes. 
// -------------------------------------------------------------------
WrsEdit.contentAreaAdjust = function (evt) {
    var reportContentArea = findDOM('designMainContentScrollDiv');
    if (reportContentArea != null && reportContentArea != "undefined") {
        var taskPaneOuter = findDOM('taskPaneCell');
        var leftTaskSectionsArea = findDOM('leftTaskPane');
        var bannerArea = findDOM('wrsBannerAndTopMenu');
        var sidePaneExpandCollapseImage = findDOM('sidePaneExpandCollapseButton');
        var leftTaskPaneDiv = findDOM('taskPaneDiv');
        var verticalBar = findDOM('designTaskPaneVerticalRibbon');
        var horizontalBar = findDOM('designTopToolbarRibbon');
        
        try {
            var scrh = window.screen.height;
            var vph = dojo.html.getViewportHeight();
            var vpw = dojo.html.getViewportWidth();
            // IE6 has a real problem with being resized below a certain height.
            // It can be resized until nothing shows of the report window at all.
            // Instead of becoming negative (when appropriate) the viewport height
            // will jump up to some fictitious number, and it gets into an infinite
            // loop that is unstoppable except by limiting it to the screen height.
            // This test breaks the cycle, and the window reacts correctly if resized
            // back to a reasonable size.
            if (isBrowserIE() && !isBrowserIE7() && vph > scrh) {
                return;
            }    
            var reportContentAreaHeight = (vph - bannerArea.offsetHeight) - horizontalBar.offsetHeight;
            var reportContentAreaWidth = (vpw - taskPaneOuter.offsetWidth) - verticalBar.offsetWidth;
            // This test is sufficient for IE7, but allows the window to be resized 
            // taller than the actual screen size, which might be useful in some situations.
            // Mozilla has no problem with tiny heights.
            if (reportContentAreaHeight < 10 || reportContentAreaWidth < 10) {
                return;
            }
            var taskPaneAreaHeight = vph - bannerArea.offsetHeight;
            var leftTaskSectionsAreaHeight = 
                (vph - bannerArea.offsetHeight) - sidePaneExpandCollapseImage.offsetHeight;
            /* ==========================================================    
            console.log("WrsEdit.contentAreaAdjust",
                " scrheight:" +  scrh 
                + " winheight:" + wh 
                + " viewport height:" + vph 
                + " viewport width:" + vpw
                + " vph-bannerHeight:" + (vph - bannerArea.offsetHeight) 
                + "\n horiz tools height:" + horizontalBar.offsetHeight 
                + " content height:" + reportContentAreaHeight
                + " content width:" + reportContentAreaWidth
                + " task area height:" + taskPaneAreaHeight
                + " left pane height:"  + leftTaskSectionsAreaHeight);
                ========================================================= */
            reportContentArea.style.height = reportContentAreaHeight + "px";
            reportContentArea.style.width = reportContentAreaWidth + "px";
            leftTaskPaneDiv.style.height = taskPaneAreaHeight + "px";
            leftTaskPaneDiv.style.verticalAlign = "top";
            leftTaskSectionsArea.style.height = leftTaskSectionsAreaHeight + "px";
            leftTaskSectionsArea.style.verticalAlign = "top";
        } catch (e) {
            console.error(e.message);
        }
        // after these adjustments, the cached drop zone coordinates will need adjustment.
        if (window.WrsEdit.layout.generateGridDropZones) {
            WrsEdit.layout.generateGridDropZones(evt, "adjust", false);
        }
    } 
      
}
