/* ------------------------------------------------------------------------ *
 * SAS Institute, Inc.                                                      *
 *                                                                          *
 * Copyright (c) 2006-2012 SAS Institute, Inc.  All rights reserved.        *
 *                                                                          *
 * citation_RichEditor - Javascript "class" containing the                  *
 * citation_RichTextEditor and citation_RichTextEditField instances plus    *
 * WRS-specific functionality                                               *
 * ------------------------------------------------------------------------ */
wrsProvide("citation_RichEditor");
wrsRequire("citation_RichTextEditor",  SCRIPT_DIR, "citation_RichEditor");
wrsRequire("citation_RichTextEditField",  SCRIPT_DIR, "citation_RichEditor");
wrsRequire("citation_RichTextEditEventMaster",  SCRIPT_DIR, "citation_RichEditor");

// constructor citation_RichEditor(editorVarName, isHeaderFooter)
// editorVarName is name of Javascript instance variable for citation_RichTextEditor component
// isHeaderFooter is false for text object, true for header or footer.
function citation_RichEditor(editorVarName, isHeaderFooter) {
    this.jspStrings = [];   // Will contain JSP string snippets indexed by key string
    this.editorVarName = editorVarName; // Name of javascript instance variable for citation_RichTextEditor
    this.isHeaderFooter = isHeaderFooter;
    this.textEdit = null;   // citation_RichTextEditField instance (after it is initialized)
    this.editor = null;     // citation_RichRextEditor instance (after it is initialized)
    this.initialized = false;
    this.hyperlinkImg = null;
}

// Method citation_RichEditor.onEditFieldInitialized()
// Is called whenever citation_RichTextEditField.waitBodyReady() returns.
citation_RichEditor.prototype.onEditFieldInitialized = function() {
    try {
        var editorInstance = eval(this.editorVarName);
        var textEditInstance = editorInstance.textEdit;
        if ("registered" != textEditInstance.initializationState) {
            return;
        }
        this.editor = editorInstance;
        this.textEdit = this.editor.textEdit;
        this.fontPicker = this.editor.fontPicker;

        // Pass through the localized messages needed by the RichTextEditFieldWRS's JavaScript:
        this.textEdit.setMessage("error.richtexteditfield.multi.para.style.change.txt",
                    this.getJspString("error.richtexteditfield.multi.para.style.change.txt"));

        // Set the default colors that will override the discovered automatic colors:
        this.textEdit.overrideAutomaticColor(this.getJspString("overrideColor"));
        this.textEdit.overrideAutomaticBackgroundColor(this.getJspString("overrideBackgroundColor"));

        if (this.isHeaderFooter) {
            var bannerSelectElem = dojo.byId("bannerImage");
            if (isBrowserIE) {
                dojo.event.connect(bannerSelectElem, "onmousewheel", "onMouseWheel")  ;
            }
            setBannerAlignment(findDOM("bannerAlignment").value); // Only header/footer has banner
            
            //WRS 4.3 hotfix (for EBI)
            this.hyperlinkImg = document.getElementById("hyperlinkImg");    // HyperLink button in the extended font picker
            if (this.hyperlinkImg) {
                this.hyperlinkImg.setAttribute("alt", this.getJspString("msgTooltipHyperlink"));
                this.hyperlinkImg.setAttribute("title", this.getJspString("msgTooltipHyperlink"));
            }
            this.initSelect("prompt");  // Dynamic item dropdown
            // this.initSelect("measure");            
        }
        else {  // Is not header or footer
            this.hyperlinkImg = document.getElementById("hyperlinkImg");    // HyperLink button in the extended font picker
            if (this.hyperlinkImg) {
                this.hyperlinkImg.setAttribute("alt", this.getJspString("msgTooltipHyperlink"));
                this.hyperlinkImg.setAttribute("title", this.getJspString("msgTooltipHyperlink"));
            }
            this.initSelect("prompt");  // Dynamic item dropdown
            this.initSelect("measure"); // S0887313
        }

        if (this.editor && this.textEdit && this.fontPicker) {
            this.textEdit.closeWindowOnEsc = true; // Esc key should cancel the dialog
            this.initialized = true;
        }

        // After a delay while the page "settles" call WRS_textStartup() to work around
        // an intermittent initial insertion point problem.
        setTimeout("WRS_textStartup();", 250);

    }
    catch (ex) {
        alert("ERROR: citation_RichEditor.onEditFieldInitialized() could not find (or initialize) "+this.editorVarName);
    }
}

// Method citation_RichEditor.setJspString(key, value)
// Set the given string value for the given string key (used for localization etc.)
citation_RichEditor.prototype.setJspString = function(key, value) {
    this.jspStrings[key] = value;
}

// Method citation_RichEditor.getJspString(key)
// return the string associated with the key string, or just the key string if not found
citation_RichEditor.prototype.getJspString = function(key) {
    if (this.jspStrings[key]) {
        return this.jspStrings[key];
    }
    return key;
}

// Method citation_RichEditor.initSelect
// Initialize the prompt or measures dynamic items dropdown
citation_RichEditor.prototype.initSelect = function(id)
{
    var sel = findDOM(id);
    sel.disabled = (sel.options.length ? false : true);
    if (sel.disabled) {
        var option = document.createElement('option');
        option.innerHTML = option.value = this.getJspString("initialSelection");
        sel.appendChild(option);
    }
    var button = id+'Button';
    if (sel.disabled) {
        setButtonState(null, button, setButtonState.DISABLED);
    }
    else {
        setButtonState(null, button, setButtonState.ENABLED);
    }
}

// =========== Methods formerly in citation_RichTextEditFieldExtensionl.js =====================

// Method citation_RichEditor.elemIntersectsSelection(elem)
// Returns true if the current selection (or insertion point)
// is in or overlaps any text in the given element.
citation_RichEditor.prototype.elemIntersectsSelection = function(elem) {
    if(this.textEdit.isBrowserIE) {
        var elemRange = this.textEdit.editDoc.body.createTextRange();   // Must start with entire doc
        elemRange.moveToElementText(elem);  // Then reduce to all text in the given elem
        if (this.textEdit.selectionRange.compareEndPoints("StartToEnd", elemRange) < 0 &&
                    this.textEdit.selectionRange.compareEndPoints("EndToStart", elemRange) > 0) {
            return true;
        }
    }
    else if (this.textEdit.isBrowserStandard) {
        return this.textEdit.selectionRange.intersectsNode(elem);

    }
    return false;
}

// Method citation_RichEditor.walkTreeForLink(elem, linkInfo)
// Walks the subtree of the given element looking for any <a>
// elements (including elem itself) that have text that is overlapped
// by the current selection.  If found, linkInfo.elem is set to the
// first <a> tag encountered, and if more than one <a> tag is overlapped
// by the selection, then linkInfo.isMultiple will be set to true.
// Recursive.
citation_RichEditor.prototype.walkTreeForLink = function(elem, linkInfo) {
    if ("A" == elem.tagName) {  // The given element is a link?
        if (this.elemIntersectsSelection(elem)) {   // Selection includes any text in this <a>?
            if (linkInfo.elem) { // Already have a link
                linkInfo.isMultiple = true;
                return;
            }
            else {  // This is the first <a> found that the selection overlaps
                linkInfo.elem = elem;
            }
        }
    }
    for (var childNode = elem.firstChild; (childNode); childNode = childNode.nextSibling) {
        if (childNode.nodeType == 1)  { // Is an element
            this.walkTreeForLink(childNode, linkInfo);  // Recursive call
        }
    }
}

// Method citation_RichEditor.walkTreeFixLinks(elem)
// Fix all links that were automatically created by IE
// (e.g., when user types www.x.com) so they have the required
// special attirbutes (linkType and destination) expected by WRS.
// Recursive method.
citation_RichEditor.prototype.walkTreeFixLinks = function(elem) {
    if ("A" == elem.tagName) {  // The given element is a link?
        var linkType = elem.getAttribute('linkType');
        var destination = elem.getAttribute('destination');
        if (! (linkType && destination)) {  // no special WRS attributes on link?
            var href = elem.href;
            elem.destination=href;
            elem.linkType = "WEB_SITE";
            elem.href = "";
            elem.title = "";
        }
    }
    for (var childNode = elem.firstChild; (childNode); childNode = childNode.nextSibling) {
        if (childNode.nodeType == 1)  { // Is an element
            this.walkTreeFixLinks(childNode);   // Recursive call
        }
    }
}

// Method citation_RichEditor.getLinkInfo()
// Returns a link info object describing the relation of hyperlink(s) to
// the current selection or insertion point.
// If the current selection is collapsed (an insertion point),
// then will have info about the <a> the insertion point is in, if any.
// If selection is not collapsed, then will give information about
// any <a> tag(s) that are completely or partially included in the
// selection.
// Returned linkInfo object properties:
//  elem - the <a> element object, or null if no <a> tag is in current selection.
//  isMultiple - true iff multiple <a> tags are included in the selection
citation_RichEditor.prototype.getLinkInfo = function() {
    var linkInfo = linkInfo = {elem:null,  isMultiple:false};
    var ancestor = this.textEdit.getCommonAncestor();
    if (this.textEdit.isRangeCollapsed()) {
        // Locate <a> tag ancestor, if any
        while (ancestor && "A" != ancestor.tagName) {
            if (this.textEdit.isBrowserIE) {
                ancestor = ancestor.parentElement;
            }
            else if (this.textEdit.isBrowserStandard) {
                ancestor = ancestor.parentNode;
            }
        }
        if (ancestor) {
            linkInfo.elem = ancestor;
        }
    }
    else { // Is not collapsed, is selection
        var elem = ancestor;
        while (elem && "A" != elem.tagName) {
            if (this.textEdit.isBrowserIE) {
                elem = elem.parentElement;
            }
            else if (this.textEdit.isBrowserStandard) {
                elem = elem.parentNode;
            }
        }
        elem = (elem) ? elem: ancestor;
        this.walkTreeForLink(elem, linkInfo);
    }
    return linkInfo;
}

// Method citation_RichEditor.canCreateLink()
// Return true if the currently selected text could be
// converted into a link and false if not (only plain text can be in an A tag)
citation_RichEditor.prototype.canCreateLink = function() {
    if (this.textEdit.isBrowserIE) {
        var existingHTML = this.textEdit.selectionRange.htmlText;
        if ((existingHTML.indexOf("<") >= 0) || (existingHTML.indexOf(">") >= 0)) {
            return false;
        }
        if (existingHTML.length < 1){
            return false;
        }
        return true;
    }
    else if (this.textEdit.isBrowserStandard) {
        var selText = this.textEdit.selectionRange.toString();
        if (selText && selText.length > 0) {
            var startNode = this.textEdit.selectionRange.startContainer;
            var endNode = this.textEdit.selectionRange.endContainer;
            if (startNode.nodeType == 3 && startNode == endNode) {  // selection is all inside one text node?
                return true;
            }
        }
    }
    return false;
}

// Method citation_RichEditor.createLink(urlString)
// Create an <a> tag surrounding the selection text,
// with the given href value.
// Returns the newly-created <a> tag object.
citation_RichEditor.prototype.createLink = function(urlString) {
    citation_RichEditor.nextUniqueSpanIdNumber++;
    var id="_a_"+citation_RichEditor.nextUniqueSpanIdNumber;
    var elem = this.textEdit.encloseSelectionRange("a", id, false);
    elem.removeAttribute("id"); // Get rid of id no longer needed
    elem.href = urlString;
    return elem;
}

// Method citation_RichEditor.changeLink(elem, urlString)
// Change the given <a> tag element's href attribute to the
// given URL string.
// Returns the updated element object.
citation_RichEditor.prototype.changeLink = function(elem, urlString) {
    elem.href = urlString;
    return elem;
}

// Method citation_RichEditor.canInsertProxy()
// Returns true if we can insert a text proxy at the current
// selection, or false if not.
// Returns false if the current selection (or insertion point) starts and/or
// ends in a text proxy, or if either end of the current selection is immediately
// adjacent to a text proxy.
citation_RichEditor.prototype.canInsertProxy = function() {
    if(this.textEdit.isBrowserIE) {
        var rpState = this.textEdit.getRangeProxyState();
        if (rpState.proxySpan || rpState.endProxySpan) {  // Selection starts and/or ends inside proxy?
            return false;
        }
        // Come here only if neither end of selection is inside a text proxy
        // Test for existing adjacent proxy on the left:
        var testRange = this.textEdit.selectionRange.duplicate();
        testRange.collapse(true);   // insertion point at left edge
        var elem = null;
        if (this.textEdit.extendRange(-1, testRange)) { // Have a character to the left?
            elem = this.textEdit.getCommonAncestor(testRange);
            if (elem.sas_RichTextEditProxy) {   // Has proxy adjacent on left?
                return false;
            }
        }
        // Now test for adjacent proxy on the right:
        testRange = this.textEdit.selectionRange.duplicate();
        testRange.collapse(false);  // insertion point at right edge
        if (this.textEdit.extendRange(1, testRange)) {  // Have a character to the right?
            elem = this.textEdit.getCommonAncestor(testRange);
            if (elem.sas_RichTextEditProxy) {   // Has proxy adjacent on right?
                return false;
            }
        }
    }
    else {  // is Firefox
        //TODO: Implement this instead of just returning true!
    }
    return true;    
}

// Method citation_RichEditor.adjustInitialSelection()
// This is called at startup to work around a problem that occurs intermittently
// on some client systems, where IE positions the initial insertion point for
// new initial text (visually empty) on the BODY instead of inside the P element.
// If this condition is detected, it moves the insertion point inside the P element.
citation_RichEditor.prototype.adjustInitialSelection = function() {

    //alert("In citationRichEditor.adjustInitialSelection()");

    this.textEdit.getRawSelectionRange();
    if (this.textEdit.isRangeCollapsed()) {
        var ancestor = this.textEdit.getCommonAncestor();
        if ("BODY" == ancestor.tagName) {
            for (var childNode = ancestor.firstChild; (childNode); childNode = childNode.nextSibling) {
                if (childNode.nodeType == 1 && "P" == childNode.tagName)  { // Is a P element?
                    if (this.textEdit.isBrowserStandard) {
                        // (S0886205) Move insertion point into the P element
                        var selection = this.textEdit.editWindow.getSelection();
                        var range = this.textEdit.editDoc.createRange();
                        range.selectNodeContents(childNode);    // select the P element
                        var pContent = childNode.innerHTML;
                        // If P only contains a single &nbsp;, then put insertion point in front of
                        // the &nbsp; (because the P is assumed to be the default "empty" content) to avoid
                        // visual paragraph left-alignment issues. Otherwise put the insertion 
                        // point at the end of the paragraph (but inside it):
                        var atStart = (pContent && "&nbsp;"==pContent) ? true : false;
                        range.collapse(atStart);  // false means end of range
                        selection.removeAllRanges();
                        selection.addRange(range);  // make new range visible
                        
                        this.textEdit.focus();
                        
                        //alert("In citationRichEditor.adjustInitialSelection(), after this.textEdit.focus() for standard");
                    }
                    else {
                        this.textEdit.selectionRange.moveToElementText(childNode);
                        this.textEdit.selectionRange.collapse(false);
                        this.textEdit.selectionRange.select();
                        this.textEdit.focus();
                    }
                }
            }
        }
    }
}

// =========== Methods and functions formerly in citation_RichTextEditorExtensionl.js =====================

// Function WRS_textStartup()
// Called after a brief delay when initializing the dialog.
// Corrects an intermittent problem with IE's initial selection placement.
// Note: this is just a function, not a class method!
function WRS_textStartup() {
    if (g_RichEditor && g_RichEditor.initialized) {
        // (S0893302 brcarb 08/30/12):
        //var isHeaderFooterText = this.hasOwnProperty("g_contentKind");
        var isHeaderFooter = g_RichEditor.isHeaderFooter;
        // (brcarb 02/16/12 fixes S0833930) Changed to work around issue with citation_RichTextEditField not 
        // working in Firefox for a RichTextEditor that is in a DIV that is styled as hidden.
        // Skip the selection initializion adjustment if this is a Firefox body Text or a
        // header/footer text that is hidden or the contentKind is set to something other than text:
        
        if ( isBrowserIE() || (! isHeaderFooter) || (isHeaderFooter && "text" == g_contentKind))    // S0893302
        {
            g_RichEditor.adjustInitialSelection();
        }
    }
}

// --- event handlers ---

// Note: This is a function, not a method:
// Event handler for Hyperlink click.
// Note: See citation_RichTextEditor_FontPicker.html for event trigger.
function WRS_onWaitCreateHyperLink() {
    //S0503903: Don't set focus, it messes up IE selection in some cases:
    //g_RichEditor.textEdit.focus();  // Restore the selection in the text edit field
    // Note: must wait a while to have selection object updated in text edit element:
    setTimeout('g_RichEditor.onClickHyperlink()', 50);
    return false;
}


// Method citation_RichEditor.onClickHyperlink()
// Process click (or Enter) on Hyperlink button in extended FontPicker toolbar.
// Note that there is no evt arg passed.
citation_RichEditor.prototype.onClickHyperlink = function() {
    //alert("In citation_RichEditor.onClickHyperlink()");
    var params = '';
    var fromHeaderFooter = false;
    fromHeaderFooter = this.isHeaderFooter;
    if (this.isHeaderFooter)
        params += '&fromHeaderFooter=true';
    else
        params += '&fromHeaderFooter=false';    
    this.textEdit.getSelectionRange();
    var linkText = (this.textEdit.isBrowserIE) ? this.textEdit.selectionRange.htmlText : this.textEdit.selectionRange.toString();
    var linkInfo = this.getLinkInfo();
    if (null == linkInfo.elem) {    // No existing link?
        if (this.textEdit.isRangeCollapsed()) {
            alert(g_RichEditor.getJspString("error.text.hyperlink.nothing.selected.txt"));
                //"To create a link, please select some text first."
            return false;
        }
        else {  // Not collapsed, have selection
            // Strip trailing blank if any:
            if (linkText.lastIndexOf(' ') + 1 == linkText.length) {
                if (this.textEdit.isBrowserIE) {
                    this.textEdit.selectionRange.moveEnd('character', -1);
                    this.textEdit.selectionRange.select();
                    linkText = this.textEdit.selectionRange.htmlText;
                }
                else {
                    if (this.textEdit.selectionRange.endOffset > 0) {
                        this.textEdit.selectionRange.setEnd(this.textEdit.selectionRange.endContainer, this.textEdit.selectionRange.endOffset-1);
                        linkText = this.textEdit.selectionRange.toString();
                    }
                }
            }
            if (! this.canCreateLink()) {
                alert(g_RichEditor.getJspString("error.text.hyperlink.cannot.create.txt"));
                    //"The selected text cannot be made into a link."
                return false;
            }
        }
    }
    else { // Have existing link(s) in the selection
        if (linkInfo.isMultiple) {
            alert(g_RichEditor.getJspString("error.text.hyperlink.multiple.select.txt"));
                //"More than one link is selected. To see the link properties, please click on only one link."
            return false;
        }
        else { // Exactly one link in the selection
            // Select the existing link and retrieve its properties:
            var linkElem = linkInfo.elem;
            if (this.textEdit.isBrowserIE) {
                this.textEdit.selectionRange.moveToElementText(linkElem);
                this.textEdit.selectionRange.select();
                linkText = linkElem.innerHTML;
            }
            else {
                this.textEdit.selectionRange.selectNodeContents(linkElem);
                linkText = linkElem.innerHTML;
            }
            var linkType = linkElem.getAttribute('linkType');
            var destination = linkElem.getAttribute('destination');
            var title = linkElem.getAttribute('title');
            var useCurrentWindow = linkElem.getAttribute('useCurrentWindow');
            if (null == linkType) { // We didn't create link, IE did (e.g. user typed www.x.com)?
                linkType = "WEB_SITE";
                destination = linkElem.getAttribute("HREF");
            }
            //alert("In citation_RichEditor.onClickHyperlink() fromHeaderFooter: " + fromHeaderFooter + " useCurrentWindow: " + useCurrentWindow);
            if(fromHeaderFooter == true && useCurrentWindow != null && useCurrentWindow != undefined)
                params += '&linked=true&linkType=' + linkType + '&tooltipText=' + encodeURI(title) + '&useCurrentWindow=' + useCurrentWindow;
            else
                params += '&linked=true&linkType=' + linkType + '&tooltipText=' + encodeURI(title) + '&useCurrentWindow=false';
            if (linkType == 'ANOTHER_REPORT')
                params += '&reportUrl=' + encodeURIComponent(destination);
            else
                params += '&webUrl=' + encodeURIComponent(destination);
/* ------- 
   Parm passing from text links has yet to be supported
   -------
            var numPrompts = linkElem.getAttribute('numPrompts');
            for (i = 0; i < numPrompts; i++) {
                var promptID = linkElem.getAttribute('promptID' + i);
                var dataItemID = linkElem.getAttribute('dataItemID' + i);
                params += '&builderDefinePromptsBean.mappedPromptIDs[' + i + ']=' + promptID;
            }
--------- */
        }
    }
    // S0481095: Following 3 lines commented out due to CDD change:
    //if (this.textEdit.isBrowserIE) {
    //    this.textEdit.focusBookmark = this.textEdit.selectionRange.getBookmark();  // Save current selection
    //}
    var textRange = this.textEdit.selectionRange;   // Needed for inline func arg below
    var winHandle = cwDialogManager.openDialog(
            'builderTextLinking.do?dialogCommand=openDialog' + params, //dlgUrl
            cwDialogManager.BUILDER_TEXT_LINK, // dlgName
            cwDialogManager.BUILDER_TEXT_LINK, // dlgFeatures
            true,  // bReplaceUrl
            true,  // bModal
            true,  // bReplaceIfOpen
            null,  // onDialogClosingFunc
            null,  // onDlgClosedFunc
            function (status, newDlg) { // Callback function when dialog exists
                    showDebugMsgs("citation_RichEditor.onClickHyperlink", "In callback, status="+status);
                    if ('ready' == status || 'exists' == status) {  // normal
                        // ************** IMPORTANT NOTE!!! **************
                        // *** Do *NOT* attempt to replace the following lines with
                        // *** "equivalent" calls to registerEventHandler() or dojo.event.connect()!
                        // *** They will not work (because they do "closure magic" that assumes
                        // *** the handler node is in the same window as this one, which it is not)!
                        // ************************************************
                        if (newDlg.dlgWindow.addEventListener) {  // DOM way
                            newDlg.dlgWindow.addEventListener("unload", function(){WRS_insertLink(newDlg.dlgWindow, textRange, linkElem, linkText, fromHeaderFooter);}, false);
                        }
                        else if (newDlg.dlgWindow.attachEvent) { // IE way
                            newDlg.dlgWindow.attachEvent( "onunload", function(){WRS_insertLink(newDlg.dlgWindow, textRange, linkElem, linkText, fromHeaderFooter);});
                        }
                        // *** See note above!
                    }
                }
            );
    return;
}

// callback function to handle creation of hyperlink, after the dialog
// for setting the hyperlink values is closing
// linkElem is null if no existing <a>
function WRS_insertLink(linkingDialog, textRange, linkElem, linkText, fromHeaderFooter) {
    if (linkingDialog && ! linkingDialog.g_okInReportLinking) {  // (S0478574) was linkind dialog just canceled?
        return false
    }
    var textEdit = g_RichEditor.textEdit;
    var form = linkingDialog.window.document.forms['buildReportLinkDialogForm'];
    if (form == null) return;
    if (form.elements['linked'].checked == false) { // Removing link if any
        if (textEdit.isBrowserIE) {
            textRange.execCommand('Unlink', true, 0);
        }
        else {
            if (linkElem) {
                linkElem.parentNode.removeChild(linkElem);
                textEdit.insertHtml(linkText);  // put back as plain text
            }
        }
        return;
    }
    if (form.elements['linked'].checked == false) return;
    var linkTypeRadio = form.elements['linkType'];
    var tooltip = form.elements['tooltip'].value;
    var destination = '';
    var linkType = 'WEB_SITE';
    var currentWindowChecked = false;
    
    if (linkTypeRadio[0].checked == true) {
        destination = form.elements['reportUrl'].value;
        linkType = 'ANOTHER_REPORT';
    } else if (linkTypeRadio[1].checked == true) {
        destination = form.elements['webUrl'].value;
        linkType = 'WEB_SITE';
        if(form.elements['useCurrentWindow'] != null)
        {
            if(form.elements['useCurrentWindow'].checked)
                currentWindowChecked = true;
        }        
    }
    var numDataItems = WRS_getFieldValue(form, 'numDataItems');
    var count;
    var prompts = '';
    for (count = 0; count < numDataItems; count++) {
        var promptID = WRS_getFieldValue(form, 'promptID' + count);
        var dataItemID = WRS_getFieldValue(form, 'dataItemID' + count);
        prompts += ' promptID' + count + '=\"' + promptID + '\"';
        prompts += ' dataItemID' + count + '=\"' + dataItemID + '\"';
    }
    if (numDataItems > 0) {
        prompts += ' numPrompts=\"' + numDataItems + '\"';
    }
    
    var newHtml = null;
    if(currentWindowChecked == true)
        newHtml = '<a href=\"\" linkType=\"' + linkType + '\" destination=\"' + destination + '\" useCurrentWindow=\"true\" title=\"' + tooltip + '\"' + prompts + '>' + linkText + '</A>';
    else
        newHtml = '<a href=\"\" linkType=\"' + linkType + '\" destination=\"' + destination + '\" title=\"' + tooltip + '\"' + prompts + '>' + linkText + '</A>';

    if (textEdit.isBrowserIE) {
        textRange.pasteHTML(newHtml);
    }
    else {
        textRange.deleteContents();
        textEdit.insertHtml(newHtml);   // put back as plain text
    }

    textEdit.getSelectionRange();
    if (textEdit.isBrowserIE) {
        textEdit.focusBookmark = textEdit.selectionRange.getBookmark();
    }
}

// IE has a bug not adding dynamically created fields
// as named properties so we loop through the elements array
function WRS_getFieldValue (form, fieldName) {
   for (var e = 0; e < form.elements.length; e++) {
      if (form.elements[e].name == fieldName)
         return form.elements[e].value;
      }
   return null;
}


// (brcarb 09/28/12) S0902149:
// For IE ONLY, move the insertion point to after the very last character
// in the RTE.  This is a function, not a method.
function WRS_ieMoveSelectionToEndCollapsed()
{
    var textEdit = g_RichEditor.textEdit;
    textEdit.focus();
    textEdit.getSelectionRange();
    var bExtended = true;
    while (bExtended)
    {
        bExtended = textEdit.extendRange(1);
    }
    textEdit.selectionRange.collapse(false);
    textEdit.selectionRange.select();
}

// This is a function, not a method
// sel is the select element, type is 8 for prompt or 9 for measure,
// or 0-7 for a header/footer dynamic item.
function WRS_onInsertDynamicText(sel, type)
{
    var textEdit = g_RichEditor.textEdit;
    textEdit.focus();
    textEdit.getSelectionRange();
    //alert(" In WRS_onInsertDynamicText, g_useLegacyDynamicItems="+g_useLegacyDynamicItems);
    if (g_useLegacyDynamicItems)
    {
    
        // Due to IE issues, disallow insertion if either end of the
        // selection is in or immediately adjacent to another text proxy:
        if (! g_RichEditor.canInsertProxy()) {  // Can't insert?
            alert(g_RichEditor.getJspString("error.dynamic.text.cannot.insert.txt"));
                //"Cannot insert a dynamic item while another dynamic item is selected, or while the insertion point is next to a dynamic item."
            return false;
        }
        var dtTypeValue = "" + type;    // As sting
        var dtItemValue = sel.options[sel.selectedIndex].value;
        var value = sel.options[sel.selectedIndex].innerHTML;
        var outerProxyId = g_RichEditor.textEdit.insertTextProxy(value, value);

        // Update selection and focus bookmark after the insert is done:
        textEdit.getSelectionRange();

        // S0426450: Following 3 lines commented out, because apparently
        // at some point the citation_richTextEditField.js was changed
        // to take care of this internally(?):
        //if (textEdit.isBrowserIE) {
        //    textEdit.focusBookmark = textEdit.selectionRange.getBookmark();
        //}

        // Apply the ROM-specific properties needed:
        if (outerProxyId) {
            var outerProxy = textEdit.editDoc.getElementById(outerProxyId);
            if (outerProxy) {
                // Save WRS data attributes on outer proxy (was inner proxy in 3.1)
                // Also attirbute is lower case now, was camel-case in 3.1.
                outerProxy.setAttribute("wrs.dttype", dtTypeValue);
                if (dtItemValue && "" != dtItemValue) {
                    outerProxy.setAttribute("wrs.dtdataitem", dtItemValue);
                }
            }
        }
    }
    else // (brcarb) Using WRS 4.4 bracktet item with plain text to represent dynamic items
    {
        // (brcarb 10/01/12) S0902149:
        var bNeedIeFix = false;
        if (g_client && g_client.browser && g_client.browser.isIe)  // IE only
        {
            bNeedIeFix =  ! textEdit.canExtendRange(1);   // true if nothing to right of caret        
            if (! bNeedIeFix)   // Still need to check for special case of first time empty content?
            {
                // Also need to check for case where the P element is completely empty,
                // which also needs the same bug-fix for IE:
                var ancestorElem = textEdit.getFixedCommonAncestor();
                if (ancestorElem.nodeType == 1 && ancestorElem.tagName == "P")
                {
                    var pKids = ancestorElem.childNodes; 
                    if (pKids.length == 0) // Nothing at all in the paragraph?
                    {
                        bNeedIeFix = true;
                    }
                }
            }
        }
        var itemText = "[" +  sel.options[sel.selectedIndex].innerHTML + "]";
        textEdit.insertHtml(itemText); 
        // (brcarb 09/28/12) S0902149:
        if (bNeedIeFix)
        {
            textEdit.focus();
            textEdit.getSelectionRange();
            // Must wait till the doc is updated before we can move the caret to work around IE bug:
            setTimeout("WRS_ieMoveSelectionToEndCollapsed();", 50);
        }
        
    }
    textEdit.focus();
}

// This is a function, not a method
// Returns the final HTML to be submitted for the form.
// TODO: Most of the "fix-up" stuff that works around browser issues, etc
// in this function should really be moved into citation_RichTextEditField.js.
function WRS_getResultHtml() {
    var textEdit = g_RichEditor.textEdit;
    if (!textEdit) {
        throw( new Error("Rich Text Editor returned undefined text") );
    }
    textEdit.removeUnneededTags();

    // Fix any links that were automatically created by IE, so they
    // have the attributes expected by WRS:
    g_RichEditor.walkTreeFixLinks(textEdit.editDoc.body);
    var value = "<HTML>" + textEdit.getHtml() + "</HTML>";
    
    // S0910118 (brcarb 10/26/12):
    // Chrome and Safari may have generated <b>...</b> in response to Ctrl+B,
    // or <i>...</i> in response to Ctrl+I, or <u>...</u> in response to Ctrl+U 
    // (the latter is blocked in Safari).  These will not be recognized for for 
    // conversion to WRS ROM model, so we must convert them to equivalent <span style="...">...</span>.
    // Also Chrome may generate un-needed attributes on B, I or U elements when used in
    // conjunction with other styles, so can't just match <b>, <i>, and <u>.
    // Instead, we must match (for example) "<b>", or "<b" followed by whitespace character followed by 
    // any number of characters except">" followed by ">":  Note that we can't just look for <b followed
    // by any number of charactrers other than > followed by >, because that would match <body>!
    value = value.replace(/<b>/g, '<span style="font-weight: bold; ">');
    value = value.replace(/<b\s[^>]*>/g, '<span style="font-weight: bold; ">');
    value = value.replace(/<\/b>/g, '</span>');
    value = value.replace(/<i>/g, '<span style="font-style: italic; ">');
    value = value.replace(/<i\s[^>]*>/g, '<span style="font-style: italic; ">');
    value = value.replace(/<\/i>/g, '</span>');
    value = value.replace(/<u>/g, '<span style="text-decoration: underline; ">');
    value = value.replace(/<u\s[^>]*>/g, '<span style="text-decoration: underline; ">');
    value = value.replace(/<\/u>/g, '</span>');

    // Remove newlines, non-breaking spaces, and fix invalid IE-specific tag:
    value = value.replace(/\r/g,"");
    value = value.replace(/\n/g,"");

    // Work around Firefox bug that generates unwanted <br> elements:
    value = value.replace(/<br>/gi,"");
    
    // (S0413517 03/22/07, UPDATED 05/02/07): 
    // The following line works around a bug in IE's TextRange.pasteHTML() method,
    // that may have been called earlier (in citation_RichTextEditField insertTextProxy()).
    // IE erroneously removes the quotes from the class and id attributes of the span,
    // making the HTML illegal.
    // We fix this by restoring the quotes, being careful to not modify similar user-entered
    // text that might occur elsewhere.  Note that the class="rte_textproxy" is a new
    // attribute effective 05/03/07; previously we only fixed the id. May be present with or without ID:
    // (S0633851) UPDATED 01/04/10 for IE8 in IE7 "compatibility mode", which still strips off the quotes
    // but reverses the order of the class and id attributes.  So we first try to match the IE8 bug, then
    // the IE7 bug, and then the IE6 bug:
    value = value.replace(/<SPAN id=_textProxy_(\d+) class=rte_textproxy /gi, '<SPAN class="rte_textproxy" id="_textProxy_$1" ');
    value = value.replace(/<SPAN class=rte_textproxy id=_textProxy_(\d+) /gi, '<SPAN class="rte_textproxy" id="_textProxy_$1" ');
    value = value.replace(/<SPAN class=rte_textproxy /gi, '<SPAN class="rte_textproxy" ');
    
    // (S0428969 06/04/07):
    // This line works around the IE bug where IE removes the quotes around the attribute
    // value for the title attribute if the value contains no blanks
    // (for example, <a title=testing href=...> is corrected to <a title="testing" href=...>).
    value = value.replace(/<A title=([^"])(\S+)/gi, '<A title="$1$2"');
    
    // (S0580434 10/14/09 and earlier) The following works around the IE bug where IE generates
    // illegal HTML for design mode by not putting quotes around the name attribute value
    // in the META tag and not having a matching </META> tag at all in IE7 and IE8.  It generates different illegal content for IE6, IE7 and IE8, so
    // we look for all three.  Note we include < or > in all matches to avoid false positives with
    // user-entered content (which would already be escaped):
    if (value.indexOf("name=GENERATOR></META>") > 0) {  // IE6 pattern
        value = value.replace(/name=GENERATOR>/gi,"name=\"GENERATOR\">"); 
    }
    else if (value.indexOf("<META name=GENERATOR ") > 0) { // IE8 pattern
        value = value.replace(/<META name=GENERATOR /gi,"<META name=\"GENERATOR\" "); 
        if (value.indexOf("</META>") <= 0) {    // Missing matching end tag?
            // Assume the missing tag goes before the </HEAD> tag
            value = value.replace(/<\/HEAD>/gi,"</META></HEAD>"); 
        }
    }
    else {  // IE7 or not IE at all
        value = value.replace(/name=GENERATOR>/gi,"name=\"GENERATOR\"></META>"); // IE Specific tag
    }

    return value;
}

// =========== Functions formerly in builderHeaderFooterDialogContent.jsp =====================

function onChangeDynamicText(selection) {
    var btn = findDOM(selection.id + 'Button');
    if (btn) {
        btn.disabled = (selection.options[selection.selectedIndex].value == "None" ? true : false);
    }
// Note: Do not set focus back to textEdit here (for sec 508 accessibility to work)
}


// value is 'left", "center" or "right"
function setBannerAlignment(value)
{
    dojo.byId("bannerAlignment").value = value;
    dojo.byId("banner_align_left_div").className = ("left" == value) ? "imageSelectedStyle" : "imageStyle";
    dojo.byId("banner_align_center_div").className = ("center" == value) ? "imageSelectedStyle" : "imageStyle";
    dojo.byId("banner_align_right_div").className = ("right" == value) ? "imageSelectedStyle" : "imageStyle";
    alignBannerImage(value);
    
}

function onInsertDynamicText(sel) {
    var dtTypeValue = sel.selectedIndex + 1;
    WRS_onInsertDynamicText(sel, dtTypeValue);
}

function alignBannerImage(value) {
    var bannerSelectElem = findDOM('bannerImage');

    if (bannerSelectElem.options[bannerSelectElem.selectedIndex].value != 'None') {
        var thumbnailContainerFormField = findDOM('thumbnailContainer_imageSelected');
        thumbnailContainerFormField.align=value;
    }
}

// Function to change Thumbnail image when a new banner is selected from drop down
function onImageChange() {
    var bannerSelectElem = findDOM('bannerImage');

    if (bannerSelectElem.options[bannerSelectElem.selectedIndex].value == 'None') {
        var imageThumbnailDivElem = findDOM('thumbnailContainer_imageSelected');
        var bannerThumbnailImgElem = findDOM('thumbnailImageElement');

        if (imageThumbnailDivElem != null) {
            imageThumbnailDivElem.style.display = 'none';
        }
        if (bannerThumbnailImgElem != null) {
           // CAUTION: Setting an image src to an empty string will cause an extra
           // http request in a seperate thread to the base href!!!!
            //bannerThumbnailImgElem.src="";

        }
    }
    else    // selected an image
    {
        var dialogCommandFormField = findDOM(g_RichEditor.getJspString("CitationDialogAction.DIALOG_CMD_KEY"));
        dialogCommandFormField.value = g_RichEditor.getJspString("CitationDialogAction.CMD_APPLY_DIALOG_KEY");
        // Get the selected image info:
        var objForm = document.forms['builderHeaderFooterForm'];
        var selectedItemUrl = bannerSelectElem.options[bannerSelectElem.selectedIndex].value;
        // Make AJAX call to the Image utility to get the equivalent URL needed:
        var imageUrlStr = "builderBrowseImageRespositoryApplyCommand.do?dialogCommand=applyDialog&applyCommand=processThumbnailRequest&selectedImageForThumbnailUrl="+selectedItemUrl;
        dojo.io.bind({
                method: "POST",
                url: imageUrlStr,
                handle: function(type, data, evt){onImageChangeReturn(type, data, evt);},
                formNode: objForm,
                mimetype: "text/plain"
        });
    }
}

// Work around IE bug that triggers on change when mousewheel is turned when select has focus
function onMouseWheel(evt) {
    return cwAbsorbEvent(evt);        
}

// Callback function for AJAX that gets the URL that can be directly
// applied to the IMG element src attribute to update the banner thumbnail
function onImageChangeReturn(type, data, evt) {
    if (data != null)  {
        var imageThumbnailDivElem = findDOM('thumbnailContainer_imageSelected');
        var bannerThumbnailImgElem = findDOM('thumbnailImageElement');

        if (imageThumbnailDivElem != null) {
            imageThumbnailDivElem.style.display = 'block';
        }
        if (bannerThumbnailImgElem != null) {
           if (data != '')
               bannerThumbnailImgElem.src=data;
        }
        var mode = findDOM('bannerAlignment').value;
        alignBannerImage(mode);
    }

    var dialogCommandFormField = findDOM(g_RichEditor.getJspString("CitationDialogAction.DIALOG_CMD_KEY"));
    dialogCommandFormField.value = g_RichEditor.getJspString("CitationDialogAction.CMD_OK_DIALOG_KEY");
}
