<%@ page contentType="text/html; charset=utf-8" %>
<%@ page language="java" %>
<% try { // START: DEBUG %>
<%@ page pageEncoding="UTF-8" isErrorPage="true" %>
<%-- NOTE: do not use tiles in this file
           as the error page needs to be as basic as possible;
           however, the banner is being used to help keep WRS visible
--%>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="http://www.sas.com/taglib/sas" prefix="sas" %>
<%@ taglib uri="http://www.sas.com/taglib/sas-uis" prefix="sas-uis"%>

<html:xhtml />
<%@ page import="com.sas.apps.citation.view.beans.PagePropertyBean
                ,com.sas.apps.citation.view.tbeans.html.CitationButton
                ,com.sas.apps.citation.view.util.ThemeUtils
                ,com.sas.apps.citation.view.util.ViewUtils
                ,com.sas.apps.citation.util.CitationException
                ,com.sas.apps.citation.util.CommonUtils
			    ,com.sas.apps.citation.util.PropertyHelper
                ,java.io.PrintWriter"
%>
<%
    String pageTitle = ViewUtils.getWindowTitle(request);
    String subTitle = PagePropertyBean.getLabel(pageContext,"request.error.title.txt");
    if (! CommonUtils.isEmptyOrWhiteSpace(subTitle)) {
        pageTitle += ": " + subTitle;
    }
    boolean closeWindowOnError = ViewUtils.isInSecondaryPage(request);
    boolean showJavaScriptDebugging =
            PropertyHelper.getPropertyAsBool("webreportstudio.show.javascript.debugging", false);
%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="<%=ViewUtils.getLocale(pageContext).getLanguage()%>" <%=ViewUtils.getDirection(pageContext)%> >
<head>
    <sas-uis:Timeout/>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8" />
    <title><%=pageTitle%></title>
    <% if (showJavaScriptDebugging) { %>
    <script type="text/javascript" src="<%=ViewUtils.getWebAppRelScriptsPath()%>dojo/dojo.js.uncompressed.js"></script>
    <% } else { %>
    <script type="text/javascript" src="<%=ViewUtils.getDojoIncludePath()%>dojo.js"></script>
    <% } %>
    <%
        PrintWriter printWriter = new PrintWriter( out );
        com.sas.servlet.util.Components.init(printWriter, request);
    %>
    <script type="text/javascript" src="scripts/sas_Common.js"></script>
    <script type="text/javascript" src="scripts/citation.js"></script>
    <script type="text/javascript" src="scripts/citation_events.js"></script>
    <script type="text/javascript" src="scripts/citation_dialogUtils.js"></script>
    <script type="text/javascript" src="scripts/citation_button.js"></script>
    <script type="text/javascript"> /*<![CDATA[*/
    window.name='SAS_WebReportStudio_Invalid_Request_Window';
    g_closeWindowOnError = <%=closeWindowOnError%>;
    /*]]>*/ </script>

    <sas:StyleSheet/>

    <%=ThemeUtils.getCitationThemableStyleSheetImportHtml(request, "citation.css")%>
    <%=ThemeUtils.getCitationThemableStyleSheetImportHtml(request, "citation_mainPageLayout.css")%>
</head>

<body oncontextmenu="return <%=ViewUtils.isContextMenuAllowed(request, false)%>">


<!-- BEGIN: banner table -->
<div id="wrsBannerAndTopMenu">   <!-- Start of WRS required banner div -->

    <!-- BEGIN: banner table -->

    <!-- Top Table: Banner Bottom (secondary menu table) removed later if is in dialog -->
    <table id="invalidRequestPageBannerLayoutTable" summary="" width="100%" class="layoutTable">
        <tr>
            <td>
                <jsp:include page="tiles-components/banner/banner.jsp"/>
            </td>
        </tr>
    </table>
    <!-- End Top Table -->

</div> <!-- End of WRS required banner div -->


<table border="0" cellpadding="0" cellspacing="0" width="100%" height="80%" summary="">
    <tr>
        <!-- BEGIN: main content area -->
        <td style="vertical-align:top; width:100%; height:100%">

            <table border="0" cellspacing="0" cellpadding="0" width="100%" summary="" >
                <tr><td class="linePadding">&nbsp;</td></tr>
                <tr><td class="linePadding">&nbsp;</td></tr>
                <tr><td class="linePadding">&nbsp;</td></tr>
                <tr><td class="linePadding">&nbsp;</td></tr>
                <tr><td class="linePadding">&nbsp;</td></tr>
                <tr><td class="linePadding">&nbsp;</td></tr>
                <tr><td class="linePadding">&nbsp;</td></tr>
                <tr><td class="linePadding">&nbsp;</td></tr>
                <tr>
                    <td align="center">
                        <table border="0" cellspacing="0" cellpadding="0" summary="" >
                            <tr>
                                <td class="errorMessages">
                                    <%=PagePropertyBean.getLabel(pageContext, "request.error.txt")%>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr><td class="linePadding">&nbsp;</td></tr>
                <tr><td class="linePadding">&nbsp;</td></tr>
                <tr><td class="linePadding">&nbsp;</td></tr>
                <tr>
                    <td align="center">
                        <table border="0" cellspacing="0" cellpadding="0" summary="" >
                            <tr>

                                <td class="buttonSpacer">&nbsp;</td>
                                <td class="buttonSpacer">&nbsp;</td>
                                <td>
                                    <%
                                        CitationButton closeButton = CitationButton.createStandaloneButton(request, "closeButton",
                                                PagePropertyBean.getLabel(pageContext,"request.error.close.txt"),
                                                "javascript:onClose();");
                                        closeButton.write(out);
                                    %>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>

        </td>
    </tr>
</table>
<script type="text/javascript">
    /* <![CDATA[*/

    function onClose() {
        location.href = 'welcome.do';
    }

    // If this page is in a dialog window, remove the banner
    // (Defect S0527599, S0528739)
    function onInvalidRequestPageLoaded(evt)
    {
        var winOpener = self.opener;
        if( winOpener != null && winOpener.cwDialogManager != null) // Is in a dialog?
        {
            var bannerLayoutTable = dojo.byId("invalidRequestPageBannerLayoutTable");
            if (bannerLayoutTable)
            {
                wrsShowElement(bannerLayoutTable, false);   // Hide the banner
            }
        }
    }

    dojo.addOnLoad(onInvalidRequestPageLoaded);

    /*]]>*/
</script>


</body>
</html>
<% } catch (Exception ex) { // MIDDLE: DEBUG
    System.out.println(PagePropertyBean.getMessage(pageContext, "request.error.fatal.txt"));
    ex.printStackTrace();

    // generate stack trace & stash in session.
    StringBuffer trace = new StringBuffer(500)
            .append("<h3>")
            .append(PagePropertyBean.getMessage(pageContext, "request.error.fatal.txt"))
            .append("</h3>")
            .append("<pre>");               // honor newlines in stack trace.
    CitationException.generateStackTrace(ex, trace);
    trace.append("</pre>");
    out.println(trace.toString());
} // END: DEBUG %>
