define([
    "dojo/_base/array",			// array
    "dojo/_base/declare",		// declare
    "dojo/_base/lang",			// lang
    "dijit/_WidgetBase",	// _WidgetBase
    "dojo/dom-class",		// domClass
    "dojo/dom-construct",	// domConstruct
    "dojo/dom-style",		// domStyle
	"dojo/i18n",			// i18n
    "dojo/parser",
    "dojo/on",					// on
    "dojo/topic",				// topic
    "dojo/store/Memory",		// Memory
    "dojo/store/Observable",	// Observable
    "dojo/data/ObjectStore",
    "dijit/registry",
    "dijit/Dialog",
    "dijit/form/Button",
    "dijit/layout/ContentPane",
    "dgrid/OnDemandGrid",
    "dgrid/extensions/ColumnResizer",    // ColumnResizer
    "dgrid/extensions/DijitRegistry",    // DijitRegistry,
    "./_CTMControlsMixin",	// _CTMControlsMixin
    "./_CTMConstantsMixin"	// _CTMConstantsMixin
], function(array, declare, lang, _WidgetBase,domClass, domConstruct, domStyle,
            i18n, parser, on, topic, Memory, Observable,
            ObjectStore, registry, Dialog, Button, ContentPane, Grid,ColumnResizer,
            DijitRegistry,
            _CTMControlsMixin, _CTMConstantsMixin, nls)
{
    var CTMVariableSummary = declare([_WidgetBase, _CTMControlsMixin, _CTMConstantsMixin], {
		constructor: function() {
			// 2015-03-18 sasjkx (related to S1145713).  Going back to
			//	getResourceBundle.  Note that getResourceBundle is hard-coded
			//	to the "webdms" module.  But during control refactor, most
			//	strings stayed in DMSTask_nls resource bundle (which is
			//	in "webdms" module), so that's ok here.
			if (!this.nls) {
				this.nls = i18n.getLocalization("webdms/ctmControls", "CTMVariableSummary_nls");
			}
		},

        buildRendering: function () {
            this.domNode = domConstruct.create("div");
            this.enabled = true;	// flag to indicate that the entire control is enabled.
            var name = this.optionItemDefinition.name;

            //Create the button
            button = new Button({
                id: this.idPrefix + name + "_button",
                "class": "sasDefaultTextButton",
                label: this.nls.sasTabPropTitle,
                "onClick": lang.hitch(this, this.getVarSummaries)
            });
            button.valueNode.setAttribute("aria-hidden", true);

            this.domNode.appendChild(button.domNode);
            button.startup();

            //this.inherited(arguments);
            // _onTaskInitializationComplete will be executed when topic is published
			//NOTE: override of _handleInitComplete is necessary when this is registered.			
			this.registerInitCompleteSubscription();            
        },

		/*override: part of contract for registerInitCompleteSubscription*/
		_handleInitComplete: function() {
            this._updateCTMContext();
        },

        postCreate: function () {
            this.inherited(arguments);
            topic.subscribe(this.idPrefix + "/" + this.getOptionMetadata("source") + "/tableColumns",
                lang.hitch(this, this.updateTableName));
        },

        updateTableName: function (tableName, columns) {

            this.tableName = tableName;

            var periodIndex = this.tableName.indexOf(".");
            this.libref = this.tableName.substring(0, periodIndex);
            this.member = this.tableName.substring(periodIndex + 1);
        },

        getVarSummaries: function () {
            if (this.tableName !== undefined) {
                dojo.xhrPost({
                    url: './sasexec/sessions/' + appDMS.sessionId + '/tables/' + this.libref + '/' + encodeValue(this.member)+ '/',
                    handleAs: "json",
                    headers:{
                        "Content-Type":"application/json"
                    },
                    preventCache: true,
                    content: {
                        isMultipleWorkspace: appDMS.multipleWorkspaceMode
                    },
                    load: lang.hitch(this, function (data, args) {
                        this.buildTablePropsDlg(data);
                    }),
                    error: lang.hitch(this, function (err, args) {
                            if (err && err.response && err.response.xhr) {
                                appDMS.dialogs.postFaultDialog(err.message);
                            }
                        }
                    )
                });
            }
        },
        buildTablePropsDlg: function (tableData) {
            var title = this.nls.sasTabPropTitle;

            var oldPropsTab = dijit.byId("propsDlg");
            if (oldPropsTab) {
                oldPropsTab.destroy();
            }

            var propsDlg = new Dialog({
                title: title,
                style: "width:600px",
                id: "propsDlg",
                content: "<div id='propsTab'></div>"//,
  /*              onShow : lang.hitch(this, function(){
                   // this.inherited(arguments);
                    this.ColumnGrid.startup();
                    this.ColumnGrid.resize();
                })
*/
            });

            dojo.connect(propsDlg, "onHide", lang.hitch(this, function (evt) {
                propsDlg.destroyRecursive(false);
                if (dijit.byId("propsTab") && dijit.byId("propsTab") !== null)
                    dijit.byId("propsTab").destroy();
            }));

            //Variable summary table
            var dGridStoreArray=[];
            var object;
            for (var i = 0; i < tableData.columns.length; i++)
            {
                if (tableData.columns[i]['type'] == "Char")
                    tableData.columns[i]['type'] = this.nls.char;
                else if (tableData.columns[i]['type'] == "Numeric")
                    tableData.columns[i]['type'] = this.nls.numeric;

                object          = new Object();
                object.name     = tableData.columns[i]['name'];
                object.label    = tableData.columns[i]['label'];
                object.type     = tableData.columns[i]['type'];
                object.length   = tableData.columns[i]['length'];
                object.format   = tableData.columns[i]['format'];

                dGridStoreArray.push(object);
            }

            var columnTabGridColumns = [
                {label: this.nls.columnName,     field: 'name',     id: 'name',
                    renderHeaderCell : lang.hitch(this, this._renderHeaderCellCol, this.nls.columnName)},
                {label: this.nls.labelHeader,    field: 'label',    id: 'label',
                    renderHeaderCell : lang.hitch(this, this._renderHeaderCellCol, this.nls.labelHeader)},
                {label: this.nls.colTypeHeader,  field: 'type',     id: 'type',
                    renderHeaderCell : lang.hitch(this, this._renderHeaderCellCol, this.nls.colTypeHeader)},
                {label: this.nls.lengthHeader,   field: 'length',   id: 'length',
                    renderHeaderCell : lang.hitch(this, this._renderHeaderCellCol, this.nls.lengthHeader)},
                {label: this.nls.formatHeader,   field: 'format',   id: 'format',
                    renderHeaderCell : lang.hitch(this, this._renderHeaderCellCol, this.nls.formatHeader)}
            ];

            var customdGrid = declare([Grid, DijitRegistry, ColumnResizer ]);

            this.ColumnGrid = new customdGrid({
                class: "ctmAADGrid",
                columns: columnTabGridColumns
            });
            this.ColumnGrid.styleColumn("length",       "text-align: right;");
            this.ColumnGrid.styleColumn("name",         "min-width: 100px;");
            this.ColumnGrid.styleColumn("label",        "min-width: 100px;");


            this.ColumnGrid.renderArray(dGridStoreArray);
            domConstruct.place(this.ColumnGrid.domNode, propsDlg.containerNode, "first");

            //Action bar
            var actionBar = domConstruct.create("div", {"class": "dijitDialogPaneActionBar"}, propsDlg.containerNode);
            var closeButton = new Button({
                "label": this.nls.close,
                "class": "sasPrimaryButton",
                "onClick": lang.hitch(this, function (evt) {
                    propsDlg.hide();
                })
            }).placeAt(actionBar);
            closeButton.valueNode.setAttribute("aria-hidden", true);

            propsDlg.show();
        },

        //added renderHeaderCell so truncated header shows ellipsis and
        //hovering over header will show tooltip with complete header text
        _renderHeaderCellCol: function(label) {
            var newDiv = document.createElement("div");
            newDiv.title=label;
            var newContent = document.createTextNode(label);
            newDiv.appendChild(newContent);
            return newDiv;
        },

        _updateCTMContext: function(parmName){
            var parms = new Object();
            parms.dummy = "dummy";

            this.setProperty('value', parms);
            this.setParameterCallback(JSON.stringify(parms));
        }

    });

    return CTMVariableSummary;
});