define(["dojo/_base/lang",
    "dojo/_base/declare",
    "dojo/_base/unload",
    "dojo/cookie",
    "dojo/dom",
    "dojo/dom-class",
    "dojo/dom-style",
    "dojo/on",
    "dojo/dom-construct",
    "dojo/has",
    "dojo/data/ItemFileWriteStore",
    "dojo/keys",
    "dijit/focus",
    "dijit/Dialog",
    "dojo/store/Memory",
    "dojo/data/ObjectStore",
    "dijit/form/Select",
    "dijit/form/SimpleTextarea",
    "dijit/form/Button",
    "dijit/form/TextBox",
    "dijit/form/ValidationTextBox",
    "dijit/Menu",
    "dijit/registry",
    "dijit/form/Form",
    "dijit/MenuSeparator",
    "dijit/MenuItem",
    "dojox/grid/DataGrid",
    "dojo/aspect",
    "dojo/topic",
    "dijit/Tooltip",
    "dgrid/OnDemandGrid",
    "dgrid/extensions/ColumnHider",
    "dgrid/extensions/ColumnResizer",
	"dgrid/extensions/ColumnReorder",
    "dgrid/Keyboard",
    "dgrid/Selection",
    "dijit/_WidgetBase",
    "dgrid/extensions/DijitRegistry",
    "dojo/store/Observable",
    "dojo/store/DataStore",
    "dojox/widget/DialogSimple",
    "dijit/layout/ContentPane",
    "dijit/layout/BorderContainer",
    "dgrid/extensions/DnD",
    "dojo/store/JsonRest",
    "dijit/TitlePane",
    "dijit/Tree", 
	"dojo/request",
	"webdms/GitServices",
	"dojo/query"],

function (lang, declare, unload, cookie, dom, domClass, domStyle, on, domConstruct, has, ItemFileWriteStore, keys,focus,
Dialog, Memory, ObjectStore, Select, SimpleTextarea, Button, TextBox, ValidationTextBox, Menu, registry, form, MenuSeparator, MenuItem, DataGrid, aspect, topic,Tooltip,
dGrid, ColumnHider, ColumnResizer, ColumnReorder, Keyboard, Selection, _WidgetBase, DijitRegistry, Observable, DataStore, DialogSimple, ContentPane, BorderContainer, dGridDND, JsonRest, TitlePane, Tree, 
request, gitServices, query) {

    var DMSGit = declare("webdms.DMSGit", null, {
        baseURL: '.',
        projects: null,
        addDialog: null,
        propertyDialog: null,
        deleteDialog: null,
        tabs: null,
        sessionId: null,
        contextMenu: null,
        addMenuItem: null,
        deleteMenuItem: null,
        propertiesMenuItem: null,
        refreshMenuItem: null,
        localPane: null,
        fileRefGrid: null,
        dataStore: null,
        selectNewFileRef: null,
        eventListeners: null,
        gridRowLastKeyHovered: null,
        connected: true,
        fileRefGridSelection: [],
        constructor: function (sessionId, tabs, appDMS) {
            this.sessionId = sessionId;
            this.refreshing = false;
            this.dataStore = null;
            this.tabs = tabs;
            this.selectNewFileRef = null;
            this.eventListeners = [];
            this.addDialog = null;
            this.propertyDialog = null;
            this.deleteDialog = null;
            //for ie keyboard accessibility issue 
            this.gridRowLastKeyHovered = null;
            this.cuurentView=null;
            this.lastRepository="";
            this.activeRepository=null;
            this.activeBranch="master";
            this.selectedRepList = [];
            this.commitCounterList = [];
            this.unstagedChangesCounterList = [];
            this.stagedChangesCounterList = [];
            this.masterCount=0;
            this.stagedCounter=0;
            this.unStagedCounter=0;
            this.stagedList=[];
            this.unStagedList=[];
            this.historyList = [];
            this.detailsList = [];
          //  this.filesCounterList = [];
            this.filesCounter=0;
            this.filesSelectionList = [];
            this.login=true;
            this.doMorph=true;
            this.addToHistory=true;
            this.resourceBundle = getResourceBundle("DMSGit_nls");
            this.resourceHelpBundle = getResourceBundle("Help_nls");
            
            this.gitServices = new gitServices();
            
//            this.gitCustomdGrid = declare([ _WidgetBase, dGrid, ColumnHider, RowDnD, Keyboard, Selection, DijitRegistry]);
            this.gitCustomdGrid = declare([ _WidgetBase, dGrid, Keyboard, Selection, ColumnResizer, DijitRegistry]);
            topic.subscribe('appDMS/connectionChange', lang.hitch(this, this.handleConnectionChange));
        },			


        createUI: function () {
            this.mainPane = dijit.byId('gitrepositoryPane');
			this.createProfilePane();
			this.createRepositoryPane();
			
			var haveProfile = false;
			if (appDMS.sasStudioPreferences.optionPreferencesGitProfiles && appDMS.sasStudioPreferences.optionPreferencesGitProfiles.gitProfiles && appDMS.sasStudioPreferences.optionPreferencesGitProfiles.gitProfiles.length > 0)
				haveProfile = true;
			if (haveProfile == false)
			{
				this.showProfileView();
			}
			else  // We have a profile
			{
			    var haveRepository = false;
			    if (appDMS.sasStudioPreferences.gitRepositoryList.length > 0)
			    	haveRepository = true;
			    
				if (haveRepository == false)
				{
				    this.showRepoDefinitionView();
				}
				else   // We have a profile and repository
				{
				   var haveSelectedRepository = true;
				   if (!this.lastRepository || this.lastRepository === null || this.lastRepository === "PHOLDER" || this.lastRepository === "CLONE"){
					   haveSelectedRepository = false
				   }
				   if (haveSelectedRepository == false)
				   {
					   this.showRepoSelectionView();
				   }
				   else
				   {
					   this.showRepositoryView();
				   }
				}
			}
            
             //free the resources on windows unload - event listeners/handles
            unload.addOnWindowUnload(lang.hitch(this, this.releaseResources));
        },
		morphBasedOnState: function(optionPreferencesGitProfiles, repoList, lastRepository) {
			if (typeof optionPreferencesGitProfiles ==='undefined' || optionPreferencesGitProfiles === null){
				optionPreferencesGitProfiles = appDMS.sasStudioPreferences.optionPreferencesGitProfiles.gitProfiles;
			}
			if (typeof repoList ==='undefined' || repoList === null){
				repoList = appDMS.SASStudioPreferences.gitRepositoryList;
			}
			if (typeof lastRepository ==='undefined' || lastRepository === null){
				lastRepository = null;
			}
			if (typeof this.lastRepository === 'undefined' || this.lastRepository === null || typeof this.lastRepository.data === 'undefined' || this.lastRepository.data === null || this.lastRepository.data === "PHOLDER" || this.lastRepository.data === "CLONE")
				lastRepository = null;
			else
				lastRepository = this.lastRepository;
			
		    this.state = "needProfile";   // "needRepositoryDefinition", "needActiveRepository", "showRepository"
		    
		    if ((optionPreferencesGitProfiles == null) || (optionPreferencesGitProfiles.length == 0)){
		    	this.state = "needProfile";
		    	if (this.cuurentView !== "profileView")
		    		this.showProfileView();
		    }
			else if ((repoList == null) || (repoList.length == 0)){
				 this.state = "needRepositoryDefinition";
				 if (this.cuurentView !== "repoDefinitionView")
					 this.showRepoDefinitionView();
			}			  
			else if ((lastRepository == null) || (lastRepository.length == 0)){
				this.state = "needActiveRepository";
					this.showRepoSelectionView();
			}
			else{
				this.state = "showRepository";
				if (this.cuurentView !== "repositoryView")
					this.showRepositoryView();
			}
		},
		
		updateGitStatusBar: function(lastRepository, numCommits, numUnstaged) {
			appDMS.appCore.displayGitStatusBar(lastRepository, numCommits, numUnstaged);
		},
		
		createProfilePane: function() {
		
			this.profileBorderContainer = new BorderContainer({
                  					id: 'profileZeroStateContainer',
  			                        style: "padding:50px; margin:0px; width:100%; height:100%;",
  				                    gutters: false,
   		                        	});
		    this.profileTitlePane = new ContentPane({
                            region: "top",
                            style: "width: 100%",
                            content: this.resourceBundle.profileTitlePaneContentLabel
                            });
           this.profileBorderContainer.addChild(this.profileTitlePane);
							
		    this.profileButtonPane = new ContentPane({
                            region: "center",
                            style: "padding-top:25px; width: 100%",
                             });
 			this.createProfileButton = new Button({
					title: this.resourceBundle.createProfileLabel,
					showLabel: true,
					id: 'createProfileButton'
			});
				
			this.createProfileButton.set("label", this.resourceBundle.createProfileLabel); 
			this.createProfileButton.set("disabled", false);
			this.profileButtonPane.addChild(this.createProfileButton);
				
            this.profileBorderContainer.addChild(this.profileButtonPane);
			this.createProfileHandle = dojo.connect(this.createProfileButton, 'onClick', lang.hitch(this, this.createProfile));

		},
		createRepositoryPane: function() {
	       	
         	this.repositoryBorderContainer = new BorderContainer({
			    id: 'reposSelector',
			    style: "padding:0px; margin:0px; width:100%; height:100%;",
				gutters: false,
				title: this.resourceBundle.local
			});
        	
        	/* existing repositories button */
         	var options =[];
         	var existingRepositories = appDMS.sasStudioPreferences.gitRepositoryList;
        	if (existingRepositories && existingRepositories.length > 0){
        		options.push({ label: this.resourceBundle.selectaRepoLabel, value: "PHOLDER",selected:true,disabled:true });
        			for(var i=0;i<existingRepositories.length;i++){
        				if (existingRepositories[i].workingFolder.indexOf('/') > -1 )
        				{
        					var repoLabel=existingRepositories[i].workingFolder.substring(existingRepositories[i].workingFolder.lastIndexOf("/")+1,existingRepositories[i].workingFolder.length);
        				}else {
        					var repoLabel=existingRepositories[i].workingFolder.substring(existingRepositories[i].workingFolder.lastIndexOf("\\")+1,existingRepositories[i].workingFolder.length);
        				}
        				
               		 	var repo = { label: repoLabel, value: existingRepositories[i].workingFolder, 
               		 				 repoObject:existingRepositories[i]};
               		 	options.push(repo);
               	 	}
        			options.push(new dijit.ToolbarSeparator());
        			options.push({ label: this.resourceBundle.cloneRepositoryLabel,value: "CLONE", disabled:false});
        			options.push({ label: this.resourceBundle.openLocalRepositoryLabel,value: "OPENLOCAL", disabled:false});
        		}
        	
        	this.repositoriesSelect = new Select({
				sortByLabel: false,
				options: options,
				style : "min-width: 200px",
				"onChange": lang.hitch(this, this.onRepoSelected)
			});
        	if (this.lastRepository && this.lastRepository !== null){
        		this.repositoriesSelect.set("value", this.lastRepository);
        	}
        	this.repositoriesSelect._onChangeActive = true;
            this.repositoriesSelect.startup();
			
        	this.repositoryContentPane = new ContentPane({
				id: "_localTopPane",
				region:"top",
				style: "padding-left:100px; padding-top:20px; height:auto; overflow:hidden;"
			});
        	if (appDMS.sasStudioPreferences.gitRepositoryList && appDMS.sasStudioPreferences.gitRepositoryList.length >0){
        		this.repositoryContentPane.setContent(this.repositoriesSelect);
        	} else {
        		this.repositoryContentPane.setContent(this.resourceBundle.noRepositoryText);
        	}
        				
        	/* clone title pane */
        	this.cloneTitlePane = new ContentPane({
                region: "top",
                style: "overflow:hidden;",
                content: this.resourceBundle.cloneTitlePaneContentLabel
                });
        	this.cloneTitlePane.set("style","padding-left:90px;padding-top:130px;");
        	/* clone button */
        	this.cloneRepositoryButton = new Button({
                title: this.resourceBundle.cloneRepositoryLabel,
                showLabel: true,
                region:"top",
                id: '_cloneRepositoryBtn'
            });
        	
	    	this.cloneRepositoryButton.set("label", this.resourceBundle.cloneRepositoryLabel);
	    	this.cloneRepositoryButton.set("style","padding-left:110px;");
	    	this.cloneRepositoryButton.set("disabled", false);
	    	
	    	this.cloneHandle = dojo.connect(this.cloneRepositoryButton, 'onClick', lang.hitch(this, this.cloneRepository));
           
	    	/* open title pane */
	    	this.openTitlePane = new ContentPane({
                region: "top",
                style: "width: 100%;overflow:hidden;",
                content: this.resourceBundle.openTitlePaneContentLabel
                });
	    	this.openTitlePane.set("style","padding-left:71px;padding-top:130px;");
	    	/* open button */
	    	this.openRepositoryButton = new Button({
                title: this.resourceBundle.openLocalRepositoryLabel,
                showLabel: true,
                region:"top",
                id: '_openRepositoryBtn'
            });
	    	this.openRepositoryButton.set("label", this.resourceBundle.openLocalRepositoryLabel);
	    	this.openRepositoryButton.set("style","padding-left:90px;");
	    	this.openRepositoryButton.set("disabled", false);
	    	
	    	this.openHandle = dojo.connect(this.openRepositoryButton, 'onClick', lang.hitch(this, this.openRepository));
	    	
	    	
	    	this.repositoryBorderContainer.addChild(this.repositoryContentPane);
	    	this.repositoryBorderContainer.addChild(this.cloneTitlePane);
	    	this.repositoryBorderContainer.addChild(this.cloneRepositoryButton);
	    	this.repositoryBorderContainer.addChild(this.openTitlePane);
	    	this.repositoryBorderContainer.addChild(this.openRepositoryButton);
		},
        createGitLocalCommitPanes: function () {
        	
        	/*local pane*/
        	this.localPane = new BorderContainer({
			    id: 'local',
			    style: "padding:0px; margin:0px; width:100%; height:100%;",
				gutters: false,
				title: this.resourceBundle.local
			});
        	
        	this.localContentPane = new ContentPane({
				id: "_repositorylocalTopPane",
				region:"top",
				style: "padding-left:10px; padding-top:20px; height:auto;"
			});
        	this.repositoriesSelect.set("value",this.lastRepository);
        	this.localContentPane.setContent(this.repositoriesSelect);
        	this.repositoriesSelect.startup();
        	
        	this.localPaneToolbar = this.createLocalPaneToolbar();
        	
        	this.localListPane = new ContentPane({
				id: "_repositoryLocalListPane",
				region:"top",
				style: "padding-left:10px; padding-top:20px; height:auto;overflow:hidden;"
			});
        	
        	this.createLocalGrids();
        	this.localListPane.addChild(this.localGrid);
        	this.localListPane.addChild(this.commitCounterGrid);
        	this.localGrid.startup();
        	this.commitCounterGrid.startup();
        	this.createLocalGridContextMenu(this.localGrid.contentNode); 
        	
        	this.localPane.addChild(this.localContentPane);
        	this.localPane.addChild(this.localPaneToolbar);
			this.localPane.addChild(this.localListPane);
            this.localPane.startup();
            
            this.GitTabContainer.addChild(this.localPane);
            this.localPane.startup();
            this.localPane.resize();
            
            /*commit pane*/
            
        	this.commitPane = new BorderContainer({
  			    id: 'commit',
  			    style: "padding:0px; margin:0px; width:100%; height:100%;",
  				gutters: false,
  				title: this.resourceBundle.commit
  			});
        	
        	 //commitUnStagedpane
        	
        	this.commitUnstagedPane = new BorderContainer({
  			    id: 'commitUnstagedPane',
  			    region:"top",
  			    style: "padding:0px; margin:0px; width:100%; height:43%;",
  			    minSize:100,
  			    gutters: true,
				splitter:true
  			});
        	
        	this.commitLabelContentPane = new ContentPane({
				id: "_repositorycommitTopPane",
				region:"top",
				style: "padding-left:10px; height:auto;"
			});
        	this.createCommitUnStagedGrids();
        	
        	this.commitUnstagedPaneToolbar = this.createCommitUnstagedPaneToolbar();
        	
        	this.commitListPane = new ContentPane({
				id: "_repositoryCommitListPane",
				region:"center",
				style: "padding-left:10px; height:auto;"
			});
        	
        	
        	
        	this.commitLabelContentPane.addChild(this.commitUnstagedPaneToolbar);
        	this.commitListPane.addChild(this.unstagedListGrid);
        	
        	this.unstagedListGrid.startup();
        	this.unstagedCounterGrid.startup();
        	this.createUnstagedListGridContextMenu(this.unstagedListGrid.contentNode); 
        	
        	this.commitUnstagedPane.addChild(this.commitLabelContentPane);
			this.commitUnstagedPane.addChild(this.commitListPane);
            this.commitUnstagedPane.startup();
            this.commitUnstagedPane.resize();
            
            //commitStagedpane
            
            this.commitStagedPane = new BorderContainer({
  			    id: 'commitStagedPane',
  			    region:"center",
  			    style: "padding:0px; margin:0px; width:100%; height:43%;",
  			    gutters: true,
  				splitter:true
  			});
        	
        	this.commitStagedLabelContentPane = new ContentPane({
				id: "_repositorycommitStagedTopPane",
				region:"top",
				style: "padding-left:10px; height:auto;"
			});
        	this.createCommitStagedGrids();
        	this.commitStagedPaneToolbar = this.createCommitStagedPaneToolbar();
        	
        	this.commitStagedListPane = new ContentPane({
				id: "_repositoryCommitStagedListPane",
				region:"center",
				style: "padding-left:10px; height:auto;"
			});
        	
        	this.commitStagedListPane.addChild(this.stagedListGrid);
        	
        	this.stagedCounterGrid.startup();
        	this.stagedListGrid.startup();
        	this.createStagedListGridContextMenu(this.stagedListGrid.contentNode); 
        	
        	this.commitStagedTextareaPane = new BorderContainer({
				id: "_repositoryCommitStagedTextareaPane",
				region:"bottom",
				gutters: true,
  				splitter:true,
  				style: "padding:0px; margin:0px; width:100%;height:14%;"
			});
        	
        	this.commitTextarea = new SimpleTextarea({
			    id: "commitComments",
        	    name: "commitSimpleTextarea",
        	    region:"center",
				intermediateChanges: true,
        	    rows:"10",
        	    cols:"50",
        	    placeHolder: this.resourceBundle.commitComments,
        	    class:"commitTextarea"
        	  }, "commitSimpleTextarea");			  

			on(this.commitTextarea, "change", lang.hitch(this, this.setCommitButtonState));
        	this.commitTextarea.domNode.placeholder=this.resourceBundle.commitComments;
        	
        	this.commitButton = new Button({
                title: this.resourceBundle.commitStagedLabel,
                region:"bottom",
                showLabel: true,
                class:"commitButton",
                id: '_commitBtn'
            });
        	this.commitButton.set("label", this.resourceBundle.commitStagedLabel);
	    	this.commitButton.set("disabled", true);
	    	this.commitHandle = dojo.connect(this.commitButton, 'onClick', lang.hitch(this, this.onCommitStaged));
        	
        	this.commitStagedTextareaPane.addChild(this.commitTextarea);
        	this.commitStagedTextareaPane.addChild(this.commitButton);
        	this.commitTextarea.startup();
        	this.commitButton.startup();
        	this.commitStagedTextareaPane.startup();
        	
        	this.commitStagedPane.addChild(this.commitStagedPaneToolbar);
			this.commitStagedPane.addChild(this.commitStagedListPane);
        	
            this.commitPane.addChild(this.commitUnstagedPane);
            this.commitPane.addChild(this.commitStagedPane);
            this.commitPane.addChild(this.commitStagedTextareaPane);
            this.commitUnstagedPane.startup();
            this.commitStagedPane.startup();
            this.commitStagedTextareaPane.startup();
        	this.GitTabContainer.addChild(this.commitPane);
            this.commitPane.startup();
            this.commitPane.resize();
            
        	this.unStageSplitter = dijit.byId('commitUnstagedPane_splitter');
			this.unStageSplitter.setAttribute("tabindex","-1");
			dojo.connect(this.unStageSplitter, "_stopDrag", lang.hitch(this, this.commitPaneResizeHandler));
			
			this.textAreasplitter = dijit.byId('_repositoryCommitStagedTextareaPane_splitter');
			this.textAreasplitter.setAttribute("tabindex","-1");
			dojo.connect(this.textAreasplitter, "_stopDrag", lang.hitch(this, this.commitPaneResizeHandler));
        },
		createLocalPaneToolbar: function()
		{
		    this.localPaneToolbar = new dijit.Toolbar({
		        'class': "logToolbar",
		        region: "top"
		    }, "toolbar");
	
			this.pullButton = new dijit.form.Button({
				iconClass: 'sasPullIcon',
				label: this.resourceBundle.pull,
				onClick:  dojo.hitch(this, this.onPull),
				showLabel: true}
			);

			this.pushButton = new dijit.form.Button({
				iconClass: 'sasPushIcon',
				label: this.resourceBundle.push,
				onClick:  dojo.hitch(this, this.onPush),
				showLabel: true}
			);

			this.historyButton = new dijit.form.Button({
				iconClass: 'sasHistoryIcon',
				label: this.resourceBundle.log,
				onClick:  dojo.hitch(this, this.onHistory),
				showLabel: true}
			);

			this.refreshButton = new dijit.form.Button({
				iconClass: 'sasRefreshIcon',
				label: this.resourceBundle.refresh,
					onClick: lang.hitch(this,this.onRefresh),
					showLabel: false});

			this.localPaneToolbar.addChild(this.pullButton);
			this.localPaneToolbar.addChild(this.pushButton);
			this.localPaneToolbar.addChild(new dijit.ToolbarSeparator());
			this.localPaneToolbar.addChild(this.historyButton);
//			this.localPaneToolbar.addChild(new dijit.ToolbarSeparator());
//			this.localPaneToolbar.addChild(this.refreshButton);
			return this.localPaneToolbar;

		},
		createLocalGrids: function (){
			
			var localGridLayout = [{
                name: 'Name',
                field: 'repoName',
                width: '100%',
                height:'100%',
                formatter: this.localGridCellFormatter
            }];
			
			this.localGrid = this.gitCustomdGrid({
				id: "repoLocalGrid",
				showHeader: false,
				tabableHeader: false,
		 		columns: localGridLayout
			});
			
			var commitCounterGridLayout = [{
                name: 'Counter',
                field: 'counter',
                width: '100%',
                height:'100%',
                formatter: this.commitCounterGridCellFormatter
            }];
			
			this.commitCounterGrid = this.gitCustomdGrid({
				id: "repoCommitCounterGrid",
				showHeader: false,
				tabableHeader: false,
		 		columns: commitCounterGridLayout
			});
			this.eventListeners.push(this.commitCounterGrid.on(".dgrid-row:contextmenu", lang.hitch(this, this.onCommitGridContextMenu)));
			on(window, "resize", lang.hitch(this, function(){
            	this.localGrid.resize();
            	this.commitCounterGrid.resize();
            }));
			
			this.localGrid.setSelectionMode("none");
			this.commitCounterGrid.setSelectionMode("none");
			if (this.lastRepository){
				if (this.lastRepository.indexOf('/') > -1){
					var repoName=this.lastRepository.substring(this.lastRepository.lastIndexOf("/")+1,this.lastRepository.length);
				} else {
					var repoName=this.lastRepository.substring(this.lastRepository.lastIndexOf("\\")+1,this.lastRepository.length);
				}
				var repo ={"repoName":repoName};
				this.selectedRepList.push(repo);
			}
			
			this.localGrid.on(".dgrid-cell:mouseover", lang.hitch(this, this.showLocalGridTooltip));
			this.localGrid.on(".dgrid-cell:mouseout", lang.hitch(this, this.hideLocalGridTooltip)); 
			
//			var counter ={"counter":this.activeBranch+"  " +"("+this.masterCount+")"};
			var counter ={"counter":this.activeBranch};
			this.commitCounterList.push(counter);
				
			this.localGrid.renderArray(this.selectedRepList);
			this.localGrid._updateColumns();
			this.commitCounterGrid.renderArray(this.commitCounterList);
			this.commitCounterGrid._updateColumns();
		},
		localGridCellFormatter: function (val, item) {
			try {
                var iconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/Folder.png"/>';
                var formattedValue = iconValue + val;
                return formattedValue;
          } catch (e) {
              return val;
          }
        },
        showLocalGridTooltip: function (event) {
        	var cell=this.localGrid.cell(event);
            var toolTipText=appDMS.encodeHtml(this.lastRepository);
            if (Tooltip._masterTT != null)
            	Tooltip._masterTT.containerNode.className="sasTooltipContainer";
            Tooltip.show(toolTipText, cell.element,["below","above"]);
        },
        hideLocalGridTooltip: function (event) {
        	var cell=this.localGrid.cell(event);
        	Tooltip.hide(cell.element);
        },
        commitCounterGridCellFormatter: function (val, item) {
            try {
                  var iconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/gitRepository.png"/>';
                  var formattedValue = iconValue + val;
                  return formattedValue;
            } catch (e) {
                return val;
            }
        },
		createCommitUnstagedPaneToolbar: function()
		{
		    this.commitUnstagedPaneToolbar = new dijit.Toolbar({
		        'class': "commitUnstagedToolbar",
		        region: "top"
		    }, "commitUnstagedToolbar");
	
			this.stageButton = new dijit.form.Button({
				iconClass: 'sasArrowDownAddDualSelectorIcon',
				label: this.resourceBundle.stage,
				onClick:  dojo.hitch(this, this.onStage),
				showLabel: false}
			);

			this.stageAllButton = new dijit.form.Button({
				iconClass: 'sasArrowDownAddAllDualSelectorIcon',
				label: this.resourceBundle.stageAll,
				onClick:  dojo.hitch(this, this.onStageAll),
				showLabel: false}
			);

			this.commitRefreshButton = new dijit.form.Button({
				iconClass: 'sasRefreshIcon',
				label: this.resourceBundle.commitRefresh,
					onClick: lang.hitch(this,this.onRefresh),
					showLabel: false});
			if (this.unstagedCounterGrid)
				this.commitUnstagedPaneToolbar.addChild(this.unstagedCounterGrid);
			this.commitUnstagedPaneToolbar.addChild(this.stageButton);
			this.commitUnstagedPaneToolbar.addChild(this.stageAllButton);
			this.commitUnstagedPaneToolbar.addChild(this.commitRefreshButton);
			return this.commitUnstagedPaneToolbar;
		},
		
		setStageButtonsStates: function() {
		    /* Stage and Unstage all menu items and buttons in both unstaged and staged grids */
		    var hasItems = (this.unStagedList!=null && this.unStagedList.length>0);
			this.stageAllButton.set("disabled", !hasItems);
			this.stageAllMenuItem.set("disabled", !hasItems);	
			
			hasItems = (this.stagedList!=null && this.stagedList.length>0);
			this.unStageAllMenuItem.set("disabled", !hasItems);
			this.commitUnstageAllButton.set("disabled", !hasItems);
		
		    var singleSelection = false;
			var hasSelection = false; 
			
		    if (this.unstagedGridGridSelection == null)
			   this.unstagedGridGridSelection = [];
            	
            /* Open, Show Differences, Reset File of single item menu items and buttons  in unstaged grid*/				
			singleSelection = (this.unstagedGridGridSelection.length == 1);	               
			this.unStageOpenMenuItem.set("disabled", !singleSelection);	           			
			this.showUnstageDifferencesMenuItem.set("disabled", !singleSelection);	244
            this.showUnstageResetFileMenuItem.set("disabled", !singleSelection);			
		
		    /* Stage and Unstage selected items menu items and buttons in staged grid */
			hasSelection = (this.unstagedGridGridSelection.length >= 1)				
			this.stageButton.set("disabled", !hasSelection);				
			this.stageSelectedMenuItem.set("disabled", !hasSelection);
		   						
		    if (this.stagedGridGridSelection == null)
			   this.stagedGridGridSelection = [];
		     			
           /* Open, Show Differences of single item menu items and buttons  in staged grid*/				
			singleSelection = (this.stagedGridGridSelection.length == 1);
			this.stageOpenMenuItem.set("disabled", !singleSelection);			
			this.showStagedDifferencesMenuItem.set("disabled", !singleSelection);	
			this.showStagedResetFileMenuItem.set("disabled", !singleSelection);			
		
		    /* Stage and Unstage selected items menu items and buttons in unstaged grid */
			hasSelection = (this.stagedGridGridSelection.length >= 1);
			this.commitUnstageButton.set("disabled", !hasSelection);												
			this.unStageSelectedMenuItem.set("disabled", !hasSelection);			
		},
		
        createCommitUnStagedGrids: function (){
        	
        	var unstagedCounterGridLayout = [{
                name: 'Counter',
                field: 'counter',
                width: '100%',
                height:'100%',
                formatter: this.unstagedCounterGridCellFormatter
            }];
			
			this.unstagedCounterGrid = this.gitCustomdGrid({
				class: "repoStageUnstagedCounterGrid",
				showHeader: false,
				tabableHeader: false,
		 		columns: unstagedListGridLayout
			});
			this.unstagedCounterGrid.setSelectionMode("single");
			this.eventListeners.push(this.unstagedCounterGrid.on(".dgrid-row:contextmenu", lang.hitch(this, this.onCommitGridContextMenu)));
			
			var unstagedListGridLayout = [
				             	 		     {label: this.resourceBundle.name, field: 'name', resizable : true, sortable : false,formatter: this.unstagedListGridNameFormatter},				             	 		            
				             	 		     {label:  this.resourceBundle.location, field: 'absolutePath', resizable : true, sortable : false}
				             	 		   ];
			
			this.unstagedListGrid = this.gitCustomdGrid({
				id: "repoUnstagedListGrid",
				showHeader: false,
				tabableHeader: false,
				allowSelectAll: true,
		 		columns: unstagedListGridLayout,
				deselectOnRefresh: true
			});
			
			this.unstagedListGrid.setSelectionMode("extended");
			this.unstagedListGrid.styleColumn(this.unstagedListGrid.columns[0].id, "width: 99%");
			this.unstagedListGrid.styleColumn(this.unstagedListGrid.columns[1].id, "width: 1%");
			this.unstagedListGrid.styleColumn(this.unstagedListGrid.columns[1].id, "display: none;");
			this.eventListeners.push(this.unstagedListGrid.on("dgrid-select", lang.hitch(this, this.onUnstagedGridClick)));			
			this.eventListeners.push(this.unstagedListGrid.on(".dgrid-row:click", lang.hitch(this, this.onUnstagedGridClick)));			

			this.eventListeners.push(this.unstagedListGrid.on(".dgrid-row:dblclick", lang.hitch(this, this.onUnstagedDblClick, 'task')));			
			
			on(window, "resize", lang.hitch(this, function(){
            	this.unstagedCounterGrid.resize();
            	this.unstagedListGrid.resize();
            }));
			
			this.unstagedListGrid.on(".dgrid-cell:mouseover", lang.hitch(this, this.showsUnStagedListGridTooltip));
			this.unstagedListGrid.on(".dgrid-cell:mouseout", lang.hitch(this, this.hideUnStagedListGridTooltip));
			
			var counter ={"counter":this.resourceBundle.unStagedChanges+"  " +"("+this.unStagedCounter+")"};
			this.unstagedChangesCounterList.push(counter);
				
			this.unstagedCounterGrid.renderArray(this.unstagedChangesCounterList);
			this.unstagedCounterGrid._updateColumns();
			this.unstagedGridGridSelection = [];
			this.unstagedListGrid.renderArray(this.unStagedList);
			this.unstagedListGrid._updateColumns();
        },
				
		onUnstagedGridClick: function (event) {
		    this.unstagedGridGridSelection = [];
             for (var id in this.unstagedListGrid.selection) {
                if (this.unstagedListGrid.selection[id]) {
                    this.unstagedGridGridSelection.push(this.unstagedListGrid.row(id));
                }
            }
            this.setStageButtonsStates();
            setPreventDefault(event);
        },
		
		onStagedGridClick: function (event) {
		    this.stagedGridGridSelection = [];
             for (var id in this.stagedListGrid.selection) {
                if (this.stagedListGrid.selection[id]) {
                    this.stagedGridGridSelection.push(this.stagedListGrid.row(id));
                }
            }
            this.setStageButtonsStates();
            setPreventDefault(event);
        },
		

		onUnstagedDblClick: function(type, event) {
		    var object = this.unstagedListGrid.row(event).data;
			var objects = [];
			objects.push(object);
			this.doStageItem(objects);
		},
		onStagedDblClick: function(type, event) {
		    var object = this.stagedListGrid.row(event).data;
			var objects = [];
			objects.push(object);
			this.doUnstageItem(objects);
		},
        unstagedCounterGridCellFormatter: function (val, item) {
//			try {
//                var iconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/Folder.png"/>';
//                var formattedValue = iconValue + val;
//                return formattedValue;
//          } catch (e) {
//              return val;
//          }
        	 return val;
        },
        unstagedListGridNameFormatter: function (val, item) {
			var status = item.status.toLowerCase();
			var statusIconValue = "";
			var fileIcon = appDMS.projects.getPngBasedOnFileExtension(item.name);
			if (fileIcon === null || fileIcon === "")
				fileIcon ="resources/js/studio/themes/corporate/images/sasIcons/sasdark/16_png/Document.png";
			fileIcon = fileIcon.replace("24_png","16_png");
			fileIcon = '<img class="fileRefIcon" src="' + fileIcon + '"/>';
			switch(status)
			{
			case "added":
			case "new":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/onDemandStatus.png"/>';
				break;
			case "renamed":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/mediumPriorityStatus.png"/>';
				break;
			case "modified":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/incompleteInProgressStatus.png"/>';
				break;
			case "copied":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/revertedStatus.png"/>';
				break;
			case "deleted":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/canceledStatus.png"/>';
				break;
			case "conflicted":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/outOfSynStatus.png"/>';
				break;
			}
			
		  try {
				var formattedValue = statusIconValue + " " + fileIcon +  " " + val;
		        return formattedValue;
		      } catch (e) {
		          return val;
		      }
		  	 return val;
		  },
		  showsUnStagedListGridTooltip: function (event) {
	        	var row=this.unstagedListGrid.row(event);
	            var toolTipText=appDMS.encodeHtml(row.data.absolutePath.trim());
	            toolTipText=appDMS.decodeHtml(toolTipText);
	            var cell=this.unstagedListGrid.cell(event);
	            if (Tooltip._masterTT != null)
	            	Tooltip._masterTT.containerNode.className="sasTooltipContainer";
	            Tooltip.show(toolTipText, cell.element,["below","above"]);
	      },
	      hideUnStagedListGridTooltip: function (event) {
	        	var cell=this.unstagedListGrid.cell(event);
	        	Tooltip.hide(cell.element);
	      },
        createCommitStagedPaneToolbar: function()
		{
		    this.commitStagedPaneToolbar = new dijit.Toolbar({
		        'class': "commitStagedToolbar",
		        region: "top"
		    }, "commitStagedToolbar");
	
			this.commitUnstageButton = new dijit.form.Button({
				iconClass: 'sasArrowUpRemoveDualSelectorIcon',
				label: this.resourceBundle.unStage,
				onClick:  dojo.hitch(this, this.onUnStage),
				showLabel: false}
			);

			this.commitUnstageAllButton = new dijit.form.Button({
				iconClass: 'sasArrowUpRemoveAllDualSelectorIcon',
				label: this.resourceBundle.unStageAll,
				onClick:  dojo.hitch(this, this.onUnStageAll),
				showLabel: false}
			);
			if (this.stagedCounterGrid)
				this.commitStagedPaneToolbar.addChild(this.stagedCounterGrid);
			this.commitStagedPaneToolbar.addChild(this.commitUnstageButton);
			this.commitStagedPaneToolbar.addChild(this.commitUnstageAllButton);
			return this.commitStagedPaneToolbar;

		},
        createCommitStagedGrids: function (){
        	
        	var stagedCounterGridLayout = [{
                name: 'Counter',
                field: 'counter',
                width: '100%',
                height:'100%',
                formatter: this.stagedCounterGridCellFormatter
            }];
			
			this.stagedCounterGrid = this.gitCustomdGrid({
				class: "repoStageUnstagedCounterGrid",
				showHeader: false,
				tabableHeader: false,
		 		columns: stagedCounterGridLayout
			});
			this.stagedCounterGrid.setSelectionMode("single");
			this.eventListeners.push(this.stagedCounterGrid.on(".dgrid-row:contextmenu", lang.hitch(this, this.onCommitGridContextMenu)));
			
			var stagedListGridLayout = [
				             	 		     {label: this.resourceBundle.name, field: 'name', resizable : true, sortable : false,formatter: this.stagedListGridNameFormatter},				             	 		            
				             	 		     {label:  this.resourceBundle.location, field: 'absolutePath', resizable : true, sortable : false}
				             	 		   ];
			
			this.stagedListGrid = this.gitCustomdGrid({
				id: "repoStagedListGrid",
				showHeader: false,
				tabableHeader: false,
				allowSelectAll: true,
		 		columns: stagedListGridLayout,
				deselectOnRefresh: true
			});
			
			this.stagedListGrid.setSelectionMode("extended");
			this.stagedListGrid.styleColumn(this.stagedListGrid.columns[0].id, "width: 99%");
			this.stagedListGrid.styleColumn(this.stagedListGrid.columns[1].id, "width: 1%");
			this.stagedListGrid.styleColumn(this.stagedListGrid.columns[1].id, "display: none;");
			this.eventListeners.push(this.stagedListGrid.on("dgrid-select", lang.hitch(this, this.onStagedGridClick)));			
			this.eventListeners.push(this.stagedListGrid.on(".dgrid-row:click", lang.hitch(this, this.onStagedGridClick)));			
			this.eventListeners.push(this.stagedListGrid.on(".dgrid-row:dblclick", lang.hitch(this, this.onStagedDblClick, 'task')));			
			
			on(window, "resize", lang.hitch(this, function(){
            	this.stagedCounterGrid.resize();
            	this.stagedListGrid.resize();
            }));
			
			this.stagedListGrid.on(".dgrid-cell:mouseover", lang.hitch(this, this.showsStagedListGridTooltip));
			this.stagedListGrid.on(".dgrid-cell:mouseout", lang.hitch(this, this.hideStagedListGridTooltip));
			
			var counter ={"counter":this.resourceBundle.stagedChanges+"  " +"("+this.stagedCounter +")"};
			this.stagedChangesCounterList.push(counter);
				
			this.stagedCounterGrid.renderArray(this.stagedChangesCounterList);
			this.stagedCounterGrid._updateColumns();
			this.stagedGridGridSelection = [];
			this.stagedListGrid.renderArray(this.stagedList);
			this.stagedListGrid._updateColumns();
        },
        
        stagedCounterGridCellFormatter: function (val, item) {
//			try {
//                var iconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/Folder.png"/>';
//                var formattedValue = iconValue + val;
//                return formattedValue;
//          } catch (e) {
//              return val;
//          }
        	 return val;
        },
		stagedListGridNameFormatter: function (val, item) {
			var status = item.status.toLowerCase();
			var statusIconValue = "";
			var fileIcon = appDMS.projects.getPngBasedOnFileExtension(item.name);
			if (fileIcon === null || fileIcon === "")
				fileIcon ="resources/js/studio/themes/corporate/images/sasIcons/sasdark/16_png/Document.png";
			fileIcon = fileIcon.replace("24_png","16_png");
			fileIcon = '<img class="fileRefIcon" src="' + fileIcon + '"/>';
			
			switch(status)
			{
			case "added":
			case "new":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/onDemandStatus.png"/>';
				break;
			case "renamed":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/mediumPriorityStatus.png"/>';
				break;
			case "modified":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/incompleteInProgressStatus.png"/>';
				break;
			case "copied":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/revertedStatus.png"/>';
				break;
			case "deleted":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/canceledStatus.png"/>';
				break;
			case "conflicted":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/Disconnect.png"/>';
				break;
			}
			
		  try {
				  var formattedValue = statusIconValue + " " + fileIcon + " " + val;
		          return formattedValue;
		      } catch (e) {
		          return val;
		      }
		  	 return val;
		  },
		  showsStagedListGridTooltip: function (event) {
	        	var row=this.stagedListGrid.row(event);
	            var toolTipText=appDMS.encodeHtml(row.data.absolutePath.trim());
	            toolTipText=appDMS.decodeHtml(toolTipText);
	            var cell=this.stagedListGrid.cell(event);
	            if (Tooltip._masterTT != null)
	            	Tooltip._masterTT.containerNode.className="sasTooltipContainer";
	            Tooltip.show(toolTipText, cell.element,["below","above"]);
	     },
	     hideStagedListGridTooltip: function (event) {
	        	var cell=this.stagedListGrid.cell(event);
	        	Tooltip.hide(cell.element);
	     },
        createLocalGridContextMenu: function (nodeId) {
            this.contextMenu = new dijit.Menu({
                targetNodeIds:[nodeId]
            });
            
			this.pullMasterMenuItem = new dijit.MenuItem({
				label: this.resourceBundle.pull, //pullMasterLabel,
				onClick:lang.hitch(this, this.onPullMaster)
			});

			this.pushToMasterMenuItem = new dijit.MenuItem({
				label: this.resourceBundle.push,   //pushToMasterLabel,
				onClick:lang.hitch(this, this.onPushToMaster)
			});


			this.deleteMasterMenuItem = new dijit.MenuItem({
				label: this.resourceBundle.deleteMasterLabel,
				onClick:lang.hitch(this, this.onDeleteMaster)
			});


            this.contextMenu.addChild(this.pullMasterMenuItem);
            this.contextMenu.addChild(this.pushToMasterMenuItem);
           // this.contextMenu.addChild(new dijit.MenuSeparator);
           // this.contextMenu.addChild(this.deleteMasterMenuItem);
        },
        createUnstagedListGridContextMenu: function (nodeId) {
            this.unStagedContextMenu = new dijit.Menu({
            	targetNodeIds:[nodeId]
            });
            
			this.unStageOpenMenuItem = new dijit.MenuItem({
				label: this.resourceBundle.openMenuLabel,
				onClick:lang.hitch(this, this.onUnStageOpen)
			});

			this.stageSelectedMenuItem = new dijit.MenuItem({
				label: this.resourceBundle.stageSelectedLabel,
				onClick:lang.hitch(this, this.onStage)
			});
			
			this.stageAllMenuItem = new dijit.MenuItem({
				label: this.resourceBundle.stageAllLabel,
				onClick:lang.hitch(this, this.onStageAll)
			});

			this.showUnstageDifferencesMenuItem = new dijit.MenuItem({
				label: this.resourceBundle.showDifferences, 
				onClick:lang.hitch(this, this.onUnStagedShowDifferences)
			});

			this.showUnstageResetFileMenuItem = new dijit.MenuItem({
				label: this.resourceBundle.resetFileChanges, 
				onClick:lang.hitch(this, this.onUnStagedResetFile)
			});

            this.unStagedContextMenu.addChild(this.unStageOpenMenuItem);
            this.unStagedContextMenu.addChild(new dijit.MenuSeparator);
            this.unStagedContextMenu.addChild(this.stageSelectedMenuItem);
            this.unStagedContextMenu.addChild(this.stageAllMenuItem);
            this.unStagedContextMenu.addChild(this.showUnstageDifferencesMenuItem);
            this.unStagedContextMenu.addChild(this.showUnstageResetFileMenuItem);
        },
        createStagedListGridContextMenu: function (nodeId) {
        	 this.stagedContextMenu = new dijit.Menu({
                 targetNodeIds:[nodeId]
             });
             
 			this.stageOpenMenuItem = new dijit.MenuItem({
 				label: this.resourceBundle.openMenuLabel,
 				onClick:lang.hitch(this, this.onStageOpen)
 			});

 			this.unStageSelectedMenuItem = new dijit.MenuItem({
 				label: this.resourceBundle.unStageSelectedLabel,
 				onClick:lang.hitch(this, this.onUnStage)
 			});
 			
 			this.unStageAllMenuItem = new dijit.MenuItem({
 				label: this.resourceBundle.unStageAllLabel,
 				onClick:lang.hitch(this, this.onUnStageAll)
 			});

			this.showStagedDifferencesMenuItem = new dijit.MenuItem({
				label: this.resourceBundle.showDifferences, 
				onClick:lang.hitch(this, this.onStagedShowDifferences)
			});
			
			this.showStagedResetFileMenuItem = new dijit.MenuItem({
				label: this.resourceBundle.resetFileChanges, 
				onClick:lang.hitch(this, this.onStagedResetFile)
			});


            this.stagedContextMenu.addChild(this.stageOpenMenuItem);
            this.stagedContextMenu.addChild(new dijit.MenuSeparator);
            this.stagedContextMenu.addChild(this.unStageSelectedMenuItem);
            this.stagedContextMenu.addChild(this.unStageAllMenuItem);
            this.stagedContextMenu.addChild(this.showStagedDifferencesMenuItem);
            this.stagedContextMenu.addChild(this.showStagedResetFileMenuItem);
        },
		
		setCommitButtonState: function()
		{
		    // Commit button is only enabled if:
            //	- there are staged files 
            //   - there is a commit message
		    var comment = this.commitTextarea.getValue();
            if (comment.length == 0)
		        this.commitButton.set("disabled", true);
			else 
		        this.commitButton.set("disabled", (this.stagedList.length == 0));
		},
		
		showProfileView: function() {
			if (typeof this.mainPane !== 'undefined'){
				var children = this.mainPane.getChildren();
				for (var i = 0; i < children.length; i++){
					 this.mainPane.removeChild(children[i]);
				 } 
				this.mainPane.addChild(this.profileBorderContainer);
				this.profileBorderContainer.startup();
				this.mainPane.resize();
				this.cuurentView="profileView";
				this.updateGitStatusBar(null, 0, 0);
			}		
		},
		showRepoDefinitionView: function() {
			if (typeof this.mainPane !== 'undefined'){
				var children = this.mainPane.getChildren();
				for (var i = 0; i < children.length; i++){
					 this.mainPane.removeChild(children[i]);
				 } 
				
				var repChildren = this.repositoryBorderContainer.getChildren();
				for (var i = 0; i < repChildren.length; i++){
					 this.repositoryBorderContainer.removeChild(repChildren[i]);
				 } 
				this.repositoryContentPane.setContent(this.resourceBundle.noRepositoryText);
				this.repositoryBorderContainer.addChild(this.repositoryContentPane);
		    	this.repositoryBorderContainer.addChild(this.cloneTitlePane);
		    	this.repositoryBorderContainer.addChild(this.cloneRepositoryButton);
		    	this.repositoryBorderContainer.addChild(this.openTitlePane);
		    	this.repositoryBorderContainer.addChild(this.openRepositoryButton);
		    	
				this.mainPane.addChild(this.repositoryBorderContainer);
				this.repositoryBorderContainer.startup();
				this.mainPane.resize();
				this.cuurentView="repoDefinitionView";
				this.updateGitStatusBar(null, 0, 0);
			}
		},
		showRepoSelectionView: function() {
			if (typeof this.mainPane !== 'undefined'){
				var children = this.mainPane.getChildren();
				for (var i = 0; i < children.length; i++){
					 this.mainPane.removeChild(children[i]);
				 } 
				
				var repChildren = this.repositoryBorderContainer.getChildren();
				for (var i = 0; i < repChildren.length; i++){
					 this.repositoryBorderContainer.removeChild(repChildren[i]);
				 } 
				
				var options =[];
	         	var existingRepositories = appDMS.sasStudioPreferences.gitRepositoryList;
	        	if (existingRepositories && existingRepositories.length > 0){
	        		options.push({ label: this.resourceBundle.selectaRepoLabel, value: "PHOLDER",selected:true,disabled:true });
	        			for(var i=0;i<existingRepositories.length;i++){
	        				if (existingRepositories[i].workingFolder.indexOf('/') > -1 )
	        				{
	        					var repoLabel=existingRepositories[i].workingFolder.substring(existingRepositories[i].workingFolder.lastIndexOf("/")+1,existingRepositories[i].workingFolder.length);
	        				}else {
	        					var repoLabel=existingRepositories[i].workingFolder.substring(existingRepositories[i].workingFolder.lastIndexOf("\\")+1,existingRepositories[i].workingFolder.length);
	        				}
	        				
	        				var repo = { label: repoLabel, value: existingRepositories[i].workingFolder,
              		 				 repoObject:existingRepositories[i]};
	               		 	options.push(repo);
	               	 	}
	        			options.push(new dijit.ToolbarSeparator());
	        			options.push({ label: this.resourceBundle.cloneRepositoryLabel,value: "CLONE", disabled:false});
	        			options.push({ label: this.resourceBundle.openLocalRepositoryLabel,value: "OPENLOCAL", disabled:false});
	        		}
	        	if (this.repositoriesSelect)
	        		this.repositoriesSelect.destroy();
	        	this.repositoriesSelect = new Select({
					sortByLabel: false,
					options: options,
					style : "min-width: 200px",
					"onChange": lang.hitch(this, this.onRepoSelected)
				});
	        	
	        	 var selectedRepoExits = false;
					for(var i = 0; i < options.length; i++)
					{
					  if(options[i].value === this.lastRepository)
					  {
						  selectedRepoExits=true;
					  }
					}
					if (!selectedRepoExits)
						this.repositoriesSelect.set("value","PHOLDER");
					else
						this.repositoriesSelect.set("value", this.lastRepository);
        		this.repositoriesSelect._onChangeActive = true;
				this.repositoryContentPane.setContent(this.repositoriesSelect);
				this.repositoriesSelect.startup();
				this.repositoryBorderContainer.addChild(this.repositoryContentPane);
		    	this.repositoryBorderContainer.addChild(this.cloneTitlePane);
		    	this.repositoryBorderContainer.addChild(this.cloneRepositoryButton);
		    	this.repositoryBorderContainer.addChild(this.openTitlePane);
		    	this.repositoryBorderContainer.addChild(this.openRepositoryButton);
		    	
				this.mainPane.addChild(this.repositoryBorderContainer);
				this.repositoryBorderContainer.startup();
				this.mainPane.resize();
				this.cuurentView="repoSelectionView";
				this.updateGitStatusBar(null, 0, 0);
			}
		},
		showRepositoryView: function() {
			if (appDMS.sasStudioPreferences.optionPreferencesGitProfiles && appDMS.sasStudioPreferences.optionPreferencesGitProfiles.gitProfiles && appDMS.sasStudioPreferences.optionPreferencesGitProfiles.gitProfiles.length === 0)
			{
				this.showProfileView();
				return;
			}
			if (typeof this.mainPane !== 'undefined'){
				var children = this.mainPane.getChildren();
				for (var i = 0; i < children.length; i++){
					 this.mainPane.removeChild(children[i]);
				 }
				if (typeof this.GitTabContainer === 'undefined')
				{
					this.GitTabContainer = new dijit.layout.TabContainer({
						style: "height: 100%!important; width: 100%;",     
						id: '_gitTabContainer',
						"class":"sasSuiteTabs",
						region:"center",
						splitter:true
					}, "tc1-prog");
					this.createGitLocalCommitPanes();
				} else {
		            if(this.commitPaneShowHandle != null)
		            	dojo.disconnect(this.commitPaneShowHandle);
		            
					var children = this.GitTabContainer.getChildren();
					for (var i = 0; i < children.length; i++){
						 this.GitTabContainer.removeChild(children[i]);
					 }
					this.localContentPane.removeChild(this.localContentPane.getChildren()[0]);
					this.repositoriesSelect.set("value",this.lastRepository);
					this.localContentPane.addChild(this.repositoriesSelect);
					this.repositoriesSelect.startup();
					
					this.localListPane.removeChild(this.localListPane.getChildren()[0]);
					this.localListPane.removeChild(this.localListPane.getChildren()[0]);
					this.localListPane.addChild(this.localGrid);
		        	this.localListPane.addChild(this.commitCounterGrid);
		        	this.localGrid.startup();
		        	this.commitCounterGrid.startup();
					
					this.localContentPane.removeChild(this.localContentPane.getChildren()[0]);
					this.repositoriesSelect.set("value",this.lastRepository);
					this.localContentPane.addChild(this.repositoriesSelect);
					this.repositoriesSelect.startup();
					
					
					this.GitTabContainer.addChild(this.localPane);
		            this.localPane.startup();
		            this.GitTabContainer.addChild(this.commitPane);
		            this.commitPane.startup();
		            
					this.commitPaneShowHandle = dojo.connect(this.commitPane, "onShow", lang.hitch(this, function(tab){
						this.unstagedGridGridSelection = [];
						this.unstagedListGrid.renderArray([]);
						this.unstagedListGrid._updateColumns();
						this.stagedGridGridSelection = [];
						this.stagedListGrid.renderArray([]);
						this.stagedListGrid._updateColumns();
						
						this.postOperationRunningDialog("status");
						this.gitServices.getRepositoryStatus(this.lastRepository,lang.hitch(this, this.populateGridLists));
					}));
				}
				this.mainPane.addChild(this.GitTabContainer);
				this.GitTabContainer.startup();
				this.mainPane.resize();
				this.cuurentView="repositoryView";
				if (this.lastRepository===null || this.lastRepository==="PHOLDER"){
					this.updateGitStatusBar(null, 0, 0);
				} else {
					if (appDMS.accordionViewManager && appDMS.accordionViewManager.accordionViews && appDMS.accordionViewManager.accordionViews.Git){
						this.updateGitStatusBar(this.lastRepository, 0, 0);
					} else {
						this.updateGitStatusBar(null, 0, 0);
					}
					
				}
				
//				this.eventListeners.push(this.localPane.on('Show', lang.hitch(this, this.onPaneActive)));
			}
		},
		populateGridLists: function(data)
		{
			//this.postOperationRunningDialog("refresh");
			if (data)
				this.initializeCounters();
			for (var i=0; i<data.length; i++) {
//				this.masterCount = data[i][0]; 	//column 'N'
				var fileName 	 = data[i][1];	//column 'PATH'
				//skip auto saved files
				
				if (typeof fileName === 'undefined' || endsWith(fileName,"~")) continue;
				
				var status 		 = data[i][2];	//column 'STATUS'
				var staged 		 = data[i][3];	//column 'STAGED'

				var url = this.lastRepository + "/";
//	            var icon = SASStudioServices.getIconBasedOnFileExtension(fileName.trim());
	            var statusIcon = "";
	            var statusIconTooltip = "";

				status = status.toLowerCase().trim();
				staged = staged.toLowerCase().trim();
				
				var displayName = fileName.trim();
				var index = displayName.lastIndexOf("/");
				if (index === -1) {
					index = displayName.lastIndexOf("\\");
				}
				if (index > -1) {
					displayName = displayName.substring(index + 1);
				}
				url = url + fileName.trim().substring(0, index);
				
//				if (status === "modified") {
//					statusIcon = sas.icons.HC.INCOMPLETEINPROGRESSSTATUS;
//					statusIconTooltip = StudioUtils.getResourceString("gitModifiedStatusTooltip.txt");
//				} else if (status === "new") {
//					statusIcon = sas.icons.HC.ONDEMANDSTATUS;
//					statusIconTooltip = StudioUtils.getResourceString("gitNewStatusTooltip.txt");
//				} else if (status === "renamed") {
//					statusIcon = sas.icons.HC.MEDIUMPRIORITYSTATUS;
//					statusIconTooltip = StudioUtils.getResourceString("gitRenamedStatusTooltip.txt");
//				} else if (status === "copied") {
//					statusIcon = sas.icons.HC.REVERTEDSTATUS;
//					statusIconTooltip = StudioUtils.getResourceString("gitCopiedStatusTooltip.txt");
//				} else if (status === "deleted") {
//					statusIcon = sas.icons.HC.CANCELEDSTATUS;
//					statusIconTooltip = StudioUtils.getResourceString("gitDeletedStatusTooltip.txt");
//				}
                // create the data for the select list
            	var jsonData = {
            			"name" : appDMS.encodeHtml(displayName),
            			"relativePath" : appDMS.encodeHtml(fileName.trim()),
//            	        "icon" : icon,
//            	        "selected" : false,
//            	        "staged" : staged,
            	        "status" : status,
//            	        "statusIcon" : statusIcon,
//            	        "statusIconTooltip" : statusIconTooltip,
            	        "absolutePath" : appDMS.encodeHtml(url)
            	      };
            	if (staged.toLowerCase() === "true") {
            		this.stagedList.push(jsonData);
            		this.stagedCounter = this.stagedCounter +1;
            	} else {
            		this.unStagedList.push(jsonData);
            		this.unStagedCounter = this.unStagedCounter +1;
            	}
				this.setCommitButtonState();
			}

			//get the amount of commits to update the masterCounter
			this.gitServices.getOutStandingNumberOfCommits(this.lastRepository, this.activeBranch, lang.hitch(this, function(commitCount){
				this.masterCount = commitCount;
//				var counter ={"counter":this.activeBranch+"  " +"("+this.masterCount+")"};
				var counter ={"counter":this.activeBranch};
				this.commitCounterList.push(counter);
				var counter ={"counter":this.resourceBundle.unStagedChanges+"  " +"("+this.unStagedCounter+")"};
				this.unstagedChangesCounterList.push(counter);
				var counter ={"counter":this.resourceBundle.stagedChanges+"  " +"("+this.stagedCounter +")"};
				this.stagedChangesCounterList.push(counter);
				this.renderGrids();
				this.hideOperationRunningDialog();
				this.updateGitStatusBar(this.lastRepository, this.masterCount, this.unStagedCounter+this.stagedCounter);
			}));
		},
		initializeCounters: function()
		{
			this.commitCounterList = [];
            this.unstagedChangesCounterList = [];
            this.stagedChangesCounterList = [];
//            this.masterCount=0;
            this.stagedCounter=0;
            this.unStagedCounter=0;
            this.stagedList=[];
            this.unStagedList=[];
		},
		renderGrids: function()
		{
			if (typeof this.commitCounterGrid !== 'undefined'){
				this.commitCounterGrid.renderArray(this.commitCounterList);
				this.commitCounterGrid._updateColumns();
			}
			if (typeof this.unstagedCounterGrid !== 'undefined' && typeof this.unstagedListGrid !== 'undefined'){
				this.unstagedCounterGrid.renderArray(this.unstagedChangesCounterList);
				this.unstagedCounterGrid._updateColumns();
				this.unstagedGridGridSelection = [];
				this.unstagedListGrid.renderArray(this.unStagedList);
				this.unstagedListGrid._updateColumns();
			}
			if (typeof this.stagedCounterGrid !== 'undefined' && typeof this.stagedListGrid !== 'undefined'){
				this.stagedCounterGrid.renderArray(this.stagedChangesCounterList);
				this.stagedCounterGrid._updateColumns();
				this.stagedGridGridSelection = [];
				this.stagedListGrid.renderArray(this.stagedList);
				this.stagedListGrid._updateColumns();
			}
			setTimeout(lang.hitch(this, function () {
				this.setStageButtonsStates();
			    }), 100);
		},
		populateHistoryGridLists: function(coomitLogData,coomitIdData,grid)
		{
			if (coomitLogData)
				this.historyList = [];
			this.branches=coomitIdData["branches"];
			this.aheadBranches=[];
    		var localCommitId = coomitIdData["local-master"];
	    	var remoteCommitId = coomitIdData["remote-master"];
	    	var localCommitIdIndex = this.findIndex(coomitLogData,localCommitId);
	    	var remoteCommitIdIndex = this.findIndex(coomitLogData,remoteCommitId);
	    	var localIsBehind = false;
	    	
	    	if (localCommitIdIndex > remoteCommitIdIndex)
	    		localIsBehind = true;
	    	
			for (var i=0; i<this.branches.length; i++) {
				if (this.branches[i].indexOf("activeBranch") === -1 && this.branches[i].indexOf("local-master") === -1 && this.branches[i].indexOf("remote-master") === -1){
					var branchCommitId=coomitIdData[this.branches[i]];
					var branchCommitIdIndex = this.findIndex(coomitLogData,branchCommitId);
					if (branchCommitIdIndex < localCommitIdIndex){
						this.aheadBranches.push(this.branches[i]);
					}
				}
			}
	    	
	    	
			for (var i=0; i<coomitLogData.length; i++) {
				var disbleRecord =false;
				var branches =[];
				var commitLogCount = coomitLogData[i][0]; 	//column 'N'
				var commitID 	 	= coomitLogData[i][1];	//column "COMMIT_ID"
				var author 		 	= coomitLogData[i][2];	//column "AUTHOR_NAME"
				var authorEmail  	= coomitLogData[i][3];	//column "AUTHOR_EMAIL"
				var message  	 	= coomitLogData[i][4];	//column "MESSAGE"
				var originalMessage = coomitLogData[i][4];	//column "MESSAGE"
				var parentID     	= coomitLogData[i][5];	//column "PARENT_IDS"
				var time  		 	= coomitLogData[i][6];	//column "TIME"
				
				var date = new Date( Number(time)*1000);
				var formattedDate = dojo.date.locale.format(date,{formatLength:'medium'} );
				
				for (var b=0; b < coomitIdData["branches"].length; b++) {
					if (commitID === coomitIdData[coomitIdData["branches"][b]]){
						message = "-"+coomitIdData["branches"][b]+"-" + message.trim();
						branches.push(coomitIdData["branches"][b]);
					}
				}
				
				
				if (localIsBehind && i < localCommitIdIndex){
					disbleRecord  = true;
				}
                // create the data for the history list
            	var jsonData = {
            			"message" 		: message,
            			originalMessage	: originalMessage,
            			"id" 			: commitID.substr(0,7),
            			"author" 		: author,
            	        "date" 			: formattedDate,
            	        "commitID" 		: commitID,
            	        "time"			: time,
            	        "parentID"		: parentID,
            	        "authorEmail"	: authorEmail,
            	        "commitLogCount": commitLogCount,
            	        "disbleRecord"	: disbleRecord,
            	        "branches"		: branches
            	      };
            		this.historyList.push(jsonData);
			}
			this.renderHistoryGrids(grid);
		},
		populateBranches: function(branches,branchesSelect)
		{
			var activeBranch = this.findActiveBranch(branches);
			var options =this.formatBranches(branches,activeBranch);
			if (typeof branchesSelect !='undefined' && branchesSelect !== null && branchesSelect.domNode !== null)
			{
				branchesSelect.options = options;
				branchesSelect.startup();
			} 
		},
		findActiveBranch: function(branches)
		{
			var activeBranch ="master";
			if (typeof branches !== 'undefined' && branches !== null) {
				for (var j=0; j<branches.length; j++)
				{
					var value = branches[j];
				
					if (value.indexOf("activeBranch-") === 0){
					//	activeBranch= value.substring(value.lastIndexOf("-")+1).trim();
					    var stripLen = "activeBranch-".length;
					    activeBranch = value.substring(stripLen, value.length);
						this.activeBranch=activeBranch;
						return activeBranch;
					} 
					
				}
			}
			this.activeBranch=activeBranch;
			return activeBranch;
		},
		formatBranches: function(branches,activeBranch)
		{
			var options =[];
			if (typeof branches !== 'undefined' && branches !== null) {
				for (var j=0; j<branches.length; j++)
				{
					var value = branches[j];
					if (value  === "local-master")
						value = "master";
					if (value  === "remote-master")
						value = "origin/master";
					if ( (value.indexOf("activeBranch-") === -1) && (value.indexOf("origin/master") === -1) /* && (value.indexOf("origin/") === -1 )*/ ){
						if (value === activeBranch)
							options.push({value:value,label:value,selected:true});
						else
							options.push({value:value,label:value,selected:false});
					}
					
				}
			}
			return options;
		},
		renderHistoryGrids: function(grid)
		{
			if (typeof grid !== 'undefined'){
				grid.renderArray(this.historyList);
				grid._updateColumns();
			}
		},
		populateDetailsGridLists: function(data)
		{
			if (data)
			{
				this.detailsList = [];
				
				var author			= data.author; 	
				var commit 	 		= data.commitID;
				var children 		= ((typeof data.children !== 'undefined') ? data.children : "");
				var parents  		= data.parentID;
				var date			= data.date;
				var time            = data.time;
				
                // create the data for the details list
            	var jsonData = {
            			"author" 	: author,
            			"commit" 	: commit,
            			"children" 	: children,
            	        "parents" 	: parents,
            	        "date"		: date,
						"time"      : time
            	      };
            	this.detailsList.push(jsonData);

            	var message = data.originalMessage.trim();
            	this.renderDetailsData(message);
			}
		},
		createDetailsPane: function()
		{
				this.detailsList = [];
				if (typeof detailsTextarea !== "undefined"){
					detailsTextarea.destroy();
					detailsTextarea = new SimpleTextarea({
		        	    name: "detailsSimpleTextarea",
		        	    region:"top",
		        	    rows:"10",
		        	    cols:"50",
		        	    readOnly:true,
		        	    style: "width:95%;height:60px;"//"width:100%;height:70px;"
		        	  }, "detailsSimpleTextarea");
					detailsTextarea.setValue("");
					var detailsContentPane = new ContentPane({
						region:"top",
						gutters: true,
		  				splitter:true,
						style: "padding-left:10px; padding-top:20px; height:auto;"
					});
		        	detailsContentPane.setContent(detailsTextarea);
		        	this.detailsPane.addChild(detailsContentPane);
//		        	this.createDetailsData();
				}
		},
		resetDetailsPane: function()
		{
				this.detailsList = [];
				this.renderDetailsData("");
				
		},
		renderDetailsData: function(message)
		{
			var tabs=appDMS.getCurrentPerspectiveSASStudioTabs();
	        this.currentTab=tabs.getFocusedTab();
			if (this.currentTab && this.currentTab.type && this.currentTab.type==="git"){
				var detailsPane = this.currentTab.tab.getChildren()[2].getChildren()[0];
				var detailsTextArea = detailsPane.getChildren()[0].getChildren()[0];
				detailsTextArea.setValue(" "+appDMS.decodeHtml(message));
				var detailsDataPane = detailsPane.getChildren()[1];
				this.createDetailsData(detailsDataPane);
				
			} 
			
		},
		populateFilesPaneData: function(data)
		{
			var filesList=[];
			//var filesCounterList=[];
			var filesSelectionList=[];
			var filesCounter=data[0].rows.length;
			//filesCounterList.push(counter);
			
			
			var tabs=appDMS.getCurrentPerspectiveSASStudioTabs();
			currentTab=tabs.getFocusedTab();
			var filesPane = currentTab.tab.getChildren()[2].getChildren()[1];
			var filesCenterPane = filesPane.getChildren()[1];
			var filesLeftPane = filesPane.getChildren()[0];
			var filesLabelContentPane = filesPane.getChildren()[0].getChildren()[0];
			var filesListPane = filesPane.getChildren()[0].getChildren()[1];
			var filesCounterGrid = filesLabelContentPane.getChildren()[0];
			
			var fileNameLabelContentPane = filesPane.getChildren()[1].getChildren()[0];
			var fileDiffContentPane = filesPane.getChildren()[1].getChildren()[1];
			var fileNameGrid = fileNameLabelContentPane.getChildren()[0];
			
			fileDiffContentPane.setContent("");
		    this.openDialogContent="";
		    fileNameGrid.renderArray(filesSelectionList);
		    fileNameGrid._updateColumns();
			
			//filesCounterGrid.renderArray(filesCounterList);
			//filesCounterGrid._updateColumns();
			var counter = this.resourceBundle.files+"  " +"("+filesCounter+")";
			filesCounterGrid.set("value", counter);
			
			var filesLeftPaneKids= filesLeftPane.getChildren();
			for (var i=filesLeftPaneKids.length-1;i>0;i--){
				filesLeftPane.removeChild(i);
			}
			
			for (var i=0;i<data[0].rows.length;i++){
				var obj = {};
				var name = data[0].rows[i][1];
				name= name.substring(name.lastIndexOf("/")+1);
				obj.name=appDMS.encodeHtml(name);  
				obj.absolutePath=this.currentRepository+"/"+data[0].rows[i][1]; //"FILE_PATH"
				obj.content = data[0].rows[i][2];//"DIFF_CONTENT"
				obj.content = "["+obj.content.substring(0, obj.content.length)+"]";
				obj.status  = data[0].rows[i][3]; //"STATUS"
				filesList.push(obj);
			}
			
			var filesListGrid = this.createFileListGrid();
			filesListGrid.renderArray(filesList);
			filesListGrid._updateColumns();
			var filesListPane = new TitlePane({
				content: filesListGrid,
				style: "width:100%;"
			});
			
			if (data.olderCommitID.length === 0){
				filesListPane.setTitle(this.resourceBundle.fileListCommitLabel+ " " + data.newerCommitID);	
			} else {
				var title =  this.resourceBundle.diffBetweenLabel;
				title = title.replaceAll('${0}', data.olderCommitID).replaceAll('${1}', data.newerCommitID);
				filesListPane.setTitle(title);
			}
			
			filesListGrid.startup();
			filesLeftPane.addChild(filesListPane);
			
			filesPane.domNode.style.display='block';
			filesPane.resize();
		},
		
		createDiffHtml:function(content){

			//escape JSON bs.
			content = 	content.replace(/[\\]/g, '\\\\')
								.replace(/[\"]/g, '\\"')
						        .replace(/[\/]/g, '\\/')
						        .replace(/[\b]/g, '\\b')
						        .replace(/[\f]/g, '\\f')
						        .replace(/[\n]/g, '\\n')
						        .replace(/[\r]/g, '\\r')
						        .replace(/[\t]/g, '\\t');

			//Now we need to double escape the contents of the value properties.
			var valueSplitter = "\\\", \\\"value\\\":\\\"";
			var topArr = content.split(valueSplitter);	
			var newContent = '[{"type":"file_header", "value":"'; //always begins with file_header type
			for(var i=1; i<topArr.length; i++){
				var splitContent = topArr[i];
				if (endsWith(splitContent,"}]")){
					newContent+=splitContent.split('\\"}]')[0];
					newContent+='\"}]';
				}else{
					var nestedArr = splitContent.split('\\"},{\\"type\\":\\"');
					newContent+=nestedArr[0];
					newContent+='\"},{\"type\":\"';
					newContent+=nestedArr[1]+'\", \"value\":\"';
				}
			}
			
			var diffArr = "";
			
			try{
				diffArr = JSON.parse(newContent);
			}catch(err){
				appDMS.dialogs.postInfoDialog(this.resourceBundle.largeDiff);
			}
			
			var diffHTML = "";
			
			for(var i = 0; i < diffArr.length; i++){
				var diffLine = diffArr[i];
				
				switch(diffLine.type){
				case "file_header":
					diffHTML += "<div class='sasGitDiffFileHeaderLine'>"+appDMS.encodeHtml(diffLine.value)+"</div>";
					break;
				case "hunk_header":
					diffHTML += "<div class='sasGitDiffHunkHeaderLine'>"+appDMS.encodeHtml(diffLine.value)+"</div>";
					break;
				case "context":
					diffHTML += "<div class='sasGitDiffContextLine'>"+appDMS.encodeHtml(diffLine.value)+"</div>";
					break;
				case "deletion":
					diffHTML += "<div class='sasGitDiffDeletionLine'>"+appDMS.encodeHtml(diffLine.value)+"</div>";
					break;
				case "addition":
					diffHTML += "<div class='sasGitDiffAdditionLine'>"+appDMS.encodeHtml(diffLine.value)+"</div>";
					break;
				case "no_lf_at_end_of_both_files":
					diffHTML += "<div class='sasGitDiffNoLineFeedAtEndOfBoth'>"+appDMS.encodeHtml(diffLine.value)+"</div>";
					break;
				case "old_file_has_no_lf_at_end_new_does":
					diffHTML += "<div class='sasGitDiffOldFileHasNoLineFeedNewDoes'>"+appDMS.encodeHtml(diffLine.value)+"</div>";
					break;
				case "old_file_has_lf_at_end_new_doesnt":
					diffHTML += "<div class='sasGitDiffOldFileHasLineFeedNewDoesnt'>"+appDMS.encodeHtml(diffLine.value)+"</div>";
					break;
				case "binary":
					diffHTML += "<div class='sasGitDiffBinaryLine'>"+appDMS.encodeHtml(diffLine.value)+"</div>";
					break;
				}
			}
			
			return diffHTML;
		},
		
		populateMultiParentFilesPaneData: function(data)
		{
			var filesList={};
			//var filesCounterList=[];
			var filesCounter=0;
			
			var tabs=appDMS.getCurrentPerspectiveSASStudioTabs();
			currentTab=tabs.getFocusedTab();
			var filesPane = currentTab.tab.getChildren()[2].getChildren()[1];
			var filesCenterPane = filesPane.getChildren()[1];
			var filesLeftPane = filesPane.getChildren()[0];
			var filesLabelContentPane = filesPane.getChildren()[0].getChildren()[0];
			var filesListPane = filesPane.getChildren()[0].getChildren()[1];
			var filesCounterGrid = filesLabelContentPane.getChildren()[0];
			
			var fileNameLabelContentPane = filesPane.getChildren()[1].getChildren()[0];
			var fileDiffContentPane = filesPane.getChildren()[1].getChildren()[1];
			var fileNameGrid = fileNameLabelContentPane.getChildren()[0];
			
			var filesLeftPaneKids= filesLeftPane.getChildren();
			for (var i=filesLeftPaneKids.length-1;i>0;i--){
				filesLeftPane.removeChild(i);
			}
			
			
			for (var i=0;i<data.length;i++){
				filesList[i]=[];
				filesCounter=filesCounter+data[i].rows.length;
				for (var j=0;j<data[i].rows.length;j++){
					var obj = {};
					var name = data[i].rows[j][1];
					name= name.substring(name.lastIndexOf("/")+1);
					obj.name=appDMS.encodeHtml(name);  
					obj.absolutePath=data[i].rows[j][1]; //"FILE_PATH"
					obj.content = data[i].rows[j][2];//"DIFF_CONTENT"
					obj.content = "["+obj.content.substring(0, obj.content.length-1)+"]";
					obj.status  = data[i].rows[j][3]; //"STATUS"
					filesList[i].push(obj);
				}
				var filesListGrid = this.createFileListGrid();
				filesListGrid.renderArray(filesList[i]);
				filesListGrid._updateColumns();
				var filesListPane = new TitlePane({
					content: filesListGrid,
					style: "padding-left:10px; width:94%;height:50%;"
				});
				filesListPane.setTitle(this.resourceBundle.diffWithLabel+ data[i].parent.substr(0,7));
				filesListGrid.startup();
				filesLeftPane.addChild(filesListPane);
				filesListPane.startup();
			}
			
			var counter =this.resourceBundle.files+"  " +"("+filesCounter+")";
			//filesCounterList.push(counter);
			//filesCounterGrid.renderArray(filesCounterList);
			//filesCounterGrid._updateColumns();
			filesCounterGrid.set("value", counter);

			filesCenterPane.domNode.style.display='none';
			filesPane.domNode.style.display='block';
			filesPane.resize();
		},
		commitPaneResizeHandler: function() {
			console.log("commitPaneResizeHandler");
			this.commitPane.resize();
			this.commitStagedTextareaPane.resize();
//			var accordionContainer = dijit.byId("accordionContainer");
//			accordionContainer.resize();
		},
		historyPaneResizeHandler: function() {
			console.log("historyPaneResizeHandler");
			this.historyPane.resize();
		},
        createProfile: function()
		{
        	if(typeof appDMS.sasStudioPreferences.newProfileDialog==="undefined" || appDMS.sasStudioPreferences.newProfileDialog == null)
			{
				require(
						["webdms/dialogs/NewProfileDialog"],
						lang.hitch(this, function(NewProfileDialog)
						{
							appDMS.sasStudioPreferences.newProfileDialog = new NewProfileDialog(appDMS.sasStudioPreferences,null);
						}
						));
			}
			else
			{
				appDMS.sasStudioPreferences.newProfileDialog.show();
			}
		},
		cloneRepository: function()
		{
			if(typeof appDMS.sasStudioPreferences.cloneGITRepositoryDialog==="undefined" || appDMS.sasStudioPreferences.cloneGITRepositoryDialog == null)
			{
				require(
						["webdms/dialogs/CloneGITRepositoryDialog"],
						lang.hitch(this, function(CloneGITRepositoryDialog)
						{
							appDMS.sasStudioPreferences.cloneGITRepositoryDialog = new CloneGITRepositoryDialog(appDMS.sasStudioPreferences,null);
						}
						));
			}
			else
			{
				appDMS.sasStudioPreferences.cloneGITRepositoryDialog.show();
			} 
			
			//this.repositoriesSelect.set("value","PHOLDER");
		},
		openRepository: function()
		{
			console.log("open repository"); 
				 if (this.repoOpenDialog == null) {
				        require(["webdms/dialogs/RepoOpenDialog"],
								lang.hitch(this, function (RepoOpenDialog) {
								    this.repoOpenDialog = new RepoOpenDialog();
								    this.repoOpenDialog.postDialog(appDMS.sasStudioPreferences);
								}
								));
				    } else {
				        this.repoOpenDialog.postDialog(appDMS.sasStudioPreferences);
				    }
		},
		onRepoSelected: function(evt)
		{
			if (!this.doMorph){
				this.doMorph=true;
				return;
			}
		    var selectedValue = this.repositoriesSelect.getValue();
			if (selectedValue ==="OPENLOCAL"){
				//this.lastRepository = selectedValue;
				//appDMS.selectedGitRepository=selectedValue;
				//this.activeRepository=null;
				this.repositoriesSelect.set("value", this.activeRepository.workingFolder);
				this.openRepository();
			}
			else
			{
				if (selectedValue !=="CLONE"){
					if (typeof this.activeRepository !=="undefined" && this.activeRepository !== null && this.activeRepository.workingFolder){
						if (selectedValue !== this.activeRepository.workingFolder)
							appDMS.sasStudioPreferences.closeOpenTab(this.activeRepository.workingFolder);
					}
					this.lastRepository = selectedValue;
					appDMS.selectedGitRepository=selectedValue;
					this.activeRepository=null;
					this.updateLocalGrids(this.lastRepository);
					if (!this.addToHistory){
						this.addToHistory=true;
					}else {
						this.gitServices.addRepositoryToHistory(this.lastRepository);
					}
				}
				if (selectedValue !== "CLONE" && selectedValue !== "PHOLDER"){
					this.lastRepository = selectedValue;
					appDMS.selectedGitRepository=selectedValue;
					this.activeRepository=null;
					this.showRepositoryView();
					this.activeRepository = this.repositoriesSelect._getSelectedOptionsAttr().repoObject;
					 setTimeout(lang.hitch(this, function () {
						 this.hideOperationRunningDialog();
						}), 2000);
				}
				else if (selectedValue === "CLONE")
			//	else if (selectedValue === "CLONE" || selectedValue === "PHOLDER")
				{
						this.doMorph=false;
						this.repositoriesSelect.set("value", this.activeRepository.workingFolder);

					//this.showRepoSelectionView();
					// if (selectedValue === "CLONE"){
						this.cloneRepository();
					// } 
				}
			}
			
		},
		updateLocalGrids: function(repository)
		{
			this.selectedRepList=[];
			if (repository && repository.length >0){
				if (repository.indexOf('/') > -1){
					var repoName=repository.substring(repository.lastIndexOf("/")+1,repository.length);
				} else {
					var repoName=repository.substring(repository.lastIndexOf("\\")+1,repository.length);
				}
				this.selectedRepList.push({"repoName":repoName});
			}
			if (typeof this.localGrid !== 'undefined'){
				this.localGrid.renderArray(this.selectedRepList);
				this.localGrid._updateColumns();
			}
			this.gitServices.gitActiveBranch(repository,lang.hitch(this, function(data) {
				this.commitCounterList = [];
//				this.commitCounterList.push({"counter":this.activeBranch+"  " +"("+this.masterCount+")"});
				this.commitCounterList.push({"counter":this.activeBranch});
				this.commitCounterGrid.renderArray(this.commitCounterList);
				this.commitCounterGrid._updateColumns();
			}));
		},
		setSelectedFolder: function(selectedFolder /* Object */) {
//			dijit.byId(this.getDirectoryInputId()).set("value", selectedFolder.uri);
			console.log("selected folder is passed to the caller");
		},
        onPullMaster: function (evt) {
           // console.log("onPullMaster");
            this.onPull();
        },
        onPushToMaster: function (evt) {
        	// console.log("onPushToMaster");
        	 this.onPush();
        },
        onDeleteMaster: function (evt) {
        	 console.log("onDeleteMaster");
        },
        resetSessionId: function (id) {
            this.sessionId = id;
        },
        onCommitGridContextMenu: function (evt) {
          if(evt.preventDefault)
      		  evt.preventDefault();
      	  if(evt.stopPropagation)
      		  evt.stopPropagation();
        },
        onCommitStaged: function (evt) {
        	console.log("onCommitStaged");
        	var comment = this.commitTextarea.getValue();
        	
        	if(comment == null || comment == ""){
        		appDMS.dialogs.postFaultDialog(this.resourceBundle.commitMsgRequired);
        		return;
        	}
        	if (typeof this.stagedList === "undefined" || this.stagedList === null || this.stagedList.length === 0 ){
        		
        		var yes=function()
       	   		{
        			this.commitStagePromptDialog.hide();
					this.onStageAndCommitAll();
						
				}
				
				var no=function()
				{
					this.commitStagePromptDialog.hide();
				}
				var question = this.resourceBundle.noStagedFiles;

				this.commitStagePromptDialog=appDMS.dialogs.postDecisionDialog(question, null,
																	 {label:this.resourceBundle.yesLabel,
																	 callback:lang.hitch(this,yes),
																	 primary:false},
																	 {label:this.resourceBundle.noLabel,
																	 callback:lang.hitch(this,no),
																	 primary:true});
				
				focus.focus(this.commitStagePromptDialog.buttons[1].focusNode);
				
				return;
        	}
        	this.postOperationRunningDialog("commit");
            this.gitServices.gitCommit(
			    this.lastRepository, 
            	this.activeRepository.profileName,
            	"HEAD",
            	appDMS.encodeHtml(comment),
				this.activeRepository.mergeCommitId,        				
			    lang.hitch(this, function(data){
					console.log("commit successful");
					this.commitTextarea.reset();
					this.hideOperationRunningDialog();
					var studioTabs=appDMS.getCurrentPerspectiveSASStudioTabs();
					var tabs=[];
					if (typeof studioTabs != 'undefined')
						tabs=studioTabs.mainTabs;
					for (var i=0; i<tabs.length; i++) {
						if (tabs[i].type === "git"){
							studioTabs.selectTab(tabs[i]);
							this.onHistoryRefresh("",tabs[i]);
						}
					}
					this.onRefresh();

					//reset the mergeCommit stuff
					if(this.activeRepository.isMerging){
						this.activeRepository.isMerging = false;
						this.activeRepository.mergeCommitId = null;
						this.activeRepository.mergeBranch = null;
						this.gitServices.updateRepositoryMergeState(this.activeRepository);
					}
					
			    }), 
				lang.hitch(this, function(error) 
				{
					this.hideOperationRunningDialog();
				})
			);
        },
        onRefresh: function (calledFrom) {
        	
        	if(!this.refreshing)
        		this.refreshing = true;
        	else
        		return;
        	
            console.log("onRefresh");
            if (typeof calledFrom === 'undefined' || calledFrom === null || calledFrom !=="silentStatus")
            	this.postOperationRunningDialog("status");
            this.gitServices.getRepositoryStatus(
			    this.lastRepository,
				lang.hitch(this, function(data){
					this.populateGridLists(data);
					this.refreshing = false;
				}),
				lang.hitch(this, function(error) 
				{
					this.hideOperationRunningDialog();
					this.refreshing = false;
				})
			);
        },
            
        onPull: function () {
            console.log("onPull");
            var availableProfilesList = appDMS.sasStudioPreferences.optionPreferencesGitProfiles.gitProfiles;
            var profileFound = false;
            for (var i = 0; i < availableProfilesList.length; i++) {
            	if (availableProfilesList[i].profileName === this.activeRepository.profileName ){
            		profileFound = true;
            	}
            }
            if (!profileFound){
            	var Message=this.resourceBundle.profileNotFound.replaceAll('${0}', this.activeRepository.profileName);
            	appDMS.dialogs.postFaultDialog(Message);
            	return;
            }
            this.postOperationRunningDialog("pull");
            this.gitServices.gitPull(
			    this.lastRepository, 
				this.activeRepository.profileName, 
				lang.hitch(this, function(data){
					
					this.hideOperationRunningDialog();
			    	switch(data){
			    	case 0:
			    		//merge successful.
			    		appDMS.projects.onRefresh();
						var studioTabs=appDMS.getCurrentPerspectiveSASStudioTabs();
						var tabs=[];
						if (typeof studioTabs != 'undefined')
							tabs=studioTabs.mainTabs;
						for (var i=0; i<tabs.length; i++) {
							if (tabs[i].type === "git"){
								studioTabs.selectTab(tabs[i]);
								this.onHistoryRefresh("",tabs[i]);
							}
						}
						this.checkOpenTabs();
						break;
			    	case 1:
			    		//already up to date.
			    		appDMS.dialogs.postInfoDialog(this.resourceBundle.branchUpToDate);
			    		break;
			    	case -2:
						//hotfix
						this.activeRepository.isMerging = true;
						var url = appDMS.baseURL + '/sasexec/sessions/' + appDMS.sessionId + '/workspace/' + encodeValue(this.activeRepository.workingFolder+"/.git/FETCH_HEAD", false);
						dojo.xhrGet({
							url : url,
							sync : false,
							preventCache: true,
							handleAs : "text",
							load : lang.hitch(this, function(data, args) 
							{
								if(data){
									var targetBranchCommitID = data.length >= 40 ? data.substr(0, 40) : "";
									this.activeRepository.mergeCommitId = targetBranchCommitID;
									this.gitServices.updateRepositoryMergeState(this.activeRepository);
								}
							})
						});

						appDMS.dialogs.postFaultDialog(this.resourceBundle.mergeConflicts);
			    		appDMS.gitRepoRefresh(this.activeRepository.workingFolder);
						this.checkOpenTabs();
			    		break;
			    	}
				}),
				lang.hitch(this, function(error) 
				{
					this.hideOperationRunningDialog();
				})
			);
        },
        onPush: function () {
            console.log("onPush");
            var availableProfilesList = appDMS.sasStudioPreferences.optionPreferencesGitProfiles.gitProfiles;
            var profileFound = false;
            for (var i = 0; i < availableProfilesList.length; i++) {
            	if (availableProfilesList[i].profileName === this.activeRepository.profileName ){
            		profileFound = true;
            	}
            }
            if (!profileFound){
            	var Message=this.resourceBundle.profileNotFound.replaceAll('${0}', this.activeRepository.profileName);
            	appDMS.dialogs.postFaultDialog(Message);
            	return;
            }
			this.postOperationRunningDialog("push");
            this.gitServices.gitPush(
			    this.lastRepository, 
			    this.activeRepository.profileName, 
			    lang.hitch(this, function(data){
					console.log("push successful");
					this.hideOperationRunningDialog();
					var studioTabs=appDMS.getCurrentPerspectiveSASStudioTabs();
					var tabs=[];
					if (typeof studioTabs != 'undefined')
						tabs=studioTabs.mainTabs;
					for (var i=0; i<tabs.length; i++) {
						if (tabs[i].type === "git"){
							studioTabs.selectTab(tabs[i]);
							this.onHistoryRefresh("",tabs[i]);
						}
					}
//					this.onRefresh();
				}), 
				lang.hitch(this, function(error) 
				{
					this.hideOperationRunningDialog();
				})
			);
        },
        onHistory: function () {
			this.postOperationRunningDialog("history");
			
        	this.gitServices.gitCommitLog(
			    this.lastRepository, 
				lang.hitch(this, function(coomitLogData){
					if(coomitLogData && coomitLogData.rows && coomitLogData.rows.length == 0){
						appDMS.dialogs.postFaultDialog(this.resourceBundle.noCommits);
						this.hideOperationRunningDialog();
					}else{
						console.log("commit log successful");
						this.coomitLogData = coomitLogData;
						this.gitServices.getLastCommitIds(
							this.lastRepository,
							lang.hitch(this, function(coomitIdData){
								console.log("getLastCommitIds successful");
	//							var grid = this.createHistoryGrid();
								this.populateHistoryGridLists(this.coomitLogData.rows,coomitIdData);
								this.createDetailsPane();
								this.activeRepository.name=this.activeRepository.workingFolder;
								this.activeRepository.type="git";
								this.activeRepository.branches=coomitIdData.branches;
								this.activeRepository.branchData=coomitIdData;
	//							this.activeRepository.historyGrid=grid;
								this.activeRepository.historyList= JSON.parse(JSON.stringify(this.historyList));
								if (appDMS.currentPerspectiveKey === "vp"){
									if (appDMS.perspective[appDMS.currentPerspectiveKey].onAddGitTab)
										appDMS.perspective[appDMS.currentPerspectiveKey].onAddGitTab(this.activeRepository);
								}
								else {
									appDMS.tabs.addGitTab(this.activeRepository);
								}
								this.hideOperationRunningDialog();
							}), 
							lang.hitch(this, function(error) 
							{
								this.hideOperationRunningDialog();
							})
						);
					}
				}), 				
				lang.hitch(this, function(error) 
				{
					this.hideOperationRunningDialog();
				}));
        	
        },
		onDiffBetweenCommits:function(localRepo, olderCommitID, newerCommitID){
 			this.postOperationRunningDialog("getdiffs");
 			this.diffData=[];
 			this.diffData.olderCommitID= olderCommitID.substr(0,7);
 			this.diffData.newerCommitID= newerCommitID.substr(0,7);
 			
        	this.gitServices.gitDiffBetweenCommits(
			    localRepo, 
			    olderCommitID, 
				newerCommitID, 
				lang.hitch(this, function(data){
					console.log("onDiff");
					this.diffData.push(data);
					this.populateFilesPaneData(this.diffData);
					this.hideOperationRunningDialog();
				}),
				lang.hitch(this, function(error) 
				{
					this.hideOperationRunningDialog();
				})
			);
        	
        },
        onMultiParentDiffBetweenCommits:function(localRepo, commitRecord){
 			this.parts = commitRecord.parentID.split(",");
			var newerCommitID = commitRecord.commitID;
			this.diffData = [];
			
			var callbackFunction = lang.hitch(this, function(diff, parents, index, length){
				
				if(index < length){
					this.gitServices.gitDiffBetweenCommits(
						    localRepo, 
						    parents[index], 
							newerCommitID, 
							lang.hitch(this, function(cbDiff, cbParents, cbIndex, cbLength, data){
								cbDiff.push(data);
								data.parent = cbParents[cbIndex];
								callbackFunction(cbDiff, cbParents, ++cbIndex, cbLength);
							}, diff, parents, index, length),
							lang.hitch(this, function(error) 
							{
								this.hideOperationRunningDialog();
							})
						);
				}else{
					this.populateMultiParentFilesPaneData(diff)
				}
			});
			
			callbackFunction(this.diffData, this.parts, 0, this.parts.length);
			
        },
        onStageOpen: function (evt) {
	        console.log("onStageOpen");
	        if (this.stagedGridGridSelection && this.stagedGridGridSelection.length==1) {
			   var obj = this.copyAndScrubObject(this.stagedGridGridSelection[0].data);
			   appDMS.handleWebOneEvent('FileOpen', obj, evt);
			}	
	    },
	    onStage: function (evt) {
	        var items = [];
            for (var i=0; i<this.unstagedGridGridSelection.length; i++){
				var item = {};
				item.name = appDMS.decodeHtml(this.unstagedGridGridSelection[i].data.name);
            	item.absolutePath = this.unstagedGridGridSelection[i].data.absolutePath;			
             	item.relativePath = this.unstagedGridGridSelection[i].data.relativePath;
             	item.status = this.unstagedGridGridSelection[i].data.status;
                items.push(item);				
			}
			this.doStageItem(items);		
	    },
		
		doStageItem: function(item) {
			console.log("onStage");
			this.postOperationRunningDialog("stage");
	        this.gitServices.gitStage(
			    this.lastRepository, 
			    item, 
				lang.hitch(this,function(){
				    this.hideOperationRunningDialog();
	        		this.onRefresh();
	        	}),
				lang.hitch(this, function(error) 
				{
				    this.hideOperationRunningDialog();
				})
			);
		},

        onStageAll: function (evt) {
        	console.log("onStageAll");
        	for (var i=0; i<this.unStagedList.length; i++) {
        		this.unStagedList[i].name=appDMS.decodeHtml(this.unStagedList[i].name);
    			this.unStagedList[i].relativePath=appDMS.decodeHtml(this.unStagedList[i].relativePath);
    			this.unStagedList[i].absolutePath=appDMS.decodeHtml(this.unStagedList[i].absolutePath);
        	}
			this.postOperationRunningDialog("stageAll");
        	this.gitServices.gitStage(
			    this.lastRepository, 
				this.unStagedList, 
				lang.hitch(this,function(){
					this.hideOperationRunningDialog();
					this.onRefresh();
				}),
				lang.hitch(this, function(error) 
				{
				    this.hideOperationRunningDialog();
				})
			);
        },
        onStageAndCommitAll: function (evt) {
        	console.log("onStageAll");
			this.postOperationRunningDialog("stageAll");
        	this.gitServices.gitStage(
			    this.lastRepository, 
				this.unStagedList, 
				lang.hitch(this,function(){
					this.onRefresh();
					setTimeout(lang.hitch(this, function () {
						this.hideOperationRunningDialog();
						this.onCommitStaged();
					    }), 2000);
					
				}),
				lang.hitch(this, function(error) 
				{
				    this.hideOperationRunningDialog();
				})
			);
        },
 		copyAndScrubObject: function(obj) {
		    var object={};
		    obj.name = appDMS.decodeHtml(obj.name);
			object.name=obj.name;
			if (!endsWith(obj.absolutePath,"/"))
		        obj.absolutePath = obj.absolutePath+"/";
		 	object.id=(obj.absolutePath+obj.name).replaceAll("/","~ps~");
		 	object.uri=obj.absolutePath+obj.name;
		 	object.uriParent=obj.absolutePath;
	        return object;
		}, 
		
        onUnStageOpen: function (evt) {
	        console.log("onUnStageOpen");
			if (this.unstagedGridGridSelection && this.unstagedGridGridSelection.length==1) {
			   var obj = this.copyAndScrubObject(this.unstagedGridGridSelection[0].data);
			   appDMS.handleWebOneEvent('FileOpen', obj, evt);
			}	        
	    },
		
		
	    onUnStagedResetFile: function(item)
	    {
	    	if (this.unstagedGridGridSelection && this.unstagedGridGridSelection.length==1){
	    		
				if(this.unstagedGridGridSelection[0].data.status === "new") {
					this.postOperationRunningDialog("resetFile");
					return this.onNewFileReset(this.unstagedGridGridSelection[0].data);
				}
	    		
	    		this.resetFile(this.activeRepository.workingFolder, this.unstagedGridGridSelection[0].data.relativePath);
	    	}
	    },
		onStagedResetFile: function(item)
		{
			if (this.stagedGridGridSelection && this.stagedGridGridSelection.length==1){ 
				
				if(this.stagedGridGridSelection[0].data.status === "new") {
					this.postOperationRunningDialog("resetFile");
					//need to unstage the file then delete it or or we will get a deleted status in the unstaged area.
			       return this.gitServices.gitUnStage(
						    this.lastRepository,
						    [this.stagedGridGridSelection[0].data],
							lang.hitch(this,function(data, filePath){
								this.onNewFileReset(this.stagedGridGridSelection[0].data);
							}, this.stagedGridGridSelection[0].data),
							lang.hitch(this, function(error) 
							{
							    this.hideOperationRunningDialog();
							})
						);
				}
			
	    		this.resetFile(this.activeRepository.workingFolder, this.stagedGridGridSelection[0].data.relativePath);
			}
		},
		
		onNewFileReset:function(fileObject){
			var path = fileObject.absolutePath + fileObject.name;
			if(fileObject.absolutePath[fileObject.absolutePath.length - 1] !== "/")
				path = fileObject.absolutePath + "/" + fileObject.name;
			this.gitServices.deleteRepositoryDirectory(appDMS.decodeHtml(path),
						lang.hitch(this, function(data){
							appDMS.refreshApplication();
							this.hideOperationRunningDialog();
							this.onRefresh();
							this.checkOpenTabs();
							console.log("reset of new file successful");
						}),
						lang.hitch(this, function(data){
							this.hideOperationRunningDialog();
							console.log("error resetting new file");
						}));
		},
		
		resetFile: function(path, name)
		{
			this.postOperationRunningDialog("resetFile");
			this.resetPath = appDMS.decodeHtml(path);
			this.resetName = appDMS.decodeHtml(name);
	        this.gitServices.gitResetFile(
			    this.resetPath,
				this.resetName,
				lang.hitch(this,function(data){
					appDMS.refreshApplication();
					this.hideOperationRunningDialog();
					this.onRefresh();
					this.checkOpenTabs(this.resetPath, this.resetName);
				}),
				lang.hitch(this, function(error) 
				{
				    this.hideOperationRunningDialog();
				})
			);				
		},
		
		onUnStagedShowDifferences: function(item)
		{
	       if (this.unstagedGridGridSelection && this.unstagedGridGridSelection.length==1) {
	    		this.getDiffs(this.activeRepository.workingFolder, this.unstagedGridGridSelection[0].data.relativePath);
	       }
		},
		onStagedShowDifferences: function(item)
		{
		    if (this.stagedGridGridSelection && this.stagedGridGridSelection.length==1){
	    		this.getDiffs(this.activeRepository.workingFolder, this.stagedGridGridSelection[0].data.relativePath);
		    }
		},
		
		getDiffs: function(path, name)
		{
			this.postOperationRunningDialog("fileDiff");
	        this.gitServices.gitDiffIndexFile(
			    appDMS.decodeHtml(path),
				appDMS.decodeHtml(name),
				lang.hitch(this,function(data){
					this.hideOperationRunningDialog();
					var diffContent = data.rows[0][0];
					if ((diffContent.length > 0) && (diffContent.lastIndexOf(',') == diffContent.length-1))
					   diffContent = diffContent.substring(0, diffContent.length-1);   // Strip trailing comma
					var content = "[" + diffContent + "]";
					//content = "[" + content[0].substring(0, content[0].length-1) + "]";
					//this.openDialogContent = this.createDiffHtml(data.rows[0]);
					this.openDialogContent = this.createDiffHtml(content);
					if (this.openDialogContent && this.openDialogContent.length > 0)
					    this.onOpenDialog();
				}),
				lang.hitch(this, function(error) 
				{
				    this.hideOperationRunningDialog();
				})
			);		
		},
		
        onUnStage: function () {
		    var items = [];
            for (var i=0; i<this.stagedGridGridSelection.length; i++){
				var item = {};
				item.name = encodeValue(this.stagedGridGridSelection[i].data.name);
            	item.absolutePath = this.stagedGridGridSelection[i].data.absolutePath;			
             	item.relativePath = this.stagedGridGridSelection[i].data.relativePath;
                items.push(item);				
			}
			this.doUnstageItem(items);
	    },
		doUnstageItem: function(item) {
		    console.log("onUnStage");
			this.postOperationRunningDialog("unstage");
	        this.gitServices.gitUnStage(
			    this.lastRepository,
			    item,
				lang.hitch(this,function(){
					this.hideOperationRunningDialog();
					this.onRefresh();
				}),
				lang.hitch(this, function(error) 
				{
				    this.hideOperationRunningDialog();
				})
			);

		},

        onUnStageAll: function () {
        	console.log("onUnStageAll");
        	for (var i=0; i<this.stagedList.length; i++) {
        		this.stagedList[i].name=appDMS.decodeHtml(this.stagedList[i].name);
    			this.stagedList[i].relativePath=appDMS.decodeHtml(this.stagedList[i].relativePath);
    			this.stagedList[i].absolutePath=appDMS.decodeHtml(this.stagedList[i].absolutePath);
        	}
			this.postOperationRunningDialog("unstageAll");
       	    this.gitServices.gitUnStage(
			    this.lastRepository, 
				this.stagedList,
				lang.hitch(this,function(){
					this.hideOperationRunningDialog();
					this.onRefresh();
				}),
				lang.hitch(this, function(error) 
				{
				    this.hideOperationRunningDialog();
				})
			);
        },
//        onRefreshEvent: function (event) {
//            this.onRefresh();
//        },
        onHistoryRefresh: function (event,tab) {
            console.log("onHistoryRefresh");
            var tabs=appDMS.getCurrentPerspectiveSASStudioTabs();
            if (typeof tab != 'undefined'){
            	  this.currentTab=tab;
            } else {
            	  this.currentTab=tabs.getFocusedTab();
            }
            this.currentRepository=this.currentTab.workingFolder;
            this.postOperationRunningDialog("history");
            this.gitServices.gitCommitLog(
            		this.currentRepository, 
    				lang.hitch(this, function(coomitLogData){
						if(coomitLogData && coomitLogData.rows && coomitLogData.rows.length == 0){
							appDMS.dialogs.postFaultDialog(this.resourceBundle.noCommits);
							this.hideOperationRunningDialog();
						}else{
							console.log("commit log successful");
							this.coomitLogData = coomitLogData;
							this.gitServices.getLastCommitIds(
								this.currentRepository,
								lang.hitch(this, function(coomitIdData){
									console.log("getLastCommitIds successful");
									var grid = this.currentTab.tab.getChildren()[1].getChildren()[0];
									this.populateHistoryGridLists(this.coomitLogData.rows,coomitIdData,grid);
									var branchesSelect = this.currentTab.tab.getChildren()[0].getChildren()[1];
									this.populateBranches(coomitIdData.branches,branchesSelect);
									this.currentTab.historyList= JSON.parse(JSON.stringify(this.historyList));
									this.resetDetailsPane();
									this.filesPane.domNode.style.display='none';
									this.filesPane.getParent().selectChild(this.filesPane.getParent().getChildren()[0]);
									this.hideOperationRunningDialog();
								}), 
								lang.hitch(this, function(error) 
								{
									this.hideOperationRunningDialog();
								})
							);
						}
    				}), 				
    				lang.hitch(this, function(error) 
    				{
    					this.hideOperationRunningDialog();
    				}));
        },
		onReset: function (selectedRows) {
			
			var selectedKeys = Object.keys(selectedRows);
			if(selectedKeys.length == 1){
				 var tabs=appDMS.getCurrentPerspectiveSASStudioTabs();
		         currentTab=tabs.getFocusedTab();
				 var selectedCommit = currentTab.historyList[selectedKeys[0]];
			
				if(this.resetDialog == null){
					require(["webdms/dialogs/ResetGITRepositoryDialog"],
							lang.hitch(this,function(selectedCommit, ResetGITRepositoryDialog){
								this.resetDialog = new ResetGITRepositoryDialog(lang.hitch(this, function(activeCommit, resetType){
							            this.gitServices.gitResetToCommit(currentTab.workingFolder, activeCommit.commitID, resetType, lang.hitch(this, function(data){
							            	console.log("reset successful");
							            	this.onHistoryRefresh();
							            	appDMS.projects.onRefresh();
							            	var accordion=dijit.byId('accContainer');
											if (accordion && accordion.selectedChildWidget && accordion.selectedChildWidget.id === "gitrepositoryPane"){
												var gitTabContainer=dijit.byId('_gitTabContainer');
												if (gitTabContainer && gitTabContainer.selectedChildWidget && gitTabContainer.selectedChildWidget.id === "commit"){
													this.onRefresh("silentStatus");
												}
											}

											//hotfix
											//reset the mergeCommit stuff
											if(this.activeRepository.isMerging){
												this.activeRepository.isMerging = false;
												this.activeRepository.mergeCommitId = null;
												this.activeRepository.mergeBranch = null;
												this.gitServices.updateRepositoryMergeState(this.activeRepository);
											}

											this.checkOpenTabs();
							            }));
								}));
								this.resetDialog.postDialog(selectedCommit);
							}, selectedCommit));
				}else{
					this.resetDialog.postDialog(selectedCommit);
				}
			}else{
				alert("select one commit for reset.");
			}
        },
        onFilesPaneShow: function (filesPane){
        	console.log("filePane show");
			if (this.historySelection.length === 1)
			{
				this.filesPane.domNode.style.display='block';
				this.filesPane.getParent().selectChild(this.filesPane.getParent().getChildren()[0]);
				this.populateDetailsGridLists(this.historySelection[0]);
				var multiParents = this.historySelection[0].parentID.split(",");
				if (multiParents.length > 1){
					this.onMultiParentDiffBetweenCommits(this.currentRepository,this.historySelection[0]);
				} else {
					this.onDiffBetweenCommits(this.currentRepository,this.historySelection[0].parentID,this.historySelection[0].commitID);
				}
			} else if (this.historySelection.length === 2)
			{
				this.filesPane.domNode.style.display='block';
	            var date0 = new Date (this.historySelection[0].date);
	            var date1 = new Date (this.historySelection[1].date);
	            if (Math.sign(date0-date1) === 1){
	            	this.onDiffBetweenCommits(this.currentRepository,this.historySelection[1].commitID,this.historySelection[0].commitID);
	            } else {
	            	this.onDiffBetweenCommits(this.currentRepository,this.historySelection[0].commitID,this.historySelection[1].commitID);
	            }
				this.populateDetailsGridLists(this.historySelection[1]);
				
			} else if (this.historySelection.length > 2)
			{
				this.filesPane.domNode.style.display='none';
				this.filesPane.getParent().selectChild(this.filesPane.getParent().getChildren()[0]);
				this.populateDetailsGridLists(this.historySelection[this.historySelection.length-1]);
			}
        },
        onBranchSelect: function (selectedBranch){
        	if (selectedBranch.trim() !== "origin/master")
        		this.onCheckoutBranch(selectedBranch);
        },
        
        onCreateBranch: function (selectedRows) {
			
			var selectedKeys = Object.keys(selectedRows);
			if(selectedKeys.length == 1){
				 var tabs=appDMS.getCurrentPerspectiveSASStudioTabs();
		         currentTab=tabs.getFocusedTab();
				 var selectedCommit = currentTab.historyList[selectedKeys[0]];
				 selectedCommit.remoteRepoPath=this.activeRepository.repositoryUri;
				 selectedCommit.localRepoPath=this.activeRepository.workingFolder;
				 if(typeof this.createBranchDialog==="undefined" || this.createBranchDialog == null)
					{
						require(
								["webdms/dialogs/CreateBranchDialog"],
								lang.hitch(this, function(CreateBranchDialog)
								{
									this.createBranchDialog = new CreateBranchDialog(selectedCommit);
								}
								));
					}
					else
					{
						this.createBranchDialog.show(selectedCommit);
					}
			}else{
				alert("select one commit to create branch.");
			}
        },
        
        onDeleteBranch: function (branch) {
			
        		this.postOperationRunningDialog("deleteBranch");
				 this.gitServices.deleteBranch(
						 this.activeRepository.workingFolder,
						 branch,
						    lang.hitch(this, function(data){
								console.log("Branch delete is successful");
								this.hideOperationRunningDialog("deleteBranch");
								if(data === -1)
									appDMS.dialogs.postFaultDialog(this.resourceBundle.unableToDeleteBranch);
								else
									this.onHistoryRefresh();
						    }), 
							lang.hitch(this, function(error) 
							{
								console.log("Branch delete failed");
								this.hideOperationRunningDialog("deleteBranch");
								if (error.xhr.response)
									appDMS.dialogs.postFaultDialog(error.response.xhr.getResponseHeader("Exception"));
								else
									appDMS.dialogs.postFaultDialog(error);
							})
						);
        },
        
        onCheckoutBranch: function (branch) {
			

				//if branch indexOf origin/ create new branch with the contents after origin/
				//need to find the commit id of the target remote branch.
				if(branch!= null && branch.indexOf("origin/") == 0){
					var newBranchPayload = {
						repoPath: this.activeRepository.workingFolder,
						commitId: this.activeRepository.branchData[branch],
						branchName: branch.split("origin/")[1], 
						force: 1,
						checkout:true
					};
					this.gitServices.newBranch(
						newBranchPayload,            				
						lang.hitch(this, function(payload, data){
							console.log("Branch created");
							this.branchSelect.addOption({value:payload.branchName,label:payload.branchName});
							this.branchSelect.setValue(payload.branchName);
						}, newBranchPayload), 
						lang.hitch(this, function(error) 
						{
							console.log("Branch creation failed");
							if (error.response)
								appDMS.dialogs.postFaultDialog(error.response.xhr.getResponseHeader("Exception"));
							else
								appDMS.dialogs.postFaultDialog(error);
						})
					);
				}else{
					this.checkoutBranchPayload = {
						repoPath: this.activeRepository.workingFolder, 
						branchName: branch, 
					};
					this.postOperationRunningDialog("checkOut");
					this.gitServices.checkoutBranch(
							this.checkoutBranchPayload,            				
							lang.hitch(this, function(data){
								console.log("Branch checkout is successful");
								this.activeBranch=branch;
								this.hideOperationRunningDialog("checkOut");
								this.commitCounterList = [];
	//								this.commitCounterList.push({"counter":this.activeBranch+"  " +"("+this.masterCount+")"});
								this.commitCounterList.push({"counter":this.activeBranch});
								this.commitCounterGrid.renderArray(this.commitCounterList);
								this.commitCounterGrid._updateColumns();
								setTimeout(lang.hitch(this, function () {
									appDMS.projects.onRefresh();
									var accordion=dijit.byId('accContainer');
									if (accordion && accordion.selectedChildWidget && accordion.selectedChildWidget.id === "gitrepositoryPane"){
										var gitTabContainer=dijit.byId('_gitTabContainer');
										if (gitTabContainer && gitTabContainer.selectedChildWidget && gitTabContainer.selectedChildWidget.id === "commit"){
											this.onRefresh("silentStatus");
										}
									}
									this.checkOpenTabs();
									this.onHistoryRefresh();
								}), 300);
							}), 
							lang.hitch(this, function(error) 
							{
								console.log("Branch checkout failed");
								this.hideOperationRunningDialog("checkOut");
								this.branchSelect.setValue(this.activeBranch);
								if (error.response)
									appDMS.dialogs.postFaultDialog(error.response.xhr.getResponseHeader("Exception"));
								else
									appDMS.dialogs.postFaultDialog(error);
							})
						);
				}
        },
        
        onMergeBranch: function (branch) {
			
        	this.mergePayload = {
        			localRepo: this.activeRepository.workingFolder,
        			profileName: this.activeRepository.profileName,
        			branch:branch
				};
        	this.postOperationRunningDialog("merge");
			this.activeRepository.mergeBranch = branch;
        	this.gitServices.mergeBranch(
					this.mergePayload,            				
				    lang.hitch(this, function(data){
				    	
				    	switch(data){
				    	case 0:
				    		//merge successful.
							this.activeRepository.mergeBranch = null;
				    		appDMS.projects.onRefresh();
				    		this.hideOperationRunningDialog("merge");
							this.onHistoryRefresh();
							this.checkOpenTabs();
							break;
				    	case 1:
				    		//already up to date.
							this.hideOperationRunningDialog("merge");
				    		appDMS.dialogs.postInfoDialog(this.resourceBundle.branchUpToDate);
				    		break;
				    	case -2:

							//hotfix
							this.activeRepository.isMerging = true;
							var url = appDMS.baseURL + '/sasexec/sessions/' + appDMS.sessionId + '/workspace/' + encodeValue(this.activeRepository.workingFolder+"/.git/refs/heads/", false) + this.activeRepository.mergeBranch;
							dojo.xhrGet({
								url : url,
								sync : false,
								preventCache: true,
								handleAs : "text",
								load : lang.hitch(this, function(data, args) 
								{
									if(data){
										var targetBranchCommitID = data.length >= 40 ? data.substr(0, 40) : "";
										this.activeRepository.mergeCommitId = targetBranchCommitID;
										this.gitServices.updateRepositoryMergeState(this.activeRepository);
									}
								})
							});

				    		this.hideOperationRunningDialog("merge");
				    		appDMS.dialogs.postFaultDialog(this.resourceBundle.mergeConflicts);
				    		appDMS.gitRepoRefresh(this.activeRepository.workingFolder);
				    		break;
				    	}
				    }), 
					lang.hitch(this, function(error) 
					{
						this.hideOperationRunningDialog("merge");
						if (error.response)
							appDMS.dialogs.postFaultDialog(error.response.xhr.getResponseHeader("Exception"));
						else
							appDMS.dialogs.postFaultDialog(error);
					})
				);
        },

        updateToolbarMenuStates: function () {
        },
        onPaneActive: function (evt) {
            //this.onRefresh(true);
        },
     	createGitView: function(componentId,branches)
		{
			this.gitViewTabContainer = new BorderContainer({
				style: "height: 100%; width: 100%;",     
				id: componentId,
				"class":"sasSuiteTabs",
				region:"center"
			});
			this.gitMainToolbar = this.createGitMainToolbar(branches);
			
			this.historyPane = new ContentPane({
				region:"top",
				style: "padding-left:10px; padding-top:20px; height:50%;overflow-x: hidden;overflow-y: hidden;",
				minSize:100,
				maxSize:600,
				gutters: true,
				splitter:true
			});
        	
			var historyGrid = this.createHistoryGrid();
        	
        	this.historyPane.addChild(historyGrid);
        	
        	historyGrid.startup();
			
			this.createDetailsFilesPanes();
			this.gitViewTabContainer.addChild(this.gitMainToolbar);
			this.gitViewTabContainer.addChild(this.historyPane);
			this.gitViewTabContainer.addChild(this.historyTabContainer);
			this.historyTabContainer.startup();
			this.gitMainToolbar.startup();
			this.gitViewTabContainer.startup();
			this.gitViewTabContainer.resize();
			this.gitViewTabContainer.historyGrid = historyGrid;
			
        	this.historySplitter = dijit.byId(this.historyPane.id+'_splitter');
			this.historySplitter.setAttribute("tabindex","-1");
			dojo.connect(this.historySplitter, "_stopDrag", lang.hitch(this, this.historyPaneResizeHandler));
			this.filesPane.domNode.style.display='none';//at the start files pane data should not be displayed.
			
           return this.gitViewTabContainer;
		},
        createGitMainToolbar: function(branches)
		{
		    this.gitMainToolbar = new dijit.Toolbar({
		        'class': "logToolbar",
		        region: "top"
		    }, "toolbar");
	
		    this.labelButton = new dijit.form.Button({
				label: this.resourceBundle.currentBranchLabel,
//					onClick: lang.hitch(this,this.onRefresh),
					showLabel: true,
					disabled:false,
					class:"buttonLabelClass"
					});
		    var activeBranch = this.findActiveBranch(branches);
		    var options =this.formatBranches(branches,activeBranch);
		    
		    this.branchSelect = new Select({
				sortByLabel: false,
				options: options,
				style : "min-width: 200px",
				"onChange": lang.hitch(this, this.onBranchSelect)
			});
		    this.branchSelect._onChangeActive = true;
		    this.branchSelect.startup();
		    
			this.refreshButton = new dijit.form.Button({
				iconClass: 'sasRefreshIcon',
				label: this.resourceBundle.refresh,
				onClick: lang.hitch(this,this.onHistoryRefresh),
				showLabel: false});
			
			var separator = new dijit.ToolbarSeparator();
			separator.set("style", "padding-left:20px;");
			
			this.gitMainToolbar.addChild(this.labelButton);
			this.gitMainToolbar.addChild(this.branchSelect);
			this.gitMainToolbar.addChild(this.refreshButton);
			return this.gitMainToolbar;
		},
        createHistoryGrid: function (){
        	
			this.historyGridLayout = [
				             	 {label: this.resourceBundle.messageLabel, field: 'message', resizable : true, sortable : false,formatter: lang.hitch(this,this.historyGridMessageFormatter) },     //renderCell: lang.hitch(this, this.historyGridMessageRenderCell)},				             	 		            
				             	 {label: this.resourceBundle.idLabel, field: 'id', resizable : true, sortable : false},
				             	 {label: this.resourceBundle.authorLabel, field: 'author', resizable : true, sortable : false},
				             	 {label: this.resourceBundle.dateLabel, field: 'date', resizable : true, sortable : false},
				             	 {label: "", field: 'disbleRecord', resizable : true, sortable : false},
				             	 {label: "", field: 'branches', resizable : true, sortable : false}
				             	];
			
			var historyGrid = this.gitCustomdGrid({
				className: 'gitGrid',
				showHeader: true,
				tabableHeader: true,
		 		columns: this.historyGridLayout
			});
			
			historyGrid.setSelectionMode("extended");
			historyGrid.styleColumn(historyGrid.columns[0].id, "width: 38%");
			historyGrid.styleColumn(historyGrid.columns[1].id, "width: 20%");
			historyGrid.styleColumn(historyGrid.columns[2].id, "width: 20%");
			historyGrid.styleColumn(historyGrid.columns[3].id, "width: 20%");
			historyGrid.styleColumn(historyGrid.columns[4].id, "width: 1%");
			historyGrid.styleColumn(historyGrid.columns[5].id, "width: 1%");
			historyGrid.styleColumn(historyGrid.columns[4].id, "display: none;");
			historyGrid.styleColumn(historyGrid.columns[5].id, "display: none;");
			this.eventListeners.push(historyGrid.on(".dgrid-row:contextmenu", lang.hitch(this, this.onCommitGridContextMenu)));
			
			
			historyGrid.on("dgrid-select", lang.hitch(this, function(event){
				event.preventDefault();
				var historySelection=[];
				var tabs=appDMS.getCurrentPerspectiveSASStudioTabs();
				this.currentTab=tabs.getFocusedTab();
	            this.currentRepository=this.currentTab.workingFolder;
				var selected = historyGrid.selection;
				if (selected) {
		            for (row in selected) {
		            	var selectedRow = historyGrid._rowIdToObject[historyGrid.id+"-row-"+row];
		            	historySelection.push(selectedRow);
		            }
				}
				this.historySelection=historySelection;
				if (historySelection.length === 0)
				{
					this.filesPane.domNode.style.display='none';
					this.filesPane.getParent().selectChild(this.filesPane.getParent().getChildren()[0]);
					this.resetDetailsPane();
				} else if (historySelection.length === 1)
				{
					this.filesPane.domNode.style.display='block';
					this.filesPane.getParent().selectChild(this.filesPane.getParent().getChildren()[0]);
					this.populateDetailsGridLists(historySelection[0]);
				} else if (historySelection.length === 2)
				{
					this.filesPane.domNode.style.display='block';
					this.populateDetailsGridLists(historySelection[1]);
					
				} else if (historySelection.length > 2)
				{
					this.filesPane.domNode.style.display='none';
					this.filesPane.getParent().selectChild(this.filesPane.getParent().getChildren()[0]);
					this.populateDetailsGridLists(historySelection[historySelection.length-1]);
				}
		    }));
	
			historyGrid.on("dgrid-deselect", lang.hitch(this, function(event){
				var historySelection=[];
				var selected = historyGrid.selection;
				if (selected) {
		            for (row in selected) {
		            	var selectedRow = historyGrid._rowIdToObject[historyGrid.id+"-row-"+row];
		            	historySelection.push(selectedRow);
		            }
				}
				this.historySelection=historySelection;
				if (historySelection.length === 0)
				{
					this.filesPane.domNode.style.display='none';
					this.filesPane.getParent().selectChild(this.filesPane.getParent().getChildren()[0]);
					this.resetDetailsPane();
				} else if (historySelection.length === 1)
				{
					this.filesPane.domNode.style.display='block';
					this.filesPane.getParent().selectChild(this.filesPane.getParent().getChildren()[0]);
					this.populateDetailsGridLists(historySelection[0]);
					
				} else if (historySelection.length === 2)
				{
					this.filesPane.domNode.style.display='block';
					var tabs=appDMS.getCurrentPerspectiveSASStudioTabs();
			        this.currentTab=tabs.getFocusedTab();
		            this.currentRepository=this.currentTab.workingFolder;
					this.populateDetailsGridLists(historySelection[1]);
					
				} else if (historySelection.length > 2)
				{
					this.filesPane.domNode.style.display='none';
					this.filesPane.getParent().selectChild(this.filesPane.getParent().getChildren()[0]);
					this.populateDetailsGridLists(historySelection[historySelection.length-1]);
				}
		    }));
			
			
			historyGrid.on(".dgrid-row:mousedown", lang.hitch(this, function(event){
				if (event.button === 2){
					event.preventDefault(); // prevent default browser context menu
					var row = historyGrid.row(event);
					this.createHistoryGridContextMenu(historyGrid,row.data);
				}
				}));
			historyGrid.on('.dgrid-content .dgrid-row:contextmenu', lang.hitch(this, function(event){
				event.preventDefault(); // prevent default browser context menu
			}));
			on(window, "resize", lang.hitch(this, function(){
            	historyGrid.resize();
            }));
			
			aspect.after(historyGrid, "renderArray", function (results,args) {
				for (var i=0; i<results.length; i++) {
					if (args[0][i].disbleRecord){
						results[i].className += " originAhead";
					}
				}
					this.results=results;
				    setTimeout(lang.hitch(this, function () {
				    	if (this.results && this.results.length > 0)
					    	historyGrid.select(this.results[0]);
					    }), 100);
			}); 
			
			historyGrid.renderArray(this.historyList);
			historyGrid._updateColumns();
			return historyGrid;
        },
        createHistoryGridContextMenu: function (grid,data) {
             var historyContextMenu = new dijit.Menu({
                 targetNodeIds:[grid.contentNode]
             });
             
			var resetMenuItem = new dijit.MenuItem({
 				label: this.resourceBundle.reset,
 				onClick:lang.hitch(this, this.onReset, grid.selection)
 			});
			
			var createBranchMenuItem = new dijit.MenuItem({
 				label: this.resourceBundle.createBranch,
 				onClick:lang.hitch(this, this.onCreateBranch, grid.selection)
 			});
			
			this.deleteMenu = new dijit.Menu();
			this.deleteBranchMenuPopup = new dijit.PopupMenuItem(
					{
						label:  this.resourceBundle.deleteBranch,
						popup: this.deleteMenu 
					});
			
			this.deleteBranchMenuItems =[];
			for (var i =0; i < this.branches.length; i++)
			{
				if (this.branches[i] === "local-master" )
					this.branches[i] = "master";
				else if (this.branches[i] === "remote-master" )
					this.branches[i] = "origin/master";
				
				if (this.branches[i] !== this.activeBranch && this.branches[i].indexOf("origin/") === -1 && this.branches[i].indexOf("activeBranch-") === -1){
					this.deleteBranchMenuItems[i]= new dijit.MenuItem({
			            label: this.branches[i],
			            onClick:lang.hitch(this, this.onDeleteBranch,this.branches[i])
			         });
					this.deleteMenu.addChild(this.deleteBranchMenuItems[i]);
				}
			}
			
			
			this.checkoutMenu = new dijit.Menu();
			this.checkoutBranchMenuPopup = new dijit.PopupMenuItem(
					{
						label:  this.resourceBundle.checkoutBranch,
						popup: this.checkoutMenu 
					});
			
			this.checkoutBranchMenuItems =[];
			for (var i =0; i < data.branches.length; i++)
			{
				if (data.branches[i] === "local-master" )
					data.branches[i] = "master";
				else if (data.branches[i] === "remote-master" )
					data.branches[i] = "origin/master";
				
				if (data.branches[i] !== this.branchSelect.getValue() ){
					this.checkoutBranchMenuItems[i]= new dijit.MenuItem({
			            label: data.branches[i],
			            onClick:lang.hitch(this, this.onCheckoutBranch,data.branches[i])
			         });
					this.checkoutMenu.addChild(this.checkoutBranchMenuItems[i]);
				}
			}
			
			var noMerge=false;
			this.mergeMenu = new dijit.Menu();
			this.mergeBranchMenuPopup = new dijit.PopupMenuItem(
					{
						label:  this.resourceBundle.mergeIntoCurrent,
						popup: this.mergeMenu 
					});
			
			this.mergeBranchMenuItems =[];
			if (data.branches.length === 0){
				noMerge=true;
				//not doing the merge with commit ID in 38
//				this.mergeBranchMenuItems[0]= new dijit.MenuItem({
//		            label: data.commitID,
//		            onClick:lang.hitch(this, this.onMergeBranch,data.commitID)
//					});
//				this.mergeMenu.addChild(this.mergeBranchMenuItems[0]);
			} else {
				for (var i =0; i < data.branches.length; i++)
				{
					if (data.branches[i] === "local-master" )
						data.branches[i] = "master";
					else if (data.branches[i] === "remote-master" )
						data.branches[i] = "origin/master";
					
					if (data.branches[i] === this.branchSelect.getValue() && data.branches[i].indexOf("origin/") === -1){
						for (var k =0; k < this.branches.length; k++){
							
							if (this.branches[k] === "local-master" )
								this.branches[k] = "master";
							else if (this.branches[k] === "remote-master" )
								this.branches[k] = "origin/master";
							
							if (this.branches[k] !== this.branchSelect.getValue() && this.branches[k].indexOf("origin/") === -1 && this.branches[k].indexOf("activeBranch") === -1 ){
								var branchAdded=false;
								for (var j =0; j < this.mergeBranchMenuItems.length; j++){
									if (this.mergeBranchMenuItems[j].label === this.branches[k]){
										branchAdded=true;
										break;
									}
								}
								if (!branchAdded){
									this.mergeBranchMenuItems[i]= new dijit.MenuItem({
							            label: this.branches[k],
							            onClick:lang.hitch(this, this.onMergeBranch,this.branches[k])
										});
									this.mergeMenu.addChild(this.mergeBranchMenuItems[i]);
								}
								
							}
						}
						this.mergeBranchMenuPopup.setLabel(this.resourceBundle.mergeWithBranch);
						
					} else if (data.branches[i] !== this.branchSelect.getValue() && data.branches[i].indexOf("origin/") === -1){
						noMerge=true;
						var branchAdded=false;
						for (var j =0; j < this.mergeBranchMenuItems.length; j++){
							if (this.mergeBranchMenuItems[j].label === data.branches[i]){
								branchAdded=true;
								break;
							}
						}
						if (!branchAdded){
							this.mergeBranchMenuItems[i]= new dijit.MenuItem({
					            label: data.branches[i],
					            onClick:lang.hitch(this, this.onMergeBranch,data.branches[i])
								});
							this.mergeMenu.addChild(this.mergeBranchMenuItems[i]);
						}
						this.mergeBranchMenuPopup.setLabel(this.resourceBundle.mergeIntoCurrent);
					}
				}
			}
			
             historyContextMenu.addChild(resetMenuItem);
             historyContextMenu.addChild(new dijit.MenuSeparator);
             historyContextMenu.addChild(createBranchMenuItem);
             historyContextMenu.addChild(this.deleteBranchMenuPopup);
             historyContextMenu.addChild(new dijit.MenuSeparator);
             historyContextMenu.addChild(this.checkoutBranchMenuPopup); 
             if (!noMerge){
             historyContextMenu.addChild(new dijit.MenuSeparator);
             historyContextMenu.addChild(this.mergeBranchMenuPopup);
             }
             
             if (this.deleteMenu.getChildren().length === 0){
            	 this.deleteBranchMenuPopup.setDisabled(true);
             }
             if (this.checkoutMenu .getChildren().length === 0){
            	 this.checkoutBranchMenuPopup.setDisabled(true);
             }
             if (this.mergeMenu .getChildren().length === 0){
            	 this.mergeBranchMenuPopup.setDisabled(true);
             }
             
             if (data.branches.length >0){
            	 if (data.branches[0] === "origin/master"){
            		 this.checkoutBranchMenuPopup.setDisabled(true);
            	 }
             } else {
            	 this.deleteBranchMenuPopup.setDisabled(true);
             }
//             //disale merge if there is only one branch and if that branch is current active branch or if there are no branches or if the the branch head is inside current active branch head
//             if ( (data.branches.length === 1 && data.branches[0] === this.branchSelect.getValue()) || (data.branches.length === 0) || (this.mergeBranchMenuPopup.label ===  this.resourceBundle.mergeIntoCurrent) ){
//            	 console.log("No merge required");
//            	 for (var i =0; i < this.aheadBranches.length; i++) {
//            		 if (this.aheadBranches[i] !== data.branches[0]){
//            			 this.mergeBranchMenuPopup.setDisabled(true);
//                         break;
//            		 }
//            	 }
//            	 if (this.mergeBranchMenuPopup.label ===  this.resourceBundle.mergeIntoCurrent){
//            		 this.mergeBranchMenuPopup.setDisabled(true);
//            	 }
//             } 
             /*else if ( (data.branches.length === 2 && data.branches[0] === this.branchSelect.getValue()) && (data.branches[1] === "origin/master") ){
            	 console.log("No merge required");
            	 this.mergeBranchMenuPopup.setDisabled(true);
             }*/
             historyContextMenu.startup();
         },		

        createDetailsFilesPanes: function () {
        	
			this.historyTabContainer = new dijit.layout.TabContainer({
				style: "height: 50%; width: 100%;",     
				"class":"sasSuiteTabs",
				gutters: true,
				splitter:true,
				minSize:100,
				region:"center"
			}, "tc1-prog");
        	
        	/*detail pane*/
        	this.detailsPane = new BorderContainer({
			    style: "padding:0px; margin:0px; width:100%; height:100%;",
				gutters: false,
				title: this.resourceBundle.details
			});
        	
        	var detailsContentPane = new ContentPane({
				region:"top",
				gutters: true,
  				splitter:true,
				style: "padding-left:10px; padding-top:20px; padding-bottom:5px; height:60px;"
			});
        	
        	var detailsTextarea = new SimpleTextarea({
        	    name: "detailsSimpleTextarea",
        	    region:"top",
        	    rows:"10",
        	    cols:"50",
        	    readOnly:true,
        	    style: "width:95%;height:100%;resize:both;"
        	  }, "detailsSimpleTextarea");
        	
        	detailsContentPane.setContent(detailsTextarea);
        	detailsTextarea.startup();
        	
        	var detailsDataPane = new ContentPane({
				region:"center",
				style: "padding-left:10px; padding-bottom:0px; height:100px;",
				gutters: false,
				splitter:false
			});
        	
        	this.createDetailsData(detailsDataPane);
        	
			if (this.detailsList.length >0){
				detailsDataPane.addChild(this.authorForm);
	        	detailsDataPane.addChild(this.commitForm);
	        	detailsDataPane.addChild(this.parentForm);	
			}
        		
        	
        	this.detailsPane.addChild(detailsContentPane);
        	this.detailsPane.addChild(detailsDataPane);
        	detailsContentPane.startup();
        	detailsDataPane.startup();
            this.detailsPane.startup();
            
            /*End of detail pane*/
            
            /*files pane*/
            
        	this.filesPane = new BorderContainer({
  			    style: "padding:0px; margin:0px; width:100%; height:100%;",
  				gutters: false,
  				title: this.resourceBundle.files
  			});
        	
        	this.filesLeftPane = new ContentPane({
  			    style: "padding:0px; margin:0px; width:50%; height:100%;",
  				gutters: true,
  				spliter:true,
  				region:"left"
  			});
        	this.filesCenterPane = new ContentPane({
  			    style: "padding:0px; margin:0px; width:50%; height:100%;",
  			    class:"diffDetails",
  			    gutters: true,
				spliter:true,
  				region:"center"
  			});
        	
        	var filesLabelContentPane = new ContentPane({
				region:"top",
				style: "padding-top:5px; height:auto;"
			});
        	
        	var fileNameLabelContentPane = new ContentPane({
				region:"top",
				style: "padding-left:10px; padding-top:20px; height:auto;"
			});
        	
        	this.fileDiffContentPane = new ContentPane({
				region:"center",
				style: "padding-left:30px; padding-top:20px; height:auto;"
			});
        	dojo.connect(this.fileDiffContentPane, "onMouseDown", lang.hitch(this, this.onFileDiffMouseClick));
        	
        	var fileGrids = this.createFilesGrids();
        	var filesCounterGrid = fileGrids[0];
        	var fileNameGrid = fileGrids[1];
        	var filesListGrid = fileGrids[2];
        	
        	
        	var filesListPane = new TitlePane({
				title:"Diff with parent 5689145",
				content: filesListGrid,
				style: "padding-left:10px; width:94%;height:90%;"
			});
        	filesListPane.startup();
        	
        	filesLabelContentPane.addChild(filesCounterGrid);
        	filesListPane.addChild(filesListGrid);
        	//filesCounterGrid.startup();
        	filesListGrid.startup();
        	
        	this.filesLeftPane.addChild(filesLabelContentPane);
        	this.filesLeftPane.addChild(filesListPane);
        	
        	fileNameLabelContentPane.addChild(fileNameGrid);
        	this.filesCenterPane.addChild(fileNameLabelContentPane);
        	this.filesCenterPane.addChild(this.fileDiffContentPane);
        	
        	this.filesPane.addChild(this.filesLeftPane);
        	this.filesPane.addChild(this.filesCenterPane);
        	this.filesLeftPane.startup();
        	this.filesCenterPane.startup();
        	 dojo.connect(this.filesPane, 'onShow',
                     lang.hitch(this, this.onFilesPaneShow, this.filesPane));

        	
        	/*End of files pane*/
        	
        	this.historyTabContainer.addChild(this.detailsPane);
        	this.historyTabContainer.addChild(this.filesPane);
            this.detailsPane.startup();
            this.detailsPane.resize();
            this.filesPane.startup();
            this.filesPane.resize();
        },
        createDetailsData: function (detailsDataPane){
        	
        	var authorForm = new dijit.form.Form({
            }, dojo.doc.createElement('div'));
        	
        	var dateForm = new dijit.form.Form({
            }, dojo.doc.createElement('div'));
            
        	var commitForm = new dijit.form.Form({
            }, dojo.doc.createElement('div'));
        	
        	var parentForm = new dijit.form.Form({
            }, dojo.doc.createElement('div'));
            
        	var author ="";
        	var date ="";
        	var finalDateLabel = "";
    		var commit ="";
    		var parents ="";
			var time="";
    		
        	if (this.detailsList.length>0){
        		author = this.detailsList[0].author;
        		date = this.detailsList[0].date;
        		commit = this.detailsList[0].commit;
        		parents = this.detailsList[0].parents;
				time = this.detailsList[0].time;
        	}
        	
        	if (date.length > 0){
        		finalDateLabel = this.getFinalDateLabel(date, time);
        	} 
        	
        	var authText = this.resourceBundle.authorLabelColon.replace("${0}", author);
        	var dateText = this.resourceBundle.dateLabelColon.replace("${0}", finalDateLabel);
        	var commitText = this.resourceBundle.commitLabel.replace("${0}", commit);
        	var parentsText = this.resourceBundle.parentsLabel;// + parents;
        	authorForm.domNode.appendChild(dojo.doc.createTextNode(authText));
        	dateForm.domNode.appendChild(dojo.doc.createTextNode(dateText));
        	commitForm.domNode.appendChild(dojo.doc.createTextNode(commitText));
        	
        	//create parent buttons;
        	var parents = parents.split(",");
        	parentForm.domNode.appendChild(dojo.doc.createTextNode(parentsText));
        	//for each parent create a button.
        	for(var p = 0; p < parents.length; p++){
        		var parentId = parents[p];
        		var pButton = new Button({
        			title: parentId,
        			label: parentId,
        			class:"parentBtnClass",
        			showLabel: true,
        			onClick:lang.hitch(this, function(id, event){
        				console.log("Parent click " + id);
        				var tabs = appDMS.getCurrentPerspectiveSASStudioTabs();
        				var tab = tabs.getFocusedTab();
        				var historyList = tab.historyList;

        				for(var i=0; i<historyList.length; i++){
        					if(id == historyList[i].commitID){
                				var currentSelections = Object.keys(tab.tab.historyGrid.selection);
        						
                				for(var k =0; k < currentSelections.length; k++){
                					tab.tab.historyGrid.deselect(currentSelections[k]);
                				}
                				tab.tab.historyGrid.select(i);
        						break;
        					}
        				}
        				
        			}, parentId)
        		});
        		dojo.place(pButton.domNode, parentForm.domNode, "last");
        		
        		if(p+1 < parents.length)
        			parentForm.domNode.appendChild(dojo.doc.createTextNode(","));
        	}
        	
        	var detailsDataPaneChildren = detailsDataPane.getChildren();
        	for (var i =0; i < detailsDataPaneChildren.length; i++)
        	{
        		detailsDataPane.removeChild(detailsDataPaneChildren[i]);
        	}
        	if (this.detailsList.length >0){
				detailsDataPane.addChild(authorForm);
				detailsDataPane.addChild(dateForm);
	        	detailsDataPane.addChild(commitForm);
	        	detailsDataPane.addChild(parentForm);	
			}
        },
        createFilesGrids: function (){
        	
        	/*var filesCounterGridLayout = [{
                name: 'Counter',
                field: 'counter',
                label: this.resourceBundle.files,
                formatter: this.filesCounterGridCellFormatter
            }];*/
			
			/*var filesCounterGrid = this.gitCustomdGrid({
				showHeader: false,
				tabableHeader: false,
				class:"gitFilesCounterGrid",
		 		columns: filesCounterGridLayout
			});*/
			var counter ="Files  " +"("+this.filesCounter+")";
		
			var filesCounterGrid = new TextBox({
				value: counter,
				style:"border:none; overflow:auto; outline: none; -webkit-box-shadow: none; -moz-box-shadow: none;box-shadow: none;"
        	 });	
          	filesCounterGrid.textbox.disabled = true;	 
			//filesCounterGrid.setSelectionMode("single");
			//this.eventListeners.push(filesCounterGrid.on(".dgrid-row:contextmenu", lang.hitch(this, this.onCommitGridContextMenu)));
			
			var fileNameGridLayout = [{
                name: 'fileNameGrid',
                field: 'name',
                label: "",
                formatter: this.fileNameGridCellFormatter
            }];
			
			var fileNameGrid = this.gitCustomdGrid({
				class:"gitCounterGrid",
				showHeader: false,
				tabableHeader: false,
		 		columns: fileNameGridLayout
			});
			fileNameGrid.setSelectionMode("single");
			this.eventListeners.push(fileNameGrid.on(".dgrid-row:contextmenu", lang.hitch(this, this.onCommitGridContextMenu)));
			
			var filesListGrid = this.createFileListGrid();
	
			//this.filesCounterList.push(counter);
				
			//filesCounterGrid.renderArray(this.filesCounterList);
			//filesCounterGrid._updateColumns();
			//filesCounterGrid.set("value", counter);
			
			var fileGrids = [];
			fileGrids.push(filesCounterGrid);
			fileGrids.push(fileNameGrid);
			fileGrids.push(filesListGrid);
			return fileGrids;
			
        },
        showFilesListGridTooltip: function (event) {
        	var row=this.filesListGrid.row(event);
            var toolTipText=appDMS.encodeHtml(row.data.absolutePath.trim());
            var cell=this.localGrid.cell(event);
            if (Tooltip._masterTT != null)
            	Tooltip._masterTT.containerNode.className="sasTooltipContainer";
            Tooltip.show(toolTipText, cell.element,["below","above"]);
        },
        hideFilesListGridTooltip: function (event) {
        	var cell=this.localGrid.cell(event);
        	Tooltip.hide(cell.element);
        },
        filesCounterGridCellFormatter: function (val, item) {
//			try {
//                var iconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/Folder.png"/>';
//                var formattedValue = iconValue + val;
//                return formattedValue;
//          } catch (e) {
//              return val;
//          }
        	 return val;
        },
        fileNameGridCellFormatter: function (val, item) {
			var status = item.status.toLowerCase();
			var statusIconValue = "";
			switch(status)
			{
			case "added":
			case "new":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/onDemandStatus.png"/>';
				break;
			case "renamed":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/mediumPriorityStatus.png"/>';
				break;
			case "modified":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/incompleteInProgressStatus.png"/>';
				break;
			case "copied":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/revertedStatus.png"/>';
				break;
			case "deleted":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/canceledStatus.png"/>';
				break;
			case "conflicted":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/Disconnect.png"/>';
				break;
			}
			
		  try {
				var formattedValue = statusIconValue + " " + val;
		        return formattedValue;
		      } catch (e) {
		          return val;
		      }
		  	 return val;
		  },
        filesListGridNameFormatter: function (val, item) {
			var status = item.status.toLowerCase();
			var statusIconValue = "";
			var fileIcon = appDMS.projects.getPngBasedOnFileExtension(item.name);
			if (fileIcon === null || fileIcon === "")
				fileIcon ="resources/js/studio/themes/corporate/images/sasIcons/sasdark/16_png/Document.png";
			fileIcon = fileIcon.replace("24_png","16_png");
			fileIcon = '<img class="fileRefIcon" src="' + fileIcon + '"/>';
			switch(status)
			{
			case "added":
			case "new":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/onDemandStatus.png"/>';
				break;
			case "renamed":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/mediumPriorityStatus.png"/>';
				break;
			case "modified":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/incompleteInProgressStatus.png"/>';
				break;
			case "copied":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/revertedStatus.png"/>';
				break;
			case "deleted":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/canceledStatus.png"/>';
				break;
			case "conflicted":
				statusIconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/Disconnect.png"/>';
				break;
			}
			
		  try {
				var formattedValue = statusIconValue + " " + fileIcon +  " " + val;
		        return formattedValue;
		      } catch (e) {
		          return val;
		      }
		  	 return val;
		  },
		  
		itemBranchMatch: function (val, item, valToMatch) {
		    if (endsWith(val, item.originalMessage)) // This should always be true
			{
		       /* The val ends with the original message, so strip that off before doing the branch name check. */
			    val = val.substring(0, val.length - item.originalMessage.length); 
				return (val.indexOf("-"+valToMatch+"-") !== -1);
			}
			else // This should never happen.
			{
				if (item.branches && item.branches.length > 0)
				{
					for (i=0; i<item.branches.length; i++)
					{
						var branch = item.branches[i];
						if (branch == valToMatch)
							return true;
					}
				}
			}
			return false;	
		},
		
		removeBranchTag: function (val, item, branchName) {
			/* Then put it back on at the end */
			if (endsWith(val, item.originalMessage)) // This should always be true
			{
		       /* The val ends with the original message, so strip that off before doing the replace. */
			    val = val.substring(0, val.length - item.originalMessage.length); 
			}
			else
			   return val;   /* wtf */
		    /* Strip the branch name */
		    val = val.replaceAll("-" + branchName + "-", "");
			/* Put the message back on */
			val = val + item.originalMessage;
            return val;			
		},	  
		  
        historyGridMessageFormatter: function (val, item) {
        	var masterButton = '<html><body><button type="button" class="localMasterBranch"><span class="icon"></span>master</button></body></html>';
        	var remoteButton = '<html><body><button type="button"  class="remoteBranch"><span class="icon"></span>origin/master</button></body></html>';
        	var iconValue = '<img class="fileRefIcon" src="' + dojoConfig.baseUrl + '/studio/themes/corporate/images/sasIcons/sasdark/16_png/gitBranch.png"/>';
        	var remote=false;
        	var local=false;
        	var branch=false;
        	var activeBranch=false;
        	var tackingBranch=false;
        	var remoteBranch=false;
        	var formattedValue = val;
       	
          try {
		         if (this.itemBranchMatch(val, item, "origin/master")) {
				      val = this.removeBranchTag(val, item, "origin/master");
         			  remote=true;
        		  }
		         if (this.itemBranchMatch(val, item, "origin/local-master")) {
				      val = this.removeBranchTag(val, item, "origin/local-master");
         		  }
		         if (this.itemBranchMatch(val, item, "remote-master")) {
				      val = this.removeBranchTag(val, item, "remote-master");
         			  remote=true;
        		  }
 		         if (this.itemBranchMatch(val, item, "local-master")) {
				      val = this.removeBranchTag(val, item, "local-master");
         			  local=true;
        			  if (this.activeBranch === "master"){
        				  activeBranch=true;
        				  masterButton = masterButton.replace("localMasterBranch","checkedOutBranch");
        			  }
        		  }
        		  var branchButtons =[];
        		  for (var i=0; i<appDMS.git.branches.length; i++) {
         			  activeBranch=false;
        			  remoteBranch=false;
        			  tackingBranch=false;
        			  if (appDMS.git.branches[i] != "local-master" && appDMS.git.branches[i] != "remote-master" )
        			  {
					      if (this.itemBranchMatch(val, item, appDMS.git.branches[i])) { 
        				//  if (val.indexOf ("-"+appDMS.git.branches[i]+"-") !== -1){
						      var branchClass = "";
            				  val = val.replace("-"+appDMS.git.branches[i]+"-","");
            				  if (this.activeBranch && this.activeBranch === appDMS.git.branches[i]){
            					  activeBranch=true;
            					  branchClass = "checkedOutBranch";
            				  }
            				  if (appDMS.git.branches[i].indexOf("origin/"+this.activeBranch) !== -1){
            					  tackingBranch=true;
            					  branchClass = "trackingBranch";
            				  }
            				  if (appDMS.git.branches[i].indexOf("origin/") !== -1){
            					  remoteBranch=true;
            					  branchClass = "remoteBranch";
            				  }
            				  //this is for remote branches without a local counter part.
            				  if(appDMS.git.branches[i].indexOf("origin/") !== -1 && appDMS.git.branches[i].indexOf("origin/master") === -1) {
            					  branch=true;
            				  }
            				  var updatedBranchButton = '<html><body><button type="button" class="' + branchClass + '"><span class="icon"></span>' + 
							               appDMS.git.branches[i] + '</button></body></html>';

            				  branchButtons.push(updatedBranchButton);
            				  if (!remoteBranch)
            					  branch=true;
            			  } 
        			  }
        		  }
        		  var formattedBranchButton = "";
        		  for (var i=0; i<branchButtons.length; i++) {
        			  formattedBranchButton = formattedBranchButton + " " + branchButtons[i] ;
        		  }
//        		  if (activeBranch){
//        			  formattedBranchButton = formattedBranchButton.replace("localBranch","checkedOutBranch");
//        		  }
//        		  if (remoteBranch){
//        			  formattedBranchButton = formattedBranchButton.replace("localBranch","remoteBranch");
//        		  }
//        		  if (tackingBranch){
//        			  formattedBranchButton = formattedBranchButton.replace("localBranch","trackingBranch");
//        		  }
        		  
				  val = appDMS.encodeHtml(val);
        		  if (branch && local && remote){
        			   formattedValue = formattedBranchButton + " " + masterButton + " " + remoteButton +" " + val;
        		  } else if (branch && local){ 
        			   formattedValue = formattedBranchButton + " " + masterButton + " " + val;
        		  } else if (branch && remote){ 
        			   formattedValue = formattedBranchButton + " " + remoteButton + " " + val;
        		  } else if (local && remote){ 
        			   formattedValue = masterButton + " " + remoteButton + " " + val;
        		  } else if (local){
        			   formattedValue = masterButton + " "+ val;
        		  } else if (remote){
        			   formattedValue = remoteButton +" " + val;
        		  }else if (branch){
        			   formattedValue = formattedBranchButton + " "+ val;
        		  } 
                  return formattedValue;
          } catch (e) {
              return val;
          }
      	 return val;
      },
      historyGridMessageRenderCell: function (object, data, cell) {
    	  if (data.indexOf("master" !==-1)){
    		  var masterButton = new Button({
  				name: 'masterButton',
  				title: "master",//this.resourceBundle.taskRepsitoryProperties,
  				label:"master",
  				showLabel:true,
  				gridRow : object,
  				gridCell : cell,
  				main: this,
  				disabled:true
  			});
      	  masterButton._destroyOnRemove = true;
    	  } else{
    		  return;
    	  }
    },
    createFileListGrid: function (){
    	
		var filesListGridLayout = [
			             	 		     {label: this.resourceBundle.name, field: 'name', resizable : true, sortable : false,formatter: this.filesListGridNameFormatter},				             	 		            
			             	 		     {label:  this.resourceBundle.location, field: 'absolutePath', resizable : true, sortable : false}
			             	 		   ];
		
		var filesListGrid = this.gitCustomdGrid({
			showHeader: false,
			tabableHeader: false,
			class:"gitDetailsGrid",
	 		columns: filesListGridLayout
		});
		
		filesListGrid.setSelectionMode("single");
		filesListGrid.styleColumn(filesListGrid.columns[0].id, "width: 99%");
		filesListGrid.styleColumn(filesListGrid.columns[1].id, "width: 1%");
		filesListGrid.styleColumn(filesListGrid.columns[1].id, "display: none;");
		this.eventListeners.push(filesListGrid.on(".dgrid-row:contextmenu", lang.hitch(this, this.onCommitGridContextMenu)));
		
		
		filesListGrid.on("dgrid-select", lang.hitch(this, function(event){
			var filesSelectionList=[];
			for (var i =0; i < event.rows.length; i++)
				{
					 event.rows[i].data.name=appDMS.decodeHtml(event.rows[i].data.name);
					 event.rows[i].data.name=appDMS.encodeHtml(event.rows[i].data.name);
					 filesSelectionList.push(event.rows[i].data);
					 var tabs=appDMS.getCurrentPerspectiveSASStudioTabs();
				     currentTab=tabs.getFocusedTab();
					 var filesPane = currentTab.tab.getChildren()[2].getChildren()[1];
					 var filesLeftPane = filesPane.getChildren()[0];
					 var filesLeftPaneKids= filesLeftPane.getChildren();
						for (var i=filesLeftPaneKids.length-1;i>0;i--){
							var grid=filesLeftPaneKids[i].getChildren()[0];
							if (grid.id !== event.grid.id){
								grid.clearSelection();
							}
						}
					 
					 var fileNameLabelContentPane = filesPane.getChildren()[1].getChildren()[0];
					 var fileNameGrid = fileNameLabelContentPane.getChildren()[0];
					 var fileDiffContentPane = filesPane.getChildren()[1].getChildren()[1];
					 
					 fileNameGrid.renderArray(filesSelectionList);
					 fileNameGrid._updateColumns();
					
					 this.filesCenterPane.domNode.style.display='block';
					 
					 var diffHtml = this.createDiffHtml(event.rows[i].data.content);
					 fileDiffContentPane.setContent(diffHtml);
					 this.openDialogContent=diffHtml;
				}
	    }));

		filesListGrid.on("dgrid-deselect", lang.hitch(this, function(event){
						var tabs=appDMS.getCurrentPerspectiveSASStudioTabs();
				        currentTab=tabs.getFocusedTab();
						var filesPane = currentTab.tab.getChildren()[2].getChildren()[1];
						var fileNameLabelContentPane = filesPane.getChildren()[1].getChildren()[0];
						this.filesCenterPane.domNode.style.display='none';
						var fileDiffContentPane = filesPane.getChildren()[1].getChildren()[1];
					    fileDiffContentPane.setContent("");
					    this.openDialogContent="";
	    }));
		
		filesListGrid.on(".dgrid-cell:mouseover", lang.hitch(this, this.showFilesListGridTooltip));
		filesListGrid.on(".dgrid-cell:mouseout", lang.hitch(this, this.hideFilesListGridTooltip));
		
		on(window, "resize", lang.hitch(this, function(){
        	filesListGrid.resize();
        }));
		this.filesListGrid=filesListGrid;
		return filesListGrid;
    },
        releaseResources: function () {
            var evtHandle = null;
            for (var i = 0; i < this.eventListeners.length; i++) {

                evtHandle = this.eventListeners[i];
                if (evtHandle != null && typeof evtHandle.remove == 'function') {
                    evtHandle.remove();
                }
            }
            this.eventListeners = [];
        },
        handleConnectionChange: function ( /* boolean */ flag) {
            if (flag) {
                 this.connected = true;
            } else {
                this.connected = false;
            }
        },
		getFinalDateLabel: function (date, time){
			var label = this.resourceBundle.secondsAgo;
    		var finalDate = "";
			var now = new Date().getTime();
			var t = (new Date(Number(time)*1000)).getTime();
    		var timeDiff =(now - t) / 1000;
    		if (timeDiff >60){
    			 var minutes = timeDiff/60;
                 if (minutes > 60){
                 	var hours = minutes/60;
                 	if (hours > 24){
                 		var days = hours/24;
                 		days = Math.abs(Math.round(days));
                 		if (days === 1)
                 			label = this.resourceBundle.dayAgo;
                 		else
                 			label = this.resourceBundle.daysAgo.replace("${0}", days);
                     	finalDate = label + "(" + date + ")";
                 	}
                 	else {
                 		hours = Math.abs(Math.round(hours));
                     	label = this.resourceBundle.hoursAgo;
                     	finalDate = label.replace("${0}", hours) + "(" + date + ")";
                 	}
                 }
                 else {
                 	minutes =Math.abs(Math.round(minutes));
                 	label = this.resourceBundle.minutesAgo;
                 	finalDate = label.replace("${0}", minutes) + "(" + date + ")";
                 }
    		} else {
    			var seconds = Math.abs(Math.round(timeDiff));
    			finalDate = label.replace("${0}", seconds) + "(" + date + ")";
    		}
    		return finalDate;
		},
		setVisible: function(visible)
		{
			var wrapper=dijit.byId("gitrepositoryPane_wrapper");
			if (visible)
				wrapper.set("style","display:block");
			else
				wrapper.set("style","display:none");

			var resize=function()
			{
				var accordion=dijit.byId('accContainer');
				accordion.resize();
			};

			setTimeout(resize,0);
		},
		
		postOperationRunningDialog: function(operationRun) {
			
			var operationMsg = this.resourceBundle.runningFileOperation;
			if(operationRun == "stageAll")
				operationMsg =this.resourceBundle.stagingAllChanges;  
			if(operationRun == "stage")
				operationMsg = this.resourceBundle.staging;  
			if(operationRun == "unstageAll")
				operationMsg = this.resourceBundle.unStagingAllChanges;  
			if(operationRun == "unstage")
				operationMsg = this.resourceBundle.unstaging;  
			if(operationRun == "pull")
				operationMsg = this.resourceBundle.pulling;  
			else if(operationRun == "push")
				operationMsg = this.resourceBundle.pushing; 
			else if(operationRun == "history")
				operationMsg =this.resourceBundle.gettingHistory; 
			else if(operationRun == "log")
				operationMsg = this.resourceBundle.gettingCommitLog;
			else if(operationRun == "commit")
				operationMsg = this.resourceBundle.committingStagedChanges; 
			else if(operationRun == "refresh")
				operationMsg = this.resourceBundle.refreshingGitInformation; 
			else if(operationRun == "getdiffs")
			    operationMsg = this.resourceBundle.gettingDifferencesBetweenCommits;
			else if(operationRun == "status")
			    operationMsg = this.resourceBundle.gettingRepositoryStatus;
			else if(operationRun == "merge")
			    operationMsg = this.resourceBundle.branchMergeStatus;
			else if(operationRun == "checkOut")
			    operationMsg = this.resourceBundle.branchCheckOutStatus;
			else if(operationRun == "deleteBranch")
			    operationMsg = this.resourceBundle.branchDeleteStatus;
			else if(operationRun == "fileDiff")
			    operationMsg = this.resourceBundle.gettingFileDifferences;
			else if(operationRun == "resetFile")
			    operationMsg = this.resourceBundle.resettingFile;
			
			this.operationRunningDialog = appDMS.dialogs.postBusyDialog(operationMsg, null);
		},
		
		hideOperationRunningDialog: function() {

			if(!this.operationRunningDialog)
				return;
			
			this.operationRunningDialog.hide();
			delete this.operationRunningDialog;
		},
		
		findIndex: function(arrayData,id) {
			for (var i=0; i<arrayData.length; i++) {
				if (id === arrayData[i][1])
					return i;
			}
			return -1;
		},
		onFileDiffMouseClick: function(event) {
			console.log("onFileDiffMouseClick");
			
			if (event.button !== 2)
				return;
				
			if ((this.openDialogContent == null) || (this.openDialogContent.length ==0))
			    return;
				
			this.fileDiffContextMenu = new dijit.Menu({
	                targetNodeIds:[this.fileDiffContentPane.containerNode]
	            });
			 
			this.openMenuItem = new dijit.MenuItem({
					label: this.resourceBundle.openLabel,
					onClick:lang.hitch(this, this.onOpenDialog)
				});
			this.fileDiffContextMenu.addChild(this.openMenuItem);
		},
		onOpenDialog: function(event) {
			
			var dialog = new Dialog({
				title: appDMS.dialogs.resourceBundle.FaultDialogTitle,
				"class":"gitDiffDialog"
			});
			
        	var messagePane = new ContentPane({
  			    "class": "gitDiffDialogMessagePane",
  				gutters: true,
  				splitters: false,
  				region:"center"
  			});
        	
        	dialog.addChild(messagePane);

			var message = domConstruct.create("div", {
				id: dialog.id + "_message",
				innerHTML: this.openDialogContent
			}, messagePane.domNode);
			
			
			//create content pane for action bar.
        	var actionPane = new ContentPane({
  			    "class":"gitDiffDialogActionPane",
  				gutters: true,
  				splitter:false,
  				region:"bottom"
  			});
			appDMS.dialogs.createActionBar(actionPane, [{id:"diffDialog",
													label: appDMS.dialogs.resourceBundle.FaultDialogClose,
													onClick: lang.hitch(this, function(diffDialog){
														diffDialog.hide();
													}, dialog),
													primary:true}]);		
			
			dialog.addChild(actionPane);
			dialog.show();
			dialog.resize();
		},
		
		resetReloadTabs: function() {
		    if (this.reloadTabs) {		  
				for (var i=0; i<this.reloadTabs.length; i++)
				{
					this.reloadTabs[i].gitClose = false;
					this.reloadTabs[i].gitReload = false;
				}
			}
			this.reloadTabs=[];
		},
		
		checkOpenTabs: function(path, name) {
		    console.log('checkOpenTabs');
			var tabObjects = appDMS.getCurrentPerspectiveSASStudioTabs().getAllTabObjects();
			
			//find open tabs that reside in the active repo.
			if(tabObjects){
			//    if ((path && path.length>0) && (name && name.length>0))
			//	{
			//	    if (!this.reloadTabs)
					    this.reloadTabs = [];
			//	}
			//	else
			//	    this.resetReloadTabs();
				var currentRepository="";
				if (this.lastRepository && this.lastRepository.indexOf('/') === -1 ){
					currentRepository =this.lastRepository.replaceAll("\\","/");
				} else {
					currentRepository =this.lastRepository;
				}
				for (var i=0;i<tabObjects.length; i++)
				{
					if (typeof tabObjects[i].uriParent !== 'undefined' && tabObjects[i].uriParent !== null && tabObjects[i].uriParent.toLowerCase().indexOf(currentRepository.toLowerCase()) > -1){
						
						//ctms in run mode do not need to be reloaded if the ctm is editted after running it, saving a ctm in run mode always prompts the saveAs
						if(tabObjects[i].fileType === "CTM" && tabObjects[i].mode === "run")
							continue;
						if ((path && path.length>0) && (name && name.length>0))
						{
						    // Reset only done on a single file. index check is to handle sub-directory cases.
							if ((name.indexOf(tabObjects[i].name)> -1) && (tabObjects[i].uriParent.toLowerCase().indexOf(path.toLowerCase()) > -1))
							{
							    this.reloadTabs.push(tabObjects[i]);
								break;
							}
						}
						else
						   this.reloadTabs.push(tabObjects[i]);
					}
				}
			}
			
			//loop thru open tabs in active repo.
			if (this.reloadTabs.length>0){
				
				//need to check these tabs to see if the contents have changed.
				//if so post dialog.
				
				for (var i=0;i<this.reloadTabs.length; i++)
				{
										
					var _url = this.baseURL + '/sasexec/sessions/' + this.sessionId + '/workspace/modified/' + encodeValue(this.reloadTabs[i].uri, "workspace");
					
					//getting the modified date for .xml files fails. doing this as a work around and resolving on the midtier.
					if(this.reloadTabs[i].fileType === "XML")
						_url += "sasxml";
					
					
					dojo.xhrGet({
						url : _url,
						handleAs : "text",
						load : lang.hitch(this, function(tab, data, args) {
							
							if(parseInt(data) === -1 ){
								tab.gitClose = true;
								tab.gitReload = false;
							}else if(typeof tab.modifiedDate ==='undefined' &&  parseInt(data) !== -1){
								tab.gitReload = true;
								tab.gitClose = false;
							}else if(tab.modifiedDate !== parseInt(data)){
								tab.gitReload = true;
								tab.gitReloadModifiedDate = parseInt(data);
								tab.gitClose = false;
							}else if(tab.modifiedDate === parseInt(data)){
								tab.gitReload=false;
								tab.gitClose=false;
							}
							
														
							if(tab.tab.selected && (tab.gitClose || tab.gitReload)){
								this.hideOperationRunningDialog();
								this.postReloadDialog(tab);
							    tab.modifiedDate = parseInt(data);//reset the modified date.
								tab.gitReloadModifiedDate = "";
							}
							console.log("laod success");
						}, this.reloadTabs[i]),
						error : function(err, args){
							console.log("laod failed");
						}
					});
				}
			}
		},
		
		postReloadDialog:function(tabObject){
			
			//function to keep the tab as it is and mark the tabs dirty or close them depending.
			var keepAsIs = function(){
				var tabs = appDMS.getCurrentPerspectiveSASStudioTabs();
				tabs.changeTabPreferences(tabObject, tabs.perspectiveKey);
				
				var targetObject = tabObject.targetObject;
				switch(tabObject.fileType){
				case "CTK":
					tabObject.editor.uri = null;
					tabObject.editor.task.uri = null;
					tabObject.editor.task.filePath = null;
					tabObject.editor.taskArea.uri = null;
					tabObject.uri = null;
					tabObject.uriParent = null;
					tabObject.tooltip = null;
					tabObject.tab.setAttribute("tooltip", tabObject.name);
					tabObject.tab.controlButton.set("label", "*"+tabObject.tab.title); 
					var fileLocationLabelDiv = dojo.byId('fileStatus' + tabObject.editor.editorTabContainer.id);
	                fileLocationLabelDiv.innerHTML = appDMS.encodeHtml(tabObject.name);
					tabObject.editor.editorContentChanged = true;
					tabObject.editor.autoSaved = true;//keeps the saveAs dialog from popping up.
					tabObject.editor.setButtonStates();
					break;
				case "CQY":
				case "CPF":
				case "CTL":
					//if its a gitReload situation and the user hits no on the reload prompt, close the tab.
					if(tabObject.gitReload)
						tabs.closeTab(tabObject.tab);
					break;
				default:
					tabObject.editor.uri = null;
					var fileLocationLabelDiv = dojo.byId('fileStatus' + tabObject.editor.editorTabContainer.id);
	                fileLocationLabelDiv.innerHTML = appDMS.encodeHtml(tabObject.name);
					fileLocationLabelDiv.title=tabObject.name;
					tabObject.tab.setAttribute("tooltip", tabObject.name);
					tabObject.editor.applyChangedIndicationToTab();
					tabObject.editor.editorContentChanged = true;
					tabObject.editor.autoSaved = true;//keeps the saveAs dialog from popping up.
					tabObject.editor.setButtonStates();
				}
			};
			
			var ok=function()
			{
				this.reloadDialog.hide();
				var tabs = appDMS.getCurrentPerspectiveSASStudioTabs();
				if(tabObject.gitClose){
					keepAsIs();
					tabObject.gitClose=false;
				}else if(tabObject.gitReload){
					
					var targetObject = tabObject.targetObject;
					switch(tabObject.fileType){
					case "CTK":
						tabs.closeTab(tabObject.tab);
						tabs.addTaskTab(targetObject);
						return;
					case "CPF":
						tabs.closeTab(tabObject.tab);
						vp.addFileTab(targetObject);
						return;
					case "CTL":
					case "CPK":
					case "CQY":
						tabs.closeTab(tabObject.tab);
						tabs.addFileTab(targetObject);
						return;
					default:
						tabObject.editor.uri = tabObject.uri;
						var fileLocationLabelDiv = dojo.byId('fileStatus' + tabObject.editor.editorTabContainer.id);
		                fileLocationLabelDiv.innerHTML = appDMS.encodeHtml(tabObject.uri);
						fileLocationLabelDiv.title=tabObject.uri;
						tabObject.tab.setAttribute("tooltip", tabObject.uri);
						tabObject.gitReload = false;
						if (tabObject.gitReloadModifiedDate && tabObject.gitReloadModifiedDate != "")
						{
						    tabObject.modifiedDate = tabObject.gitReloadModifiedDate;
					     	tabObject.gitReloadModifiedDate = "";
						}
					}
					
					var _url;
					_url = this.baseURL + '/sasexec/sessions/' + this.sessionId + '/' + "workspace" + '/' + encodeValue(tabObject.uri, "workspace");
					
					if (appDMS.sasStudioPreferences && appDMS.sasStudioPreferences.optionPreferencesGeneral){
		                var _ct = "text/plain;charset=" + appDMS.sasStudioPreferences.optionPreferencesGeneral.defaultTextEncoding;
		                _url += "?ct=" + _ct;
		            } else {
		            	var _ct = "text/plain;charset=" + "UTF-8";
		            	_url += "?ct=" + _ct;
		            }
					dojo.xhrGet({
							url : _url,
							handleAs : "text",
							load : lang.hitch(this, function(tab, data, args) {
								tab.editor.setEditContent(data);
								tab.editor.resetSaveState();
								tab.gitReload = false;
								console.log("reload success");
							}, tabObject),
							error : function(err, args){
								console.log("reload failed");
							}
						});
				}
			};
			var cancel=function()
			{
				this.reloadDialog.hide();
				var tabs = appDMS.getCurrentPerspectiveSASStudioTabs();
				if(tabObject.gitClose){
					tabs.closeTab(tabObject.tab);
				}else if(tabObject.gitReload){
					keepAsIs();
				}
				
				tabObject.gitReload=false;
				tabObject.gitClose=false;
			};
			
			var question = this.resourceBundle.reloadMessageLabel;
			var okLabel = this.resourceBundle.reloadLabel;
			if(tabObject.gitClose == true){
				question = this.resourceBundle.fileNoLongerExistsLabel;
				okLabel = this.resourceBundle.yesLabel;
			}else if(tabObject.gitReload = true){
				question = this.resourceBundle.reloadMessageLabel;
				okLabel = this.resourceBundle.reloadLabel;
			}

			this.reloadDialog=appDMS.dialogs.postDecisionDialog(question, null,
															     {label:okLabel,
															     callback:lang.hitch(this,ok),
															     primary:true},
															     {label:this.resourceBundle.noLabel,
															     callback:lang.hitch(this,cancel)});
		}
    });

    return DMSGit;
});
