define(["CodeEditor/controls/CodeEditor",
         "dojo/_base/lang",
        "dojo/_base/declare",
        "dojo/dom",
        "dojo/dom-construct",
        "dojo/dom-style",
		"dojo/dom-class",
		"dojo/io-query",
        "dojo/on",
		"dojo/query",
        "dijit/layout/TabContainer",
        "dijit/form/SimpleTextarea",
        "dijit/form/NumberTextBox",
        "dijit/layout/ContentPane",
        "dijit/Toolbar",
        "dijit/form/Button",
        "dojo/_base/xhr",
        "dijit/registry",
        "dijit/Dialog",
        "dijit/Tree",
        "dojo/store/JsonRest",
		"dijit/focus",
		"dijit/layout/BorderContainer",
		"dojo/topic",
		"dijit/MenuBar",
		"dijit/MenuItem",
		"dijit/DropDownMenu",
		"dijit/PopupMenuBarItem",
		"dijit/form/DropDownButton",
		"dojo/window",
		"dojo/date/locale",
		"dojo/store/Memory",
		"dijit/tree/ObjectStoreModel",
		"dojo/store/Observable",
		"dijit/TitlePane",
		"dojo/dnd/Source",
		"dojo/dnd/Target",
		"dojo/dnd/Manager",
		"dojo/dom-geometry",
		"dojo/text!webdms/templates/SendMailDialogTemplate.html",
		"dojo/text!webdms/templates/SnippetsAddDialogTemplate.html",
		"dojo/keys",
		"dojox/validate/web",
        "./DMSQuery",
		"./SASTask",
		"./ReportAppUtil"
        ],
        function(Editor, lang, declare, dom, domConstruct, domStyle, domClass,
				ioQuery, on, dojoQuery, TabContainer,
				SimpleTextarea, NumberTextBox, ContentPane, Toolbar, Button, xhr, registry,
				Dialog, Tree, JsonRest, focus, BorderContainer, topic, Menu, MenuItem, DropDownMenu,
				PopupMenuBarItem, DropDownButton, win, locale, Memory, ObjectStoreModel, Observable, TitlePane,
				Source, Target, Manager, domGeom, sendMailDialogTemplate,
				snippetsAddDialogTemplate, keys, validate, DMSQuery, SASTask, reportAppUtil)
{
	var DMSEditor = declare( null, {
		LOG: 'logContentPane',
		EDITOR: 'editContentPane',
		RESULT: "outputContentPane",
        DATA: "dataContentPane",
		dmsTabs: null,
		tree: null,
		connected: true,
		// saveable: true,
		recallReadOnly : false,
		codeSnippet: false,
		codeRan: false,
		running: false,
		eatChangeEvent: false,

		month: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
		constructor: function(editorTabContainer, sessionId, name, uri, content, appDMSHook, isFile, tabObj, isTask)
		{
			this.finalized = false;
			this.appDMS = appDMSHook;
			this.taskArea = null;
			this.finding = false;
			this._saveable = true;
			this.logTiled = false;
			this.editorTiled = false;
			this.savedSize = null;
			this.submitStack =[];
			this.submitCount = 0;
			this.resourceBundle = getResourceBundle("DMSEditor_nls");
			this.allowCtrlS = false;
			this.pdfURL=null;
			this.rtfURL=null;
			this.mode="normal";

			this.fileType="SAS";
			if(tabObj && tabObj.type == 'CODE')
				this.fileType="SAS";
			else if(tabObj && tabObj.uri)
				this.fileType=appDMS.getFileType(tabObj);
			else if(uri!=null && uri.length > 0)
				this.fileType=appDMS.getFileType({name:name, uri:uri});

			topic.subscribe('appDMS/connectionChange', lang.hitch(this, this.updateToolbarStates));
			this.enabled = {clearBlock: false, submit: false, find: false};
			this.baseURL = '.';
			this.sessionId = sessionId;
			this.isFile = isFile;
			this.name = name;
			this.object=tabObj;
			this.uri = (uri !== null) ? uri : "";
			this.projects = this.appDMS.projects;
			this.libraries = this.appDMS.libraries;
			this.templates = this.appDMS.templates;
			this.tasks = this.appDMS.tasks;
//			this.snippets = snippets;
			this.files = this.appDMS.files;
			this.tabs = null;
			this.iframe = null;
			if (this.object)
				this.encoding=this.object.encoding;

			this.canUpdateTabTitle = true;
			this.canUpdateTabIcon = true;
			this.focus = focus;
			this.logSummaryInitHeight = 0;
			this.log = null;
			this.sendMailDialog =null;
			this.editorContent = content;
			this.editorTabContainer = editorTabContainer;
			if(this.isFile){
				this.editorContentChanged = true;
			} else {
				this.editorContentChanged = false;
			}
			this.sasSuiteTabContainer = new dijit.layout.TabContainer({
				style:/* "height: 90%; */ "width: 100%;",     // setting this to
															// 50% makes the
															// task area work
				id: editorTabContainer.id + 'sasSuiteTabContainer',
				"class":"sasSuiteTabs",
				region:"center",
				splitter:true
			}, "tc1-prog");

			this.hiddenTabContainer = new dijit.layout.TabContainer({
				style:	"display: none;",
				id: editorTabContainer.id + 'hiddenTabContainer',
				"class":"sasSuiteTabs"
			}, "tc1-prog");

//			this.tabPrefs=appDMS.getPreference("WEBDMS.CLRTabs");

			if(tabObj==null) {
				tabObj=appDMS.getCurrentPerspectiveSASStudioTabs().getFocusedTab();
			}
			if(tabObj && !tabObj.editor){
				tabObj.editor=this;
			}
			this.tabObject=tabObj;

			this.createEditorTab(content);
			this.createLogTab();
			this.createOutputTab();
            // Create output data tab dynamically and only as needed
			//this.createDataTab();

			this.sasSuiteTabContainer.startup();
			this.hiddenTabContainer.startup();

			// initalize tab dnd functionality
			this.initTabDND();
			this.setLogClearState();
			this.resultsClearButton.set("disabled",true);

			this.setButtonStates();
			this.resultsURL=null;
			this.logURL = null;
			this.submitError = false;
			this.selectedIndex = 0;
			var tabType = '';
			if (typeof tabObj !== 'undefined' && tabObj !== null){
				tabType = tabObj.type;
			}
			if (tabType === 'newprogram' || tabType === 'querytool'  || tabType === 'importtool' || (tabObj && tabObj.isReadOnly)){//pre-defined snippets and other readOnly files should be disabled as well.
				this.autoSaveAllowed = false; // not saving 'new programs' just yet.
			} else if (uri === undefined){
				this.autoSaveAllowed = false;
			} else {
				this.autoSaveAllowed = true;
			}


			if (tabType === 'newprogram' && (this.fileType === "SAS") && appDMS.optionPreferencesGeneral.interActiveMode === true){
				this.goInteractive();
			}
			if (this.autoSaveAllowed){
				var timeoutPref = this.appDMS.getPreference("SWE.optionPreferencesEditor");
				if ((typeof timeoutPref.autoSave === 'undefined' || timeoutPref.autoSave === null) ||
					(typeof timeoutPref.autoSave !== 'undefined' && timeoutPref.autoSave !== null  && timeoutPref.autoSave === "true")){

					var autoTimeout = 30000;

					if (typeof timeoutPref.autoSaveInterval !== 'undefined' && timeoutPref.autoSaveInterval !== null){
						autoTimeout = timeoutPref.autoSaveInterval * 1000;
					}
					this.autoSaveTimeout = setInterval(lang.hitch(this, this.autoSave), autoTimeout); // 30 secs
					this.autoSaved = false;
				}

			}
			dojo.connect(this.sasSuiteTabContainer, "selectChild",lang.hitch(this, this.onTabSelect));
			
			if (tabObj && tabObj.desktopFile)
			{
				setTimeout(lang.hitch(this,this.desktopDirty),0);
			}
		},
		
		setLogClearState: function()
		{
			try {
				this.clearLogButton.set("disabled",true);
				this.clearLogButton.set("style","display:none");
				this.logClearSeparator.set("style","display:none");
				if (!appDMS.optionPreferencesEditor.appendLog){
					// Do nothing
				} else if (appDMS.optionPreferencesEditor.typeSelection === "Program and Task"){
					this.clearLogButton.set("disabled",false);
					this.clearLogButton.set("style","display:inline-block");
					this.logClearSeparator.set("style","display:inline-block");
	        	} else if (appDMS.optionPreferencesEditor.typeSelection === "Program only" && typeof (this.taskMode) === 'undefined'){
	        		this.clearLogButton.set("disabled",false);
					this.clearLogButton.set("style","display:inline-block");
					this.logClearSeparator.set("style","display:inline-block");
	        	} else if (appDMS.optionPreferencesEditor.typeSelection === "Task only" && typeof (this.taskMode) !== 'undefined' && this.taskMode){
	        		this.clearLogButton.set("disabled",false);
					this.clearLogButton.set("style","display:inline-block");
					this.logClearSeparator.set("style","display:inline-block");
	        	}
			}
			catch(e)
			{
				console.log(e);
				console.log("Error while doing setLogClearState.");
			}
		},
		
		desktopDirty: function()
		{
			this.editorChanged(true);
		},
		
		enableAutoSave: function(flag){
			if (this.autoSaveAllowed === true)
			{
				if (flag == "true") // turn it on
				{
					var timeoutPref = this.appDMS.getPreference("SWE.optionPreferencesEditor");

					if (this.autoSaveTimeout){
						clearInterval(this.autoSaveTimeout);
					}

					var autoTimeout = 30000;
					if (typeof timeoutPref.autoSaveInterval !== 'undefined' && timeoutPref.autoSaveInterval !==  null)
						autoTimeout = timeoutPref.autoSaveInterval * 1000;
					this.autoSaveTimeout = setInterval(lang.hitch(this, this.autoSave), autoTimeout); // 30 secs
					this.autoSaved = false;
				}
				else // turn it off
				{
					if (this.autoSaveTimeout){
						clearInterval(this.autoSaveTimeout);
						this.autoSaveTimeout = null;
					}
				}
			} else {
				if (this.autoSaveTimeout){
					clearInterval(this.autoSaveTimeout);
					this.autoSaveTimeout = null;
				}
			}
		},

		disableSubmitCancelButtons: function(disableSubmit, disableCancel) {
			this.submitButton.set("disabled",disableSubmit);
			this.cancelButton.set("disabled",disableCancel);
			if (this.taskArea)
			{
				this.taskArea.enableRunSubmitButton();
				this.taskArea.cancelButton.set("disabled",disableCancel);
			}

			this.onDisableSubmitCancelButtons(disableSubmit, disableCancel);
		},

		// This is used to enable/disable run/cancel for the query.
		onDisableSubmitCancelButtons: function(disableSubmit, disableCancel) {
		},

		initTabDND:function()
		{

			// dummyContainer to add to the target tabContainer when dragging
			// over
			this.dummyContainer = new BorderContainer({
				disabled: true,
				dummy: true
			});

			this.editorContentPaneTarget = new Target(this.editorTabContainer.containerNode,{
				main: this,
				checkAcceptance: function(source, nodes){

					var currentTabs=appDMS.getCurrentPerspectiveSASStudioTabs();
					if(currentTabs && currentTabs.checkAcceptance){
						return currentTabs.checkAcceptance(source, nodes);
					}else{
						var sourceWidget = dijit.getEnclosingWidget(source.node),
							selectedItems = null,
							selectedIndex,
							grid,
							id,
							itemName,
							itemId;
						if(sourceWidget.id == "searchDGrid"){
							selectedIndex = sourceWidget.store.index[Object.keys(sourceWidget.selection)[0]];
							selectedItems = [sourceWidget.objs.rows[selectedIndex]];
						}else if(sourceWidget.id == "filerefsPane"){
							grid = source.grid;
							selectedItems = [];
							for(id in grid.selection){
								if(grid.selection[id])
									selectedItems.push(grid.row(id));
							}
						}else
							selectedItems = sourceWidget.selectedItems;

						if(selectedItems){
							for(i=0; i < selectedItems.length; i++)
							{
								switch(sourceWidget.id)
								{
								case "projects.tree":
									if(!selectedItems[i].isDirectory)
										return true;
									break;
								case "library.tree":
									if(selectedItems[i].table ||
											(selectedItems[i].library=="columns" &&
											this.main.taskArea==null &&
											!this.main.editor.readOnly() &&
											this.main.isCodeTabActive()))
										return true;
									break;
								case "tasks.tree":
									if(selectedItems[i].type == appDMS.TASK || selectedItems[i].isMyTask)
										return true;
									break;
								case "templates.tree":
									if(selectedItems[i].type == "CODE" || selectedItems[i].isMySnippet)
										return true;
									break;
								case "searchDGrid":
									switch(selectedItems[i].type)
									{
									case "file":
									case "table":
									case "column":
									case "label":
										return true;
									}
									break;
								case "filerefsPane":
									if(selectedItems[i].data.accessMethod == "DISK" || selectedItems[i].data.accessMethod == "FTP")
										return true;
									break;
								}

							}
						}
						return false;
					}
				},
				onDrop: function(source, nodes){
					var currentTabs=appDMS.getCurrentPerspectiveSASStudioTabs();
					if(this.main.tabs){
						var pRegion = this.main.editorTabContainer.getParent().getParent().region;
						if(pRegion=="center")
							pRegion=null;
						this.main.tabs.onDrop(source, nodes, null, pRegion);
					}else if(currentTabs && currentTabs.onDrop){
						currentTabs.onDrop(source, nodes);
					}else
						this.main.appDMS.handleWebOneEvent("Drop", {source: source, nodes:nodes, x:this.x, y:this.y});
				},
				// In IE and Safari the onSelectStart function only allows
				// highlighting
				// if the target is a form
				// object or the skipForm tag is set true.
				// if skipform is set to true, highlighting in the editor works,
				// but not the log.
				// so overriding onSelectStart and having it do nothing fixes
				// the highlighting issue.
				onSelectStart: function(e){},
				// removes dummy from the tab containers that is not being
				// dragged over.
				removeDummy: function(dropZone){
					Manager.manager().overDropZone = false;
					switch(dropZone)
					{
					case "right":
						if(this.main.sasSuiteTabContainer.getIndexOfChild(this.main.dummyContainer) > -1)
							this.main.sasSuiteTabContainer.removeChild(this.main.dummyContainer);
						if(this.main.bottomTabs && this.main.bottomTabs.getIndexOfChild(this.main.dummyContainer) > -1)
							this.main.bottomTabs.removeChild(this.main.dummyContainer);
						break;
					case "bottom":
						if(this.main.sasSuiteTabContainer.getIndexOfChild(this.main.dummyContainer) > -1)
							this.main.sasSuiteTabContainer.removeChild(this.main.dummyContainer);
						if(this.main.rightTabs && this.main.rightTabs.getIndexOfChild(this.main.dummyContainer) > -1)
							this.main.rightTabs.removeChild(this.main.dummyContainer);
						break;
					case "main":
						if(this.main.rightTabs && this.main.rightTabs.getIndexOfChild(this.main.dummyContainer) > -1)
							this.main.rightTabs.removeChild(this.main.dummyContainer);
						if(this.main.bottomTabs && this.main.bottomTabs.getIndexOfChild(this.main.dummyContainer) > -1)
							this.main.bottomTabs.removeChild(this.main.dummyContainer);
						break;
					case "all":
						if(this.main.sasSuiteTabContainer.getIndexOfChild(this.main.dummyContainer) > -1)
							this.main.sasSuiteTabContainer.removeChild(this.main.dummyContainer);
						if(this.main.rightTabs && this.main.rightTabs.getIndexOfChild(this.main.dummyContainer) > -1)
							this.main.rightTabs.removeChild(this.main.dummyContainer);
						if(this.main.bottomTabs && this.main.bottomTabs.getIndexOfChild(this.main.dummyContainer) > -1)
							this.main.bottomTabs.removeChild(this.main.dummyContainer);
						break;
					}
				},
				getTargetBoxes: function(){
					//getTargetBoxes on drag start
					if(this.main.sasSuiteTabContainer && this.main.sasSuiteTabContainer.domNode)
						this.mainTabsTargetBox = domGeom.position(this.main.sasSuiteTabContainer.domNode, false);
					if(this.main.bottomTabs && this.main.bottomTabs.domNode)
						this.bottomTargetBox = domGeom.position(this.main.bottomTabs.domNode, false);
					if(this.main.rightTabs){
						if(this.main.rightTabs.domNode)
							this.rightTargetBox = domGeom.position(this.main.rightTabs.domNode, false);
					}
					this.targetBox = domGeom.position(this.node, false);
				},
				removeDropZoneIndicator: function(/*String*/ region){
					Manager.manager().overDropZone = false;
					switch(region)
					{
					case "right":
						if(this.parent.contains(this.rightDropZoneIndicator))
							this.parent.removeChild(this.rightDropZoneIndicator);
						break;
					case "bottom":
						if(this.parent.contains(this.bottomDropZoneIndicator))
							this.parent.removeChild(this.bottomDropZoneIndicator);
						break;
					default:
						if(this.parent.contains(this.bottomDropZoneIndicator))
							this.parent.removeChild(this.bottomDropZoneIndicator);
						if(this.parent.contains(this.rightDropZoneIndicator))
							this.parent.removeChild(this.rightDropZoneIndicator);
						break;
					}
				},
				createDropZoneIndicator: function(/*String*/ region){

					switch(region)
					{
					case "right":
						if(this.rightDropZoneIndicator == null)
							this.rightDropZoneIndicator = dojo.create("div", {
								"class":"dropZoneIndicator"
							});

						this.rightDropZoneIndicator.style.width = "50%";
						this.rightDropZoneIndicator.style.height = "100%";
						this.rightDropZoneIndicator.style.cssFloat = "right";
						this.rightDropZoneIndicator.style.top = "";
						this.rightDropZoneIndicator.style.zIndex = 10000;
						break;
					case "bottom":
						if(this.targetBox == null)
							this.getTargetBoxes();

						if(this.bottomDropZoneIndicator == null)
							this.bottomDropZoneIndicator = dojo.create("div", {
								"class": "dropZoneIndicator"
							});

						//doing the styles like this also serves as reseting the styles back to the default
						this.bottomDropZoneIndicator.style.height = "40%";
						this.bottomDropZoneIndicator.style.top = (this.targetBox.h - (this.targetBox.h * 0.4)) + "px";
						this.bottomDropZoneIndicator.style.width = "100%";
						this.bottomDropZoneIndicator.style.cssFloat = "";
						this.bottomDropZoneIndicator.style.zIndex = 10000;
						break;
					}

				},
				onMouseOut: function(e){
					this.removeDummy("all");

					if(this.targetBox == null)
						this.targetBox = domGeom.position(this.node, false);

					// we need to check if we are actually out of the targetBox otherwise the
					//mouseOut event will fire when we are over a dropZoneIndicator
					if(e.clientX <= this.targetBox.x || e.clientX >= (this.targetBox.x+this.targetBox.w) ||
						e.clientY <= this.targetBox.y || e.clientY >= (this.targetBox.y+this.targetBox.h))
					{
						this.removeDropZoneIndicator();
					}
				},
				onMouseMove: function(e){
					if(this.isDragging)
					{
						this.x = e.layerX;
						this.y = e.layerY;
						var dndManager = Manager.manager();
						if(dndManager.nodes[0].sourceType && dndManager.nodes[0].sourceType == "clrTab_" + this.main.editorTabContainer.id)
						{

							var sourceWidget = dijit.getEnclosingWidget(dndManager.nodes[0]);
							var sourceParent="";// to keep track of where we can
												// and can't add the dummyTab
							this.main.dummyContainer.title = sourceWidget.page.title;
							var canDrop = true;
							if(sourceWidget.id.indexOf("sasSuiteTabContainer") > -1)
							{
								canDrop = this.main.sasSuiteTabContainer.getChildren().length > 1;
								sourceParent = "main";
								if(this.main.sasSuiteTabContainer.selectedChildWidget != sourceWidget.page)
									this.main.sasSuiteTabContainer.selectChild(sourceWidget.page, false);
							}else if(sourceWidget.id.indexOf("bottomTabContainer") > -1){
								sourceParent = "bottom";
								if(this.main.bottomTabs.selectedChildWidget != sourceWidget.page)
									this.main.bottomTabs.selectChild(sourceWidget.page, false);
							}else if(sourceWidget.id.indexOf("rightTabContainer") > -1){
								sourceParent = "right";
								if(this.main.rightTabs.selectedChildWidget != sourceWidget.page)
									this.main.rightTabs.selectChild(sourceWidget.page, false);
							}
							if(this.targetBox == null)
								this.targetBox = domGeom.position(this.node, false);

							if(this.mainTabsTargetBox == null)
								this.mainTabsTargetBox = domGeom.position(this.main.sasSuiteTabContainer.domNode, false);
							//get the 10% threshold for the right side and bottom
							var thresholdY90 = (this.targetBox.h * 0.9) + this.targetBox.y;
							var thresholdX90 = (this.targetBox.w * 0.9) + this.targetBox.x;

							//get the 10% threshold for the left side and for the top.
							var thresholdX10 = (this.targetBox.w * 0.1) + this.targetBox.x;
							var thresholdY10 = (this.targetBox.h * 0.1) + this.targetBox.y;

							this.dropZone = "";
							this.splitDir = "";

							// if bottomTabs exists or rightsTabs exists adjust
							// targetBox
							if(this.main.bottomTabs && this.main.rightTabs)
							{
								if(this.bottomTargetBox == null)
									this.bottomTargetBox = domGeom.position(this.main.bottomTabs.domNode, false);
								if(this.rightTargetBox == null)
									this.rightTargetBox = domGeom.position(this.main.rightTabs.domNode, false);
								// differentiate valid dropZones from
								// non-dropZones (tabContainer the dragging tab
								// already belongs too)
								if(sourceParent === "main")
								{
									//always false because you cannot drag
									//the last tab from the main tab container
									this.dropZone = "";
								}else if(sourceParent === "bottom"){
									// then drop zones == main tab container or
									// right tab container;
									if(e.clientX >= thresholdX90){


										// right 10% outside of the corners. dragging here is for 3 way vertical
										if(e.clientY > thresholdY10 && e.clientY < thresholdY90){
											this.removeDropZoneIndicator();
											this.removeDummy("all");

											if(this.main.bottomTabs.region != "right")
											{
												this.createDropZoneIndicator("right");
												if(this.main.bottomTabs.region == "center")
													this.splitDir = "";
												else{
													this.splitDir = "3v";
													this.rightDropZoneIndicator.style.width = "33%";
												}
												this.dropZone = "right";

												dojo.place(this.rightDropZoneIndicator, this.main.editorTabContainer.id);
												appDMS.updateAvatar(true);
												dndManager.overDropZone = true;
											}

										// top right corner
										}else if(e.clientY <= thresholdY10){
											this.removeDropZoneIndicator();
											this.removeDummy("all");

											this.dropZone = "topRightCorner";
											this.splitDir = "h";

											this.createDropZoneIndicator("right");
											if(this.main.dndBC && this.main.dndBC.region == "right")
												this.rightDropZoneIndicator.style.height = this.main.rightTabs._contentBox.h + "px";
											else
												this.rightDropZoneIndicator.style.height = this.main.sasSuiteTabContainer._contentBox.h + "px";
											dojo.place(this.rightDropZoneIndicator, this.main.editorTabContainer.id);
											appDMS.updateAvatar(true);
											dndManager.overDropZone = true;

										//bottom right corner dragging from bottom left with a horizontal split on left.
										}else if(e.clientY >= thresholdY90 && (this.main.dndBC && this.main.dndBC.region == "center")){
											this.removeDropZoneIndicator();
											this.removeDummy("all");

											this.dropZone = "bottomRightCorner";
											this.splitDir = "h";

											this.createDropZoneIndicator("bottom");
											this.bottomDropZoneIndicator.style.cssFloat = "right";
											this.bottomDropZoneIndicator.style.width = this.main.rightTabs._contentBox.w + "px";
											this.bottomDropZoneIndicator.style.height = this.main.bottomTabs._contentBox.h + "px";
											this.bottomDropZoneIndicator.style.top = (this.targetBox.h - this.main.bottomTabs._contentBox.h) + "px";
											dojo.place(this.bottomDropZoneIndicator, this.main.editorTabContainer.id);
											appDMS.updateAvatar(true);
											dndManager.overDropZone = true;
										}

									// bottom left corner
									}else if(e.clientY >= thresholdY90 && e.clientX <= thresholdX10 && (this.main.dndBC && this.main.dndBC.region == "right")){
										this.removeDropZoneIndicator();
										this.removeDummy("all");

										this.dropZone = "bottomLeftCorner";
										this.splitDir = "h";

										this.createDropZoneIndicator("bottom");
										this.bottomDropZoneIndicator.style.width = this.main.sasSuiteTabContainer._contentBox.w + "px";
										this.bottomDropZoneIndicator.style.height = this.main.bottomTabs._contentBox.h + "px";
										this.bottomDropZoneIndicator.style.top = (this.targetBox.h - this.main.bottomTabs._contentBox.h) + "px";
										dojo.place(this.bottomDropZoneIndicator, this.main.editorTabContainer.id);
										appDMS.updateAvatar(true);
										dndManager.overDropZone = true;


									// bottom 10% when split vertically twice.
									}else if(e.clientY >= thresholdY90 && this.main.bottomTabs.region == "right"){

										this.removeDropZoneIndicator();
										this.dropZone = "bottom";
										this.removeDummy(this.dropZone);
										this.createDropZoneIndicator("bottom");
										dojo.place(this.bottomDropZoneIndicator, this.main.editorTabContainer.id);
										appDMS.updateAvatar(true);
										dndManager.overDropZone = true;

									// over right tab container
									}else if((e.clientX >= this.rightTargetBox.x && e.clientX <(this.rightTargetBox.x + this.rightTargetBox.w)) &&
											(e.clientY >= this.rightTargetBox.y && e.clientY < (this.rightTargetBox.y + this.rightTargetBox.h))){
										this.removeDropZoneIndicator();

										//if dragging over rightTabs (bottom) container in a 3 way horizontal split, treat as bottomTabs container.
										if(this.main.rightTabs.region == "bottom")
											this.dropZone = "bottom";
										else
											this.dropZone = "right";

										this.removeDummy("right");
										if(sourceParent != "right" &&
												this.main.rightTabs.getIndexOfChild(this.main.dummyContainer) == -1) {
											this.main.rightTabs.addChild(this.main.dummyContainer);
											appDMS.updateAvatar(true);
											dndManager.overDropZone = true;
										}

									//over main tab container
									}else if((e.clientX >= this.mainTabsTargetBox.x && e.clientX < (this.mainTabsTargetBox.x + this.mainTabsTargetBox.w)) &&
											  (e.clientY >= this.mainTabsTargetBox.y && e.clientY < (this.mainTabsTargetBox.y + this.mainTabsTargetBox.h))){
										this.removeDropZoneIndicator();
										this.dropZone = "main";
										this.removeDummy(this.dropZone);
										if(sourceParent != this.dropZone &&
											this.main.sasSuiteTabContainer.getIndexOfChild(this.main.dummyContainer) == -1) {
											this.main.sasSuiteTabContainer.addChild(this.main.dummyContainer);
											appDMS.updateAvatar(true);
											dndManager.overDropZone = true;
										}
									}else{
										this.removeDropZoneIndicator();
										this.removeDummy("bottom");
										appDMS.updateAvatar(false);
									}
								}else if(sourceParent === "right"){
									// right tab container tab being dragged
									// drop zones == main tab container or
									// bottom tab container;
									if(e.clientX >= thresholdX90)
									{

										// bottom right corner dragging right tab with horizontal split on left.
										if(e.clientY >= thresholdY90 && this.main.bottomTabs.region != "right")// && (this.main.dndBC && this.main.dndBC.region == "center"))
										{
											this.removeDropZoneIndicator();
											this.removeDummy("all");

											this.dropZone = "bottomRightCorner";

											this.createDropZoneIndicator("bottom");
											this.bottomDropZoneIndicator.style.cssFloat = "right";
											this.bottomDropZoneIndicator.style.width = this.main.rightTabs._contentBox.w + "px";
											this.bottomDropZoneIndicator.style.height = this.main.bottomTabs._contentBox.h + "px";
											this.bottomDropZoneIndicator.style.top = (this.targetBox.h - this.main.bottomTabs._contentBox.h) + "px";
											this.splitDir = "v";
											dojo.place(this.bottomDropZoneIndicator, this.main.editorTabContainer.id);
											appDMS.updateAvatar(true);
											dndManager.overDropZone = true;

											// right 10% outside bottom right corner
										}else if(!this.main.dndBC){
											this.removeDropZoneIndicator();
											this.removeDummy("all");

											this.dropZone = "right";

											this.createDropZoneIndicator("right");
											this.rightDropZoneIndicator.style.width = "50%";
											dojo.place(this.rightDropZoneIndicator, this.main.editorTabContainer.id);
											appDMS.updateAvatar(true);
											dndManager.overDropZone = true;
										}

									}else if(e.clientX < thresholdX90 && e.clientY >= thresholdY90){

//										//bottom left corner && dragging from top right Corner
										if(e.clientX <= thresholdX10 && (this.main.dndBC && this.main.dndBC.region == "right")){
											this.removeDropZoneIndicator();
											this.removeDummy("all");

											this.dropZone = "bottomLeftCorner";
											this.splitDir = "v";

											this.createDropZoneIndicator("bottom");
											this.bottomDropZoneIndicator.style.width = this.main.sasSuiteTabContainer._contentBox.w + "px";
											this.bottomDropZoneIndicator.style.height = this.main.bottomTabs._contentBox.h + "px";
											this.bottomDropZoneIndicator.style.top = (this.targetBox.h - this.main.bottomTabs._contentBox.h) + "px";
											dojo.place(this.bottomDropZoneIndicator, this.main.editorTabContainer.id);
											appDMS.updateAvatar(true);
											dndManager.overDropZone = true;

										// bottom 10% outside the corners. 3 way horizontal stack
										}else{
											this.removeDropZoneIndicator();
											this.removeDummy("all");

											if(this.main.rightTabs.region != "bottom")
											{
												this.dropZone = "bottom";

												if(this.main.rightTabs.region == "right")
													this.splitDir = "3h";

												this.createDropZoneIndicator("bottom");
												this.bottomDropZoneIndicator.style.height = "33%";
												this.bottomDropZoneIndicator.style.top = (this.targetBox.h - (this.targetBox.h * 0.33)) + "px";
												dojo.place(this.bottomDropZoneIndicator, this.main.editorTabContainer.id);
												appDMS.updateAvatar(true);
												dndManager.overDropZone = true;
											}
										}

									//over bottom tab container
									}else if((e.clientX >= this.bottomTargetBox.x && e.clientX < (this.bottomTargetBox.x + this.bottomTargetBox.w)) &&
											(e.clientY >= this.bottomTargetBox.y && e.clientY < (this.bottomTargetBox.y + this.bottomTargetBox.h))){
										this.removeDropZoneIndicator();

										//if dragging over bottomTabs (right) container in a 3 way vertical split, treat as rightTabs container.
										if(this.main.bottomTabs.region == "right")
											this.dropZone = "right";
										else
											this.dropZone = "bottom";

										this.removeDummy("bottom");
										if(sourceParent != "bottom" &&
												this.main.bottomTabs.getIndexOfChild(this.main.dummyContainer) == -1) {
											this.main.bottomTabs.addChild(this.main.dummyContainer);
											appDMS.updateAvatar(true);
											dndManager.overDropZone = true;
										}

									// over main tab container
									}else if((e.clientX >= this.mainTabsTargetBox.x && e.clientX < (this.mainTabsTargetBox.x + this.mainTabsTargetBox.w)) &&
											  (e.clientY >= this.mainTabsTargetBox.y && e.clientY < (this.mainTabsTargetBox.y + this.mainTabsTargetBox.h))){
										this.removeDropZoneIndicator();
										this.dropZone = "main";
										this.removeDummy(this.dropZone);
										if(sourceParent != this.dropZone &&
												this.main.sasSuiteTabContainer.getIndexOfChild(this.main.dummyContainer) == -1){
											this.main.sasSuiteTabContainer.addChild(this.main.dummyContainer);
											appDMS.updateAvatar(true);
											dndManager.overDropZone = true;
										}
									}else{
										this.removeDummy("right");
										appDMS.updateAvatar(false);
									}
								}


							/**
							 * Split Vertically Once
							 */
							}else if(this.main.rightTabs){
								if(this.rightTargetBox == null)
									this.rightTargetBox = domGeom.position(this.main.rightTabs.domNode, false);
								//drop targets == rightTabPane or bottom 10% of entire editor pane
								if(e.clientX >= this.rightTargetBox.x && e.clientY < thresholdY90)
								{
									// remove bottomDropZoneIndicator if it
									// exists
									this.removeDropZoneIndicator("bottom");

									// dragging in the right 10% of the target.
									if(e.clientX >= thresholdX90){

										if(sourceParent === "right" && this.main.rightTabs.getChildren().length == 1)
											canDrop = false;

										if(canDrop)
										{
											this.createDropZoneIndicator("right");

											// top right corner
											if(e.clientY <= thresholdY10)
											{
												this.rightDropZoneIndicator.style.height = "60%";
												this.dropZone = "topRightCorner";
												this.splitDir = "h";

											// right 10% outside the corners
											}else{
												this.dropZone = "right";
												this.splitDir = "3v";
												this.rightDropZoneIndicator.style.width = "33%";
											}
											dojo.place(this.rightDropZoneIndicator, this.main.editorTabContainer.id);
											appDMS.updateAvatar(canDrop);
											dndManager.overDropZone = canDrop;
										}

									}else{

										this.removeDropZoneIndicator("right");

										if(sourceParent == "right")
											this.dropZone = "";
										else
											this.dropZone = "right";

										this.removeDummy(this.dropZone);
										if(canDrop && sourceParent != this.dropZone && this.dropZone !== "" &&
											this.main.rightTabs.getIndexOfChild(this.main.dummyContainer) == -1) {
											this.main.rightTabs.addChild(this.main.dummyContainer);
											appDMS.updateAvatar(canDrop);
											dndManager.overDropZone = canDrop;
										}
									}

								// dragging in the bottom 10% of the target
								}else if(e.clientY >= thresholdY90){

									this.removeDropZoneIndicator();
									this.removeDummy("all");

									// dragging in bottom left 10% corner. splits left side horizontally.
									if(e.clientX <= thresholdX10)
									{
										if(sourceParent === "right" && this.main.rightTabs.getChildren().length == 1)
											canDrop = false;

										if(canDrop)
										{
											this.dropZone = "bottomLeftCorner";
											this.splitDir = "h";
											this.createDropZoneIndicator("bottom");
//											this.bottomDropZoneIndicator.style.width = "50%";
											this.bottomDropZoneIndicator.style.width = this.main.sasSuiteTabContainer._contentBox.w + "px";
											appDMS.updateAvatar(canDrop);
											dndManager.overDropZone = canDrop;
										}

									// bottom right corner. splits rights side horizontally.
									}else if(e.clientX >= thresholdX90){

										if(sourceParent === "right" && this.main.rightTabs.getChildren().length == 1)
											canDrop = false;

										if(canDrop)
										{
											this.dropZone = "bottomRightCorner";
											this.splitDir = "h";
											this.createDropZoneIndicator("bottom");
											this.bottomDropZoneIndicator.style.cssFloat = "right";
											this.bottomDropZoneIndicator.style.width = "50%";
										}

									// bottom 10% outside the corners
									}else{
										if(canDrop){
											this.dropZone = "bottom";
											this.createDropZoneIndicator(this.dropZone);
										}
									}

									if(canDrop){
										dojo.place(this.bottomDropZoneIndicator, this.main.editorTabContainer.id);
										appDMS.updateAvatar(canDrop);
										dndManager.overDropZone = canDrop;
									}
								// dragging over main tab container (sasSuiteTabs)
								}else if((e.clientX >= this.mainTabsTargetBox.x && e.clientX < (this.mainTabsTargetBox.x + this.mainTabsTargetBox.w)) &&
										  (e.clientY >= this.mainTabsTargetBox.y && e.clientY < (this.mainTabsTargetBox.y + this.mainTabsTargetBox.h))){

									this.removeDropZoneIndicator();

									this.dropZone = "main";
									this.removeDummy(this.dropZone);

									if(sourceParent == this.dropZone)
									{
										dndManager.overDropZone = false;
										appDMS.updateAvatar(false);
									}

									if(sourceParent != this.dropZone &&
											this.main.sasSuiteTabContainer.getIndexOfChild(this.main.dummyContainer) == -1){
										this.main.sasSuiteTabContainer.addChild(this.main.dummyContainer);

										appDMS.updateAvatar(true);
										dndManager.overDropZone = true;
									}
								}

							/**
							 * Split horizontally once
							 */
							}else if(this.main.bottomTabs){
								if(this.bottomTargetBox == null)
									this.bottomTargetBox = domGeom.position(this.main.bottomTabs.domNode, false);

								//Dragging over bottom 10% drop zone outside of the bottom right and left corners
								if(e.clientY >= thresholdY90 && e.clientX < thresholdX90){// && e.clientX > thresholdX10){
									this.removeDropZoneIndicator("right");

									//cannot drag only tab from bottom tab container to 3 way stack drop zone
									if(sourceParent === "bottom" && this.main.bottomTabs.getChildren().length == 1)
										canDrop = false;

									if(canDrop)
									{
										this.dropZone = "bottom";
										this.splitDir = "3h";
										this.createDropZoneIndicator("bottom");
										this.bottomDropZoneIndicator.style.height = "33%";
										this.bottomDropZoneIndicator.style.top = (this.targetBox.h - (this.targetBox.h * 0.33)) + "px";
										dojo.place(this.bottomDropZoneIndicator, this.main.editorTabContainer.id);
										appDMS.updateAvatar(canDrop);
										dndManager.overDropZone = canDrop;
									}

								// bottom right corner 10%x10%
								}else if(e.clientX >= thresholdX90 && e.clientY >= thresholdY90){

									this.removeDropZoneIndicator("bottom");

									//cannot drag only tab from bottom tab container to 3 way stack drop zone
									if(sourceParent === "bottom" && this.main.bottomTabs.getChildren().length == 1)
										canDrop = false;

									if(canDrop)
									{
										this.dropZone = "bottomRightCorner";
										this.splitDir = "v";
										this.createDropZoneIndicator("right");
										this.rightDropZoneIndicator.style.top = (this.targetBox.h - (this.targetBox.h * 0.4)) + "px";
										this.rightDropZoneIndicator.style.height = "40%";
										dojo.place(this.rightDropZoneIndicator, this.main.editorTabContainer.id);
										appDMS.updateAvatar(canDrop);
										dndManager.overDropZone = canDrop;
									}

								// bottom left corner 10%x10%
//		 						}else if(e.clientX <= thresholdX10 && e.clientY >= thresholdY90){
//									this.removeDropZoneIndicator("bottom");
//									this.removeDummy("all");
//
//									//cannot drag only tab from bottom tab container to 3 way stack drop zone
//									if(sourceParent === "bottom" && this.main.bottomTabs.getChildren().length == 1)
//										canDrop = false;
//
//									if(canDrop)
//									{
//										this.dropZone = "bottomLeftCorner";
//										this.splitDir = "v";
//										this.createDropZoneIndicator("bottom");
//										this.bottomDropZoneIndicator.style.width = "50%";
//										dojo.place(this.bottomDropZoneIndicator, this.main.editorTabContainer.id);
//									}
								// top right corner 10%x10%
								}else if(e.clientY <= thresholdY10 && e.clientX >= thresholdX90){
									this.removeDropZoneIndicator("right");
									this.removeDummy("all");

									//cannot drag only tab from bottom tab container to 3 way stack drop zone
									if(sourceParent === "bottom" && this.main.bottomTabs.getChildren().length == 1)
										canDrop = false;

									if(canDrop)
									{
										this.dropZone = "topRightCorner";
										this.splitDir = "v";
										this.createDropZoneIndicator("right");
										this.rightDropZoneIndicator.style.height = (this.bottomTargetBox.y - this.mainTabsTargetBox.y -
																					this.main.bottomTabs._splitterWidget.h - 2) + "px";
										dojo.place(this.rightDropZoneIndicator, this.main.editorTabContainer.id);
										appDMS.updateAvatar(canDrop);
										dndManager.overDropZone = canDrop;
									}

								// dragging over the right 10% outside the corners
								}else if(e.clientY < thresholdY90 && e.clientY > thresholdY10 && e.clientX >= thresholdX90){
									this.dropZone = "right";
									this.removeDummy(this.dropZone);

									if(canDrop)
									{
										this.createDropZoneIndicator("right");
										dojo.place(this.rightDropZoneIndicator, this.main.editorTabContainer.id);
										appDMS.updateAvatar(canDrop);
										dndManager.overDropZone = canDrop;
									}

								//Dragging over bottom tabs container out side of dropzones
								}else if(e.clientY >= this.bottomTargetBox.y && e.clientX >= this.bottomTargetBox.x){

									this.removeDropZoneIndicator();

									if(sourceParent == "bottom")
										this.dropZone = "";
									else
										this.dropZone = "bottom";
									this.removeDummy(this.dropZone);
									if(canDrop && sourceParent != this.dropZone && this.dropZone !== "" &&
											this.main.bottomTabs.getIndexOfChild(this.main.dummyContainer) == -1){
										this.main.bottomTabs.addChild(this.main.dummyContainer);
										appDMS.updateAvatar(canDrop);
										dndManager.overDropZone = canDrop;
									}

								//Dragging over Main Tabs Container (sasSuiteTabs).
								}else if((e.clientX >= this.mainTabsTargetBox.x && e.clientX < (this.mainTabsTargetBox.x + this.mainTabsTargetBox.w)) &&
										  (e.clientY >= this.mainTabsTargetBox.y && e.clientY < (this.mainTabsTargetBox.y + this.mainTabsTargetBox.h))){

									this.removeDropZoneIndicator("right");

									this.dropZone = "main";
									this.removeDummy(this.dropZone);

									if(sourceParent == this.dropZone)
									{
										dndManager.overDropZone = false;
										appDMS.updateAvatar(false);
									}

									if(sourceParent != this.dropZone &&
											this.main.sasSuiteTabContainer.getIndexOfChild(this.main.dummyContainer) == -1){
										this.main.sasSuiteTabContainer.addChild(this.main.dummyContainer);
										appDMS.updateAvatar(true);
										dndManager.overDropZone = true;
									}
								}

							/**
							 * Not currently Split
							 */
							}else{

								// to avoid confusion make the bottom right
								// corner a non drop zone
								if(e.clientY >= thresholdY90 && e.clientX < thresholdX90)
								{
									this.dropZone = "bottom";

									this.removeDropZoneIndicator("right");

									if(canDrop)
									{
										this.createDropZoneIndicator("bottom");
										dojo.place(this.bottomDropZoneIndicator, this.main.editorTabContainer.id);
										appDMS.updateAvatar(canDrop);
										dndManager.overDropZone = canDrop;
									}

								}else if(e.clientX >= thresholdX90 && e.clientY < thresholdY90){
									this.dropZone = "right";

									this.removeDropZoneIndicator("bottom");

									if(canDrop)
									{
										this.createDropZoneIndicator("right");
										dojo.place(this.rightDropZoneIndicator, this.main.editorTabContainer.id);
										appDMS.updateAvatar(canDrop);
										dndManager.overDropZone = canDrop;
									}
								}else{
									this.removeDropZoneIndicator();
								}
							}
						}
					}
				},
				onMouseUp: function(e){
					if(this.isDragging)
					{
						var dndManager = Manager.manager();
						var sourceWidget = dijit.getEnclosingWidget(dndManager.nodes[0]);

						if(sourceWidget){
							var sourceContainer = null;
							if(sourceWidget.id.indexOf("sasSuiteTabContainer") > -1)
							{
								//dont want to drop on self.
								if(this.dropZone == "main")
									return;

								sourceContainer = this.main.sasSuiteTabContainer;
								if(sourceContainer.getChildren().length == 1) // if
																		// main
																		// tab
																		// container
																		// only
																		// has
																		// one
																		// tab,
																		// we
																		// don't
																		// want
																		// to
																		// remove
																		// it.
									return;
							}else if(sourceWidget.id.indexOf("bottomTabContainer") > -1){
								sourceContainer = this.main.bottomTabs;
							}else if(sourceWidget.id.indexOf("rightTabContainer") > -1){
								sourceContainer = this.main.rightTabs;
							}
							if(sourceContainer !== null){
								switch(this.dropZone)
								{
								case "bottom":
									this.main.dropTab(this.dropZone, this.splitDir, sourceWidget.page, sourceContainer);
									this.removeDropZoneIndicator("bottom");
									break;
								case "right":
									this.main.dropTab(this.dropZone, this.splitDir, sourceWidget.page, sourceContainer);
									this.removeDropZoneIndicator("right");
									break;
								case "bottomLeftCorner":
									this.main.dropTab(this.dropZone, this.splitDir, sourceWidget.page, sourceContainer);
									this.removeDropZoneIndicator();
									break;
								case "bottomRightCorner":
									this.main.dropTab(this.dropZone, this.splitDir, sourceWidget.page, sourceContainer);
									this.removeDropZoneIndicator();
									break;
								case "topRightCorner":
									this.main.dropTab(this.dropZone, this.splitDir, sourceWidget.page, sourceContainer);
									this.removeDropZoneIndicator();
									break;
								case "main":
									this.main.dropTab("", "", sourceWidget.page, sourceContainer);
									break;
								}
							}
							this.removeDummy("all");
							this.dropZone = ""; // reset dropZone
							this.splitDir = ""; // reset splitDir
						}
					}
				}
			});

			topic.subscribe("/dnd/start", lang.hitch(this, function(source, nodes, copy){
				if(nodes[0].sourceType == "clrTab_"+this.editorTabContainer.id)
					this.editorContentPaneTarget.getTargetBoxes();
			}));
			on(appDMS.splitter, 'mouseup', lang.hitch(this, this.onResize));

			this.addSplitterMouseUpListeners();

			dojo.connect(this.sasSuiteTabContainer, "addChild", function(child){
				if(!child.dummy)
				{
					dojo.forEach(this.tablist.containerNode.children, lang.hitch(this, function(node) {
						dojo.addClass(node, "dojoDndItem");
						node.sourceType = "clrTab_" + this.id.substr(0, this.id.indexOf("sasSuiteTabContainer"));
					}));
				}
			});

			dojo.forEach(this.sasSuiteTabContainer.tablist.containerNode.children, lang.hitch(this, function(node) {
				dojo.addClass(node, "dojoDndItem");
				node.sourceType = "clrTab_" + this.editorTabContainer.id;// codeLogResultsTab
			}));

			var sasSuiteTabListSource = new Source(this.sasSuiteTabContainer.tablist.containerNode, {
				withHandles: false,
				horizontal: true,
				delay: 5,
				autoSync: true,
				checkAcceptance: lang.hitch(this, function(source, nodes){
					if(nodes.length == 1)
					{
						var widgetId = dijit.getEnclosingWidget(nodes[0]).id;
						if(widgetId.indexOf(this.editorTabContainer.id + "sasSuiteTabContainer") > -1)
							return true;
					}else
						return false;
				})
			});

			//I have to do this so the this.sasSuiteTabContainer.getChildren() is sync'd...
			dojo.connect(sasSuiteTabListSource, "onDrop", lang.hitch(this, function(source, nodes){
				var dropItem = dijit.getEnclosingWidget(nodes[0]).page;
				var index = source.getAllNodes().indexOf(nodes[0]);
				this.sasSuiteTabContainer.removeChild(dropItem);
				this.sasSuiteTabContainer.addChild(dropItem, index);
				this.sasSuiteTabContainer.selectChild(dropItem);
			}));
		},
		dropTab:function(dropZone, splitDir, tab, container)
		{

			container.removeChild(tab);
			var height;
			switch(dropZone)
			{
			case "bottomLeftCorner":
				if(splitDir == "h")
				{
					this.destroyDNDBorderContainer();

					this.editorTabContainer.removeChild(this.sasSuiteTabContainer);
					this.addDNDBorderContainer("center", this.editorTabContainer);
					this.dndBC.addChild(this.sasSuiteTabContainer);

					if(this.bottomTabs)
					{
						this.editorTabContainer.removeChild(this.bottomTabs);
						this.dndBC.addChild(this.bottomTabs);
						this.bottomTabs.addChild(tab);
						this.bottomTabs.selectChild(tab, false);
//						this.saveTabPreferences();
					}else
						this.processDropTab("bottom", tab, this.dndBC);

				}else if(splitDir == "v"){

					this.destroyDNDBorderContainer();

					var topHeight = container._contentBox.h;

					this.editorTabContainer.removeChild(this.bottomTabs);
					this.editorTabContainer.removeChild(this.sasSuiteTabContainer);

					this.bottomTabs.region ="center";
					this.sasSuiteTabContainer.region = "top";
					domStyle.set(this.sasSuiteTabContainer.domNode, "height", topHeight+"px");

					//bottomTabs will only have 1 tab at this point.
					//If draggin from bottomTabs, the tab being dragged has already been removed.
					//need to relocate the last bottom tab to the right
					//since this operation shifts the current bottom tab to the right.
					var bottomChild = this.bottomTabs.getChildren()[0];
					this.bottomTabs.removeChild(bottomChild);
					this.bottomTabs.addChild(tab);

					this.editorTabContainer.addChild(this.sasSuiteTabContainer);
					this.editorTabContainer.addChild(this.bottomTabs);

					this.processDropTab("right", bottomChild, this.editorTabContainer);
				}
				break;
			case "bottomRightCorner":
				if(splitDir == "h")
				{

					this.destroyDNDBorderContainer();

					this.editorTabContainer.removeChild(this.rightTabs);
					this.addDNDBorderContainer("right", this.editorTabContainer);
					this.rightTabs.region = "center";
					this.dndBC.addChild(this.rightTabs);
					if(this.bottomTabs)
					{
						this.editorTabContainer.removeChild(this.bottomTabs);
						this.dndBC.addChild(this.bottomTabs);
						this.bottomTabs.addChild(tab);
						this.bottomTabs.selectChild(tab, false);
					}else
						this.processDropTab("bottom", tab, this.dndBC);

				}else if(splitDir == "v"){

					if(container == this.rightTabs)
						height = this.rightTabs._contentBox.h > this.sasSuiteTabContainer._contentBox.h ? this.sasSuiteTabContainer._contentBox.h : this.rightTabs._contentBox.h;
					else
						height = this.sasSuiteTabContainer._contentBox.h;

					this.destroyDNDBorderContainer();

					this.editorTabContainer.removeChild(this.bottomTabs);
					this.editorTabContainer.removeChild(this.sasSuiteTabContainer);

					this.bottomTabs.region ="center";
					this.sasSuiteTabContainer.region = "top";
					domStyle.set(this.sasSuiteTabContainer.domNode, "height", height+"px");

					this.editorTabContainer.addChild(this.sasSuiteTabContainer);
					this.editorTabContainer.addChild(this.bottomTabs);

					this.processDropTab("right", tab, this.editorTabContainer);
				}
				break;
			case "bottom":
				if(splitDir == "3h")
				{
					this.destroyDNDBorderContainer();

					height = this.editorTabContainer._contentBox.h/3 + "px";
					this.editorTabContainer.removeChild(this.sasSuiteTabContainer);
					this.editorTabContainer.removeChild(this.bottomTabs);

					this.sasSuiteTabContainer.region = "top";
					this.bottomTabs.region = "center";

					if(this.rightTabs)
						this.editorTabContainer.removeChild(this.rightTabs);

					this.processDropTab("right", tab, null);

					this.rightTabs.region = "bottom"; // i know its weird.
					domStyle.set(this.rightTabs.domNode, "width", "100%");
					domStyle.set(this.rightTabs.domNode, "height", height);
					domStyle.set(this.sasSuiteTabContainer.domNode, "height", height);
					domStyle.set(this.bottomTabs.domNode, "height", height);

					this.editorTabContainer.addChild(this.sasSuiteTabContainer);
					this.editorTabContainer.addChild(this.bottomTabs);
					this.editorTabContainer.addChild(this.rightTabs);
				}else if(splitDir === ""){

					this.destroyDNDBorderContainer();

					//if region is right then we need to treat bottomTabs as rightTabs.
					if(this.rightTabs && this.rightTabs.region == "bottom")
					{

						if(container.id == this.bottomTabs.id){
							var rightTab = this.rightTabs.getChildren()[0];
							this.rightTabs.removeChild(rightTab);
						}

						this.resetRegions(this.rightTabs);

						if(this.rightTabs._splitterWidget)
							this.rightTabs._splitterWidget.destroy();
						this.rightTabs.destroy();
						this.rightTabs = null;
						container = null;

						if(rightTab)
							this.bottomTabs.addChild(rightTab);
						this.bottomTabs.addChild(tab);
						this.bottomTabs.selectChild(tab);
					}else{

						if(this.sasSuiteTabContainer.region != "center")
							this.resetRegions(container);

						this.processDropTab("bottom", tab, this.editorTabContainer);
					}

				}
				break;
			case "right":
				if(splitDir == "3v")
				{
					this.destroyDNDBorderContainer();

					var width = this.editorTabContainer._contentBox.w/3 + "px";
					this.editorTabContainer.removeChild(this.sasSuiteTabContainer);
					this.editorTabContainer.removeChild(this.rightTabs);

					this.sasSuiteTabContainer.region = "left";
					this.rightTabs.region = "center";

					if(this.bottomTabs)
						this.editorTabContainer.removeChild(this.bottomTabs);

					this.processDropTab("bottom", tab, null);

					this.bottomTabs.region = "right";
					domStyle.set(this.rightTabs.domNode, "width", width);
					domStyle.set(this.sasSuiteTabContainer.domNode, "width", width);
					domStyle.set(this.bottomTabs.domNode, "width", width);

					this.editorTabContainer.addChild(this.sasSuiteTabContainer);
					this.editorTabContainer.addChild(this.bottomTabs);
					this.editorTabContainer.addChild(this.rightTabs);
				}else if(splitDir === ""){

					this.destroyDNDBorderContainer();
					//this only occurs in a 3 way vertical split
					if(this.bottomTabs && this.bottomTabs.region == "right")
					{
						if(container.id == this.rightTabs.id){
							var bottomTab = this.bottomTabs.getChildren()[0];
							this.bottomTabs.removeChild(bottomTab);
						}
						this.resetRegions(this.bottomTabs);

						if(this.bottomTabs._splitterWidget)
							this.bottomTabs._splitterWidget.destroy();
						this.bottomTabs.destroy();
						this.bottomTabs = null;
						container = null;

						if(bottomTab)
							this.rightTabs.addChild(bottomTab);
						this.rightTabs.addChild(tab);
						this.rightTabs.selectChild(tab);
					}else{

						if(this.sasSuiteTabContainer.region != "center")
							this.resetRegions(container);

						//if bottomTabs doesn't exist or the tab being dropped is the last tab in bottomTabs
						if(!this.bottomTabs || (container == this.bottomTabs && this.bottomTabs.getChildren().length === 0))
							this.processDropTab("right", tab, this.editorTabContainer);
						//else we are dragging from main or bottomTabs with 2 tabs
						else{
							this.editorTabContainer.removeChild(this.sasSuiteTabContainer);
							this.editorTabContainer.removeChild(this.bottomTabs);
							this.addDNDBorderContainer("center", this.editorTabContainer);
							this.dndBC.addChild(this.sasSuiteTabContainer);
							this.dndBC.addChild(this.bottomTabs);
							this.processDropTab("right", tab, this.editorTabContainer);
						}
					}
				}
				break;
			case "topRightCorner":
				if(splitDir == "v")
				{
					this.destroyDNDBorderContainer();

					this.processDropTab("right", tab, this.editorTabContainer);

				}else{

					var botHeight = null;
					if(this.bottomTabs)
						botHeight = this.bottomTabs._contentBox.h + "px";

					this.destroyDNDBorderContainer();

					if(this.sasSuiteTabContainer.region != "center")
						this.resetRegions(container);
					else{
						this.editorTabContainer.removeChild(this.rightTabs);

						if(this.bottomTabs)
							this.editorTabContainer.removeChild(this.bottomTabs);
					}

					this.editorTabContainer.removeChild(this.rightTabs);
					this.addDNDBorderContainer("right", this.editorTabContainer);

					var curRightTab = this.rightTabs.getChildren()[0];
					this.rightTabs.removeChild(curRightTab);

					this.processDropTab("right", tab, null);
					this.processDropTab("bottom", curRightTab, null);
					this.rightTabs.region = "center";
					this.bottomTabs.region = "bottom";
					if(botHeight)
						domStyle.set(this.bottomTabs.domNode, "height", botHeight);
					this.dndBC.addChild(this.rightTabs);
					this.dndBC.addChild(this.bottomTabs);

				}
				break;
			case "": //dropping on main tab container(sasSuiteTabContainer)

				this.destroyDNDBorderContainer();

				if(this.sasSuiteTabContainer.region != "center")
					this.resetRegions(container);

				this.processDropTab("", tab, null);
				break;
			}

			// resize the editor
			this.onResize();
			this.editor.activate();
			this.editorActive = true;

			// no more tabs? destroy!
			if(container && container.getChildren().length === 0)
			{
				if(container == this.rightTabs)
					this.rightTabs = null;
				else if(container == this.bottomTabs)
					this.bottomTabs = null;

				if(container._splitterWidget)
					container._splitterWidget.destroy();
				container.destroy();
				this.editorTabContainer.resize();
			}

			this.addSplitterMouseUpListeners();

			this.saveTabPreferences();

		},
		addSplitterMouseUpListeners: function()
		{
			//sigh
			if(this.sasSuiteTabContainer._splitterWidget){
					on(this.sasSuiteTabContainer._splitterWidget, "click", lang.hitch(this, this.onSplitterMouseUp));
					on(this.sasSuiteTabContainer._splitterWidget, "mouseup", lang.hitch(this, this.onSplitterMouseUp));
			}

			if(this.bottomTabs && this.bottomTabs._splitterWidget){
					on(this.bottomTabs._splitterWidget, "click", lang.hitch(this, this.onSplitterMouseUp));
					on(this.bottomTabs._splitterWidget, "mouseup", lang.hitch(this, this.onSplitterMouseUp));
			}
			if(this.rightTabs && this.rightTabs._splitterWidget){
					on(this.rightTabs._splitterWidget.domNode, "click", lang.hitch(this, this.onSplitterMouseUp));
					on(this.rightTabs._splitterWidget.domNode, "mouseup", lang.hitch(this, this.onSplitterMouseUp));
			}
			if(this.dndBC && this.dndBC._splitterWidget)
			{
					on(this.dndBC._splitterWidget, "click", lang.hitch(this, this.onSplitterMouseUp));
					on(this.dndBC._splitterWidget, "mouseup", lang.hitch(this, this.onSplitterMouseUp));
			}
		},
		resetRegions: function(sourceContainer)
		{
			//remove all children from editorTabContainer.
			if(this.bottomTabs)
			{
				if(this.editorTabContainer.getIndexOfChild(this.bottomTabs) > -1)
					this.editorTabContainer.removeChild(this.bottomTabs);
			}

			if(this.rightTabs)
			{
				if(this.editorTabContainer.getIndexOfChild(this.rightTabs)>-1)
					this.editorTabContainer.removeChild(this.rightTabs);
			}

			//sasSuiteTabContainer is always a child
			this.editorTabContainer.removeChild(this.sasSuiteTabContainer);

			this.sasSuiteTabContainer.region = "center";
			this.editorTabContainer.addChild(this.sasSuiteTabContainer);

			if(this.bottomTabs && sourceContainer != this.bottomTabs)
				this.addTabContainer("bottom", this.editorTabContainer);

			if(this.rightTabs && sourceContainer != this.rightTabs)
				this.addTabContainer("right", this.editorTabContainer);
		},
		processDropTab: function(region, tab, parentContainer){

			var container;
			switch(region)
			{
			case "bottom":
				this.addTabContainer(region, parentContainer);
				container = this.bottomTabs;
				break;
			case "right":
				this.addTabContainer(region, parentContainer);
				container = this.rightTabs;
				break;
			case "":
				container = this.sasSuiteTabContainer;
				break;
			}

			if(container.getIndexOfChild(this.dummyContainer)>-1)
				container.removeChild(this.dummyContainer);

			container.addChild(tab);
			container.selectChild(tab, false);
		},
		destroyDNDBorderContainer: function()
		{
			if(this.dndBC)
			{
				var right = false;
				if(this.dndBC.region == "center")
				{
					this.dndBC.removeChild(this.sasSuiteTabContainer);
				}else if(this.dndBC.region == "right"){
					right = true;
					this.dndBC.removeChild(this.rightTabs);
				}

				//dndBC will always contain this.bottomTabs
				this.dndBC.removeChild(this.bottomTabs);
				this.editorTabContainer.removeChild(this.dndBC);

				if(this.dndBC._splitterWidget)
					this.dndBC._splitterWidget.destroy();
				this.dndBC.destroy();
				this.dndBC = null;

				if(right)
				{
					this.rightTabs.region = "right";
					this.editorTabContainer.addChild(this.rightTabs);

				}else{
					this.editorTabContainer.addChild(this.sasSuiteTabContainer);
				}

//				//don't want to leave the bottomTabs hangin..
				this.bottomTabs.region = "bottom";
				this.editorTabContainer.addChild(this.bottomTabs);

			}
		},
		addDNDBorderContainer: function(/*String*/region, /*Container*/parent)
		{
			this.dndBC = new BorderContainer({
				style:"width:50%;height:100%",
				id: this.editorTabContainer.id + "_dndBC",
				region: region,
				splitter:true,
				gutters: true
			});
			if(parent)
				parent.addChild(this.dndBC);
			this.dndBC.startup();
		},
		addTabContainer: function(/*String*/tabContainer, /*Container*/parent)
		{
			//only needed when the tabs are split.
			on(this.sasSuiteTabContainer.domNode, 'click', lang.hitch(this, function(){
				this.onTabSelect(this.sasSuiteTabContainer.selectedChildWidget);
			}));

			switch(tabContainer)
			{
			case "right":
				if (this.rightTabs == null){
					this.rightTabs = new dijit.layout.TabContainer({
						style:"width: 50%;",
						id: this.editorTabContainer.id + '_rightTabContainer',
						"class":"sasSuiteTabs",
						region:"right",
						splitter:true,
						gutters: true
					}, "tc1-prog");

					dojo.connect(this.rightTabs, "addChild", function(child){
						if(!child.dummy)
						{
							dojo.forEach(this.tablist.containerNode.children, lang.hitch(this, function(node) {
								dojo.addClass(node, "dojoDndItem");
								node.sourceType = "clrTab_" + this.id.substr(0, this.id.indexOf("_rightTabContainer"));
							}));
						}
					});

					this.rightTabContainerTabListSource = new Source(this.rightTabs.tablist.containerNode,{
						withHandles:false,
						horizontal: true,
						delay: 5,
						autoSync: true,
						checkAcceptance: lang.hitch(this, function(source, nodes){
							if(nodes.length == 1)
							{
								var widgetId = dijit.getEnclosingWidget(nodes[0]).id;
								if(widgetId.indexOf(this.editorTabContainer.id + "_rightTabContainer") > -1)
									return true;
							}else
								return false;
						})
					});

					dojo.connect(this.rightTabContainerTabListSource, "onDrop", lang.hitch(this, function(source, nodes){
						var dropItem = dijit.getEnclosingWidget(nodes[0]).page;
						var index = source.getAllNodes().indexOf(nodes[0]);
						this.rightTabs.removeChild(dropItem);
						this.rightTabs.addChild(dropItem, index);
						this.rightTabs.selectChild(dropItem);
					}));

					dojo.connect(this.rightTabs, "selectChild",lang.hitch(this, this.onTabSelect));
					if(this.rightTabs._splitterWidget)
						on(this.rightTabs._splitterWidget, "mouseup",lang.hitch(this, this.onSplitterMouseUp));

					this.rightTabs.startup();

					on(this.rightTabs.domNode, 'click', lang.hitch(this, function(){
						this.onTabSelect(this.rightTabs.selectedChildWidget);
					}));
				}

				if(this.rightTabs._splitterWidget){
					if(dojo.isIE)
						on(this.rightTabs._splitterWidget, "click",lang.hitch(this, this.onSplitterMouseUp));
					else
						on(this.rightTabs._splitterWidget, "mouseup",lang.hitch(this, this.onSplitterMouseUp));
				}

				//set styles and region back to default.
				this.rightTabs.region = "right";
				domStyle.set(this.rightTabs.domNode, {
					width: "50%",
					height: "100%"
				});

				if(parent && parent.getIndexOfChild(this.rightTabs) == -1)
					parent.addChild(this.rightTabs);
				break;
			case "bottom":
				if (this.bottomTabs == null){
					this.bottomTabs = new dijit.layout.TabContainer({
						style:"width: 100%;height:40%",
						id: this.editorTabContainer.id + '_bottomTabContainer',
						"class":"sasSuiteTabs bottomArea",
						region:"bottom",
						splitter:true,
						gutters: true
					}, "tc1-prog");

					dojo.connect(this.bottomTabs, "addChild", function(child){
						if(!child.dummy)
						{
							dojo.forEach(this.tablist.containerNode.children, lang.hitch(this, function(node) {
								dojo.addClass(node, "dojoDndItem");
								node.sourceType = "clrTab_" + this.id.substr(0, this.id.indexOf("_bottomTabContainer"));
							}));
						}
					});

					this.bottomTabContainerTabListSource = new Source(this.bottomTabs.tablist.containerNode,{
						withHandles:false,
						horizontal: true,
						delay: 5,
						autoSync: true,
						checkAcceptance: lang.hitch(this, function(source, nodes){
							if(nodes.length == 1)
							{
								var widgetId = dijit.getEnclosingWidget(nodes[0]).id;
								if(widgetId.indexOf(this.editorTabContainer.id + "_bottomTabContainer") > -1)
									return true;
							}else
								return false;
						})
					});

					dojo.connect(this.bottomTabContainerTabListSource, "onDrop", lang.hitch(this, function(source, nodes){
						var dropItem = dijit.getEnclosingWidget(nodes[0]).page;
						var index = source.getAllNodes().indexOf(nodes[0]);
						this.bottomTabs.removeChild(dropItem);
						this.bottomTabs.addChild(dropItem, index);
						this.bottomTabs.selectChild(dropItem);
					}));

					dojo.connect(this.bottomTabs, "selectChild",lang.hitch(this, this.onTabSelect));


					if(this.bottomTabs._splitterWidget){
						if(dojo.isIE)
							on(this.bottomTabs._splitterWidget, "click",lang.hitch(this, this.onSplitterMouseUp));
						else
							on(this.bottomTabs._splitterWidget, "mouseup",lang.hitch(this, this.onSplitterMouseUp));
					}
					this.bottomTabs.startup();

					on(this.bottomTabs.domNode, 'click', lang.hitch(this, function(){
						this.onTabSelect(this.bottomTabs.selectedChildWidget);
					}));
				}

				//set styles and region back to default.
				this.bottomTabs.region = "bottom";
				domStyle.set(this.bottomTabs.domNode, {
					width: "100%",
					height: "40%"
				});

				if(parent && parent.getIndexOfChild(this.bottomTabs) == -1)
					parent.addChild(this.bottomTabs);
				break;
			}

		},
		onSplitterMouseUp:function()
		{
			this.saveTabPreferences();
			this.onResize();
			this.resizeEnhancedLog();
		},
		saveTabPreferences: function()
		{
			this.tabPrefrences= this.appDMS.tabPrefrences;
			if (this.taskMode)
			{
				tabName= this.task.uri;
			} else
			{
				tabName= this.uri;
			}
			if (!this.tabPrefrences[tabName]){
				this.tabPrefrences[tabName]={};
			}
			this.tabPrefrences[tabName].clrTabs = {};

			this.tabPrefrences[tabName].clrTabs.mainTabs = [];

			this.tabPrefrences[tabName].clrTabs.parentDimensions = this.editorTabContainer._contentBox;

			if(this.dndBC)
				this.tabPrefrences[tabName].clrTabs.dndBCRegion = this.dndBC.region;

			var mainTabs = this.sasSuiteTabContainer.getChildren();
			for(var i=0; i<mainTabs.length; i++) {
				if(mainTabs[i].type=="data") //do not persist output data tab.
					continue;
				this.tabPrefrences[tabName].clrTabs.mainTabs[i] = mainTabs[i].type;
			}

			this.tabPrefrences[tabName].clrTabs.sasSuiteTabsRegion = this.sasSuiteTabContainer.region;

			this.tabPrefrences[tabName].clrTabs.sasSuiteTabsParentID = this.sasSuiteTabContainer.getParent().id;

			this.tabPrefrences[tabName].clrTabs.mainTabDimensions = this.sasSuiteTabContainer._contentBox;

			if(this.bottomTabs && this.bottomTabs !=null && this.bottomTabs.hasChildren())
			{
				var bottomTabsChildren = this.bottomTabs.getChildren();
				if(!(bottomTabsChildren.length==1 && bottomTabsChildren[0].type == "data")){//do not persist output data tab.
					this.tabPrefrences[tabName].clrTabs.bottomTabs = [];

					for(i=0; i<bottomTabsChildren.length;i++)
					{
						this.tabPrefrences[tabName].clrTabs.bottomTabs[i] = bottomTabsChildren[i].type;
					}
					this.tabPrefrences[tabName].clrTabs.bottomTabsRegion = this.bottomTabs.region;
					this.tabPrefrences[tabName].clrTabs.bottomTabsParentID = this.bottomTabs.getParent().id;
					this.tabPrefrences[tabName].clrTabs.bottomTabDimensions = this.bottomTabs._contentBox;
				}
			}

			if(this.rightTabs && this.rightTabs !=null && this.rightTabs.hasChildren())
			{
				var rightTabsChildren = this.rightTabs.getChildren();
				if(!(rightTabsChildren.length==1 && rightTabsChildren[0].type == "data")){//do not persist output data tab.
					this.tabPrefrences[tabName].clrTabs.rightTabs = [];

					for(i=0;i<rightTabsChildren.length;i++)
					{
						this.tabPrefrences[tabName].clrTabs.rightTabs[i] = rightTabsChildren[i].type;
					}

					this.tabPrefrences[tabName].clrTabs.rightTabsRegion = this.rightTabs.region;
					this.tabPrefrences[tabName].clrTabs.rightTabsParentID = this.rightTabs.getParent().id;
					this.tabPrefrences[tabName].clrTabs.rightTabDimensions = this.rightTabs._contentBox;
				}
			}

			if(this.dndBC)
				this.tabPrefrences[tabName].clrTabs.dndBCDimensions = this.dndBC._contentBox;

			appDMS.setPreference("SWE.tabPrefrences", JSON.stringify(this.tabPrefrences));
			appDMS.setPreference("SWE.CLRTabs", JSON.stringify(this.tabPrefrences[tabName].clrTabs));
		},
		rearrangeTabs:function(/*JSON Obj*/tabPrefs)
		{
			var i,k;
			if(tabPrefs && tabPrefs.mainTabs)
			{
				var editorTabContainerChildren= this.editorTabContainer.getChildren();
				for (k=0; k<editorTabContainerChildren.length; k++)
				{
					if (editorTabContainerChildren[k].id.indexOf("taskContainer")===-1 && editorTabContainerChildren[k].id.indexOf("toolbarBC")===-1){
						this.editorTabContainer.removeChild(editorTabContainerChildren[k]);
					}
				}
				//this.editorTabContainer.removeChild(this.sasSuiteTabContainer);
				this.sasSuiteTabContainer.region = tabPrefs.sasSuiteTabsRegion;

				if(tabPrefs.rightTabs)
				{
					this.addTabContainer("right", null);
					this.rightTabs.region = tabPrefs.rightTabsRegion;
					for(i=0; i < tabPrefs.rightTabs.length; i++)
					{
						switch(tabPrefs.rightTabs[i])
						{
						case "editor":
							this.sasSuiteTabContainer.removeChild(this.editContentPane);
							this.rightTabs.addChild(this.editContentPane);
							this.rightTabs.selectChild(this.editContentPane);
							break;
						case "log":
							this.logContentPane.getParent().removeChild(this.logContentPane);
							//this.sasSuiteTabContainer.removeChild(this.logContentPane);
							this.rightTabs.addChild(this.logContentPane);
							break;
						case "output":
							this.outputContentPane.getParent().removeChild(this.outputContentPane);
							//this.sasSuiteTabContainer.removeChild(this.outputContentPane);
							this.rightTabs.addChild(this.outputContentPane);
							break;
						}
					}
				}

				if(tabPrefs.bottomTabs)
				{
					this.addTabContainer("bottom", null);
					this.bottomTabs.region = tabPrefs.bottomTabsRegion;
					for(i=0; i < tabPrefs.bottomTabs.length; i++)
					{
						switch(tabPrefs.bottomTabs[i])
						{
						case "editor":
							this.sasSuiteTabContainer.removeChild(this.editContentPane);
							this.bottomTabs.addChild(this.editContentPane);
							this.bottomTabs.selectChild(this.editContentPane);
							break;
						case "log":
							this.logContentPane.getParent().removeChild(this.logContentPane);
							//this.sasSuiteTabContainer.removeChild(this.logContentPane);
							this.bottomTabs.addChild(this.logContentPane);
							break;
						case "output":
							this.outputContentPane.getParent().removeChild(this.outputContentPane);
							//this.sasSuiteTabContainer.removeChild(this.outputContentPane);
							this.bottomTabs.addChild(this.outputContentPane);
							break;
						}
					}
				}

				if(tabPrefs.mainTabs)
				{
					for(i=0; i < tabPrefs.mainTabs.length; i++)
					{
						switch(tabPrefs.mainTabs[i])
						{
						case "editor":
							this.sasSuiteTabContainer.selectChild(this.editContentPane);
							break;
						}
					}
				}

				if(tabPrefs.dndBCRegion)
					this.addDNDBorderContainer(tabPrefs.dndBCRegion, null);

				if(tabPrefs.mainTabDimensions)
				{
					if(tabPrefs.parentDimensions)
					{
						domStyle.set(this.sasSuiteTabContainer.domNode, "width", (tabPrefs.mainTabDimensions.w / tabPrefs.parentDimensions.w) * 100 + "%");
						domStyle.set(this.sasSuiteTabContainer.domNode, "height", (tabPrefs.mainTabDimensions.h / tabPrefs.parentDimensions.h) * 100 +"%");
					}else{
						domStyle.set(this.sasSuiteTabContainer.domNode, "width", tabPrefs.mainTabDimensions.w+ "px");
						domStyle.set(this.sasSuiteTabContainer.domNode, "height", tabPrefs.mainTabDimensions.h+ "px");
					}
				}

				if(tabPrefs.sasSuiteTabsParentID && tabPrefs.sasSuiteTabsParentID.indexOf("_dndBC")>-1)
					this.dndBC.addChild(this.sasSuiteTabContainer);
				else
					this.editorTabContainer.addChild(this.sasSuiteTabContainer);

				if(this.bottomTabs)
				{

					if(tabPrefs.bottomTabDimensions)
					{
						if(tabPrefs.parentDimensions)
						{
							domStyle.set(this.bottomTabs.domNode, "width", (tabPrefs.bottomTabDimensions.w / tabPrefs.parentDimensions.w) * 100 + "%");
							domStyle.set(this.bottomTabs.domNode, "height", (tabPrefs.bottomTabDimensions.h / tabPrefs.parentDimensions.h) * 100 +"%");
						}else{
							domStyle.set(this.bottomTabs.domNode, "width", tabPrefs.bottomTabDimensions.w+ "px");
							domStyle.set(this.bottomTabs.domNode, "height", tabPrefs.bottomTabDimensions.h+ "px");
						}
					}

					if(tabPrefs.bottomTabsParentID && tabPrefs.bottomTabsParentID.indexOf("_dndBC")>-1){
						this.dndBC.addChild(this.bottomTabs);
					}else if ((this.bottomTabs.getChildren().length) !== 0){
						this.editorTabContainer.addChild(this.bottomTabs);
					}
				}

				if(this.rightTabs)
				{
					if(tabPrefs.rightTabDimensions)
					{
						if(tabPrefs.parentDimensions)
						{
							domStyle.set(this.rightTabs.domNode, "width", (tabPrefs.rightTabDimensions.w / tabPrefs.parentDimensions.w) * 100 + "%");
							domStyle.set(this.rightTabs.domNode, "height", (tabPrefs.rightTabDimensions.h / tabPrefs.parentDimensions.h) * 100 +"%");
						}else{
							domStyle.set(this.rightTabs.domNode, "width", tabPrefs.rightTabDimensions.w+ "px");
							domStyle.set(this.rightTabs.domNode, "height", tabPrefs.rightTabDimensions.h+ "px");
						}
					}

					if(tabPrefs.rightTabsParentID && tabPrefs.rightTabsParentID.indexOf("_dndBC")>-1){
						this.dndBC.addChild(this.rightTabs);
					}else if ((this.rightTabs.getChildren().length) !== 0){
						this.editorTabContainer.addChild(this.rightTabs);
					}
				}

				if(this.dndBC)
					this.editorTabContainer.addChild(this.dndBC);

				this.addSplitterMouseUpListeners();

				this.editor.activate();
				this.editorActive = true;

			}//if tabPrefs
		},
		openOutput: function (event)
		{
			appDMS.outputDialog.hide();
			var selectedProgram = appDMS.tabs.getFocusedTab();
			if (selectedProgram.editor.dataURL!=null)
			{
				if (this.iframe==null)
				{
					this.iframe = document.createElement("iframe");
					this.iframe.setAttribute('style', 'visibility:hidden');
					dojo.body().appendChild(this.iframe);
				}
				this.iframe.src=encodeDoubleSlashesInURL(selectedProgram.editor.dataURL);
			}
		},
		openOutputCancel: function (event)
		{
			appDMS.outputDialog.hide();
		},

		openBigOutput: function (event)
		{
			appDMS.outputWarningDialog.hide();
			var selectedProgram = appDMS.tabs.getFocusedTab();
			if (selectedProgram.editor.currentSubmission!=null)
			{
//				var url="./sasexec/submissions/" + appDMS.tabs.tabs[appDMS.tabs.selectedIndex].editor.currentSubmission.id + "/results";
//				appDMS.tabs.tabs[appDMS.tabs.selectedIndex].editor.resultsURL=url;
//				appDMS.tabs.tabs[appDMS.tabs.selectedIndex].editor.submitStack[appDMS.tabs.tabs[appDMS.tabs.selectedIndex].editor.submitStack.length - 1].resultsURL = url;
//				appDMS.tabs.tabs[appDMS.tabs.selectedIndex].editor.outputAreaContentPane.set('href', url);
				var url="./sasexec/submissions/" + selectedProgram.editor.currentSubmission.id + "/results";
				selectedProgram.editor.resultsURL=url;
				selectedProgram.editor.submitStack[selectedProgram.editor.submitStack.length - 1].resultsURL = url;
				selectedProgram.editor.outputAreaContentPane.set('href', url);
			}
		},
		openBigOutputCancel: function (event)
		{
			appDMS.outputWarningDialog.hide();
			var selectedProgram = appDMS.tabs.getFocusedTab();
//			if (appDMS.tabs.tabs[appDMS.tabs.selectedIndex].editor.currentSubmission!=null)
//			{
//				appDMS.tabs.tabs[appDMS.tabs.selectedIndex].editor.resultsURL="./toobig";
//				appDMS.tabs.tabs[appDMS.tabs.selectedIndex].editor.outputAreaContentPane.set('href', "./toobig");
//			}
			if (selectedProgram.editor.currentSubmission!=null)
			{
				var url="./sasexec/submissions/" + selectedProgram.editor.currentSubmission.id + "/results";
				selectedProgram.editor.resultsURL=url;
				selectedProgram.editor.outputAreaContentPane.set('href', "./toobig");
			}
		},
		setEditContent: function(editorContent)
		{
			if (this.editor)
			{
				this.editor.clear();
				this.editor.insert(editorContent);
			}
			else
			{
				this.editorContent = editorContent;
			}
			this.setButtonStates();
		},

		createDataTab: function (tables)
		{
		    if (this.sasSuiteTabContainer != null) {
		        if (this.dataContentPane == null) {
		            this.dataContentPane = new BorderContainer({
		                type: "data",
		                region: "center",
		                id: this.editorTabContainer.id + 'data',
		                title: this.resourceBundle.dataTitle,
		                gutters: true
		            });

		            this.sasSuiteTabContainer.addChild(this.dataContentPane);
		        }
		    }

            // initialize the view
		    this.loadData(tables);
		},

		removeDataTab: function () {
		    if (this.dataContentPane != null) {
		        var parentTabContainer = this.dataContentPane.getParent();
		        parentTabContainer.removeChild(this.dataContentPane);
		        this.dataContentPane.destroy();
		        this.dataContentPane = null;
		        this.dataView = null;

		        var tabs = parentTabContainer.getChildren();
		        if (tabs.length == 0) {
		            if (this.bottomTabs != null) {
		                var children = this.bottomTabs.getChildren();
		                if (children.length == 0) {
		                    if (this.bottomTabs._splitterWidget)
		                        this.bottomTabs._splitterWidget.destroy();
		                    this.bottomTabs.destroy();
		                    this.bottomTabs = null;
		                }
		            }
		            if (this.rightTabs != null) {
		                var children = this.rightTabs.getChildren();
		                if (children.length == 0) {
		                    if (this.rightTabs._splitterWidget)
		                        this.rightTabs._splitterWidget.destroy();
		                    this.rightTabs.destroy();
		                    this.rightTabs = null;
		                }
		            }
		        }

		        this.editorTabContainer.resize();
		    }
		},

		clearData: function () {
		    if (this.dataView != null) {
		        this.dataView.clearTables();
		        this.dataView.disableGrid();
		    }
		},

		// function modified for SAS9-44523
		loadData: function (tables) {
			var self = this;
			
			if (!this.dataContentPane || !tables || tables.length === 0) return;
	
			// Clear old content
			var clearContent = function(){
				var children = self.dataContentPane.getChildren();
				if (children != null) {
				    for (var i = 0; i < children.length; i++) {
				        self.dataContentPane.removeChild(children[i]);
				    }
				}
			};
			clearContent();
			var sessionId = this.sessionId;
			var appDMS = this.appDMS;
			var tabObj = this.object;
			var holder = this.dataContentPane;

				
			// Recursive function that tries to load one table at a time for defect-SAS9-33189
			function tryTable(index) {
				clearContent();
				if (index >= tables.length) {
					msg = self.resourceBundle.noTables;
					appDMS.dialogs.postFaultDialog(msg);
					return;
				}
	
				var tableInfo = tables[index];
				var library = tableInfo.library;
				var table = tableInfo.member;
	
				try {
					var dataView = new DMSQuery(sessionId, library, table, tables, false, appDMS, tabObj, true, true);
	
					self.dataView = dataView;
					dataView.mainTableBorderContainer.region = "center";
					holder.addChild(dataView.mainTableBorderContainer);
					dataView.container = holder;
					holder.resize();
					
					dataView.onGridLoadFail = function () {
						//console.error("Failed loading data for library=" + library + " table=" + table);
						// Remove the failed entry from the tables array
						tables.splice(index, 1);
						// Try the next index (same index now refers to next item after splice)
						tryTable(index);
					};
	
					dataView.openGridInContainer(holder);
				} catch (e) {
					console.error("Error loading data for library=" + library + " table=" + table);
					// Remove and try next
					tables.splice(index, 1);
					tryTable(index);
				}
			}
	
			tryTable(0);
		},

		createOutputTab: function()
		{
			this.createOutputToolbar();
			this.outputContentPane = new BorderContainer({
				id: this.editorTabContainer.id + 'output',
				type: "output",
				gutters: false,
				title: this.resourceBundle.resultsTitle
			});
// title: "Results"});
			var cp1 = new ContentPane({
				region: "top",
				style: "width:100%; padding-top:0px; padding-left:0px; padding-right:0px; padding-bottom:0px",
				content: this.outputToolbar.domNode
			});

			this.outputContentPane.addChild(cp1);
			
			var tocEval=function()
  			{
  				setTimeout(lang.hitch(this,this.resizeTOC),0);
  			}
			this.resultsList = new dijit.TitlePane({
				style: "padding-left:0px; padding-right:0px; padding-bottom:11px; width:100%;max-height: 33%",
				layoutPriority: "2",
				title: this.resourceBundle.tableOfContents,
				region: "top",
				// content: this.logTree,
				duration: 0,
				open: false,
				onShow: lang.hitch(this, tocEval)
			});
			domClass.add(this.resultsList.hideNode, "sasResultsTOC sasTOCDropDown")
			on(this.resultsList, "click", lang.hitch(this, function(event){
				this.outputContentPane.layout();
			}));
			
			this.outputContentPane.addChild(this.resultsList);

			this.outputAreaContentPane = new dijit.layout.ContentPane({
				title: this.resourceBundle.resultsTitle,
				style: "padding-left:0px; padding-right:0px;",
				region: "center",
				preventCache: true,
				preLoad: true
			});
			this.outputContentPane.addChild(this.outputAreaContentPane);

			this.sasSuiteTabContainer.addChild(this.outputContentPane);

			this.outputContentPane.startup();
			on(this.outputAreaContentPane, 'load', lang.hitch(this, this.outputLoaded));
		},
		outputLoaded: function()
		{
			if (this.mode=="interactive")
			{
				if (this.oldLength > 0 && this.oldLength!=this.outputAreaContentPane.domNode.innerHTML.length)
				{
					this.selectTab(this.outputContentPane);
				}
				this.oldLength=this.outputAreaContentPane.domNode.innerHTML.length;

				var scroll=function()
				{
					this.outputAreaContentPane.domNode.scrollTop=this.outputAreaContentPane.domNode.scrollHeight;
				};

				setTimeout(lang.hitch(this,scroll),20);
				
				try
				{
					var body=this.outputAreaContentPane.domNode.getElementsByClassName("c body")[0];
					this.resultsTOC=buildTOC(body);
					//console.log(this.resultsTOC);
					this.createTOCTree(this.resultsTOC);
				}
				catch(e)
				{
					console.log(e);
					console.log("Error building table of contents for HTML5 results.");
				}
				
			}
			else
			{
				if (this.outputAreaContentPane.domNode.innerHTML.indexOf("<article")==-1 && this.outputAreaContentPane.domNode.innerHTML.indexOf('id="IDX"')===-1)
				{
				    this.resultsList.set("content", null);
					var logPop=function()
					{
						try
						{
							if (this.dataContentPane) {
								this.selectTab(this.dataContentPane);
							} else if (this.logURL != null && this.logURL != "") {
						        this.selectTab(this.logContentPane);
						    } else {
						        this.selectTab(this.editContentPane);
						    }
						}
						catch(e)
						{
							try
							{
								this.selectTab(this.editContentPane);
							}
							catch(e2)
							{

							}
						}
					}

					setTimeout(lang.hitch(this,logPop),40);
					
				}
				 else if (reportApp) 
				 {
					this.makeOutputLinksOpenTabs();
				}
				else
				{
					try
					{
						var body=this.outputAreaContentPane.domNode.getElementsByClassName("c body")[0];
						this.resultsTOC=buildTOC(body);
						//console.log(this.resultsTOC);
						this.createTOCTree(this.resultsTOC);
					}
					catch(e)
					{
						console.log(e);
						console.log("Error building table of contents for HTML5 results.");
					}
				
				}
			}
		},
		// 2014-06-24 sasjkx.  For report apps, allow links in output to actually
		//	do something (but in a separate tab)
		makeOutputLinksOpenTabs: function() {
			if (this.outputAreaContentPane && this.outputAreaContentPane.domNode) {
				var queryContext = this.outputAreaContentPane.domNode;
				var nodeList = dojoQuery('*[href]', queryContext);
				var hitchedClickHandler = lang.hitch( // hitch once outside loop
					this, '_reportOutputLinkClickHandler');
				nodeList.forEach(function(node) {
					on(node, 'click', hitchedClickHandler);
				}, this);
			}
		},
		// 2014-06-24 sasjkx  For report apps, handle clicks on links within
		//	task output
		_reportOutputLinkClickHandler: function(event) {
			setPreventDefault(event);

			if (event && event.target && event.target.href) {
				var queryParameters = this._getUrlQueryParameters(event.target.href);
				// if looks like a report link, try to open in new studio tab
				if (this._isOutputReportLink(event.target.href, queryParameters)) {
					// 2014-06-26 sasjkx  On mobile especially, there can be
					//	noticeable lag between here and when new tab is created
					//	and eventually displays it's own progress dialog.  So,
					//	set busy now for early feedback to the user (and be
					//	sure to turn busy off later).
					this.appDMS.setBusy(true);

					// store some information for handlers to use in a different
					// scope later
					var causeInfo = {
						queryParameters: queryParameters,
						report: queryParameters.report,
						target: event.target
					};
					// Load the ctk which report points to
					var url = this._getStorageUrlForReport(queryParameters.report);
					// Note: handleAs xml doesn't seem to work -- so, use
					//	default handling as text.
					// Note: use default of asynchronous
					dojo.xhrGet({
						url: url,
						preventCache: true,
						load: lang.hitch(this, "_onLinkedReportLoadDefinitionSuccess",
							causeInfo),
						error: lang.hitch(this, "_onLinkedReportLoadDefinitionError",
							causeInfo)
					});
				} else { // else not a report link, make sure it opens in a new browser tab
					// Note: odd urls like javascript: may not work this way
					window.open(event.target.href, '_blank'); // force new tab
				}
			}
		},
		// 2014-06-24 sasjkx  return true/false whether link is to another
		//	[drill-down] report (which should be opened in a studio tab,
		//	rather than a new browser tab)
		_isOutputReportLink: function(href, queryParameters) {
			// 2014-06-27 sasjkx  Not that we're supposed to handle third party
			//	links in output, the simple test for report url parameter is
			//	insufficient.
			//	So, consider an output link a link to a report (which should
			//	be opened in a studio tab) if there is a report url parameter
			//	and link hostname matches current hostname.  If current
			//	protocol is http / https ( ~= starts with 'http') then require
			//	the link to also start with 'http' before considering it a
			//	report local to studio.
			var rc = false;
			if (href && queryParameters && queryParameters.report) {
				// use dom to parse pieces of url
				var a = document.createElement('a');
				a.href = href;

				// have a report url parameter.  at this point default to true.
				// later stages may set to false
				rc = true; // at this point default to true

				// if current values available to compare against, they need to match
				if (window && window.location) {
					// if have a current hostname, it must match
					if (window.location.hostname) {
						var lowerHostname = window.location.hostname.toLowerCase();
						rc = a.hostname &&
							(a.hostname.toLowerCase() == lowerHostname);
					}

					if (rc && window.location.protocol &&
						(window.location.protocol.substring(0, 4) == 'http'))
					{
						rc = a.protocol && (a.protocol.substring(0, 4) == 'http');
					}
				}
			}
			return rc;
		},
		// 2014-06-24 sasjkx pull parameters out of an url, taking into account
		//	usual studio double- encode/decode
		_getUrlQueryParameters: function(url) {
			var rc = {};
			if (typeof url === 'string') {
				// first remove any fragment
				var i = url.indexOf('#');
				if (i >= 0) {
					url = url.substring(0, i);
				}
				// now find query part
				i = url.indexOf('?');
				if (i >= 0) {
					var queryString = url.substring(i + 1);
					var singleDecode = ioQuery.queryToObject(queryString);
					// Generally need double-decode (queryToObject does it once)
					for (var p in singleDecode) {
						if (singleDecode.hasOwnProperty(p) &&
							(typeof singleDecode[p] === 'string'))
						{ // note: decoding name again, too
							rc[decodeURIComponent(p)] = decodeURIComponent(singleDecode[p]);
						}
					}
				}
			}
			return rc;
		},
		// 2014-06-24 sasjkx given a report path (value of report= url parameter)
		//	return a url to the .ctk / .ctm contents
		_getStorageUrlForReport: function(reportPath) {
			var storageType = 'workspace';
			var url = this.baseURL + '/sasexec/sessions/' + this.sessionId +
				'/' + storageType + '/' + encodeValue(reportPath);
			return url;
		},
		// 2014-06-24 sasjkx handle an error trying to load [or process] task
		//	definition of a report linked from output results
		_onLinkedReportLoadDefinitionError: function(causeInfo, error, args) {
			var fault = this.resourceBundle.outputReportLinkLoadError;
			if (causeInfo && causeInfo.report) {
				fault = fault.replace("${0}", causeInfo.report);
			}
			console.log(fault);

			if (error && error.response && error.response.xhr &&
					(typeof error.response.xhr.getResponseHeader === "function"))
			{
				error = error.response.xhr.getResponseHeader("Exception");
			}
			if (error) {
				console.log(error);
			}

			this.appDMS.setBusy(false);
			this.appDMS.dialogs.postFaultDialog(fault, error);
		},
		// 2014-06-24 sasjkx part of async click processing for task output
		//	links which refer to [drill-down] report tasks.
		//	Parse the task definition and then open it in a new studio tab
		//	(rather than a browser tab).
		_onLinkedReportLoadDefinitionSuccess: function(causeInfo, data, args) {
			// should never not have causeInfo.queryParameters.report, but test anyway
			if (causeInfo && causeInfo.queryParameters && causeInfo.queryParameters.report) {
				var reportPath = causeInfo.queryParameters.report;
				var error;
				var detail;
				var task;
				if (data) {
					try {
						task = new SASTask(null, null, data);
					} catch (e) {
						error = this.resourceBundle.outputReportLinkParseError.replace(
							"${0}", reportPath);
						detail = e;
					}
				} else {
					error = this.resourceBundle.outputReportLinkParseError.replace(
						"${0}", reportPath);
				}

				if (task) {
					// update ctk values with any url parameters

					// make a defensive copy, as we'll be modifying the parameter
					// list
					var newReportParameters = lang.mixin({}, causeInfo.queryParameters);

					// First filter out some url paramters which we know
					// shouldn't get transferred to drill-down tab
					delete newReportParameters.test;
					delete newReportParameters.linked;
					delete newReportParameters.report;
					delete newReportParameters.zone;

					// want to update values, so get, mix and set
					var newTemplateValues = lang.mixin(
						task.getTemplateValues(), newReportParameters);
					task.setTemplateValues(newTemplateValues);


					// now cause a new tab to be opened

					var lastSeparator = reportPath.replaceAll('\\', '/').lastIndexOf('/');
					var shortReportName = reportPath.substring(lastSeparator + 1);
					var fakeTaskTarget = {
						name: shortReportName,
						noUpdateBanner: true, // don't update banner text for drill-down tabs
						type: this.appDMS.TASK,
						// 2014-07-02 sasjkx  need to specify run mode, now
						//	that might be running .ctm's as reports
						mode: 'run',
						getTask: function () {
							return task;
						}
					};
					if (causeInfo.target && causeInfo.target.title) {
						// trim the title from clicked element for tooltip
						var title = lang.trim(causeInfo.target.title);
						if (title.length > 0) {
							fakeTaskTarget.tooltip = title;
						}
						// then use only first (non-empty) trimmed line as tab title
						var end = title.search(/[\r\n]/);
						if (end >= 0) {
							title = lang.trim(title.substring(0, end));
						}
						if (title.length > 0) {
							fakeTaskTarget.nlsTabTitle = title;
							fakeTaskTarget.tabTitle = title;
							fakeTaskTarget.title = title;
						}
					}
					this.appDMS.tabs.addTaskTab(fakeTaskTarget);
					this.appDMS.setBusy(false);
				}

				if (error) {
					this._onLinkedReportLoadDefinitionError(causeInfo, error, detail);
				}
			} else {
				this.appDMS.setBusy(false);
			}
		},

		isVirgin: function()
		{
			return (typeof this.uri === 'undefined') || this.uri === null || this.uri === "" || this.uri === 'undefined';
		},
		tileTab: null,

		hideToggleButtons: function(flag){
			if (flag){
/*
 * // hide the up/down toggle buttons, and then add the reset toggle button to
 * each toolbar this.editToolbar.removeChild(this.toggleUpButton);
 * this.editToolbar.removeChild(this.toggleDownButton);
 * this.editToolbar.addChild(this.resetToggleButton);
 *
 * this.logToolbar.removeChild(this.logToggleUpButton);
 * this.logToolbar.removeChild(this.logToggleDownButton);
 * this.logToolbar.addChild(this.logResetToggleButton);
 *
 * this.outputToolbar.removeChild(this.outputToggleUpButton);
 * this.outputToolbar.removeChild(this.outputToggleDownButton);
 * this.outputToolbar.addChild(this.outputResetToggleButton);
 */
			} else {
/*
 * // hide the up/down toggle buttons, and then add the reset toggle button to
 * each toolbar this.editToolbar.addChild(this.toggleUpButton);
 * this.editToolbar.addChild(this.toggleDownButton);
 * this.editToolbar.removeChild(this.resetToggleButton);
 *
 * this.logToolbar.addChild(this.logToggleUpButton);
 * this.logToolbar.addChild(this.logToggleDownButton);
 * this.logToolbar.removeChild(this.logResetToggleButton);
 *
 * this.outputToolbar.addChild(this.outputToggleUpButton);
 * this.outputToolbar.addChild(this.outputToggleDownButton);
 * this.outputToolbar.removeChild(this.outputResetToggleButton);
 */
			}
		},
		toggleLogTileTabUp: function(){
			// hide the up/down toggle buttons, and then add the reset toggle
			// button to each toolbar
			this.hideToggleButtons(true);
			this.toggleLogTileTab("top");
		},
		toggleLogTileTabDown: function(){
			// hide the up/down toggle buttons, and then add the reset toggle
			// button to each toolbar
			this.hideToggleButtons(true);
			this.toggleLogTileTab("bottom");
		},
		resetToggle: function(){
			// hide the reset toggle button, and then add back the up/down
			this.hideToggleButtons(false);
			this.toggleLogTileTab("reset");
		},
		toggleLogTileTab: function(/* String */ direction){
			var size = 0;
			if (!this.logTiled && !this.editorTiled){
				if (this.tileTab == null){
					this.tileTab = new dijit.layout.TabContainer({
						style:/* "height: 90%; */ "width: 100%;",
						id: this.editorTabContainer.id + 'tileTabContainer',
						"class":"sasSuiteTabs",
						region:"top",
						splitter:true,
						gutters: true
					}, "tc1-prog");
				}
				if (direction === 'top'){
					this.sasSuiteTabContainer.removeChild(this.logContentPane);
					domClass.remove(this.logContentPane.domNode, "dijitHidden");
					this.tileTab.region = direction;
					this.logContentPane.region = 'top';
					this.logContentPane.splitter = true;
					this.logContentPane.gutters = true;
					if (this.savedSize == null){
						domStyle.set(this.tileTab.domNode, "height", "30%");
					}
					else {
						size = Math.round(this.savedSize) + 'px';
						domStyle.set(this.tileTab.domNode, "height", size);
					}
					this.tileTab.addChild(this.logContentPane);
					this.editorTabContainer.addChild(this.tileTab); // this.logContentPane);//
																	// try this
					this.tileTab.startup(); // force a re-layout?
					this.logTiled = true;
				} else {
					this.sasSuiteTabContainer.removeChild(this.editContentPane);
					domClass.remove(this.editContentPane.domNode, "dijitHidden");
					this.tileTab.region = 'top';
					this.editContentPane.region = 'top';
					this.editContentPane.splitter = true;
					this.editContentPane.gutters = true;
					if (this.savedSize == null){
						domStyle.set(this.tileTab.domNode, "height", "30%");
					}
					else {
						size = Math.round(this.savedSize) + 'px';
						domStyle.set(this.tileTab.domNode, "height", size);
					}
					this.tileTab.addChild(this.editContentPane);
					this.editorTabContainer.addChild(this.tileTab); // this.logContentPane);//
																	// try this
					this.tileTab.startup(); // force a re-layout?
					this.editorTiled = true;
				}
			} else {
/**
 * this.savedSize = domStyle.get(this.logContentPane.domNode, "height");
 * this.editorTabContainer.removeChild(this.logContentPane);
 * domClass.add(this.logContentPane.domNode, "dijitTabPane");
 * this.logContentPane.region = 'center';
 * domStyle.set(this.logContentPane.domNode, "height", "100%");
 * this.sasSuiteTabContainer.addChild(this.logContentPane,1);
 */
				if (this.logTiled){
					this.savedSize = domStyle.get(this.tileTab.domNode, "height");
					this.tileTab.removeChild(this.logContentPane);
					this.editorTabContainer.removeChild(this.tileTab);
					// domClass.add(this.logContentPane.domNode,
					// "dijitTabPane");
					this.logContentPane.region = 'center';
					domStyle.set(this.logContentPane.domNode, "height", "100%");
					domStyle.set(this.outputContentPane.domNode, "height", "100%");
					domStyle.set(this.editContentPane.domNode, "height", "100%");
					domStyle.set(this.editorDiv, "height", "100%");
					this.sasSuiteTabContainer.addChild(this.logContentPane,1);
					domStyle.set(this.sasSuiteTabContainer.domNode, "height", "100%");
					this.sasSuiteTabContainer.layout();
	// this.editorTabContainer.startup();
					this.logTiled = false;
				} else {
					this.savedSize = domStyle.get(this.tileTab.domNode, "height");
					this.tileTab.removeChild(this.editContentPane);
					this.editorTabContainer.removeChild(this.tileTab);
					// domClass.add(this.logContentPane.domNode,
					// "dijitTabPane");
					this.editContentPane.region = 'center';
					domStyle.set(this.logContentPane.domNode, "height", "100%");
					domStyle.set(this.outputContentPane.domNode, "height", "100%");
					domStyle.set(this.editContentPane.domNode, "height", "100%");
					domStyle.set(this.editorDiv, "height", "100%");
					this.sasSuiteTabContainer.addChild(this.editContentPane,0);
					domStyle.set(this.sasSuiteTabContainer.domNode, "height", "100%");
					this.sasSuiteTabContainer.layout();
					this.sasSuiteTabContainer.selectChild(this.editContentPane);
					this.editorTiled = false;
				}
			}
		},

	   createTOCTree: function(toc)
		{
			var rooted=new Object();
			rooted.root=true;
			rooted.items=toc;
			rooted.label="root";
			rooted.id="root";
			rooted.iconClass="";
			
			var i=0;
			for(i=0;i<toc.length;i++)
			{
				toc[i].parent="root";
			}
			
			this.tocStore = new dojo.data.ItemFileReadStore({
				data: rooted
			});
			
			
			this.tocModel = new dijit.tree.ForestStoreModel({
				store: this.tocStore,
				query: {"id": "*"},
				rootId: "root",
				rootLabel: "",
				childrenAttrs: ["items"],
				labelAttr: "label",
				mayHaveChildren: function(object)
				{
					return(object.items.length>0);
				}
			
			
			});
			
			var tree = new Tree({
				model: this.tocModel,
				style: 'width:100%;height:100%;overflow:auto',
				showRoot: false,
				prevClickedItem: null,
				persist: false,
				duration: 0,
				main: this,
				openOnDblClick: false,
				onClick: lang.hitch(this, this.onTocClick),
				onOpen: lang.hitch(this, lang.hitch(this, function(node, widget){
					if(!node.root)
					{
						if(this.openTOCNodes == null)
							this.openTOCNodes = [];
						if(this.openTOCNodes.indexOf(node.id) == -1 && this.outputContentPane)
						{
							this.openTOCNodes[this.openTOCNodes.length] = node.id;
							widget._expandDeferred.then(lang.hitch(this, this.resizeTOC));
						}
					}
				})),
				onClose: lang.hitch(this, function(node, widget){
					widget._collapseDeferred.then(lang.hitch(this, function(){
						if(this.openTOCNodes == null)
							this.openTOCNodes = [];

						var index = this.openTOCNodes.indexOf(node.id);
						if(index > -1)
							this.openTOCNodes.splice(index, 1);

						this.resizeTOC();
					}));
				}),
				getIconClass: function(item, opened)
				{
					return item.iconClass;
				}
			});
			
			tree.dndController.singular = true;
			
			this.resultsList.set("content", tree);
			tree.startup();
			this.tocTree = tree;
			this.tocTree.expandAll();
			this.outputContentPane.resize();
			if (this.resultsList._contentBox)
				this.defaultTOCHeight = this.resultsList._contentBox.h;
			else this.defaultTOCHeight = 0;
//			setTimeout(lang.hitch(this,this.resizeTOC),0);
		},
		
		onTocClick : function(object)
		{	
		//	console.log(object);
		//	console.log(object.domNode[0]);
		//	console.log(this.outputAreaContentPane.domNode.scrollTop);
		//	console.log(dojo.coords(object.domNode[0],false));
		
			try
			{
				var coords=dojo.coords(object.domNode[0],false);
				this.outputAreaContentPane.domNode.scrollTop=coords.t-10;
			}
			catch(e)
			{
				console.log("Problem scrolling to content from table of contents.");
				console.log(e);
			}
			
		},
	
		createLogTree: function(data)
		{

			this.logStore = new Memory({
// data: [{id: "root", type:"root", root:true, isItem: false },
// {id:"errorRoot", name: this.resourceBundle.errors, type:'errorRoot', parent:
// 'root', isItem: false},
// {id:"warningRoot", name: this.resourceBundle.warnings, type:'warningRoot',
// parent: 'root', isItem:false},
// {id:"noteRoot", name: this.resourceBundle.notes, type:'noteRoot', parent:
// 'root', isItem: false}],
				data: data,
                getChildren: function (object) {
                    var kids = this.query({ parent: object.id });
                    //below is for S1461606
                    //decode the name, which is the log line, before returning it because it will get
                    //encoded by dojo a second time
                    if (object.id !== "root") {
                        for (var i = 0; i < kids.length; i++) {
                            kids[i].name = appDMS.decodeHtml(kids[i].name);
                        }
                    }
					return kids;
				},
				removeAll: function(){
					this.query({isItem: true}).forEach(lang.hitch(this, function(object){
						this.remove(object.id);
					}));
				}
			});
// this.logStore = new Observable(this.logStore);

			this.logModel = new ObjectStoreModel({
				store: this.logStore,
				query: {root: true},
				mayHaveChildren: function(object){
					return !object.isItem;
				}
			});

			var tree = new Tree({
				id: this.editorTabContainer.id + "logTree",
				model: this.logModel,
				style: 'width:100%;height:100%;overflow:auto',
				showRoot: false,
				prevClickedItem: null,
				persist: false,
				duration: 0,
				main: this,
				openOnDblClick: true,
				getLabelClass: function(item, opened){
					switch(item.type){
					case 'error':
						return 'sasError';
					case 'warning':
						return 'sasWarning';
					case 'note':
						return 'sasNote';
					}
				},
				getIconClass: function(item, opened){
					switch(item.type){
					case 'error':
					case 'warning':
					case 'note':
						return 'dijitNoIcon';
					case 'errorRoot':
						return 'sasErrorStatusIcon';
					case 'warningRoot':
						return 'sasWarningStatusIcon';
					case 'noteRoot':
						return 'sasInformationIcon';
					}
				},
				collapseAll: function(){
					var _this = this;

					function collapse(node) {
						if(!node.item.root)
							_this._collapseNode(node);

						var childBranches = dojo.filter(node.getChildren() || [],
								function(node){
									return node.isExpanded;
								}
						);

						var def = new dojo.Deferred();
						def = dojo.map(childBranches, collapse);
					}
					return collapse(this.rootNode);
				},
				onClick: lang.hitch(this, this.scrollToItem),
				onOpen: lang.hitch(this, function(node, widget){
					if(!node.root)
					{
						if(this.openEnhancedLogNodes == null)
							this.openEnhancedLogNodes = [];
						if(this.openEnhancedLogNodes.indexOf(node.id) == -1 && this.logContentPane && node.name.indexOf("(") > -1)
						{
							this.openEnhancedLogNodes[this.openEnhancedLogNodes.length] = node.id;
							widget._expandDeferred.then(lang.hitch(this, this.resizeEnhancedLog));
						}
					}

				}),
				onClose: lang.hitch(this, function(node, widget){
					widget._collapseDeferred.then(lang.hitch(this, function(){
						if(this.openEnhancedLogNodes == null)
							this.openEnhancedLogNodes = [];

						var index = this.openEnhancedLogNodes.indexOf(node.id);
						if(index > -1)
							this.openEnhancedLogNodes.splice(index, 1);

						this.resizeEnhancedLog();
					}));
				})
			});

			this.openEnhancedLogNodes = [];
			tree.dndController.singular = true;
			tree.on("keydown", lang.hitch(this,this.onTreeKeyPress));
			this.logList.set("content", tree);
			tree.startup();
			tree.collapseAll();
			this.logTree = tree;
			this.logList.startup();
			
		},
		
		resizeTOC:function()
		{
			if(this.openTOCNodes &&  this.openTOCNodes.length > 0)
			{
				var maxHeight = domStyle.get(this.outputContentPane.containerNode, 'height') * 0.3;
				var tocHeight = this.resultsList.containerNode.clientHeight;
				if (tocHeight > maxHeight) 
					domStyle.set(this.resultsList.containerNode, "height", maxHeight+'px');
				domStyle.set(this.resultsList.containerNode, "overflow", "auto");

				if(maxHeight > this.outputContentPane._contentBox.h * 0.5){
					domStyle.set(this.outputContentPane.containerNode, "overflowY", "auto");
				}
			}else if(this.defaultTOCHeight && this.outputContentPane._contentBox){
				//dont want the enhanced log to take up the entire view port.
				if(this.defaultTOCHeight <= this.outputContentPane._contentBox.h * 0.3){
					domStyle.set(this.resultsList.containerNode, "height", "");
				}
			}
			this.outputContentPane.layout();
		},
		
		resizeEnhancedLog:function()
		{
			if(this.openEnhancedLogNodes &&  this.openEnhancedLogNodes.length > 0)
			{
				var maxHeight = domStyle.get(this.logContentPane.containerNode, 'height') * 0.3;
				domStyle.set(this.logList.containerNode, "height", maxHeight+'px');
				domStyle.set(this.logList.containerNode, "overflow", "auto");

				if(maxHeight > this.logContentPane._contentBox.h * 0.5){
					domStyle.set(this.logContentPane.containerNode, "overflowY", "auto");
				}
			}else{
				//dont want the enhanced log to take up the entire view port.
				if(this.defaultEnhLogHeight <= this.logContentPane._contentBox.h * 0.3){
					domStyle.set(this.logList.containerNode, "height", "");
				}
			}

			this.logContentPane.layout();
		},
		scrollToItem:function(object, node, event)
		{
			if(this.logTree.selectedNodes != null && this.logTree.selectedNodes.length > 0)
				this.currentLogNode=node;
			else
				this.currentLogNode=null;
			if(object.isItem && this.currentLogNode)
			{
				var domObject;
				if (this.logTree.prevClickedItem != null)
					dojo.removeClass(this.logTree.prevClickedItem, "focus-line");

				domObject = dom.byId(object.id);
				win.scrollIntoView(domObject);
				this.logTree.prevClickedItem = domObject;
				dojo.addClass(domObject, "focus-line");
			}else{
				if (this.logTree.prevClickedItem != null)
					dojo.removeClass(this.logTree.prevClickedItem, "focus-line");
			}
		},
		onTreeKeyPress: function(event)
		{
			var key = event.keyCode;
			var node = dijit.getEnclosingWidget(event.target);
			switch(key)
			{
			case keys.ENTER:
				if(node.isExpandable && !node.isExpanded){
					this.logTree._expandNode(node);
				}
				else if(node.isExpandable && node.isExpanded){
					this.logTree._collapseNode(node);
				}
				break;
			case keys.DOWN_ARROW:
				var nextNode = this.logTree._getNextNode(node);
				this.logTree.dndController.setSelection([nextNode]);
				this.scrollToItem(nextNode.item, nextNode);
				break;
			case keys.UP_ARROW:
				var prevNode = node.getPreviousSibling();
				if(prevNode)
				{
					while(prevNode.isExpandable && prevNode.isExpanded && prevNode.hasChildren()){
						// move to the last child
						var children = prevNode.getChildren();
						prevNode = children[children.length-1];
					}
					this.logTree.dndController.setSelection([prevNode]);
					this.scrollToItem(prevNode.item, prevNode);
				}else{
					var parent = node.getParent();
					if(!(!this.showRoot && parent === this.rootNode)){
						node = parent;
					}
					this.logTree.dndController.setSelection([node]);
					this.currentLogNode=node;
				}
				break;
			}
		},
		updateTabIcon: function(data)
		{
		    if (reportApp || !this.canUpdateTabIcon) return;

			var tabWidget = this.getTabWidget();
			if (tabWidget != null)
			{
				if(data.indexOf('class="sasError"') > -1){
					domClass.replace(tabWidget.iconNode, 'sasErrorStatusIcon', 'sasSASTransportFileIcon treeProjectSASFile sasWarningStatusIcon sasInformationIcon smallBusyIcon sasSubmittedStatusIcon');
					if (this.task)
					{
						if(tabWidget)
							domClass.replace(tabWidget.iconNode, 'sasErrorStatusIcon', this.task.icon);
					}
					tabWidget.page.iconStatusClass = "sasErrorStatusIcon";
				}else if(data.indexOf('class="sasWarning"') > -1){
					domClass.replace(tabWidget.iconNode, 'sasWarningStatusIcon', 'sasSASTransportFileIcon treeProjectSASFile sasErrorStatusIcon sasInformationIcon smallBusyIcon sasSubmittedStatusIcon');
					tabWidget.page.iconStatusClass = "sasWarningStatusIcon";
	//			}else if(data.indexOf('sasNote') > -1){
	//				domClass.replace(tabWidget.iconNode, 'sasInformationIcon', 'treeProjectSASFile sasWarningStatusIcon sasErrorStatusIcon');
//					tabWidget.page.iconStatusClass = "sasInformtaionIcon";
				}else{
					if (this.fileType=="CPK")
						domClass.replace(tabWidget.iconNode, 'sasSASTransportFileIcon', 'sasInformationIcon sasWarningStatusIcon sasErrorStatusIcon smallBusyIcon sasSubmittedStatusIcon');
					else
						domClass.replace(tabWidget.iconNode, 'treeProjectSASFile', 'sasInformationIcon sasWarningStatusIcon sasErrorStatusIcon smallBusyIcon sasSubmittedStatusIcon');
					tabWidget.page.iconStatusClass = null;
				}
			}
		},
		setTabBusyIcon: function()
		{
		    if (!this.canUpdateTabIcon) return;

			var tabWidget = this.getTabWidget();
			if (tabWidget != null)
			{
				domClass.replace(tabWidget.iconNode, 'smallBusyIcon', 'treeProjectSASFile sasInformationIcon sasWarningStatusIcon sasErrorStatusIcon smallBusyIcon sasSubmittedStatusIcon' + tabWidget.iconNode.getAttribute("class"));
			}
		},

		setTabQueuedIcon: function()
		{
		    if (!this.canUpdateTabIcon) return;

			var tabWidget = this.getTabWidget();
			if (tabWidget != null)
			{
				domClass.replace(tabWidget.iconNode, 'sasSubmittedStatusIcon', 'treeProjectSASFile sasInformationIcon sasWarningStatusIcon sasErrorStatusIcon smallBusyIcon sasSubmittedStatusIcon' + tabWidget.iconNode.getAttribute("class"));
			}
		},

		removeTabBusyIcon: function()
		{
		    if (!this.canUpdateTabIcon) return;

			var tabWidget = this.getTabWidget();
			if (tabWidget != null)
			{
				domClass.replace(tabWidget.iconNode, 'treeProjectSASFile', 'smallBusyIcon sasSubmittedStatusIcon');
			}
		},

		getTabWidget: function()
		{
			var tabWidget = null;
			if (this.tabObject && this.tabObject.tab && this.tabObject.tab.controlButton)
				tabWidget=this.tabObject.tab.controlButton;
			else if (this.editorTabContainer.controlButton)
				tabWidget = this.editorTabContainer.controlButton;
			else if (this.editorTabContainer.getParent())
			{
				if (this.editorTabContainer.getParent().controlButton)
					tabWidget = this.editorTabContainer.getParent().controlButton;
			}
			else if (this.tabContainer)
			{
				if (this.tabContainer.controlButton && this.tabContainer.controlButton != 'undefined'){
					tabWidget = this.tabContainer.controlButton;
				}
			}
			else if (this.taskArea.taskContainer.getParent())
			{
				if (this.taskArea.taskContainer.getParent().controlButton){
					tabWidget = this.taskArea.taskContainer.getParent().controlButton;
				}
			}
			return tabWidget;
		},

		updateLogTree: function()
		{
			if (reportApp) return;
			//resize the logList
			domStyle.set(this.logList.containerNode, "height", "");

			if(this.logTree)
				this.logTree.destroy();
			var errorCount = 0;
			var warnCount = 0;
			var noteCount = 0;
			var noteWarnError = false;
			var icon = false;
			var storeArray = [];
			var tabWidget = this.getTabWidget();

			if (tabWidget.iconNode.getAttribute("class").indexOf("smallBusyIcon") > -1)
				tabWidget=null;

			dojo.query("[id]",
					this.logAreaContentPane.containerNode).forEach(lang.hitch(this, function(node, index, nodelist){
						if(node.id !== "")
						{
							var type = "";
							var parent = "";
							switch(node.className)
							{
							case "sasError":
								type = 'error';
								parent = 'errorRoot';
								errorCount++;
								noteWarnError = true;
								break;
							case "sasNote":
								type = 'note';
								parent = 'noteRoot';
								noteCount++;
								noteWarnError = true;
								break;
							case "sasWarning":
								type = 'warning';
								parent = 'warningRoot';
								warnCount++;
								noteWarnError = true;
								break;
							}

							if(parent !== '' && type !== '')
								storeArray[storeArray.length] = {id: node.id, name: node.innerHTML, type: type, parent: parent, isItem: true};
						}
					}));

			var rootArray = [{id: "root", type:"root", root:true, isItem: false }];

			if(errorCount > 0)
			{
				var errorRootName = this.resourceBundle.errors + " (" + errorCount + ")";
				if (tabWidget && this.canUpdateTabIcon) {
					if (this.task)
						domClass.replace(tabWidget.iconNode, 'sasErrorStatusIcon', this.task.icon + " sasTaskIcon sasWarningStatusIcon sasInformationIcon");
					else
						domClass.replace(tabWidget.iconNode, 'sasErrorStatusIcon', 'treeProjectSASFile sasWarningStatusIcon sasInformationIcon');
					tabWidget.page.iconStatusClass = "sasErrorStatusIcon";
				}
				icon = true;
			}else{
				errorRootName = this.resourceBundle.errors;
			}
			rootArray[rootArray.length] = {id:"errorRoot", name: errorRootName, type:'errorRoot', parent: 'root', isItem: false};

			if(warnCount > 0)
			{
				var warningRootName = this.resourceBundle.warnings + " (" + warnCount + ")";
				if(!icon)
				{
				    if (tabWidget && this.canUpdateTabIcon) {
						if(this.task)
							domClass.replace(tabWidget.iconNode, 'sasWarningStatusIcon', this.task.icon + " sasTaskIcon");
						else
							domClass.replace(tabWidget.iconNode, 'sasWarningStatusIcon', 'treeProjectSASFile sasErrorStatusIcon sasInformationIcon');
						tabWidget.page.iconStatusClass = "sasWarningStatusIcon";
					}
					icon = true;
				}
			}else{
				warningRootName = this.resourceBundle.warnings;
			}
			rootArray[rootArray.length] = {id:"warningRoot", name: warningRootName, type:'warningRoot', parent: 'root', isItem:false};

			if(noteCount > 0)
			{
				var noteRootName = this.resourceBundle.notes + " (" + noteCount + ")";
//				if(!icon)
//				{
//					if(tabWidget){
//						domClass.replace(tabWidget.iconNode, 'sasInformationIcon', 'treeProjectSASFile sasWarningStatusIcon sasErrorStatusIcon');
//						tabWidget.page.iconStatusClass = "sasInformationIcon";
//						icon = true;
//					}
//				}
			}else{
				noteRootName = this.resourceBundle.notes;
			}
			rootArray[rootArray.length] = {id:"noteRoot", name: noteRootName, type:'noteRoot', parent: 'root', isItem: false};

			var data = rootArray.concat(storeArray);

			this.createLogTree(data);

			// if no errors/warnings/notes set the iconNode style back to noIcon
			// and close the log summary pane if opened.
			if(!icon){
				if (this.task)
				{
					var iconClass="sasTaskIcon";
					if(this.task.icon)
						iconClass=this.task.icon;
					if (tabWidget && this.canUpdateTabIcon)
						domClass.replace(tabWidget.iconNode, iconClass, 'sasInformationIcon sasWarningStatusIcon sasErrorStatusIcon');
					if(this.logList.open)
						this.logList.toggle();
				} else {
				    if (tabWidget && this.canUpdateTabIcon)
						domClass.replace(tabWidget.iconNode, 'treeProjectSASFile', 'sasInformationIcon sasWarningStatusIcon sasErrorStatusIcon');
					if(this.logList.open)
						this.logList.toggle();
				}
				if (tabWidget) {
				    tabWidget.page.iconStatusClass = null;
				}
			}
			if(noteWarnError && !this.logList.open && this.mode!='interactive')
				this.logList.toggle();
			try
			{
				this.logContentPane.resize();
				if (this.logList._contentBox)
					this.defaultEnhLogHeight = this.logList._contentBox.h;
				else this.defaultEnhLogHeight = 0;
			}
			catch(e)
			{
				console.log(e);
			}

			if (this.mode=="interactive")
			{
				this.logAreaContentPane.domNode.scrollTop=this.logAreaContentPane.domNode.scrollHeight;
			}else{
				this.logAreaContentPane.domNode.scrollTop=0;
                domStyle.set(this.logList.containerNode, "height", "80px");	
			}

		},
		createLogTab: function()
		{
			this.createLogToolbar();
            
			this.logContentPane = new BorderContainer({
			    id: this.editorTabContainer.id + 'log',
			    style: "padding:0px; margin:0px; width:100%; height:100%;",
				type: "log",
				gutters: false,
				title: this.resourceBundle.logTitle
			});

			var cp1 = new ContentPane({
			    region: "top",
			    layoutPriority: "1",
			    style: "width:100%; padding:0px;margin:0px;",
			    content: this.logToolbar.domNode
			});
			this.logContentPane.addChild(cp1);
            
		    // log list
			// I hate to hardcode a px size, but without this, you can finagle things to get the pane to not
			// get immediately stomped on, but for some reason it doesn't think it's active.
			this.logList = new dijit.TitlePane({
			    style: "padding:0px; margin:0px; width:100%;",
			    layoutPriority: "2",
			    title: this.resourceBundle.enhancedLogTitle,
			    region: "top",
			    duration: 0,
			    open: false
			});
			domClass.add(this.logList.hideNode, "sasLogTOC sasTOCDropDown");
			this.logContentPane.addChild(this.logList);
            
			var bc1 = new BorderContainer({
			    style: "padding:0px; margin:0px; width:100%; height:100%;",
			    region: "center",
			    gutters: false			    
			});
			this.logContentPane.addChild(bc1);

			this.logAreaContentPane = new dijit.layout.ContentPane({
				title: this.resourceBundle.logTitle,
				style: "padding: 0px; margin:0px; width:100%;height:100%;",
				region: "center",
				dir: "ltr",
				preventCache: true
			});
			bc1.addChild(this.logAreaContentPane);
            
			this.sasSuiteTabContainer.addChild(this.logContentPane);
			this.logContentPane.startup();

			on(this.logList, "click", lang.hitch(this, function (event) {
			    this.logContentPane.layout();
			}));

			if (reportApp)
			{
				this.logContentPane.set("style","display:none;z-index: -9999");
			}

			var loaded=function()
			{
				this.updateLogTree();

				var scroll=function()
				{
					if (reportApp) return;
					if (this.submissionId)
						this.logAreaContentPane.domNode.scrollTop=this.logAreaContentPane.domNode.scrollHeight;
				};

				setTimeout(lang.hitch(this,scroll),20);
			}

			var clicked=function(event)
			{
				try
				{
					if (event.target.className=="logTarget")
					{
						setPreventDefault(event);
						if (this.logURL) 
							window.open(this.logURL,this.submissionId);
						else
							window.open(event.target.href,this.submissionId);
					}
				}
				catch(e)
				{
					console.warn("Unable to open full log tab - " + e.message);
				}
			}

			on(this.logAreaContentPane, 'load', lang.hitch(this, loaded));
			on(this.logAreaContentPane, 'click', lang.hitch(this, clicked));


		/*
		 * this.logAreaContentPane = new dijit.layout.ContentPane( { title:
		 * "Log", style: "width:98%;height:92%;" } );
		 *
		 * this.logContentPane = new dijit.layout.ContentPane( { id:
		 * this.editorTabContainer.id + 'log', title: "Log", content:
		 * this.logToolbar.domNode, style: "overflow:hidden" } );
		 *
		 * this.logContentPane.containerNode.appendChild(this.logAreaContentPane.domNode);
		 *
		 * this.sasSuiteTabContainer.addChild(this.logContentPane);
		 */
		},
		createEditorTab: function()
		{
			
   			this.editStatusBarBC = new BorderContainer({
					region: 'bottom',
					gutters: false,
					style: "height:15px;width:100%; padding-top:0px; padding-left:0px; padding-right:0px; padding-bottom:0px",
					"class":"lineStatusBar"
			});
			
			this.createEditorToolbar();

			this.editContentPane = new BorderContainer({
		        id: this.editorTabContainer.id + 'editor',
		        type: "editor",
	            gutters: false,
	            title: this.resourceBundle.codeTitle});

		    var cp1 = new ContentPane({
		       region: "top",
			   style: "width:100%; padding-top:0px; padding-left:0px; padding-right:0px; padding-bottom:0px",
		       content:  this.editToolbar.domNode});
		       
		    this.editContentPane.addChild(cp1);
			this.editContentPane.addChild(this.editStatusBarBC);
		    this.editorHolder= new ContentPane({
				region: "center",
				"class": "codeEditorContainer",
				style: "overflow:hidden;padding:0px;"
		    });

			this.editorDiv = domConstruct.create('div', {
				"class": 'editor_content',
				id: this.editorTabContainer.id + '_editor'
			}, this.editorHolder.containerNode);

			this.editContentPane.addChild(this.editorHolder);
			this.sasSuiteTabContainer.addChild(this.editContentPane);
			this.editorActive = true;
			this.selectedTab = this.editContentPane;
		},

		createCodeEditor: function()
		{
			if (this.fileType=="CPK" && this.editorContent.length>0)
			{
				this.setPackage(this.editorContent);
			}

			this.editor = new Editor(this.editorDiv.id, this.editorContent, SAS.Editor.LanguageMode.SasCode);
			this.editor.log=this.logAreaContentPane;
			if (appDMS.currentPerspectiveKey==="interactivePP")
				this.editor.readOnly(true);
			appDMS.applyOptionsToEditor(this.editor);
			var contextMenu = this.editor.getContextMenu();
			contextMenu.removeItems(11,2);
			contextMenu.removeItems(9,2);
			contextMenu.insertItems(9, [{
					type: 'entry',
					// label: 'Go to Toolbar',
					label: this.resourceBundle.gotoToolbarLabel,
					onClick: lang.hitch(this, this.setPreviousFocus)
				},
				{
					type: 'entry',
					// label: 'Go to Log',
					label: this.resourceBundle.gotoLogLabel,
					onClick: lang.hitch(this, this.setNextFocus)
				}]);

			 contextMenu.insertItems(8, [{
					type: 'entry',
					// label: 'Format Code',
					label: this.resourceBundle.formatCodeLabel,
					onClick: lang.hitch(this, this.formatCodeHandler),
					can: lang.hitch(this, this.canFormatCode)
				},
				{
					type: 'entry',
					label: this.resourceBundle.saveSnippet,
					onClick: lang.hitch(this, this.saveSnippet),
					can:lang.hitch(this, function(){
						 var code = this.editor.getText();
						 if(code!=null && code.length>0)
							 return true;
						 return false;
					 })
				}]);
			 
			 contextMenu.insertItems(0, [{
				 type: 'entry',
				 label: this.resourceBundle.runCodeLabel,
				 onClick:lang.hitch(this, this.submitHandler),
				 can:lang.hitch(this, function(){
					 var code = this.editor.getText();
					 if(code!=null && code.length>0)
						 return true;
					 return false;
				 })
			 },
			 {
				 type: 'separator'
			 }]);

			try
			{
				if (this.editor.setNextFocusHandler)
				{
					this.editor.setNextFocusHandler(lang.hitch(this,this.setNextFocus));
					this.editor.setPreviousFocusHandler(lang.hitch(this,this.setPreviousFocus));
				}
			}
			catch(e)
			{
				console.log(e);
			}

			this.editor.bind('textChanged', lang.hitch(this, this.editorChanged));
			this.editor.bind('selectionChanged', lang.hitch(this, this.selectionChanged));
			this.editor.bind('caretMoved', lang.hitch(this, this.caretMoved));

			this.setButtonStates();
			this.editor.gotoLine(1); // goto the first line
			setTimeout(lang.hitch(this,this.setInitialFocus),100);
			this.setGoToLineConstraints();

			this.editor.bind('drop', window.appDMS.dropFromDesktop);
            this.editor.setLibService(this.getLibList);
			this.editor.activate();
			this.setFinalized(true);
		},

		caretMoved: function(e){
			var colstatusCP = dijit.byId('colstatus' + this.editorTabContainer.id);
			var status=this.resourceBundle.LineColumn.replace("${0}", e.data.line + 1);
			status=status.replace("${1}", e.data.column + 1);
			if (colstatusCP)
				colstatusCP.setContent(status);
		},
		selectionChanged: function()
		{
			this.setButtonStates();
		},
		setNextFocus: function()
		{
			// Need to select log tab

			// Start with the main tab container.
			var logTabHeadId = this.editorTabContainer.id+'sasSuiteTabContainer_tablist_'+this.editorTabContainer.id+'log';
			var logTabHead = dijit.byId(logTabHeadId);
			var tabContainer = this.sasSuiteTabContainer;

			// If we haven't found it, try the right tab container.
			if (logTabHead === undefined)
			{
				logTabHeadId = this.editorTabContainer.id+'_rightTabContainer_tablist_'+this.editorTabContainer.id+'log';
				logTabHead = dijit.byId(logTabHeadId);
				tabContainer = this.rightTabs;
			}

			// If we still haven't found it, try the bottom tab container.
			if (logTabHead === undefined)
			{
				logTabHeadId = this.editorTabContainer.id+'_bottomTabContainer_tablist_'+this.editorTabContainer.id+'log';
				logTabHead = dijit.byId(logTabHeadId);
				tabContainer = this.bottomTabs;
			}

			// If we found the tab container, focus the log tab
			if (logTabHead !== undefined && tabContainer)
			{
				tabContainer.selectChild(this.logContentPane);
				this.focus.focus(logTabHead.focusNode);
			}
		},
		setPreviousFocus: function()
		{
			var editorTabHeadId = this.editorTabContainer.id+'sasSuiteTabContainer_tablist_' +
							      this.editorTabContainer.id+'editor';
			var editorTabHead = dijit.byId(editorTabHeadId);
			this.editToolbar.focusFirstChild();
/**
			if (!this.taskMode){
				var submitButtonNode = dijit.byId(this.editorTabContainer.id + '_submitBtn');
				this.focus.focus(submitButtonNode.focusNode);
			} else {

			}
*/
		},
		setInitialFocus: function()
		{
			try
			{
				this.editor.focus();
				//this.editor.gotoLine(1); // goto the first line
				try
				{
// if (this.isVirgin()) this.editor.selectAll();
				}
				catch(ignore) { }
			}
			catch(e)
			{
				console.log(e);
			}
		},
		onResize: function(evt)
		{
			if (this.resizeTimeout && this.resizeTimeout != null)
				clearTimeout(this.resizeTimeout);
			this.resizeTimeout = setTimeout(lang.hitch(this,function(){
				var width = domStyle.get(this.editorHolder.containerNode, 'width');
				var height = domStyle.get(this.editorHolder.containerNode, 'height');
				try
				{
					if (this.editor.resizeOnly)
						this.editor.resizeOnly(width, height);
					else
						this.editor.resize(width, height);
				}
				catch(e)
				{
					this.editor.resize(width, height);
				}
				this.resizeTOC();
			}), 10);

		},
		editorChanged: function(val)
		{
			if (reportApp) return;
			
			// WOW - This is ugly, but after about 15 crazy approaches to fix the "*" problem for S1329936
			
			if (this.eatChangeEvent === true)
			{
				//console.log("YUM!");
				this.eatChangeEvent=false;
				this.setButtonStates();
				this.setGoToLineConstraints();
				return;
			}
			
			if (this.finalized === false) return;
//			if (typeof val !== 'undefined' && val !== null){
//				if (val === false){
//					this.unapplyChangedIndicationToTab();
//				} else {
//					this.applyChangedIndicationToTab();
//				}
//				this.editorContentChanged = val;
//				if (val === false){
//					return;
//				}
//			} else
			if(this.editorContentChanged === false)
			{
				this.applyChangedIndicationToTab();
			}

			this.editorContentChanged = true;
			this.autoSaved = false;
			this.setButtonStates();
			this.setGoToLineConstraints();
		},

		setGoToLineConstraints: function()
		{
		    var constraint = {};
			constraint.min = 1;
			constraint.max = this.editor.lineCount();
			constraint.fractional = false;
			constraint.pattern = '#.#';
			constraint.places = 1;
			this.gotoInput.setAttribute("constraints",constraint);
		},

		// By making this a function, we can override it when we show a program or task
		// in the process flow. In that case, we need to let the process flow take care
		// of adding this instead of each control contained in the flow.		
        applyChangedIndicationToTab: function()
		{
		    if (this.canUpdateTabTitle) {
		    	this.setTabLabel("*" + this.name);
		    }
		},

		unapplyChangedIndicationToTab: function()
		{
			this.setTabLabel(this.name);
		},
		
		setTabLabel: function(labelText)
		{
			var tabWidget=this.getTabWidget();
			if(tabWidget){
		        tabWidget.containerNode.innerHTML = appDMS.encodeHtml(labelText);
            }
		}, 
		resetSaveState: function()
		{
		    this.editorContentChanged=false;
		    this.unapplyChangedIndicationToTab();
		    this.setButtonStates();
		},

		createOutputToolbar: function()
		{
		    this.outputToolbar = new dijit.Toolbar({
		        'class': "outputToolbar"
		    }, "outputToolbar");
		/*
		 * this.outputToggleUpButton = new dijit.form.Button({ iconClass:
		 * 'sasArrowSmallUpIcon', // label: 'Tile log tab above code editor',
		 * label: this.resourceBundle.tileLogAbove, onClick: dojo.hitch(this,
		 * this.toggleLogTileTabUp), showLabel: false, id:
		 * this.editorTabContainer.id + '_outputToggleLogTileUpBtn' });
		 * this.outputToggleDownButton = new dijit.form.Button({ iconClass:
		 * 'sasArrowSmallDownIcon', // label: 'Tile log tab below code editor',
		 * label: this.resourceBundle.tileLogBelow, onClick: dojo.hitch(this,
		 * this.toggleLogTileTabDown), showLabel: false, id:
		 * this.editorTabContainer.id + '_outputToggleLogTileDownBtn' });
		 * this.outputResetToggleButton = new dijit.form.Button({ iconClass:
		 * 'sasCollapseAllNodesIcon', // label: 'Untile log tab', label:
		 * this.resourceBundle.untileLogTab, onClick: dojo.hitch(this,
		 * this.resetToggle), showLabel: false, id: this.editorTabContainer.id +
		 * '_outputResetToggleBtn' });
		 */
			this.outputSaveButton = new dijit.form.Button({
				iconClass: 'sasHTMLFileIcon',
// label: 'Download results as an HTML file',
				label: this.resourceBundle.downloadResultsAsHTML,
				onClick:  dojo.hitch(this, this.onSaveOutputAs),
				showLabel: false}
			);

			this.outputPDFButton = new dijit.form.Button({
				iconClass: 'sasPDFFileIcon',
//				label: 'Download results as a PDF file',
				label: this.resourceBundle.downloadResultsAsPDF,
				onClick:  dojo.hitch(this, this.onSavePDF),
				showLabel: false}
			);

			this.outputRTFButton = new dijit.form.Button({
				iconClass: 'sasWordFileIcon',
// label: 'Download results as an RTF file',
				label: this.resourceBundle.downloadResultsAsRTF,
				onClick:  dojo.hitch(this, this.onSaveRTF),
				showLabel: false}
			);

				this.outputDataButton = new dijit.form.Button({
				iconClass: 'sasDownloadIcon',
				label: this.resourceBundle.downloadData,
				onClick:  dojo.hitch(this, this.openOutput),
				showLabel: false}
			);

			this.outputDataButton.set("disabled",true);

			this.outputPrintButton = new dijit.form.Button({
				iconClass: 'sasPrintIcon',
// label: 'Print results',
				label: this.resourceBundle.printResults,
				onClick:  dojo.hitch(this, this.onOutputPrint),
				showLabel: false}
			);

			this.openResultsInNewBrowserTabButton = new dijit.form.Button({
				iconClass: 'sasOpenInNewTab',
// label: 'Open in a new browser tab',
				label: this.resourceBundle.openInNewBrowserTab,
				onClick: dojo.hitch(this, function(event)
					    {
						   // opening new window...
						    if (event) setPreventDefault(event);

						    if (this.resultsURL)
							{
								var url=this.resultsURL;
								if (!url) url="";
								this.pw=window.open(url);
								//wait for window.open to finish before swapping in NLS bundle for Results tab-label (S1111166)
								setTimeout(lang.hitch(this, function(){
									this.pw.document.title = this.resourceBundle.summaryResultsHeading + this.pw.document.title.substring(this.pw.document.title.indexOf (":")+1);
								}), 300);

							}
							else
							{
								this.pw=window.open();
								var results=this.outputAreaContentPane.get("content");
								this.pw.document.write(results);
								this.pw.document.close();
								if (this.saspkgId)
									this.pw.document.getElementsByTagName("html")[0].setAttribute("class","ods_" + this.saspkgId);
							}
					    }),
				showLabel: false
			});

			this.resultsClearButton = new dijit.form.Button({
				iconClass: 'sasClearAllIcon',
				// label: 'Clear all code',
				label: this.resourceBundle.clearResults,
				title: this.resourceBundle.clearResults,
				style: "display: none",
				"aria-label": this.resourceBundle.clearResults,
				onClick: lang.hitch(this, this.clearResults),
				showLabel: false});

			this.mailResultsButton = new dijit.form.Button({
				iconClass: 'sasMailIcon',
				label: this.resourceBundle.mailResults,
				"aria-label": this.resourceBundle.mailResults,
				onClick:  dojo.hitch(this, this.onMailResults),
				showLabel: false}
			);
			if(allowDownload==='true'){
				this.outputToolbar.addChild(this.outputSaveButton);
				this.outputToolbar.addChild(this.outputPDFButton);
				this.outputToolbar.addChild(this.outputRTFButton);
				this.outputToolbar.addChild(this.outputDataButton);
				this.outputToolbar.addChild(new dijit.ToolbarSeparator());
			}
			if (typeof allowResultsActions === "undefined" || allowResultsActions === null || allowResultsActions === true){
                this.outputToolbar.addChild(this.outputPrintButton);
                this.outputToolbar.addChild(new dijit.ToolbarSeparator());
			    this.outputToolbar.addChild(this.openResultsInNewBrowserTabButton);
			}
			this.outputToolbar.addChild(this.resultsClearButton);
			if (enableMail && (typeof allowResultsActions === "undefined" || allowResultsActions === null || allowResultsActions === true)){ //set in main.jsp
				this.outputToolbar.addChild(this.mailResultsButton);
    			this.outputToolbar.addChild(new dijit.ToolbarSeparator());
			}
			// this.outputToolbar.addChild(this.outputToggleUpButton);
			// this.outputToolbar.addChild(this.outputToggleDownButton);
			this.outputSaveButton.set("disabled",true);
			this.outputPrintButton.set("disabled",true);
			this.outputPDFButton.set("disabled",true);
			this.outputRTFButton.set("disabled",true);
			this.openResultsInNewBrowserTabButton.set("disabled", true);
			this.mailResultsButton.set("disabled", true);
			this.makeOutputTips();
		},
		makeOutputTips: function()
		{
// this.outputSaveButton.set("title","Download as an HTML file");
			this.outputSaveButton.set("title",this.resourceBundle.downloadResultsAsHTML);
// this.outputPDFButton.set("title","Download as a PDF file");
			this.outputPDFButton.set("title",this.resourceBundle.downloadResultsAsPDF);
// this.outputRTFButton.set("title","Download as an RTF file");
			this.outputRTFButton.set("title",this.resourceBundle.downloadResultsAsRTF);
// this.outputPrintButton.set("title","Print results");
			this.outputPrintButton.set("title",this.resourceBundle.printResults);
// this.openResultsInNewBrowserTabButton.set("title", "Open in a new browser
// tab");
			this.mailResultsButton.set("title",this.resourceBundle.mailResults);
			this.openResultsInNewBrowserTabButton.set("title", this.resourceBundle.openInNewBrowserTab);
		},
		createLogToolbar: function()
		{
		    this.logToolbar = new dijit.Toolbar({
		        'class': "logToolbar"
		    }, "logToolbar");
	/*
	 * this.logToggleUpButton = new dijit.form.Button({ iconClass:
	 * 'sasArrowSmallUpIcon', label: 'Tile log tab above code editor', onClick:
	 * dojo.hitch(this, this.toggleLogTileTabUp), showLabel: false, id:
	 * this.editorTabContainer.id + '_logToggleLogTileUpBtn' });
	 * this.logToggleDownButton = new dijit.form.Button({ iconClass:
	 * 'sasArrowSmallDownIcon', label: 'Tile log tab below code editor',
	 * onClick: dojo.hitch(this, this.toggleLogTileTabUpDown), showLabel: false,
	 * id: this.editorTabContainer.id + '_logToggleLogTileDownBtn' });
	 * this.logResetToggleButton = new dijit.form.Button({ iconClass:
	 * 'sasCollapseAllNodesIcon', label: 'Untile log tab', onClick:
	 * dojo.hitch(this, this.resetToggle), showLabel: false, id:
	 * this.editorTabContainer.id + '_logToggleLogTileResetBtn' });
	 */
			this.logSaveAsButton = new dijit.form.Button({
				iconClass: 'sasSaveAsIcon',
				label: this.resourceBundle.saveLogAsFile,
				onClick:  dojo.hitch(this, this.onSaveLogAsProject),
				showLabel: false}
			);

			this.logSaveButton = new dijit.form.Button({
				iconClass: 'sasHTMLFileIcon',
				label: this.resourceBundle.downloadLogAsHTML,
				onClick:  dojo.hitch(this, this.onSaveLogAs),
				showLabel: false}
			);

			this.logPrintButton = new dijit.form.Button({
				iconClass: 'sasPrintIcon',
				label: this.resourceBundle.printLog,
				onClick:  dojo.hitch(this, this.onLogPrint),
				showLabel: false}
			);

			this.openlogBrowserTabButton = new dijit.form.Button({
				iconClass: 'sasOpenInNewTab',
				// label: 'Open in a new browser tab',
				label: this.resourceBundle.openInNewBrowserTab,
					onClick: lang.hitch(this,this.onLogTabOpen),
					showLabel: false});

			this.logMaxViewButton = new dijit.form.Button({
				iconClass: 'sasMaximizeViewIcon',
					onClick: lang.hitch(this,this.onMaxView),
					showLabel: false});

			this.clearLogButton = new dijit.form.Button({
				iconClass: 'sasClearAllIcon',
				// label: 'Clear all code',
				label: this.resourceBundle.clearLog,
				title: this.resourceBundle.clearLog,
				style: "display:none",
				"aria-label": this.resourceBundle.clearLog,
				onClick: lang.hitch(this, this.clearLog),
				showLabel: false});
			
			this.logToolbar.addChild(this.logSaveAsButton);
			this.logToolbar.addChild(this.logSaveButton);
			this.logToolbar.addChild(new dijit.ToolbarSeparator());
			this.logToolbar.addChild(this.logPrintButton);
			this.logClearSeparator = new dijit.ToolbarSeparator();
			this.logToolbar.addChild(this.logClearSeparator);
			this.logToolbar.addChild(this.clearLogButton);
			this.logToolbar.addChild(new dijit.ToolbarSeparator());
			this.logToolbar.addChild(this.openlogBrowserTabButton);
			this.logToolbar.addChild(this.logMaxViewButton);


			this.logSaveAsButton.set("disabled",true);
			this.logSaveButton.set("disabled",true);
			this.logPrintButton.set("disabled",true);
			this.openlogBrowserTabButton.set("disabled",true);
			this.makeLogTips();

		},
		makeLogTips: function()
		{
			this.logSaveAsButton.set("title",this.resourceBundle.saveLogAs);
			this.logSaveButton.set("title",this.resourceBundle.downloadAsHTML);
			this.logSaveAsButton.set("aria-label",this.resourceBundle.saveLogAsFile);
			this.logPrintButton.set("title",this.resourceBundle.printLog);
			this.openlogBrowserTabButton.set("title",this.resourceBundle.openInNewBrowserTab)
		},
		onSaveAsKey : function(event)
		{
			var okButton = dijit.byId('okButton');
			if (event.keyCode == 13)
			{
				setPreventDefault(event);
				okButton.onClick(event);
			}
		},
		onSaveLogAsProject: function()
		{
			var fname=this.resourceBundle.untitled + ".log";
			if (this.isVirgin() === false){
				if(this.tabObject && (this.tabObject.isMySnippet || this.tabObject.type == "CODE"))
					fname=this.name+".log";
				else
					fname=this.name.substr(0,this.name.length-4) + ".log";
			}

			appDMS.dialogs.postSaveAsDialog(fname, ["log"],
											this.resourceBundle.saveAsTitle,
											lang.hitch(this, this.onLogSaveAsOK),
											lang.hitch(this, this.onSaveAsCancel));
		},

		onSaveAsCancel: function()
		{
			appDMS.dialogs.saveAsDialog.hide();
		},
		onLogSaveAsOK: function()
		{
			var isNameEmpty=false;
			var okButton=appDMS.dialogs.saveAsDialog.okButton;
			var isOkDisabled=okButton.get("disabled");
			if (isOkDisabled)
			{
				dojoAlert(this.resourceBundle.enterValidName);
				return;
			}

			var selectedObject = this.projects.destinationTree.get("selectedItems")[0];
			var storageType = selectedObject.type.indexOf("ftpShortcut") != -1 ? "ftprefs/save" : "workspace";
			var projectPath = selectedObject.uri;
			//S1319655 - if file is selected project path will be parents path.
			if(!selectedObject.isDirectory){
				projectPath=selectedObject.uriParent;
			}
			//S1268434 - projectPath is double encoded below by call to encodeValue;
			//no need for extra encoding being done here
			//if(storageType != "ftprefs/save")
			//	projectPath = encodeURI(selectedObject.uri);

  			var fileNameTextBox=appDMS.dialogs.saveAsDialog.fileNameTextBox;
  			var isPDS=this.appDMS.objectIsMVSPartitionedDataset(selectedObject);

			var name = fileNameTextBox.get("value");
			if (name.indexOf(".")==-1 && !isPDS)
			{
				name+=".log";
				fileNameTextBox.set("value",name);
			}
			var extension='.log';
			if(!(endsWith(name.toLowerCase(),extension)) && !isPDS){
				name+=".log";
				fileNameTextBox.set("value",name);
			}
			/* find the index of the log in the logAreaContentPane */

			text="";

			pre=this.logAreaContentPane.domNode.getElementsByTagName("pre")[0];
			text=pre.innerText;

			if (!text)
			{
				text="";
				var children=pre.getElementsByTagName("div");
				for(i=0;i<children.length;i++)
				{
					var subchildren=children[i].getElementsByTagName("div");
					if (subchildren.length==0)
					{
						text+=children[i].innerHTML + "\n";
					}
//					else
//					for (j=0;j<subchildren.length;j++)
//					{
//					text+=subchildren[j].innerHTML + "\n";
//					}
				}
			}




//			console.log(text);

			//name = encodeURIComponent(name);
			//don't need / separator if path already ends with / or \
			var sep = '/';
			if (endsWith(projectPath, "/") || endsWith(projectPath, "\\"))
				sep = '';
			var url = this.baseURL + '/sasexec/sessions/' + this.sessionId + '/' + storageType + '/' + encodeValue(projectPath + sep + name, storageType == "ftprefs/save", "/", false);
			if (selectedObject && isPDS)
				url = this.baseURL + '/sasexec/sessions/' + this.sessionId + '/' + storageType + '/' + encodeValue(projectPath) + '(' + encodeValue(name) + ')';

			if (appDMS.optionPreferencesGeneral.defaultTextEncoding!="UTF-8")
			{
				url+="?encoding=" + appDMS.optionPreferencesGeneral.defaultTextEncoding;
			}


			this.commonSaveAs(selectedObject, projectPath, name, this.onReplaceLog, [text, url]);
		},
		onReplaceLog : function(text, url)
		{
			appDMS.dialogs.saveAsDialog.hide();
			dojo.xhrPost({
				postData : text,
				url : url,
				contentType : "text/file",
				handleAs : "json",
				preventCache : true,

				load: lang.hitch(this, function(data, args)
						{
							this.projects.onRefresh();
						}),
						error: function(err, args)
						{
							dojoAlert(err.response.xhr.getResponseHeader("Exception"));
						}
			});
			if (this.saveHandle)
			{
				dojo.disconnect(this.saveHandle);
				this.saveHandle=null;
			}
		},
		iEndHandler: function(event)
		{
			question=this.resourceBundle.switchQuestion3;
			this.interactiveQuestion=appDMS.dialogs.postDecisionDialog(question, null,
											  {label:this.resourceBundle.yes,
											  callback:dojo.hitch(this,this.endInteractive),
											  primary:true},
											  {label:this.resourceBundle.noLabel,
											  callback:dojo.hitch(this,this.cancelInteractive)});
		},
		endInteractive: function(event)
		{
			this.endInteractiveButton.set('disabled', true);
			this.interactiveQuestion.hide();
			this.mode="normal";
			this.endInteractiveButton.set("style","display:none");
			this.modeButton.set("style","display:inline-block");
			this.editor.readOnly(false);
			setTimeout(dojo.hitch(this,this.onResize),10);
			setTimeout(dojo.hitch(this,this.interactiveHack),500);
			this.submission=null;
			this.logURL=null;
			this.resultsURL=null;
			this.logAreaContentPane.set("content","");
			this.outputAreaContentPane.set("content","");
			this.outputPrintButton.set("disabled",true);
			this.mailResultsButton.set("disabled",false);
		    this.openResultsInNewBrowserTabButton.set("disabled", true);
		    this.logSaveButton.set("disabled",true);
			this.logSaveAsButton.set("disabled",true);
			this.logPrintButton.set("disabled",true);
			this.openlogBrowserTabButton.set("disabled",true);
			this.resultsClearButton.set("disabled",true);
			this.resultsClearButton.set("style","display: none");
			this.setLogClearState();

			dojo.xhrGet({
				handleAs:"json",
				preventCache:true,
				url: this.closeURL,
				load: dojo.hitch(this, function(submission)
				{
					this.endInteractiveButton.set('disabled', false);

					this.closeURL=null;
					this.projects.onRefresh();
					this.libraries.onRefresh();
					this.files.onRefresh();
					this.setButtonStates();
				}),
				error: dojo.hitch(this,function(err, args)
				{
					this.endInteractiveButton.set('disabled', false);

					this.closeURL=null;
					var msg=err.response.xhr.getResponseHeader("Exception");
					if (msg==null) msg=this.resourceBundle.unknownSubmissionErr;
					dojoAlert(msg);
				})
			});

		},

		setEditorToobarItemTitle: function (toolbarKey, title) {
		    if (this.hasOwnProperty(toolbarKey))
		        this[toolbarKey].set("title", title);
		},
		removeEditorToolbarItem: function(toolbarKey){
			if (this.hasOwnProperty(toolbarKey))
				this.editToolbar.removeChild(this[toolbarKey]);
		},
		createEditorToolbar: function()
		{
			var colStatus = new ContentPane({
				id:'colstatus'+this.editorTabContainer.id,
				content:"&nbsp",
				tabindex:'-1',
				region:"center",
				"class":"lineStatus lineStatusRight"
			});
			
			var fileLocationLabel = "";
			if(this.uri)
				fileLocationLabel = this.myTaskOrSnippetifyUri(this.getDecodedURI());
			
			var fileStatus = new ContentPane({
				id:'fileStatus'+this.editorTabContainer.id,
                content: appDMS.encodeHtml(fileLocationLabel),
                title: fileLocationLabel,
				tabindex: '-1',
				region:"left",
				"class":"lineStatus lineStatusLeft"
			});
			
			var encodingCP = new ContentPane({
				id:this.editorTabContainer.id+"_encodingCP",
				tabindex:"-1",
				region:"right",
				"class":"lineStatus lineStatusEncoding"
			});
			
			var encodingLabel = appDMS.sasStudioPreferences.optionPreferencesGeneral.defaultTextEncoding;
			
			if(this.encoding)
				encodingLabel=this.encoding;
			
			encodingCP.setContent(encodingLabel);
			
			this.editStatusBarBC.addChild(colStatus);
			this.editStatusBarBC.addChild(fileStatus);
			this.editStatusBarBC.addChild(encodingCP);

			this.editToolbar = new dijit.Toolbar({
			    id: this.editorTabContainer.id + '_toolbar',
			    'class': "editToolbar"
			}, "editToolbar");

			this.submitButton = new dijit.form.Button({
				iconClass: 'sasSubmitIcon',
// label: 'Run code (F3)',
				label: this.resourceBundle.runCodeLabel,
				onClick: dojo.hitch(this, this.submitHandler),
				showLabel: false,
				disabled: true,
				id: this.editorTabContainer.id + '_submitBtn'}
			);

			this.backgroundSubmitButton = new dijit.form.Button({
				iconClass: 'sasSubmitFormIcon',
				label: this.resourceBundle.backrunCodeLabel,
				onClick: dojo.hitch(this, this.submitBackgroundHandler),
				showLabel: false,
				disabled: true,
				id: this.editorTabContainer.id + '_backgroundsubmitBtn'}
			);

			try
			{
				if (appDMS.session.sasOS.indexOf('z/OS') == 0)
					this.backgroundSubmitButton.set("style","display:none");
			
				if (allowBatchSubmit==false)
					this.backgroundSubmitButton.set("style","display:none");
				
				if (showBackgroundSubmitButton==false)
					this.backgroundSubmitButton.set("style","display:none");
			}
			catch(e)
			{
				this.backgroundSubmitButton.set("style","display:none");
			}
		
			this.cancelButton = new dijit.form.Button({
				iconClass: 'sasCancelIcon',
// Cancel button:
				label: this.resourceBundle.cancelLabel,
				onClick: dojo.hitch(this, this.cancelHandler),
				showLabel: false,
				disabled: true,
				id: this.editorTabContainer.id + '_cancelBtn'}
			);

			  this.newButton = new dijit.form.Button({
			  // label: 'New',
			  iconClass: 'treeProjectSASFile',
			  onClick: lang.hitch(this, this.onNew),
			  showLabel: true
			  });

			this.saveButton = new dijit.form.Button({
				iconClass: 'sasSaveIcon',
// label: 'Save',
				label: this.resourceBundle.saveProgram,
				onClick: lang.hitch(this, this.saveFile),
				showLabel: false}
			);

			this.saveAsButton = new dijit.form.Button({
				iconClass: 'sasSaveAsIcon',
// label: 'Save program to a project',
				label: this.resourceBundle.saveProgramToFileLabel,
				onClick: lang.hitch(this, this.saveFileAsNoClose),
				showLabel: false}
			);

			this.templateButton = new dijit.form.Button({
				iconClass: 'sasCodeIcon',
// label: 'Insert SAS code',
				label: this.resourceBundle.saveSnippet,
				onClick: lang.hitch(this, this.saveSnippet),
				showLabel: false}
			);

			this.printCodeButton = new dijit.form.Button({
				iconClass: 'sasPrintIcon',
// label: 'Print program',
				label: this.resourceBundle.printProgram,
				onClick: lang.hitch(this, this.onPrintCode),
				showLabel: false}
			);

			this.summaryButton = new dijit.form.Button({
				iconClass: 'sasHTMLFileIcon',
// label: 'Program summary',
				label: this.resourceBundle.programSummary,
				onClick: lang.hitch(this, this.onSummarizeCode),
				showLabel: false,
				disabled: true}
			);

			this.undoButton = new dijit.form.Button({
				iconClass: 'sasUndoIcon',
// label: 'Undo',
				label: this.resourceBundle.undo,
				onClick: lang.hitch(this, function(){
					this.editor.undo();
				}),
				showLabel: false}
			);

			this.redoButton = new dijit.form.Button({
				iconClass: 'sasRedoIcon',
// label: 'Redo',
				label: this.resourceBundle.redo,
				onClick: lang.hitch(this, function()
						{
					this.editor.redo();
						}),
						showLabel: false}
			);

			this.lastSubmitMenu = new DropDownMenu({});
			var currentSelection = this.submitStack[0];
			this.rsButton = new DropDownButton({
				iconClass: 'sasHistoryIcon',
				label: this.resourceBundle.recallLastSubmits,
				name: 'ddbutton',
				dropDown: this.lastSubmitMenu,
				id: this.editorTabContainer.id + '_ddbutton',
				showLabel: false
			});
			this.rsButton.titleNode.setAttribute("aria-labelledby", "");
			this.gotoButton = new dijit.form.Button({
// label: 'Go to specified line',
				label: this.resourceBundle.gotoLine,
				iconClass: 'sasGoToLineIcon',
				onClick: lang.hitch(this, function()
						{
							var line = this.gotoInput.get("value");
							if (line)
							{
								if (line > this.editor.lineCount())
								{
// dojoAlert("The specified line number exceeds the number of lines in the
// program.");
									dojoAlert(this.resourceBundle.lineNumberExceedsTotalLines);
								}
								else
								{
									this.editor.gotoLine(line);
								}
							}
						}),
				showLabel: false}
			);

			this.endInteractiveButton = new dijit.form.Button({
				iconClass: 'sasActivateIcon',
				"class": "ButtonPressed",
// label: 'Run code (F3)',
				label: this.resourceBundle.CloseIMode,
				title: this.resourceBundle.CloseIModeTip,
				onClick: dojo.hitch(this, this.iEndHandler),
				showLabel: false,
				style: "display:none",
				id: this.editorTabContainer.id + '_iendBtn'}
			);

		var gotoInputStyle = "";
		if(window.dojo.locale == "en-us")
		    gotoInputStyle = "width: 50px;margin-left: 5px";
		else
		    gotoInputStyle = "width: 90px";

		this.gotoInput = new dijit.form.NumberTextBox({
				constraints:{min:1,places:1, pattern:'#.#', fractional:false},
				invalidMessage: this.resourceBundle.invalidLineNumber,
				rangeMessage:  this.resourceBundle.invalidLineNumber,
				placeHolder: this.resourceBundle.lineNumberPlaceHolder,
				style: gotoInputStyle,
				name: 'goToInput',
				onKeyPress: lang.hitch(this, function(evt)
				{
					if (evt.keyCode == 13) // enter
					{
						setPreventDefault(evt);
						var line = this.gotoInput.get("value");
						if (line && line > 0 && line <= this.editor.lineCount())
						{
							this.editor.gotoLine(line);
						}
					}
					if (evt.keyCode == 39 || evt.keyCode == 37) // enter
					{
						
						var lineValueLen = this.gotoInput.textbox.value.length;
						var lineStart = this.gotoInput.textbox.selectionStart;
						var lineEnd = this.gotoInput.textbox.selectionEnd;
						//right arrow
						if(evt.keyCode == 39){
							if(lineValueLen > lineEnd){
								evt.stopPropagation();
							}
								
						}
						//left arrow
						else if(evt.keyCode == 37){
							if(0 < lineStart){
								evt.stopPropagation();
							}
								
						}
						
					}
				})
		});

		//sometimes the placeholder likes to get in the way.
		on(this.gotoInput._phspan, "click", lang.hitch(this, function(){
			this.focus.focus(this.gotoInput.focusNode);
		}));

		/*
		 * this.gotoInputSpacer = new dijit.form.Button({ class:
		 * "ToolBarSpacerButton", style: "width: 4px", disable: true } );
		 */


			this.cutButton = new dijit.form.Button({
				iconClass: 'sasCutIcon',
// label: 'Cut code',
				label: this.resourceBundle.cutCode,
				onClick: lang.hitch(this, function(){
					this.editor.cut();
				}),
				showLabel: false}
			);

			this.copyButton = new dijit.form.Button({
				iconClass: 'sasCopyIcon',
// label: 'Copy code',
				label: this.resourceBundle.copyCode,
				onClick: lang.hitch(this, function()
						{
					this.editor.copy();
						}),
						showLabel: false}
			);

			this.pasteButton = new dijit.form.Button({
				iconClass: 'sasPasteIcon',
// label: 'Paste',
				label: this.resourceBundle.pasteCode,
				onClick: lang.hitch(this, function(){
					this.editor.paste();
				}),
				showLabel: false}
			);
			this.pasteButton.set("aria-label",this.resourceBundle.pasteCode);

			this.clearButton = new dijit.form.Button({
				iconClass: 'sasClearAllIcon',
// label: 'Clear all code',
				label: this.resourceBundle.clearAllCode,
				onClick: lang.hitch(this, this.clearAll),
				showLabel: false}
			);

			this.findButton = new dijit.form.Button({
				iconClass: 'sasFindIcon',
// label: 'Find and replace code',
				label: this.resourceBundle.findAndReplaceCode,
				onClick: lang.hitch(this,this.showFindReplaceDialog),
				showLabel: false}
			);

			this.modeButton = new dijit.form.Button({
				iconClass: 'sasActivateIcon',
// label: 'Find and replace code',
				label: this.resourceBundle.switchToInteractive,
				onClick: lang.hitch(this,this.goInteractive),
				showLabel: false}
			);

			this.saveButton.setAttribute("disabled", true);
			//this.editToolbar.addChild(this.newButton);
			this.editToolbar.addChild(this.submitButton);
			this.editToolbar.addChild(this.backgroundSubmitButton);
			//this.editToolbar.addChild(this.cancelButton);
			this.editToolbar.addChild(this.rsButton);
			// this.editToolbar.addChild(this.gotoInputSpacer);


			this.editToolbar.addChild(this.saveButton);
			this.editToolbar.addChild(this.saveAsButton);
			this.editToolbar.addChild(this.summaryButton);
		    //this.editToolbar.addChild(new dijit.ToolbarSeparator());
			this.saveSeparator = new dijit.ToolbarSeparator();
			this.editToolbar.addChild(this.saveSeparator);
			this.editToolbar.addChild(this.templateButton);
			this.editToolbar.addChild(new dijit.ToolbarSeparator());
			this.editToolbar.addChild(this.printCodeButton);
			this.undoSeparator = new dijit.ToolbarSeparator();
			this.editToolbar.addChild(this.undoSeparator);
			this.editToolbar.addChild(this.undoButton);
			this.editToolbar.addChild(this.redoButton);

			this.editToolbar.addChild(new dijit.ToolbarSeparator());
			this.editToolbar.addChild(this.cutButton);
			this.editToolbar.addChild(this.copyButton);
			this.editToolbar.addChild(this.pasteButton);

			this.editToolbar.addChild(new dijit.ToolbarSeparator());
		// this.editToolbar.addChild(this.gotoInputSpacer);
			this.editToolbar.addChild(this.gotoInput);
			this.editToolbar.addChild(this.gotoButton);
			this.editToolbar.addChild(new dijit.ToolbarSeparator());
			this.editToolbar.addChild(this.clearButton);
			this.editToolbar.addChild(this.findButton);
			this.editToolbar.addChild(new dijit.ToolbarSeparator());
			if (sasVersionShort >= 9.41)
			{
				this.editToolbar.addChild(this.modeButton);
				this.editToolbar.addChild(this.endInteractiveButton);
			}

// this.editToolbar.addChild(this.toggleUpButton);
// this.editToolbar.addChild(this.toggleDownButton);
// this.editToolbar.addChild(this.recallSubmitsButton);
// this.recallSubmitsButton.set('disabled', true);
			this.makeEditorTips();
		},

		cancelHandler: function(event)
		{
			console.log(event);

			var ok=function()
			{
				this.cancelSubmitHandler();
				this.cancelDecisionDialog.hide();
			};

			var cancel=function()
			{
				this.cancelDecisionDialog.hide();
			};

			var question=this.resourceBundle.cancelConfirm;

			this.cancelDecisionDialog = appDMS.dialogs.postDecisionDialog(question, null,
																	          {label:this.resourceBundle.yes,
																	          callback:lang.hitch(this,ok),
																	          primary:true},
																	          {label:this.resourceBundle.noLabel,
																	          callback:lang.hitch(this,cancel)});
		},


		goInteractive: function()
		{
			this.submitButton.set('disabled',true);
			this.backgroundSubmitButton.set("disabled",true);
			this.modeButton.set('disabled', true);

			this.oldLength=0;

//			this.interactiveToolbar.set("style","display:block");
			this.mode="interactive";
//			this.editor.readOnly(true);
//			setTimeout(dojo.hitch(this,this.onResize),10);
//			setTimeout(dojo.hitch(this,this.interactiveHack),500);
//			this.commandInputField.focus();

			var label=this.name;
			if (label==null || label.length === 0) // || this.isVirgin()) //
												// comment out for now
// label="untitled";
				label=this.resourceBundle.untitled;
			var _uri=this.uri;
			var _uriPassValue=_uri;
			if (_uri==null){
				_uri="";
				_uriPassValue = label;
			}

			// Make sure the message loop is running.
            appDMS.startMessageServiceLoop();

			var _url= this.baseURL+'/sasexec/sessions/' + this.sessionId + '/submissions?mode=interactive&label=' + encodeValue(label) +  "&uri=" + encodeValue(_uriPassValue);

			dojo.xhrPost({
				postData:"",
				handleAs:"json",
				preventCache:true,
				url: _url,
				headers:
				{
					"Content-Type":"text/plain; charset=utf-8"
				},
				load: dojo.hitch(this, function(submission)
				{
					this.submission=submission;
					this.submitID=submission.id;
					this.outputAreaContentPane.domNode.id="ods_" + submission.id;
					dojo.addClass(this.outputAreaContentPane.domNode,"ods_" + submission.id);

					this.logURL=this.baseURL+"/sasexec/submissions/" + submission.id + "/log";
					this.resultsURL=this.baseURL+"/sasexec/submissions/" + submission.id + "/results";
					this.addURL=this.baseURL+"/sasexec/submissions/" + submission.id + "/add";
					this.closeURL=this.baseURL+"/sasexec/submissions/" + submission.id + "/close";

					this.outputAreaContentPane.set('href', this.resultsURL);
					this.logAreaContentPane.set('href', this.logURL);
					
					//remove data tab while going interactive - S1279242
					this.removeDataTab();

					this.outputPrintButton.set("disabled",false);
					this.mailResultsButton.set("disabled",true);
				    this.openResultsInNewBrowserTabButton.set("disabled", false);
					this.logSaveButton.set("disabled",false);
					this.logSaveAsButton.set("disabled",false);
					this.logPrintButton.set("disabled",false);
					this.openlogBrowserTabButton.set("disabled",false);
					this.clearLogButton.set("disabled",false);
					this.resultsClearButton.set("disabled",false);
					this.resultsClearButton.set("style","display:inline-block");
					this.clearLogButton.set("style","display:inline-block");
					this.logClearSeparator.set("style","display:inline-block");
					this.submitButton.set('disabled',false);
					this.backgroundSubmitButton.set('disabled',true);
					this.setButtonStates();

					var refresh=function()
					{
						this.outputAreaContentPane.refresh();
						this.logAreaContentPane.refresh();

					};

					setTimeout(dojo.hitch(this,refresh),20);
					this.modeButton.set('disabled', false);
				}),
				error: dojo.hitch(this,function(err, args)
				{
					var msg=err.response.xhr.getResponseHeader("Exception");
					if (msg==null) msg=this.resourceBundle.unknownSubmissionErr;
					dojoAlert(msg);
				})
			});


		},

		/**
		 * Fix for S1072280. Call close on individual submissions to cleanup more regularly.
		 */

		closeSubmissions: function()
		{
			if (this.mode=='interactive' && this.closeURL)
			{
				dojo.xhrGet({
					handleAs:"json",
					preventCache:true,
					url: this.closeURL,
					load: dojo.hitch(this, function(submission)
					{
					}),
					error: dojo.hitch(this,function(err, args)
					{
					})
				});
			}

			if (this.submitStack)
			{
				var i=0;
				for(i=0;i<this.submitStack.length;i++)
				{
					var _url=this.baseURL+"/sasexec/submissions/" + this.submitStack[i].submission.id + "/close";
					dojo.xhrGet({
						handleAs:"json",
						preventCache:true,
						url: _url,
						load: dojo.hitch(this, function(submission)
						{
						}),
						error: dojo.hitch(this,function(err, args)
						{
						})
					});
				}
			}
		},

		cancelInteractive: function()
		{
			this.interactiveQuestion.hide();
		},
		interactiveHack: function()
		{
			this.editContentPane.resize();
			if (this.mode=="interactive")
				setTimeout(dojo.hitch(this,this.commandLineFocus),20);
			else
				this.onResize();
		},


		addFormatCodeButton: function()
		{
			if (this.formatCodeButton!=null) return;

				this.formatCodeButton = new dijit.form.Button({
				iconClass: 'sasFormatIcon',
				showLabel: false,
				// label: 'Format Code',
				label: this.resourceBundle.formatCodeLabel,
				onClick: dojo.hitch(this, this.formatCodeHandler),
				//showLabel: false,
				id: this.editorTabContainer.id + '_formatCodeBtn'}
			);
			this.formatCodeButton.set("title", this.resourceBundle.formatCodeTitle);

			this.editToolbar.addChild(this.formatCodeButton);
			this.editToolbar.addChild(new dijit.ToolbarSeparator());
		    // maximize view button should be the last button on the edit toolbar
			this.addMaximizeViewButton();
		},

		addMaximizeViewButton:  function()
		{
			if (this.editorMaxViewButton==null)
			{

			this.editorMaxViewButton = new dijit.form.Button({
			iconClass: 'sasMaximizeViewIcon',
				onClick: lang.hitch(this,this.onMaxView),
				showLabel: false}
			);

			this.editToolbar.addChild(this.editorMaxViewButton);
			}
			if (this.outputMaxViewButton==null)
			{

			this.outputMaxViewButton = new dijit.form.Button({
			iconClass: 'sasMaximizeViewIcon',
				onClick: lang.hitch(this,this.onMaxView),
				showLabel: false}
			);

			this.outputToolbar.addChild(this.outputMaxViewButton);

			this.setMaxViewButtonAttribs(this.appDMS.perspectiveMaximized[this.appDMS.currentPerspectiveKey]);
			this.outputMaxViewButton.set("disabled",false);
			}
		},
		setMaxViewButtonAttribs: function(isMaxView){
		   if (typeof isMaxView == "undefined")
		   	  {
			   this.editorMaxViewButton.setAttribute("label", this.resourceBundle.maximizeView);
   			   this.editorMaxViewButton.setAttribute("title", this.resourceBundle.maximizeView);
   			   this.editorMaxViewButton.setAttribute("aria-label", this.resourceBundle.maximizeView);
		       return;
		      }
		   //display appropriate label for both max view buttons depending on current view
		   if (isMaxView.toString()=='true')
			{
			   if(this.editorMaxViewButton)
			   {
			   this.editorMaxViewButton.setAttribute("label", this.resourceBundle.maximizeViewExit);
   			   this.editorMaxViewButton.setAttribute("title", this.resourceBundle.maximizeViewExit);
			   this.editorMaxViewButton.setAttribute("aria-label", this.resourceBundle.maximizeViewExit);
			   this.editorMaxViewButton.set("iconClass","sasNormalViewIcon");
			   }
			   if(this.outputMaxViewButton){
		       this.outputMaxViewButton.setAttribute("label", this.resourceBundle.maximizeViewExit);
   			   this.outputMaxViewButton.setAttribute("title", this.resourceBundle.maximizeViewExit);
			   this.outputMaxViewButton.setAttribute("aria-label", this.resourceBundle.maximizeViewExit);
			   this.outputMaxViewButton.set("iconClass","sasNormalViewIcon");
			   }
			   if(this.logMaxViewButton){
			       this.logMaxViewButton.setAttribute("label", this.resourceBundle.maximizeViewExit);
	   			   this.logMaxViewButton.setAttribute("title", this.resourceBundle.maximizeViewExit);
				   this.logMaxViewButton.setAttribute("aria-label", this.resourceBundle.maximizeViewExit);
				   this.logMaxViewButton.set("iconClass","sasNormalViewIcon");
				   }
			}
			else
			{
			   if (this.editorMaxViewButton){
			   this.editorMaxViewButton.setAttribute("label", this.resourceBundle.maximizeView);
   			   this.editorMaxViewButton.setAttribute("title", this.resourceBundle.maximizeView);
   			   this.editorMaxViewButton.setAttribute("aria-label", this.resourceBundle.maximizeView);
			   this.editorMaxViewButton.set("iconClass","sasMaximizeViewIcon");
			   }
			   if (this.outputMaxViewButton){
			   this.outputMaxViewButton.setAttribute("label", this.resourceBundle.maximizeView);
   			   this.outputMaxViewButton.setAttribute("title", this.resourceBundle.maximizeView);
   			   this.outputMaxViewButton.setAttribute("aria-label", this.resourceBundle.maximizeView);
			   this.outputMaxViewButton.set("iconClass","sasMaximizeViewIcon");
			   }
			   if (this.logMaxViewButton){
				   this.logMaxViewButton.setAttribute("label", this.resourceBundle.maximizeView);
	   			   this.logMaxViewButton.setAttribute("title", this.resourceBundle.maximizeView);
	   			   this.logMaxViewButton.setAttribute("aria-label", this.resourceBundle.maximizeView);
				   this.logMaxViewButton.set("iconClass","sasMaximizeViewIcon");
				   }
			}

		},

		recall: function()
		{
			this.data.name = this.data.name;
			appDMS.handleWebOneEvent("RecallSubmission", this.data);
		},


		showFindReplaceDialog : function()
		{
			try
			{
				this.editor.showFindReplaceDialog();
				this.finding = true;
				var dlg=dijit.byId("find_replace_dlg");
				domStyle.set(dlg.titleBar, "width", "auto");
				var closeButton=dijit.byId("SAS.CE.FR.btnClose");
				domClass.add(closeButton.domNode, "sasPrimaryButton");
			}
			catch(e)
			{
				dojoAlert(e);
			}
		},
		makeEditorTips: function()
		{
			this.newButton.set("title", this.resourceBundle['new']);
			this.submitButton.set("title", this.resourceBundle.runCodeLabel);
			this.backgroundSubmitButton.set("title", this.resourceBundle.backrunCodeLabel);
			this.saveAsButton.set("title",this.resourceBundle.saveAs);
			this.saveButton.set("title",this.resourceBundle.saveProgram);
			this.printCodeButton.set("title",this.resourceBundle.printCode);
			if (this.uri && this.uri.indexOf(".sas") != -1)
			{
			this.undoButton.set("title",this.resourceBundle.undo);
			this.redoButton.set("title",this.resourceBundle.redo);
			this.cutButton.set("title",this.resourceBundle.cutCode);
			this.pasteButton.set("title",this.resourceBundle.pasteCode);
			this.clearButton.set("title",this.resourceBundle.clearAllCode);
			}
			this.gotoButton.set("title",this.resourceBundle.gotoLine);
			this.gotoInput.set("title",this.resourceBundle.specifyLineNumber);
			this.gotoInput.setAttribute("aria-label",this.resourceBundle.specifyLineNumber);
			this.copyButton.set("title",this.resourceBundle.copyCode);
			this.findButton.set("title",this.resourceBundle.findAndReplaceCode);
			this.rsButton.setAttribute("aria-label",this.resourceBundle.recallLastSubmits);
            this.saveAsButton.set("aria-label",this.resourceBundle.saveProgramToFileLabel);
		},
		addEditToToolbar: function(taskArea)
		{
			this.editButton = new dijit.form.Button({
				label: this.resourceBundle.Edit,
				onClick: lang.hitch(this,this.goToEditMode),
				showLabel: true}
			);
			this.editToolbar.addChild(this.editButton);
			this.editButton.set("title", this.resourceBundle.EditTip);
			this.taskArea = taskArea;
			// disable autosave on tasks for now
			clearInterval(this.autoSaveTimeout);
			this.modeButton.set("style","display:none");
			//Maximize view button should be the last button on toolbar
			this.editSeparator = new dijit.ToolbarSeparator();
			this.editToolbar.addChild(this.editSeparator);
		},

		goToEditMode: function()
		{
				appDMS.handleWebOneEvent('TaskCodeEdit', {name: this.resourceBundle.untitled,
					type: 'newprogram', code:this.editor.getText(), editorContentChanged:true});

/**
			// create a new editor instead of this.
		    this.editor.readOnly(false);
		    this.fileType="SAS";
			this.editButton.setAttribute("disabled", true);
			this.editToolbar.removeChild(this.editSeparator);

			this.submitButton.setAttribute("disabled", false);
			this.backgroundSubmitButton.setAttribute("disabled", false);
			this.addFormatCodeButton();

			// Remove the task area.

			this.editorTabContainer.removeChild(this.taskArea.taskContainer);
			this.sasSuiteTabContainer.set("style", "width:100%");
			this.onResize();

			this.setTaskMode(false);
*/
		},


		promptForEditMode: function()
		{
			var question=this.resourceBundle.ExitTaskMode;

			var ok=function()
			{
				this.goToEditMode();
				this.endTaskGenerationDialog.hide();
			};

			var cancel=function()
			{
				this.endTaskGenerationDialog.hide();
			};

			this.endTaskGenerationDialog = appDMS.dialogs.postDecisionDialog(question, null,
																	          {label:this.resourceBundle.yes,
																	          callback:lang.hitch(this,ok),
																	          primary:true},
																	          {label:this.resourceBundle.noLabel,
																	          callback:lang.hitch(this,cancel)});
		},

		setButtonStates: function(/* boolean */ disconnected)
		{
			if (this.editorContentChanged === true)
			{
				this.saveButton.setAttribute("disabled", false);
				this.saveAsButton.setAttribute("disabled", false);
				if (this.saveTaskButton)
					this.saveTaskButton.setAttribute("disabled", false);
			}
			else
			{
				this.saveButton.setAttribute("disabled", true);
				if (this.saveTaskButton)
					this.saveTaskButton.setAttribute("disabled", true);

			}
			var code = null;
			if (this.editor)
			{
				code = this.editor.getText(); // this.textarea.getDisplayedValue();
				if (this.editor.canUndo())
					this.undoButton.setAttribute("disabled", false);
				else
					this.undoButton.setAttribute("disabled", true);
				if (this.editor.canRedo())
					this.redoButton.setAttribute("disabled", false);
				else
					this.redoButton.setAttribute("disabled", true);

				if (this.editor.canPaste())
					this.pasteButton.setAttribute("disabled", false);
				else
					this.pasteButton.setAttribute("disabled", true);

				var selcode=this.editor.getSelectedText();
				if (selcode==null || selcode.length === 0)
				{
					this.cutButton.setAttribute("disabled",true);
					this.copyButton.setAttribute("disabled",true);
				}
				else
				{
					this.cutButton.setAttribute("disabled",false);
					this.copyButton.setAttribute("disabled",false);
				}
			}

			if (code!=null && code.length>0)
			{
				this.clearButton.setAttribute("disabled", false);
				this.submitButton.setAttribute("disabled", false);
				this.backgroundSubmitButton.setAttribute("disabled", false);
				this.findButton.setAttribute("disabled", false);
			}

			if (this.isVirgin())
			{
				this.saveButton.setAttribute("disabled", false);
			}
			if (this.submitCount == 0)
			{
				this.rsButton.setAttribute("disabled", true);
			}
			if (!this.connected)
			{
				/* until I look at local storage, turn off save */
				this.saveButton.setAttribute('disabled', true);
				this.printCodeButton.setAttribute('disabled', true);
				this.submitButton.setAttribute('disabled', true);
				this.backgroundSubmitButton.setAttribute('disabled', true);
				this.saveAsButton.setAttribute("disabled", true);
				this.templateButton.setAttribute('disabled', true);
				// then disable log and results windows
			}
			else {
				this.templateButton.setAttribute('disabled', false);
			}
			// TODO: This is kind of lame.
			//I dont think we need it. S1172965.
//			if (this.name && this.name.indexOf(this.resourceBundle.readOnly) > -1)
//			{
//		 		this.recallReadOnly=true;
//			} else 	{
//					this.recallReadOnly=false;
//			}
			if (this.recallReadOnly == true)
			{
				this.saveButton.setAttribute("disabled", true);
				this.saveAsButton.setAttribute("disabled", false);
				this.submitButton.setAttribute("disabled", true);
				this.backgroundSubmitButton.setAttribute("disabled", true);
				this.rsButton.setAttribute("disabled", true);
				this.clearButton.setAttribute("disabled", true);
			}

			if (this.taskMode)
			{
				try
				{
					if (reportApp)
					{
						if (this.sasSuiteTabContainer.domNode)
						{
							try
							{
								var div=this.sasSuiteTabContainer.domNode.getElementsByClassName("dijitTabListWrapper");
								div[0].style.display="none";
								this.sasSuiteTabContainer.resize();
							}
							catch(e)
							{
								console.log(e);
							}
						}
					}

					if (this.shareTaskButton)
					{
						var canShare = false;
						var canPreview = false;
						if (sasMode != 'internal') {
							var reportPath = this.getReportPath();
							if (reportPath) {
								canPreview = true;
								canShare = (sasMode != 'single');
							}
						}

						if (this.shareTaskButton) {
							this.shareTaskButton.setAttribute("disabled", !canShare);
						}
						if (this.testTaskButton) {
							this.testTaskButton.setAttribute("disabled", !canPreview);
						}
					}
				}
				catch(e)
				{
					console.log(e);
				}

				this.clearButton.setAttribute("disabled", true);
				this.undoButton.setAttribute("disabled", true);
				this.cutButton.setAttribute("disabled", true);
				this.pasteButton.setAttribute("disabled", true);
				this.setLogClearState();			
			}
			else
			{
				if (this.editor)
				{
					if (this.editor.canUndo())
						this.undoButton.setAttribute("disabled", false);
					if (this.editor.canPaste())
						this.pasteButton.setAttribute("disabled", false);
			    }
			}

			if (this.mode=="interactive")
			{
//				this.undoButton.setAttribute("disabled", true);
//				this.cutButton.setAttribute("disabled", true);
//				this.pasteButton.setAttribute("disabled", true);
				this.templateButton.setAttribute("disabled", true);
				this.rsButton.setAttribute("disabled", true);
				this.outputSaveButton.set("disabled",true);
				this.outputPDFButton.set("disabled",true);
				this.outputRTFButton.set("disabled",true);
				this.modeButton.set("style","display:none");
				this.backgroundSubmitButton.setAttribute("disabled", true);
				this.endInteractiveButton.set("style","display:inline-block");
				//why it is enabled here S1173287
				//this.summaryButton.set("disabled",true);
			}

			// Code buttons
			this.summaryButton.set("disabled",this.resultsURL==null);

			// Results buttons
			this.outputSaveButton.set("disabled",this.resultsURL==null);
			this.outputPrintButton.set("disabled",this.resultsURL==null);
			if (this.mode!="interactive")
			{
				this.outputPDFButton.set("disabled",this.pdfURL==null);
		    	this.outputRTFButton.set("disabled",this.rtfURL==null);
		    }
		    else
		   	{
		   		this.outputPDFButton.set("disabled",true);
		    	this.outputRTFButton.set("disabled",true);
		   	}
		   	
		    this.openResultsInNewBrowserTabButton.set("disabled", this.resultsURL==null);
			this.mailResultsButton.set("disabled", this.resultsURL==null || this.mode=="interactive");

			// Log buttons
			this.logSaveAsButton.set("disabled",this.logURL==null);
			this.logSaveButton.set("disabled",this.logURL==null);
			this.logPrintButton.set("disabled",this.logURL==null);
			this.openlogBrowserTabButton.set("disabled",this.logURL==null);

		    if (this.fileType=="CPK")
		    {
		    	this.outputPrintButton.set("disabled",false);
		    	this.logPrintButton.set("disabled",false);
		    	this.openlogBrowserTabButton.set("disabled",false);
		    	this.openResultsInNewBrowserTabButton.set("disabled",false);
		    	this.templateButton.setAttribute("disabled", false);
		    }

//		    if (this.editor)
//		    {
//		    	if (this.editor.getText().trim().length==0)
//		    		this.summaryButton.set("disabled",true);
//		    	else
//		    		this.summaryButton.set("disabled",false);
//		    }


//			if (this.mode=="interactive")
//			{
//				this.summaryButton.set("disabled",true);
//			}

		},
		// 2014-07-02 sasjkx get path to task (.ctm or .ctk) on disk, or empty string
		//	TaskRuntime provides uri when opening a ctk.  However, this.uri
		//	seems to influence other things, so I'm not certain whether it's
		//	appropriate to add support for .ctm's as reports by merely setting
		//	editor uri for them as well.  Therefore without code changes, in
		//	.ctm case, uri is not available.
		//	Note that built-in tasks are excluded as they have .xml extension,
		//	which isn't considered a report by reportAppUtil.isReportExtension.
		//
		//	Note choice was made that neither preview nor share should be allowed
		//	for My Tasks.  So, filtering those out here at a somewhat low level.
		getReportPath: function() {
			var rc = "";

			// if uri is present -- that determines it
			if (this.uri) {
				if (reportAppUtil.isReportExtension(this.uri)) {
					rc = this.uri;
				}
			}
			// else ONLY if there's no uri, consider testing task filepath
			else if (this.taskArea && this.taskArea.task &&
				reportAppUtil.isReportExtension(this.taskArea.task.filePath))
			{
				rc = this.taskArea.task.filePath;
			}

			// Don't allow anything in My Tasks
			if (rc && reportAppUtil.isMyTasksPath(rc)) {
				rc = "";
			}

			return rc;
		},
		commandLineFocus: function()
		{
			this.commandInputField.focus();
		},

		cancelTimeout: function()
		{
			var killCB=function()
			{
				if (this.killConfirmDialog) {
					this.killConfirmDialog.hide();
					this.killConfirmDialog=null;
				}
				var url = this.baseURL + '/sasexec/sessions/' + this.sessionId + '/kill';

				dojo.xhrGet({
					url : url,
					handleAs : "json",
					preventCache : true,
					sync: false,
					load: lang.hitch(this, function(data, args)
						{

						// It may actually be better to wait for the completed event before we assume the submission has completed.
						this.running=false;
						this.removeTabBusyIcon();

						this.submitButton.set("disabled",false);
						this.backgroundSubmitButton.set("disabled",false);
						this.cancelButton.set("disabled",true);

						if (this.taskArea)
						{
							this.taskArea.cancelButton.set("disabled",true);
							this.taskArea.enableRunSubmitButton();
						}


						if (autoLoginUser && autoLoginUser.length > 0)
						{
							this.invalidateSession();
							unloaded=true;
							allowConfirm = false;
							window.location.href='signout?locale=' + initLocale;
							return;
						}
						else if (sasMode=="internal")
						{
							this.invalidateSession();
							unloaded=true;
							allowConfirm = false;
							window.location.href='internal?locale=' + initLocale;
							return;
						}
						else if (sasOS.indexOf("DNT")>-1)
						{
							this.invalidateSession();
							unloaded=true;
							allowConfirm = false;
							window.location.href='signout?locale=' + initLocale;
							return;
						}
						else
						{
							this.removeTabBusyIcon();

							if (this.submitDialog)
							{
								this.submitDialog.hide();
								this.submitDialog=null;
							}
							if (this.killConfirmDialog) {
								this.killConfirmDialog.hide();
								this.killConfirmDialog=null;
							}

							appDMS.submissionCancelAction=false;
							this.logURL=null;
							this.resultsURL=null;
							this.pdfURL=null;
							this.rtfURL=null;
							this.dataURL=null;

							var reset=function()
							{
					//			this.outputAreaContentPane.set("content",this.resourceBundle.submissionCanceled);
					//			this.logAreaContentPane.set("content",this.resourceBundle.submissionCanceled);
								this.projects.onRefresh();
								this.libraries.onRefresh();
								this.files.onRefresh();

								appDMS.sessionHasBeenReset();

								if (this.mode=="interactive")
								{
									this.resetInteractive();
									return;
								}
							}

							setTimeout(lang.hitch(this,reset),100);

						}
						}),
					error: lang.hitch(this,function(err, args)
						{
						this.running=false;
						this.removeTabBusyIcon();

						if (sasMode=="single")
						{
							this.invalidateSession();
							unloaded=true;
							allowConfirm = false;
							window.location.href='signout?locale=' + initLocale;
							return;
						}
						else if (autoLoginUser && autoLoginUser.length > 0)
						{
							this.invalidateSession();
							unloaded=true;
							allowConfirm = false;
							window.location.href='signout?locale=' + initLocale;
							return;
						}
						else if (sasMode=="internal")
						{
							this.invalidateSession();
							unloaded=true;
							allowConfirm = false;
							window.location.href='internal?locale=' + initLocale;
							return;
						}
						else if (sasOS.indexOf("DNT")>-1)
						{
							this.invalidateSession();
							unloaded=true;
							allowConfirm = false;
							window.location.href='signout?locale=' + initLocale;
							return;
						}
						else
						{
							if (this.submitDialog)
							{
								this.submitDialog.hide();
								this.submitDialog=null;
							}
							if (this.killConfirmDialog) {
								this.killConfirmDialog.hide();
								this.killConfirmDialog=null;
							}


							appDMS.submissionCancelAction=false;
							this.logURL=null;
							this.resultsURL=null;
							this.pdfURL=null;
							this.rtfURL=null;
							this.dataURL=null;

							var reset=function()
							{
							//	this.outputAreaContentPane.set("content",this.resourceBundle.submissionCanceled);
							//	this.logAreaContentPane.set("content",this.resourceBundle.submissionCanceled);
								this.projects.onRefresh();
								this.libraries.onRefresh();
								this.files.onRefresh();

								if (this.mode=="interactive")
								{
									this.resetInteractive();
									return;
								}
							}

							setTimeout(lang.hitch(this,reset),100);


						}
					})
				});

			}

			var cancelCB=function()
			{
				if (this.killConfirmDialog) {
					this.killConfirmDialog.hide();
					this.killConfirmDialog=null;
				}
				this.cancelTimer=setTimeout(lang.hitch(this,this.cancelTimeout),15*1000);
			}

			var question=this.resourceBundle.KillConfirmSAS;
			if ((autoLoginUser && autoLoginUser.length > 0 ||
			    sasMode=="internal") ||  sasOS.indexOf("DNT")>-1)
			    question=this.resourceBundle.KillConfirmStudio;

			this.killConfirmDialog=appDMS.dialogs.postDecisionDialog(question, null,
					{label:this.resourceBundle.TerminateLabel,
					callback:lang.hitch(this,killCB),
					primary:true},
					{label:this.resourceBundle.ContinueLabel,
					callback:lang.hitch(this,cancelCB)});
		},
		invalidateSession: function()
		{
			var url = this.baseURL + '/sasexec/sessions/' + this.sessionId + '/invalidate';

			dojo.xhrGet({
				url : url,
				handleAs : "json",
				preventCache : true,
				sync: true,
				load: function() { },
				error: function(err, args) { }
			});

		},

		cancelSubmitHandler: function()
		{
			var url = this.baseURL + '/sasexec/sessions/' + this.sessionId + '/submissions?id='+ this.submitID;
//			dijit.byId("cancelSubmit").set("disabled",true);
			this.submitDialog.cancelButton.set("disabled", true);
			appDMS.submissionCancelAction=true;
			this.cancelTimer=setTimeout(lang.hitch(this,this.cancelTimeout),15*1000);

			//----- interactive mode
			if (this.mode=='interactive')
			{
			dojo.xhrDelete({
				url : url,
				handleAs : "json",
				preventCache : true,

				load: lang.hitch(this, function(data, args)
				{
					// It may actually be better to wait for the completed event to do this.
					this.running=false;
					if (this.submitDialog)
					{
						this.submitDialog.hide();
						this.submitDialog=null;
					}

					if (this.killConfirmDialog) {
						this.killConfirmDialog.hide();
						this.killConfirmDialog = null;
					}

					try
					{
						if (this.cancelTimer) clearTimeout(this.cancelTimer);
						this.removeTabBusyIcon();
						this.cancelTimer=null;
					}
					catch(e) {}

					this.closeURL=null;
					this.projects.onRefresh();
					this.libraries.onRefresh();
					this.files.onRefresh();
					this.setButtonStates();

					if (this.mode=="interactive")
					{
						this.resetInteractive();
						return;
					}

					this.submitButton.set("disabled",false);
					this.backgroundSubmitButton.set("disabled",false);
					this.cancelButton.set("disabled",true);
					if (this.taskArea)
					{
						this.taskArea.cancelButton.set("disabled",true);
						this.taskArea.enableRunSubmitButton();
					}

					appDMS.clearRunningStatus();

				}),
				error: function(err, args)
				{
					this.running=false;
					if (this.submitDialog)
					{
						this.submitDialog.hide();
						this.submitDialog=null;
					}
					if (this.killConfirmDialog) {
						this.killConfirmDialog.hide();
						this.killConfirmDialog=null;
					}


					try
					{
						if (this.cancelTimer) clearTimeout(this.cancelTimer);
						this.removeTabBusyIcon();
						this.cancelTimer=null;
					}
					catch(e) {}


					this.closeURL=null;
					this.projects.onRefresh();
					this.libraries.onRefresh();
					this.files.onRefresh();

					if (this.mode=="interactive")
					{
						this.resetInteractive();
						return;
					}

					this.setButtonStates();

					this.disableSubmitCancelButtons(false, true);

					appDMS.clearRunningStatus();

				}
			});
			}

			//----- normal mode
			else
			{
				dojo.xhrDelete({
					url : url,
					handleAs : "json",
					preventCache : true,

					load: lang.hitch(this, function(data, args)
					{
						this.running=false;
							try
								{
									if (this.cancelTimer) clearTimeout(this.cancelTimer);
									this.cancelTimer=null;
								}
								catch(e) {}
								if (this.submitDialog) {
									this.submitDialog.hide();
									this.submitDialog=null;
								}
								if (this.killConfirmDialog) {
									this.killConfirmDialog.hide();
									this.killConfirmDialog=null;
								}

								this.removeTabBusyIcon();
								this.libraries.onRefresh();
								this.files.onRefresh();

								this.disableSubmitCancelButtons(false, true);

								appDMS.clearRunningStatus();

					}),
					error: function(err, args)
					{
						this.running=false;
						appDMS.clearRunningStatus();
					}
				});
			}
		},
		
	    submitBackgroundHandler: function(event)
	    {
	    	appDMS.startMessageServiceLoop();
	    	var userRoot=sasUserHome;
	    	if ((sasOS.indexOf('DNT')!=-1  || (sasOS.indexOf('WIN'!=-1) && sasMode=='single')))
	    	{
	    		userRoot+="/My Documents";
	    	}
	    
	    	var backgroundFolder=userRoot + "/BackgroundSubmits";
	    	var sas_code ="data _null_;\n";
			sas_code+="foldervar=DCREATE(\"BackgroundSubmits\",";
			sas_code+="\"",
			sas_code+=userRoot;
			sas_code+="\");\n";
			sas_code+="run;";
			
			var _url= appDMS.baseURL+'/sasexec/sessions/' + appDMS.sessionId + '/submissions?label=gsubmit';
			
			var t=new Date().getTime();
			var copyName=this.name+ " - " + t + '.sas';
			var logFile=this.name+ " - " + t + '.log';
			var htmlFile=this.name+ " - " + t + '.html';
			
			//console.log(copyName);
			
			var copyFile=backgroundFolder+"/"+copyName;
			//console.log(copyFile);
			var _copyUrl =  appDMS.baseURL+'/sasexec/sessions/' + appDMS.sessionId + '/workspace/' + encodeValue(copyFile);
			//console.log(_copyUrl);
			var code = this.editor.getText();
		
			var selcode=this.editor.getSelectedText();
			
			if (selcode && selcode.length>0 && this.taskArea==null) 
			{
				code=selcode;
			}
			
			
			var startTime=new Date();
		    startTime=dojo.date.locale.format(startTime,{formatLength:'medium'} );
		    startTime=startTime.substr(0,startTime.lastIndexOf(","))+startTime.substr(startTime.lastIndexOf(",")+1,startTime.length);
			
			var batchObject = new Object();
			batchObject.fileURI = copyFile;
			batchObject.fileName = copyFile;
			batchObject.fileNameRoot = copyName;
		    batchObject.startTime=startTime;
			batchObject.id = "";
			batchObject.outputLocation='';
			batchObject.logFileURI=backgroundFolder+"/"+logFile;
			batchObject.htmlFileURI=backgroundFolder+"/"+htmlFile;
			batchObject.outputChoice='delete';
			batchObject.fileType='file';
			
			var _batchUrl = appDMS.baseURL + '/sasexec/sessions/' + appDMS.sessionId + '/batchsubmit?forceAssetDeletion=true';
			var batchPayload=JSON.stringify(batchObject);
			//console.log(batchPayload);
			
			dojo.xhrPost({
						postData:sas_code,
						handleAs:"json",
						preventCache:true,
						url: _url,
						headers: 
						{
							"Content-Type":"text/plain"
						},
						load: lang.hitch(this, function(data, args)
						{
							dojo.xhrPost({
								postData : code,
								url : _copyUrl,
								contentType : "text/file",
								handleAs : "json",
								preventCache : true,

								load: lang.hitch(this, function(data, args)
								{
				   					dojo.xhrPost({
			   						 postData: batchPayload,
									 handleAs:"text",
									 preventCache:true,
									 url: _batchUrl,
									 headers: {"Content-Type":"application/json"},
									 load: lang.hitch(this, function(data, args)
									 {
									 }),
									 error: lang.hitch(this, function(err, args)
									 {
									 	dojoAlert(err.response.xhr.getResponseHeader("Exception"));
									 })
									 });
								}),
								error: lang.hitch(this, function(err, args)
								{
									dojoAlert(err.response.xhr.getResponseHeader("Exception"));
								})
							});
						}),
						error: lang.hitch(this,function(err, args)
						{
							dojoAlert(err.response.xhr.getResponseHeader("Exception"));
						})
			});
			
		 
			
	    },
	    
		submitHandler: function(event)
		{
			if (this.running)
			{
				console.warn("Submit requested while the program is running.");
				return;
			}

            // Make sure the message loop is running.
            appDMS.startMessageServiceLoop(); // force = true
            
            if (appDMS.optionPreferencesEditor.appendLog){
            	if (appDMS.optionPreferencesEditor.typeSelection === "Program and Task"){
            		//do nothing
            	} else if (appDMS.optionPreferencesEditor.typeSelection === "Program only" && typeof (this.taskMode) !== 'undefined' && this.taskMode){
            		this.logAreaContentPane.set("content", "");
            	} else if (appDMS.optionPreferencesEditor.typeSelection === "Task only" && typeof (this.taskMode) === 'undefined'){
            		this.logAreaContentPane.set("content", "");
            	}
            } else {
            	this.logAreaContentPane.set("content", "");
            }
            		
			if (this.mode == "interactive") {
				return this.interactiveSubmitHandler();
			}

			if (this.submitButton.get("disabled")==true) {
				return;
			}

			// if it is Read-Only file, should not allow to submit 'F3'. If it
			// is Read-Only
			// submit button is already disabled, but this check is to take care
			// of key 'F3'.
			if (this.recallReadOnly) {
				return;
			}

			setPreventDefault(event);
			appDMS.submissionCancelAction=false;

			var label=this.name;
			if (label==null || label.length==0) {
				label=this.resourceBundle.untitled;
			}

			var _uri=this.uri;
			var _uriPassValue=_uri;
			if (_uri==null){
				_uri="";
				_uriPassValue = label;
			}
			var _url = this.baseURL + '/sasexec/sessions/' + this.sessionId + '/asyncSubmissions?label=' + encodeValue(label) + "&uri=" + encodeValue(_uriPassValue);
			_url+="&pdf=" + appDMS.optionPreferencesResults.producePDF;
			_url+="&rtf=" + appDMS.optionPreferencesResults.produceRTF;
			var note;
			if (!this.uri)
			{
				note=this.resourceBundle.submittingUnsavedLabel.replaceAll('${0}',label);
			}
			else
			{
				//var decoded=this.getDecodedURI(this.uri);
				var val = this.uri;
				if (this.tabObject.tooltip)
				   val = this.tabObject.tooltip;
				note=this.resourceBundle.submittingLabel.replaceAll('${0}',val);
			}
			
			var selcode=this.editor.getSelectedText();
			var code = this.editor.getText(); // this.textarea.getDisplayedValue();
			if (selcode && selcode.length>0 && this.taskArea==null) 
			{
				note=this.resourceBundle.submittingSelCodeLabel;
				code=selcode;
			}
			this.submitCount++;
			if (this.submitCount > 0) {
				this.summaryButton.set("disabled", false);
				this.rsButton.setAttribute("disabled", false);
				this.codeRan = true;
				}
			else {
				this.summaryButton.set("disabled", true);
				this.codeRan = false;
				}

			appDMS.sendClientNoteMessage(note);
			this.pushSubmitStack(_uri, label, code);
			this.submitDialog = appDMS.dialogs.postBusyDialog(this.resourceBundle.submitTitle, lang.hitch(this, this.cancelSubmitHandler));
			this.running = true;
			appDMS.suspendCommands();
			//console.log("Submitting code...");
			this.submitError = false;
			appDMS.submitRequest=dojo.xhrPost({
				postData:code,
				handleAs:"json",
				preventCache:true,
				url: _url,
				headers: {
					"Content-Type":"text/plain; charset=utf-8"
				},
				load: dojo.hitch(this, this.onAsyncSubmit),
				error: dojo.hitch(this,function(err, args)
				{
                    this.running = false;
					if (this.submitDialog==null) return;
					if (this.submitDialog) {
						this.submitDialog.hide();
						this.submitDialog=null;
					}
					if (this.killConfirmDialog) {
						this.killConfirmDialog.hide();
						this.killConfirmDialog=null;
					}

					appDMS.submitRequest=null;
					var msg=null;
					var details="";
					try
					{
						details=JSON.stringify(args.xhr);
						msg=err.response.xhr.getResponseHeader("Exception");
					}
					catch(e) {}
					if (msg==null) msg=this.resourceBundle.unknownSubmissionErr;
					appDMS.dialogs.postFaultDialog(msg,details);
					this.setButtonStates();
				})
			});
		},

		pushSubmitStack: function(uri, label, code)
		{
			var ts = new Date();
			ts=dojo.date.locale.format(ts,{formatLength:'medium'} );
			ts=ts.substr(0,ts.lastIndexOf(","))+ts.substr(ts.lastIndexOf(",")+1,ts.length);
			var name = label + '(' + this.submitCount + ')' + ' ' + this.resourceBundle.readOnly + ".sas";
			var key = uri+"/"+name;
			var menuKey = '(' + this.submitCount + ')' + '&nbsp;&nbsp;&nbsp' + ts;
			var keyToolTip = ts;//locale.format(ts, {formatLength: 'medium'});
			/**
			 * var v = 1 while (this.tabs.lastSubmitsMap[key]){ key = label + '(' + v + ')' +
			 * this.submitCount; v++; }
			 */
			// this.tabs.lastSubmitsMap[key] = code;
			this.submitStack.push({key: key, name:name, menuKey: menuKey, keyToolTip: keyToolTip, code: code, time: ts});
		},

		restoreSubmitStack: function(submitStack)
		{
			if (submitStack && submitStack.length > 0)
			{
				this.submitCount = submitStack.length;
				this.currentSubmission = submitStack[submitStack.length-1];
				this.submitStack = submitStack;
				this.rsButton.setAttribute("disabled", false);
			}
			else
			{
				this.submitCount = 0;
				this.currentSubmission = null;
				this.submitStack = [];
				this.rsButton.setAttribute("disabled", true);
			}
		},

		interactiveSubmitHandler: function(event)
		{
			var selcode = this.editor.getSelectedText();
			var code = this.editor.getText(); // this.textarea.getDisplayedValue();
			if (selcode && selcode.length > 0)
				code = selcode;

			this.submitDialog = appDMS.dialogs.postBusyDialog(this.resourceBundle.submitTitle, lang.hitch(this, this.cancelSubmitHandler));
			this.submitButton.set("disabled",true);
			this.backgroundSubmitButton.set("disabled",true);
			this.cancelButton.set("disabled",false);
			this.setTabBusyIcon();
			this.running=true;

			dojo.xhrPost({
				postData: code,
				handleAs: "json",
				preventCache: true,
				url: this.addURL,
				headers:
				{
					"Content-Type": "text/plain; charset=utf-8"
				},
				load: function() {
				},
				//load: dojo.hitch(this, this.interactiveSubmitComplete),
				error: dojo.hitch(this, function (err, args) {

					this.running=false;
					if (this.submitDialog == null) return;

					this.outputSaveButton.set("disabled", true);
					this.allowCtrlS = false;

					if (this.submitDialog) {
						this.submitDialog.hide();
						this.submitDialog=null;
					}
					if (this.killConfirmDialog) {
						this.killConfirmDialog.hide();
						this.killConfirmDialog=null;
					}

					var msg = null;
					var details = "";
					try {
						details = JSON.stringify(args.xhr);
						msg = err.response.xhr.getResponseHeader("Exception");
					}
					catch (e) { }
					appDMS.dialogs.postFaultDialog(msg, details);
					this.cancelInteractiveModeButton.set("disabled", true);
					console.log(msg);

					if (err.response.status == 410) {
						dojoAlert(this.resourceBundle.BadInteractiveMode);
						this.resetInteractive();
						return;
					}
				})
			});
			return;
		},

		//CAM
		interactiveSubmitComplete: function()
		{
			if (this.submitDialog) {
				this.submitDialog.hide();
				this.submitDialog=null;
			}
			if (this.killConfirmDialog) {
				this.killConfirmDialog.hide();
				this.killConfirmDialog=null;
			}

			if (this.cancelTimer) clearTimeout(this.cancelTimer);
			this.running = false;
			this.cancelTimer = null;
			this.outputAreaContentPane.refresh();
			//this.logAreaContentPane.refresh();
			this.logAreaContentPane.set("href", this.logURL);
			this.outputSaveButton.set("disabled", false);
			this.allowCtrlS = true;
			this.disableSubmitCancelButtons(false, true);
			this.removeTabBusyIcon();
			appDMS.clearRunningStatus();
		},

		formatCodeHandler: function(event)
		{
			// If the editor is read only, we shouldn't be here.
			//if (this.editor.readOnly())
			//	return;

			var url = this.baseURL + '/sasexec/submissions/' + this.sessionId + '/formatcode';
			var code = this.editor.getText();

			dojo.xhrPost({
				postData : code,
				url : url,
				contentType : "text/file",
				handleAs : "text",
				sync: true,
				preventCache : true,
				load: lang.hitch(this, function(data, args)
				{
					var prior=this.editor.readOnly();
					if (this.editor.readOnly()==false) this.editor.selectAll();
					if (prior==true)
					{
						this.mode="normal";
						this.clearAll();
						this.mode="interactive";
					}
					this.editor.readOnly(false);
					this.editor.ctrl_.insertText(data.trim());
					this.editor.readOnly(prior);
//					if (this.mode=="interactive")
//						setTimeout(dojo.hitch(this,this.commandLineFocus),10);
					var warning = args.xhr.getResponseHeader("Warning");
					if (warning && warning != "")
					{
						dojoInfo(decodeURI(warning));
					}
				}),
				error: function(err, args)
				{
					dojoAlert(decodeURI(err.response.xhr.getResponseHeader("Exception")));
				}
			});

		},
		canFormatCode: function()
		{
			var canFormat = false;
			if (false == this.editor.readOnly())
			{
				canFormat = true;
			}
			return canFormat;
		},
		saveFile: function(/* event */ evt, /* boolean */ autoSave, /* boolean */ isSaveAs)
		{

			if (this.isVirgin() || this.isFile || (this.object && (this.object.isReadOnly || this.object.type === "newsnippet")) ||
					(this.uri.toLowerCase().lastIndexOf(".ctk")>-1 && this.taskMode==false))
			{
				this.saveFileAs(false);
				return;
			}

			var encoding = null;
			if (this.object)
			{
			    encoding = this.object.encoding;
			}
			else if (this.encoding)
			{
				encoding = this.encoding;
			}

			// editor name is not being updated for vp. S1105570
			if(this.name !==this.tabObject.name)
				this.name=this.tabObject.name;

			if (typeof this.storageType ==="undefined" && typeof this.tabObject.storageType !=="undefined" )
			{
				this.storageType =this.tabObject.storageType;
			}
			var passType = "";
			var storageType = "workspace";
			if (isSaveAs && this.projects.destinationTree && this.projects.destinationTree.selectedItem)
			{
				// Save As case - there is a "destinationTree" around
				passType = this.projects.destinationTree.selectedItem.type;
				storageType = passType && passType.indexOf("ftpShortcut") != -1 ? "ftprefs/save" : "workspace";
			}
			else
				// Simple Save case - the type of the file system is remebered in the editor
				storageType = this.storageType == "ftprefs" ? "ftprefs/save" : "workspace";

			var url = '';
			var cleanupAutoSaveURL= '' ;
			var targetURI = '';
			var specialAutoSavePathForMVSPartitionedDataset = '';

			if (appDMS.isMVSPartitionedDataset(this.uri))           /* Save to autosave dir in the user's studio dir on HFS file system */
			    specialAutoSavePathForMVSPartitionedDataset = appDMS.session.studioDataDirectory + '/autosave/';

			if(!appDMS.isMVSPartitionedDataset(this.uri) && autoSave !== true)
			{
				targetURI = this.tabObject.uri;

				// The object has fileShortcutName only if it is a FTP file shortcut selected in the File Shortcuts accordion.
				if(storageType == "ftprefs/save" && this.tabObject.fileShortcutName)
				{
					storageType = "ftpfilerefs/save";
					targetURI = this.tabObject.fileShortcutName;
				}

                // extra step for ftp files
                if (storageType === 'ftprefs/save'){
                    cleanupAutoSaveURL=this.baseURL + '/sasexec/' + this.sessionId + '/ftpShortcuts_file~ps~' + targetURI.replaceAll("/", "~ps~") + '~';

                } else {
                    /* Need to set up URL to clean up back up file */
                    cleanupAutoSaveURL=this.baseURL + '/sasexec/sessions/' + this.sessionId + '/' + storageType + '/' + encodeValue(targetURI).replaceAll("/", "~ps~") + '~';
                }

			}
			else {
				if (typeof autoSave !== 'undefined' && autoSave !== null && autoSave === true)	/* Autosave */
	            {
					// removed autosave functionality for fileshortcuts that were created on top of an ftpshortcut object, because 'uri' is not avilable for this type of FSC in cases
					// like such FSC's creadted from 'autoexec' or by direct filename submitted from program editor.
					if (typeof this.tabObject.fileShortcutName != 'undefined' && this.tabObject.fileShortcutName.length > 0 && this.tabObject.storageType=="ftprefs")
						return;
					//disableing autoSave for FTP files
					if (typeof this.tabObject.uri != 'undefined' && this.tabObject.uri.indexOf("{SAS001}") === 0)
						return;;

					targetURI = specialAutoSavePathForMVSPartitionedDataset + this.uri + '~';
					/* Do not need to set up cleanupAutoSaveURL */
				}
				else     /* Regular save, not autosave */
				{
				     targetURI = this.uri;
				     /* Need to set up URL to clean up back up file */
				     cleanupAutoSaveURL=this.baseURL + '/sasexec/sessions/' + this.sessionId + '/' + storageType + '/' +
					                    specialAutoSavePathForMVSPartitionedDataset + encodeValue(targetURI) + '~';
				}
			}

			url = this.baseURL + '/sasexec/sessions/' + this.sessionId + '/' + storageType + '/' + encodeValue(targetURI, storageType.indexOf("ftp") == 0, "/", false);
	/*   I have no idea what this is for so I am deleting it. - Jennifer
			// We may need to create projects folder here
			if(targetURI.indexOf("snippets") !=-1)
			{
				if(this.appDMS.currentPerspectiveKey == 'editTabContentPane')
					url = this.baseURL + '/sasexec/sessions/' + this.sessionId + '/' + storageType + '/' + targetURI;
			}
     */

			var code = this.editor.getText();// this.textarea.value;

            // CTK files save differently than other files (due to NLS issues).  Call special CTK Save and bail.
            if (this.fileType=="CTK")
            {
            	this.tasks.onSaveCTK(this.taskArea, this.name, '*', this.uri, lang.hitch(this, this.saveAsCTKComplete), true);  // tbd - get rid of that *
                return;
            }

			 if (this.fileType=="CPK")
			 {
			    	code=this.getPackage();
			    	encoding=null;
			 }

			 if (encoding && targetURI.indexOf(".mysnippets")==-1) url+="?encoding=" + encoding;

			dojo.xhrPost({
				postData : code,
				url : url,
				contentType : "text/file",
				handleAs : "json",
				headers: {"ObjectType": passType},
				preventCache : true,

				load: lang.hitch(this, function(data, args)
				{
				    this.successfulSave(targetURI, autoSave, cleanupAutoSaveURL);
				}),
				error: lang.hitch(this, function(err, args)
				{
				    if (err.status == 499)
					    this.successfulSave(targetURI, autoSave, cleanupAutoSaveURL);
					dojoAlert(err.response.xhr.getResponseHeader("Exception"));
				})
			});
		},


		successfulSave: function(targetURI, autoSave, cleanupAutoSaveURL)
		{
			if (endsWith(targetURI,"~")==false)
			{
				var targetObject=new Object();
				if (this.canUpdateTabTitle)
				{
					targetObject.uri = this.uri;
					targetObject.fileName = this.name;
					appDMS.handleWebOneEvent("FileSaved", targetObject);
				}

				if (this.onSaveComplete != null)
					this.onSaveComplete(targetObject);

				if (!this.editorTabContainer._destroyed)
				{
					this.editorContentChanged = false;
					if (this.canUpdateTabTitle)
					{
						// need the ability to control this in case we
						//  are saving from within a process flow
						var tabWidget = this.getTabWidget();
						if (tabWidget)
						{
						    var tabLabel = tabWidget.containerNode;
						    tabLabel.innerHTML = appDMS.encodeHtml(this.name);
						}
					}

					this.setButtonStates();
					// check for autosave existence and delete here?  or in handleWebOneEvent?
					if (typeof autoSave === 'undefined')
					{
						// Saving a hit to the server.  If there is not a back up it's no big deal.
						//	var delTgt = {storageType: storageType, uri: this.uri + '~'};
						//	if (appDMS.checkFileExistence(delTgt) === true){
						// delete the auto save and fire an event.
						dojo.xhrDelete({
							url: cleanupAutoSaveURL,
							handleAs: "text",
							sync: true,
							load: lang.hitch(this, function()
				                {
								if (debug)
									console.log("successfully deleted autosave");
								appDMS.projects.onRefresh().then(lang.hitch(this, function(){
									// SASSTUDIO-13593: Do not jump to the first line after save
									setTimeout(dojo.hitch(this,this.setInitialFocus),100);
								})) ;		
						    })
						});
					}
				}
			}
		},

		saveFileAsNoClose: function()
		{
			this.saveFileAs(false);
		},
		saveFileAs: function(closeAfterSave)
		{

			//Temporary solution to fix the new snippet save flow or lack thereof.
			//will change in 3.4. fixid S1012672
			if(this.object && this.object.type==="newsnippet"){
				this.saveSnippet();
				return;
			}

			var types=null;
			var isTask=false;
			if(this.taskMode)
			{
				types = ["ctk","sas"];
                this.fileType = "CTK";
                isTask=true;
			} else if (this.mode === 'interactive'){
				types=["sas"];
			} else if (this.codeRan || this.fileType == "CPK"){
				types = ["sas","cpk","html"];
			} else {
				types = ["sas"];
			}

			if(endsWith(this.name.toLowerCase(), ".ctm"))
				this.name = this.name.substr(0, this.name.length-4);

			var extension="." + this.fileType.toLowerCase();
			if(!endsWith(this.name.toLowerCase(), extension))
			{
				fileName = this.name + extension;
			}
			else if(this.isFile || !this.isVirgin())
			{
				fileName = this.name;
			}else{
				fileName = this.name;
			}

			appDMS.dialogs.postSaveAsDialog(fileName, types,
											this.resourceBundle.saveAsTitle,
											lang.hitch(this, this.onSaveAsOK, closeAfterSave),
											lang.hitch(this, this.onSaveAsCancel),
											isTask, "", this.object ? this.object.id : null);
		},

		onSaveAsOK:function(closeAfterSave)
		{

			var isNameEmpty=false;
			var okButton=appDMS.dialogs.saveAsDialog.okButton;
			var isOkDisabled=okButton.get("disabled");
			if(isOkDisabled){
				isNameEmpty=true;
				// dojoAlert(this.resourceBundle.enterName);
			}

			var selectedObject=appDMS.dialogs.saveAsDialog.getTreeSelection();
			if(selectedObject==null){
				dojoAlert(this.resourceBundle.projectFolderMustBeSelected);
				return;
			}
			
			var typeCombo=appDMS.dialogs.saveAsDialog.typeCombo,
				type=typeCombo.get("value");
			
			if((this.fileType==="CTK" && type === "SAS") || (this.taskMode && type==="SAS"))
				this.savingGeneratedCTKCodeAsSAS=true;
			else
				this.savingGeneratedCTKCodeAsSAS=false;

			if(type!="HTML" && !this.savingGeneratedCTKCodeAsSAS)
				this.fileType=type;
			
			if(this.object && this.object.isReadOnly && !(this.taskMode==true && type=="SAS"))
				this.object.isReadOnly=false;

			var projectPath=selectedObject.uri;
			if(!selectedObject.isDirectory){
				projectPath=selectedObject.uriParent;
			}
			projectPath = projectPath.replaceAll('\\', '/');  //S1284078
			if(selectedObject.type && selectedObject.type.indexOf("MYTASKS")>-1){
				projectPath = "MyTasks"
				if(selectedObject.type == "MYTASKS~CATEGORY")
					projectPath+="/"+selectedObject.name;
				this.savingToFolderShortcut=false;
			}else if(selectedObject.type && selectedObject.type=="folderShortcutItem" || selectedObject.type=="folderShortcutDir"){	
					this.savingToFolderShortcut=true;
			}else{
				this.savingToFolderShortcut=false;
			}
			var fileNameTextBox=appDMS.dialogs.saveAsDialog.fileNameTextBox;
			var name = fileNameTextBox.get("value");

			var sasExtension = "." + type.toLowerCase();
			var uri = '';

			if ((selectedObject.type != 'ftpShortcutConn') && (this.appDMS.objectIsMVSPartitionedDataset(selectedObject)))
			{
               uri = projectPath + '(' + name + ')';
			}
			else
			{
				if(!endsWith(name.toLowerCase(), sasExtension) && !isNameEmpty)
				{
					name += sasExtension;
					fileNameTextBox.set("value", name);
					uri = projectPath + '/' + name;
				}
			}


            /**
             * Confusing case 1 - Doing a save as to the same file you are currently editing. Should just be the same
             * thing as a save.
             * Check also that we are saving to the same file system that the original file came from (editor remebers that).
             */

            var targetStorageType = selectedObject.type && selectedObject.type.indexOf("ftpShortcut") != -1 ? "ftprefs" : "workspace";
            if (this.uri!=null && uri==this.uri && this.storageType == targetStorageType)
            {
            	appDMS.dialogs.saveAsDialog.hide();
            	this.saveFile(null,false,true);  //3rd arg true => saveAs
            	return;
            }

			if(!isNameEmpty)
			{
			    var currentlyOpen = false;
			    var tabWithSameNameSAS = null;
			    if(this.appDMS.currentPerspectiveKey == 'editTabContentPane')
			    {
			    	if(this.tabs)
			    		tabWithSameNameSAS = this.tabs.findTab(name, projectPath + '/' + name, 'sas');
			    }else{
			    	if(this.appDMS.perspective[this.appDMS.currentPerspectiveKey].findTab)
			    		tabWithSameNameSAS = this.appDMS.perspective[this.appDMS.currentPerspectiveKey].findTab(name, projectPath+'/'+name, "sas");
			    }
                if (tabWithSameNameSAS != null)
				{
					currentlyOpen = true;
				}
				else
				{
                    if (this.appDMS.currentPerspectiveKey == 'editTabContentPane') {
                        if (this.tabs)
                            tabWithSameNameOther = this.tabs.findTab(name, projectPath + '/' + name, 'other');
                        if (tabWithSameNameSAS != null)
                            currentlyOpen = true;
                    } else {
                        if(this.appDMS.perspective[this.appDMS.currentPerspectiveKey].findTab)
                            tabWithSameNameOther = this.appDMS.perspective[this.appDMS.currentPerspectiveKey].tabs.findTab(name, projectPath + '/' + name, 'other');
                        if (tabWithSameNameSAS != null)
                            currentlyOpen = true;
                    }
				}
				if (currentlyOpen == true)
				{
					appDMS.dialogs.postInfoDialog(this.resourceBundle.fileNameOpen.replace("${0}", name));
				}
				else
				{
					this.commonSaveAs(selectedObject, projectPath, name, this.onFileSave,
						[projectPath, closeAfterSave, selectedObject]);
				}
			}
		},


        // Callback for after Save or SaveAs CTK is complete.
        saveAsCTKComplete: function(closeAfterSave)
        {
            this.isFile=false;
            this.taskArea.task.filePath=this.uri;
            this.taskArea.task.editing = false;
            var targetObject = new Object();
            targetObject.uri=this.uri;
            targetObject.fileName = this.name;
            if (this.canUpdateTabTitle) {
                appDMS.handleWebOneEvent("FileSaved", targetObject);
            }

            if (this.onSaveComplete != null) {
                this.onSaveComplete(targetObject);
            }

            this.saveable=true;

            if (this.canUpdateTabTitle) {
                this.editorTabContainer.attr('title', this.name);
                var tabs = appDMS.getCurrentPerspectiveSASStudioTabs();
                var tabObject = tabs ? tabs.getFocusedTab() : null;
                var filePathLabel=this.myTaskOrSnippetifyUri(this.getDecodedURI());
                if (tabObject) {
                    tabObject.editing = false;
                    if (this.uri.indexOf("MyTasks") == 0) {
                        this.uri = this.uri.replace("MyTasks", appDMS.session.studioDataDirectory + "/tasks");
                        tabObject.title = this.name.replace(".ctk", "");
                        tabObject.name = tabObject.title;
                        tabObject.type = appDMS.MYTASK;
                        tabObject.fileType = this.fileType;
                        var tooltip=this.uri.replace(appDMS.session.studioDataDirectory + "/tasks", this.resourceBundle.myTasks);
                        tabObject.tab.setAttribute("tooltip", tooltip);
                        tabObject.tooltip=tooltip;
                        tabObject.mode=null;
                    } else {
                    	//if you're not saving a CTK to My Tasks it's being saved to Folders.
                        tabObject.id = this.uri.replace(/\//gi, '~ps~');//this.name;
                        tabObject.title = this.name;
                        tabObject.name = this.name;
                        tabObject.type= this.savingToFolderShortcut ? "folderShortcutItem" : "FILE";
                        tabObject.fileType=this.fileType;
                        tabObject.tooltip = this.uri;
                        tabObject.tab.setAttribute("tooltip", this.uri);
                    }
                    tabObject.uri = this.uri;
                    tabObject.tab.setAttribute("title", appDMS.encodeHtml(tabObject.name));
                    this.editorTabContainer.attr('title', tabObject.name);
                }
                
				var fileLocationLabelDiv = dojo.byId('fileStatus' + this.editorTabContainer.id);
                fileLocationLabelDiv.innerHTML = appDMS.encodeHtml(filePathLabel);
				fileLocationLabelDiv.title=filePathLabel;

                if (tabs)
                    tabs.saveTabPreferences();
            }

            this.editorContentChanged=false;

            // We can only do the following if this.taskArea is non-null.  Since we are saving a ctk though,
            //  we can already assume that.  Adding this comment though just in case down the road, that is
            //  no longer the case.
            if (this.canUpdateTabTitle) {
                // need the ability to control this in case we
                //  are saving from within a process flow
                var tab = tabs ? tabs.getFocusedTab().tab : null;
                if (tab && tab.controlButton) {
                    var tabLabel = tab.controlButton.containerNode;
                    domClass.replace(tab.controlButton.iconNode, "sasTaskIcon",tab.iconClass);
                    tab.iconClass="sasTaskIcon";
                    if (tabLabel != null) {
                        tabLabel.innerHTML = appDMS.encodeHtml(this.editorTabContainer.title);
                    }
                }
            }
            /** @todo Notify active perspective that file has been saved */
            //appDMS.handleWebOneEvent("FileSaved", this);

            this.setButtonStates();
            if (this.projects != null) {
                var node = this.projects.destinationTree.get("selectedItems");
                if (node != null && node.length > 0) {
                    var selectedObject = node[0];
                    if (selectedObject != null)
			            this.projects.selectThisId=selectedObject.id+'~ps~'+this.name;
                }
            }

        	if(sasOS.indexOf("z/OS")>-1){
        		var selectThisAfterRefresh=this.projects.selectThisId
        		if(node[0].isPDS || appDMS.objectIsMVSPartitionedDataset(node[0])){
        			selectThisAfterRefresh=selectedObject.id+'('+this.name+')';
        		}
				this.projects.projectTreeStore.refreshObject(selectedObject.id, true, selectThisAfterRefresh);
			}
			else{
				this.projects.onRefresh();
				this.tasks.onRefresh();
			}
        	
        	if(closeAfterSave)
        		appDMS.tabs.closeTab(this.tabObject);
        },

        // This is called to save snippets and tasks.
        // Note however that tasks bail out early and go down a different code path.
		onFileSave : function(projectPath, closeAfterSave, destinationObject)
		{
            
		    /* Setup name */
 			fileNameTextBox=appDMS.dialogs.saveAsDialog.fileNameTextBox;
			fileNameTextBox.set('invalidMessage', this.resourceBundle.invalidFileNameMsg);// nls
			
			var name = fileNameTextBox.get("value");

			if (destinationObject && (this.appDMS.objectIsMVSPartitionedDataset(destinationObject) == false))
			{
				var typeCombo=appDMS.dialogs.saveAsDialog.typeCombo,
					extension = '.'+typeCombo.getValue();
				if(!(endsWith(name.toLowerCase(),extension.toLowerCase())) && !(endsWith(name.toLowerCase(), ".html")))
				{
					name+=extension;
					fileNameTextBox.set("value",name);
				}
			}

			if(appDMS.dialogs.saveAsDialog)
				appDMS.dialogs.saveAsDialog.hide();

            // CTK files work differently.  Do no use the xhrPost for saving these.
             if (this.fileType=="CTK" && !this.savingGeneratedCTKCodeAsSAS)
            {
                this.name=name;
				if (destinationObject && (this.appDMS.objectIsMVSPartitionedDataset(destinationObject)))
				   this.uri=projectPath + '(' + name + ')';
			    else if((destinationObject.type && destinationObject.type=="folderShortcutItem" || destinationObject.type=="folderShortcutDir") &&
			    		 projectPath == "/" || projectPath == "\\")
			    {
			    	this.uri=projectPath + name;
			    }else
			       this.uri=projectPath + '/' + name;


		    	this.tasks.onSaveCTK(this.taskArea, name, '*', this.uri, lang.hitch(this, this.saveAsCTKComplete, closeAfterSave), false);   // tbd - get rid of that *
		    	return;
            }
            // Everything other than a CTK file.
            else
            {
			    /* Set up the correct url for saving content */
			    var passType='';
				var destItem=this.projects.destinationTree.selectedItem;
				if(destItem)
					passType=destItem.type;
				var storageType = "workspace";
				var singleEncode = false;
				if(passType.indexOf("ftpShortcut") != -1) {
					storageType="ftprefs/save";
					this.storageType="ftprefs";
					singleEncode = true;
					if(this.tabObject)
						this.tabObject.storageType=this.storageType;
				}
			    var url = '';
				var newUri = '';
			    if (destItem && this.appDMS.objectIsMVSPartitionedDataset(destItem))
				{
					url = this.baseURL + '/sasexec/sessions/' + this.sessionId + '/' + storageType + '/' + encodeValue(projectPath, singleEncode) + '(' + encodeValue(name, singleEncode) + ')';
					newUri = projectPath + '(' + name + ')';
				}
			    else if((destinationObject.type && destinationObject.type=="folderShortcutItem" || destinationObject.type=="folderShortcutDir") &&
			    		 projectPath == "/" || projectPath == "\\")
			    {
					url = this.baseURL + '/sasexec/sessions/' + this.sessionId + '/' + storageType + '/'+ encodeValue(projectPath, singleEncode) + encodeValue(name, singleEncode);
					newUri = projectPath + name
			    }
				else
				{
					url = this.baseURL + '/sasexec/sessions/' + this.sessionId + '/' + storageType + '/' + encodeValue(projectPath, singleEncode) + '/' + encodeValue(name, singleEncode);
					newUri = projectPath + '/' + name
				}

			    /* Get content to be saved */
			    var code = '';
			    if (this.fileType=="CPK")
			    {
			    	code=this.getPackage();
			    }
				else if (endsWith(name.toLowerCase(), ".html"))
				{
					code=this.generateSummary();
				}
				else  // must be this.fileType == "SAS"
				{
					//var selcode=this.editor.getSelectedText();
					//if (selcode && selcode.length>0)
					//	code=selcode;
					//else
						code=this.editor.getText();
				}

			    if (this.fileType != "HTML")
			    	if (this.encoding && this.encoding != "UTF-8") url+="?encoding=" + this.encoding;

			    dojo.xhrPost({
				    postData : code,
				    url : url,
				    contentType : "text/file",
				    handleAs : "json",
				    headers: { "ObjectType": passType },
				    preventCache : true,

				    load: lang.hitch(this, function(data, args)
                    {
                        //defectid=S1504480
                        //SAS Studio does not allow you to save your program if closed with Save to a unauthorized location
                        //move this code into success handler so we only close when save works
                        //and do it before the this.successfulOnFileSave call
                        if (closeAfterSave === true) {
                            this.editorContentChanged = false;
                            appDMS.tabs.closeTab(this.tabObject);
                            if (sasOS.indexOf("z/OS") > -1) {
                                this.projects.projectTreeStore.refreshObject(destinationObject.id, true, destinationObject.id + "~ps~" + name);
                            }
                            else {
                                this.projects.onRefresh();
                            }
                        }
						this.successfulOnFileSave(closeAfterSave, newUri, name);
				    }),
				    error: lang.hitch(this, function(err, args)
				    {
					    if (err.status === 499)
						    this.successfulOnFileSave(closeAfterSave, newUri, name);
					    dojoAlert(err.response.xhr.getResponseHeader("Exception"));
				    })
			    });
            }

			if (this.saveHandle)
			{
				dojo.disconnect(this.saveHandle);
				this.saveHandle=null;
			}
		},

		successfulOnFileSave: function(closeAfterSave, newUri, name)
		{
            var autoSaveCleanup = this.generateAutoSaveUrl();
            
			this.savingGeneratedCTKCodeAsSAS=false;
			if (endsWith(newUri.toLowerCase(), ".html"))
			{
				this.setButtonStates();
				this.projects.onRefresh();
			}
			else
			{
				// If this is a task, saving a SAS file should not disable the Save button as per
				//  instructions from Sam.  Only saving a task as a CTK file should do this.
				if (! this.taskMode )
					this.isFile=false;

				var targetObject=new Object();
                if (startsWith(newUri, "MVS:")){
                    newUri = newUri.toUpperCase();
                    name = name.toUpperCase();
                }
				targetObject.uri = newUri;
				targetObject.fileName = name;
				targetObject.isSnippetFile = false;
				appDMS.handleWebOneEvent("FileSaved", targetObject);
				if (closeAfterSave == false)
				{
					// For a task saving its SAS code, nothing should change.  Only if a
					//    task is saved out as a CTK file should anything change.  That code goes
					//    through onSaveCTK() and saveAsCTKComplete().
					if (! this.taskMode)
					{
						this.name=name;
						this.uri=newUri;

						if(this.object && this.object.isReadOnly)
							this.object.isReadOnly=false;

						this.saveable=true;

						// For a task saving its SAS code, nothing should change.  Only if a
						//    task is saved out as a CTK file should anything change.  That code goes
						//    through onReplaceCTK().
						if (! this.taskMode)
							this.editorContentChanged=false;

						if (this.canUpdateTabTitle)
						{
							// need the ability to control this in case we
							//  are saving from within a process flow
							this.editorTabContainer.attr('title', name);
							var tabs = appDMS.getCurrentPerspectiveSASStudioTabs();
							var tabObject = tabs ? tabs.getFocusedTab() : null;
							if(tabObject) {
								tabObject.uri=this.uri;
								tabObject.id = this.uri.replace(/\//gi, '~ps~');
								tabObject.uriParent = tabObject.uri.substring(0,tabObject.uri.lastIndexOf("/"));

								if(this.savingToFolderShortcut)
									tabObject.type="folderShortcutItem";
								else if (tabObject.type == 'newprogram' || (tabObject.type=="folderShortcutItem" && !this.savingToFolderShortcut))
									tabObject.type = 'FILE';

								tabObject.title=name;
								tabObject.name=name;
								var tooltip=this.uri;
								if(tooltip.indexOf(appDMS.session.studioDataDirectory+"/tasks")!=-1)
									tooltip=tooltip.replace(appDMS.session.studioDataDirectory+"/tasks", appDMS.tasks.categoriesResourceBundle.MyTasksKey);
								//remove setting tooltip to myFolders per S1188076
								//else if(tooltip.indexOf(appDMS.session.userDirectory)!=-1)
								//	tooltip=tooltip.replace(appDMS.session.userDirectory, this.resourceBundle.myFolders);

								if(tabObject.storageType == "ftprefs")
									tooltip = convertEncodedPath(tooltip, "FTP");

								tabObject.tab.setAttribute("tooltip", tooltip);
								tabObject.tooltip=tooltip;
                                tabObject.tab.setAttribute("title", appDMS.encodeHtml(name));
								
								var fileLocationLabelDiv = dojo.byId('fileStatus' + this.editorTabContainer.id);
								//myTaskify puts My Tasks on the Uri IF the file resides in the my task directory
								var decodedUri=this.myTaskOrSnippetifyUri(this.getDecodedURI());
                                fileLocationLabelDiv.innerHTML = appDMS.encodeHtml(decodedUri);
								fileLocationLabelDiv.title=decodedUri;
							}

							if(tabs)
								tabs.saveTabPreferences();

							var tab = tabs ? tabs.getFocusedTab().tab : null;
							if (tab && tab.controlButton) {
								var tabLabel = tab.controlButton.containerNode;
                                if (tabLabel != null) {
                                    tabLabel.innerHTML = appDMS.encodeHtml(this.editorTabContainer.title);
                                }
							}
						}
						/** @todo Notify active perspective that file has been saved */
						//appDMS.handleWebOneEvent("FileSaved", this);
					}

					this.setButtonStates();

					if (this.projects != null)
					{
						var selectId=targetObject.uri.replaceAll("/","~ps~");
						try  //S1268434 in case already decoded and name contains a %
						{
							selectId=decodeURI(selectId);
						}
						catch(e)
						{
							//ignore malformed uri error caused by trying to 
							//decode name containing % that is already decoded
						}
						this.projects.selectThisId=selectId;

						var node = this.projects.destinationTree.get("selectedItems");
						if (node != null && node.length > 0)
						{
							var selectedObject = node[0];
							this.projects.completePathArray=selectedObject.completePathArray;
							if (selectedObject != null)
								this.projects.selectThisId=selectedObject.id+'~ps~'+name;
						}
					}

					if(sasOS.indexOf("z/OS")>-1){
						this.projects.projectTreeStore.refreshObject(selectedObject.id, true, this.projects.selectThisId);
					}
					else{
						this.projects.onRefresh();
					}


					if (this.autoSaveAllowed && this.fileType.toUpperCase() === 'SAS' ){
                        // need to clean out the previous autosave!
						
                        dojo.xhrDelete({
							url: autoSaveCleanup,
							handleAs: "text",
							sync: true,
							load:  lang.hitch(this, function()
				                {
								if (debug)
									console.log("successfully deleted autosave");
								appDMS.projects.onRefresh().then(lang.hitch(this, function(){
									setTimeout(dojo.hitch(this,this.setInitialFocus),100);
								})) ;		
						    })
						});
                        
						if (this.autoSaveTimeout){
							clearInterval(this.autoSaveTimeout);
						}
						var timeoutPref = this.appDMS.getPreference("SWE.optionPreferencesEditor");
						if (timeoutPref.autoSave && timeoutPref.autoSave == "true"){
							var autoTimeout = timeoutPref.autoSaveInterval * 1000;
							this.autoSaveTimeout = setInterval(lang.hitch(this, this.autoSave), autoTimeout); // 30 secs
							this.autoSaved = false;
						}
					} else if (this.fileType.toUpperCase() === 'SAS'){
                        this.autoSaveAllowed = true;
					    this.enableAutoSave('true');
					}
				}
				if (this.onSaveComplete != null)
					this.onSaveComplete(targetObject);
			}
		},


		// This is called to save snippets.
 		onSaveSnippet : function(projectPath, needToRegisterSnippet, snippetName)
		{
 			var name = snippetName + '.sas';

			if (this.fileNameTextBox == null)
			{
				this.fileNameTextBox = dijit.byId('snippetName');
				this.fileNameTextBox.set('invalidMessage', this.resourceBundle.invalidFileNameMsg);// nls
			}

			if(appDMS.dialogs.saveAsDialog)
				appDMS.dialogs.saveAsDialog.hide();

            var uri = projectPath + '/' + name;

			var code = "";
			var selcode=this.editor.getSelectedText();
			if (selcode && selcode.length>0)
				code=selcode;
			else
			    code = this.editor.getText();

			var url =  this.baseURL + '/sasexec/sessions/' + this.sessionId + '/workspace/' + encodeValue(projectPath) + '/' + encodeValue(name);
			if(appDMS.optionPreferencesGeneral.defaultTextEncoding != "UTF-8")
			{
				url += "?encoding=" + appDMS.optionPreferencesGeneral.defaultTextEncoding;
			}

			dojo.xhrPost({
				postData : code,
				url : url,
				contentType : "text/file",
				handleAs : "json",
				headers: { "ObjectType": "" },
				preventCache : true,

				load: lang.hitch(this, function(data, args)
				{
					// If this is a task, saving a SAS file should not disable the Save button as per
					//  instructions from Sam.  Only saving a task as a CTK file should do this.
					if (! this.taskMode )
						this.isFile=false;
					var targetObject=new Object();
					targetObject.uri = uri;
					targetObject.fileName = name;
					targetObject.isSnippetFile = true;
					appDMS.handleWebOneEvent("FileSaved", targetObject);
					var tooltip=this.templates.resourceBundle.mySnippets+"/"+snippetName;
					if(this.tabObject && this.tabObject.type==="newsnippet"){

						this.name=snippetName;
						this.uri=uri;

						this.object.type="FILE";
						this.object.title=snippetName;
						this.object.name=name;
						this.object.tooltip=tooltip;
						this.object.uri=uri;
						this.object.isMySnippet=true;
						if(this.object.tab){
							if(this.object.tab.controlButton)
								this.object.tab.controlButton.containerNode.innerHTML=snippetName;
							this.object.tab.setAttribute("tooltip", tooltip);
							this.object.tab.setAttribute("title", snippetName);
						}
						this.editorContentChanged=false;
					}else{
						targetObject=dojo.mixin({tabTitle:snippetName, name:snippetName, tooltip:tooltip,
									 type:"FILE", code:code, uri:uri, isMySnippet:true}, targetObject);

						appDMS.handleWebOneEvent("TaskCodeEdit", targetObject);
					}

					//S1141145
					//this.setButtonStates();
					if (this.projects != null)
						this.projects.onRefresh();

					if (needToRegisterSnippet)
					{
						var object = {
								name: name,
								uri: uri
						};
						this.templates.onRegisterMySnippet(object);
					}

					if (this.onSaveComplete != null)
						this.onSaveComplete(targetObject);
				}),
				error: function(err, args)
				{
					dojoAlert(err.response.xhr.getResponseHeader("Exception"));
				}
			});

			if (this.saveHandle)
			{
				dojo.disconnect(this.saveHandle);
				this.saveHandle=null;
			}
		},

		onNew: function()
		{
// this.tabs.addEditorTab('&lt;untitled&gt;', '', '/*Enter your code here*/',
// false);
			//this.tabs.addEditorTab(this.resourceBundle.untitled, '', '/*'+ this.resourceBundle.enterCodeHere+ '*/', false);
		appDMS.handleWebOneEvent("NewProgram", {name:this.resourceBundle.untitled, type:"sas"});
		},
		onSaveLogAs: function()
		{
			if (this.logURL!=null)
			{
				if (this.iframe==null)
				{
					this.iframe = document.createElement("iframe");
					this.iframe.setAttribute('style', 'visibility:hidden');
					dojo.body().appendChild(this.iframe);
				}

				var name=this.name.replace(".sas","");
				name=name.replace(".SAS","");
				name=name.replace(".ctk","");
				name=name.replace(".CTK","");
				name=name.replace(".ctm","");
				name=name.replace(".CTM","");
				name=name + "-" + this.resourceBundle.logFile + ".html";

				var ename = encodeValue(name);
				this.iframe.src=encodeDoubleSlashesInURL(this.logURL + "?download=true&filename=" + ename);
			}
		},
		onSaveOutputAs: function()
		{
			if (this.resultsURL!=null)
			{
				if (!this.allowCtrlS) return; // if you do an empty submit,
												// you get a results url, but no
												// content - this hack keeps you
												// from saving with keyboard
				if (this.iframe==null)
				{
					this.iframe = document.createElement("iframe");
					this.iframe.setAttribute('style', 'visibility:hidden');
					dojo.body().appendChild(this.iframe);
				}

				var name=this.name.replace(".sas","");
				name=name.replace(".SAS","");
				name=name.replace(".ctk","");
				name=name.replace(".CTK","");
				name=name.replace(".ctm","");
				name=name.replace(".CTM","");
				name=name + "-" + this.resourceBundle.resultsFile + ".html";

				var ename = encodeValue(name);
				this.iframe.src=encodeDoubleSlashesInURL(this.resultsURL + "?download=true&filename=" + ename);
			}
		},
		selectAll: function()
		{
			this.editor.selectAll();
			this.setButtonStates();
		},
		resetInteractive: function()
		{
			if (this.mode=="interactive")
			{
				var label=this.name;
				if (label==null || label.length==0) // || this.isVirgin()) //
															// comment out for now
							// label="untitled";
				label=this.resourceBundle.untitled;

				// Make sure the message loop is running.
	            appDMS.startMessageServiceLoop();

				var _url= this.baseURL+'/sasexec/sessions/' + this.sessionId + '/submissions?mode=interactive&label=' + encodeValue(label);

				dojo.xhrPost({
							postData:"",
							handleAs:"json",
							preventCache:true,
							url: _url,
							headers:
							{
								"Content-Type":"text/plain; charset=utf-8"
							},
							load: dojo.hitch(this, function(submission)
							{
								this.submission=submission;
								this.submitID = submission.id;
								this.outputAreaContentPane.domNode.id="ods_" + submission.id;
								dojo.addClass(this.outputAreaContentPane.domNode,"ods_" + submission.id);
								this.logURL=this.baseURL+"/sasexec/submissions/" + submission.id + "/log";
								this.resultsURL=this.baseURL+"/sasexec/submissions/" + submission.id + "/results";
								this.addURL=this.baseURL+"/sasexec/submissions/" + submission.id + "/add";
								this.closeURL=this.baseURL+"/sasexec/submissions/" + submission.id + "/close";

								this.outputAreaContentPane.set('href', this.resultsURL);
								this.logAreaContentPane.set('href', this.logURL);
								//setTimeout(dojo.hitch(this,this.commandLineFocus),20);
								this.mailResultsButton.set("disabled",false);
								this.outputPrintButton.set("disabled",false);
							    this.openResultsInNewBrowserTabButton.set("disabled", false);
								this.logSaveButton.set("disabled",false);
								this.logSaveAsButton.set("disabled",false);
								this.logPrintButton.set("disabled",false);
								this.openlogBrowserTabButton.set("disabled",false);
								this.setButtonStates();

							}),
							error: dojo.hitch(this,function(err, args)
							{
								var msg=err.response.xhr.getResponseHeader("Exception");
								if (msg==null) msg=this.resourceBundle.unknownSubmissionErr;
								dojoAlert(msg);
							})
						});
			}

		},
		clearInteractive: function()
		{
			this.clearIDialog.hide();
			this.clearIDialog=null;
			this.editor.readOnly(false);
			this.editor.setText("");
			dojo.xhrGet({
				handleAs:"json",
				preventCache:true,
				url: this.closeURL,
				load: dojo.hitch(this, function(submission)
				{
					this.closeURL=null;
					this.projects.onRefresh();
					this.libraries.onRefresh();
					this.files.onRefresh();
					this.setButtonStates();

					var label=this.name;
					if (label==null || label.length==0) // || this.isVirgin()) //
														// comment out for now
						// label="untitled";
						label=this.resourceBundle.untitled;

					var _url= this.baseURL+'/sasexec/sessions/' + this.sessionId + '/submissions?mode=interactive&label=' + encodeValue(label);

					dojo.xhrPost({
						postData:"",
						handleAs:"json",
						preventCache:true,
						url: _url,
						headers:
						{
							"Content-Type":"text/plain; charset=utf-8"
						},
						load: dojo.hitch(this, function(submission)
						{
							this.submission=submission;
							this.submitID=submission.id;
							this.outputAreaContentPane.domNode.id="ods_" + submission.id;
							dojo.addClass(this.outputAreaContentPane.domNode,"ods_" + submission.id);
							this.logURL=this.baseURL+"/sasexec/submissions/" + submission.id + "/log";
							this.resultsURL=this.baseURL+"/sasexec/submissions/" + submission.id + "/results";
							this.addURL=this.baseURL+"/sasexec/submissions/" + submission.id + "/add";
							this.closeURL=this.baseURL+"/sasexec/submissions/" + submission.id + "/close";

							this.outputAreaContentPane.set('href', this.resultsURL);
							this.logAreaContentPane.set('href', this.logURL);
							setTimeout(dojo.hitch(this,this.commandLineFocus),20);
							this.mailResultsButton.set("disabled",false);
							this.outputPrintButton.set("disabled",false);
						    this.openResultsInNewBrowserTabButton.set("disabled", false);
							this.logSaveButton.set("disabled",false);
							this.logSaveAsButton.set("disabled",false);
							this.logPrintButton.set("disabled",false);
							this.openlogBrowserTabButton.set("disabled",false);
							this.setButtonStates();

						}),
						error: dojo.hitch(this,function(err, args)
						{
							var msg=err.response.xhr.getResponseHeader("Exception");
							if (msg==null) msg=this.resourceBundle.unknownSubmissionErr;
							dojoAlert(msg);
						})
					});

				}),
				error: dojo.hitch(this,function(err, args)
				{
					this.closeURL=null;
					var msg=err.response.xhr.getResponseHeader("Exception");
					if (msg==null) msg=this.resourceBundle.unknownSubmissionErr;
					dojoAlert(msg);
				})
			});
		},
		clearCancel: function()
		{
			this.clearIDialog.hide();
			this.clearIDialog=null;
		},

		clearAll: function()
		{
			if (this.mode=="interactive")
			{
				this.clearIDialog=appDMS.dialogs.postDecisionDialog(this.resourceBundle.ClearCodeAndReset, null,
						{label:this.resourceBundle.yes,
						callback:lang.hitch(this,this.clearInteractive),
						primary:true},
						{label:this.resourceBundle.noLabel,
						callback:lang.hitch(this,this.clearCancel)});
			}
			else
			{
				this.editor.clear();
				this.setButtonStates();
			}
		},

		clearLog: function()
		{			
			if (this.mode.toUpperCase !=="INTERACTIVE")
				var url=this.baseURL+"/sasexec/submissions/" + this.submitID + "/log";
			else
				var url=this.baseURL+"/sasexec/submissions/" + this.submission.id + "/log";
			dojo.xhrDelete({
				url : url,
				handleAs : "json",
				preventCache : true,

				load: lang.hitch(this, function(data, args)
				{
					var refresh=function()
					{
						if (this.mode.toUpperCase !=="INTERACTIVE")
							this.logAreaContentPane.set("content","");
						else
							this.logAreaContentPane.refresh();
					};

					setTimeout(dojo.hitch(this,refresh),20);
				}),
				error: dojo.hitch(this,function(err, args)
				{
					var msg=err.response.xhr.getResponseHeader("Exception");
					if (msg!=null)
						dojoAlert(msg);
				})
			});
		},
		
		clearResults: function()
		{
			var okCB=function()
			{
				this.clearResultsDialog.hide();
				var url=this.baseURL+"/sasexec/submissions/" + this.submission.id + "/results";
				dojo.xhrDelete({
					url : url,
					handleAs : "json",
					preventCache : true,

					load: lang.hitch(this, function(data, args)
					{
						var refresh=function()
						{
							this.outputAreaContentPane.refresh();
						};

						setTimeout(dojo.hitch(this,refresh),20);
					}),
					error: dojo.hitch(this,function(err, args)
					{
						var msg=err.response.xhr.getResponseHeader("Exception");
						if (msg!=null)
							dojoAlert(msg);
					})
				}
				);
			}

			var cancelCB=function()
			{
				this.clearResultsDialog.hide();
			}

			this.clearResultsDialog=appDMS.dialogs.postDecisionDialog(this.resourceBundle.clearResultsPrompt, null,
						{label:this.resourceBundle.yes,
						callback:lang.hitch(this,okCB),
						primary:true},
						{label:this.resourceBundle.noLabel,
						callback:lang.hitch(this,cancelCB)});
		},

		onOutputPrint: function()
		{
			if (this.resultsURL)
			{
				var url=this.resultsURL;
				if (!url) url="";
				this.pw=window.open(url);
				//wait for window.open to finish before swapping in NLS bundle for Results tab-label (S1043964)
				setTimeout(lang.hitch(this, function(){
				    // Need to use the name being passed in and not what's on the object S1120433
				    this.pw.document.title = this.resourceBundle.summaryResultsHeading + this.name;

					setTimeout(lang.hitch(this,this.printWindow),900);
				}), 100);
			}
			else
			{
				this.pw=window.open();
				var results=this.outputAreaContentPane.get("content");
				this.pw.document.write(results);
				this.pw.document.close();
				if (this.saspkgId)
					this.pw.document.getElementsByTagName("html")[0].setAttribute("class","ods_" + this.saspkgId);
				setTimeout(lang.hitch(this,this.printWindow),1000);
			}

		},
		onLogPrint: function()
		{
			this.pw=window.open();
			var log=this.logAreaContentPane.get("content");
            var style = "<style>\n.sasError{color:red}\n.sasMessage{color:#000}\n.sasWarning{color:#008000}\n.sasSource{color:#000}\n.sasNote{color:#00f}\n</style>";
            this.pw.document.write("<!DOCTYPE html>\n<html><head>" + style + "<title>" + appDMS.encodeHtml(this.resourceBundle.summaryLogHeading + this.name) + "</title><body>" + log + "</body></html>");
			this.pw.document.close();
			setTimeout(lang.hitch(this,this.printWindow),1000);
		},

		onLogTabOpen: function()
		{
			var appendLog = true;
			if (appDMS.optionPreferencesEditor.appendLog){
            	 if (appDMS.optionPreferencesEditor.typeSelection === "Program only" && typeof (this.taskMode) !== 'undefined' && this.taskMode){
            		appendLog = false;
            	} else if (appDMS.optionPreferencesEditor.typeSelection === "Task only" && typeof (this.taskMode) === 'undefined'){
            		appendLog = false;
            	}
            } 
			
		    if (this.logURL && !appendLog)
			{
				var url=this.logURL;
				if (!url) url="";
				this.pw=window.open(url);
				//wait for window.open to finish before swapping in NLS bundle for Results tab-label (S1111166)
				setTimeout(lang.hitch(this, function(){
					this.pw.document.title = this.resourceBundle.summaryLogHeading + this.pw.document.title.substring(this.pw.document.title.indexOf (":")+1);
				}), 300);

			}
			else {
			this.pw=window.open();
			var log=this.logAreaContentPane.get("content");
			var style="<style>\n.sasError{color:red}\n.sasMessage{color:#000}\n.sasWarning{color:#008000}\n.sasSource{color:#000}\n.sasNote{color:#00f}\n</style>";
            this.pw.document.write("<!DOCTYPE html>\n<html><head>" + style + "<title>" + appDMS.encodeHtml(this.resourceBundle.summaryLogHeading + this.name) + "</title><body>" + log + "</body></html>");
			this.pw.document.close();
		}
		},

		setCompleteMailPreferences: function ()
		{
			var mailIds = this.mailStore.query();
			if (this.recipientInput.displayedValue && this.recipientInput.displayedValue !== null && this.mailStore.get(this.recipientInput.displayedValue) == null) {

				if (this.mailStore.data.length >= 9)
	                this.mailStore.remove(this.mailStore.data[0].id);

	           obj={};
	           obj.id=this.recipientInput.displayedValue;
	           obj.name=this.recipientInput.displayedValue;
	           mailIds.push(obj);
	        }
			this.appDMS.sasStudioPreferences.setMailPreferences(mailIds, "mailIds");

			var ccMailIds = this.ccMailStore.query();
			if (this.recipientCCInput.displayedValue && this.recipientCCInput.displayedValue !== null && this.ccMailStore.get(this.recipientCCInput.displayedValue) == null) {

				if (this.ccMailStore.data.length >= 9)
	                this.ccMailStore.remove(this.ccMailStore.data[0].id);

	           obj={};
	           obj.id=this.recipientCCInput.displayedValue;
	           obj.name=this.recipientCCInput.displayedValue;
	           ccMailIds.push(obj);
	        }
			this.appDMS.sasStudioPreferences.setMailPreferences(ccMailIds, "ccMailIds");
		},

		onMailResults: function()
		{
			if (dojo.exists("sendMailDialog"))
			{
			//	console.log ("sendMail dialog widget already exists");
			}
			else
			{
				appDMS.dialogs.postTmplDialog(sendMailDialogTemplate,"sendMailDialog");

			}

			if (this.sendMailDialog==null){
				this.sendMailDialog=registry.byId('sendMailDialog');
				this.sendMailDialog.set("title", this.resourceBundle.sendEmail);
			}

			dojo.byId('attachItemsLabel').innerHTML = this.resourceBundle.sendMailHeading;
			dojo.byId('emailCodeLabel').innerHTML = this.resourceBundle.emailCodeLabel;
			dojo.byId('emailLogLabel').innerHTML = this.resourceBundle.emailLogLabel;
			dojo.byId('emailPDFResultsLabel').innerHTML = this.resourceBundle.emailPDFResultsLabel;
			dojo.byId('emailHTMLResultsLabel').innerHTML = this.resourceBundle.emailHTMLResultsLabel;
			dojo.byId('emailRTFResultsLabel').innerHTML = this.resourceBundle.emailRTFResultsLabel;
			dojo.byId('emailSummaryLabel').innerHTML = this.resourceBundle.emailSummaryLabel;
			dojo.byId('recipientLabel').innerHTML = this.resourceBundle.recipientLabel;
			dojo.byId('recipientCCLabel').innerHTML = this.resourceBundle.recipientCCLabel;
			dojo.byId('mailSubjectLabel').innerHTML = this.resourceBundle.mailSubjectLabel;
			dijit.byId('mailContentInput').set('placeHolder', this.resourceBundle.mailContentInputPlaceholder);

			dojo.byId('emailPDFResultsLabel').setAttribute('style','display:table-cell');
			dojo.byId('emailRTFResultsLabel').setAttribute('style','display:table-cell');


			this.recipientInput=dijit.byId('recipientInput');
			this.recipientInput.set("aria-label", this.resourceBundle.recipientAriaLabel);
			this.recipientCCInput=dijit.byId('recipientCCInput');
			this.recipientCCInput.set("aria-label", this.resourceBundle.recipientCCLabel);
			var mailSubjectInput=dijit.byId('mailSubjectInput');
			mailSubjectInput.set("aria-label", this.resourceBundle.mailSubjectLabel);
			var mailContentInput=dijit.byId('mailContentInput');
			mailContentInput.set("aria-label", this.resourceBundle.mailContenttLabel);

			//swghan test
			var mailIds=[];
			this.mailPreferences =  this.appDMS.sasStudioPreferences.getMailPreferences();
			if (!this.mailPreferences.mailIds || this.appDMS.isEmpty(this.mailPreferences.mailIds)) {
				var obj = new Object();
				obj.name = '';
				obj.id = '';
				mailIds.push(obj);
			}
			else {
				if (this.mailPreferences.mailIds.length > 0)
					mailIds = this.mailPreferences.mailIds;
			}

			this.mailStore = new Memory({
				data: mailIds
			});

			var ccMailIds=[];
			if (!this.mailPreferences.ccMailIds || this.appDMS.isEmpty(this.mailPreferences.ccMailIds)) {
				var obj = new Object();
				obj.name = '';
				obj.id = '';
				ccMailIds.push(obj);
			}
			else {
				if (this.mailPreferences.ccMailIds.length > 0)
					ccMailIds = this.mailPreferences.ccMailIds;
			}

			this.ccMailStore = new Memory({
				data: ccMailIds
			});

			//swghan test ends

			this.recipientInput.store=this.mailStore;
			this.recipientInput.searchAttr= "name";
			this.recipientInput.intermediateChanges=true;
			this.recipientInput.set("onChange", lang.hitch(this, function(value){
			    	var validationTBName = dijit.byId('recipientInput');
			    	var isNameValid=validationTBName.validator();

			    	setTimeout(lang.hitch(this,function(){
						var sendMailButton = dijit.byId('sendMailButton');
						sendMailButton.set("disabled",true);
				    	if(isNameValid){
				    		sendMailButton.set("disabled",false);
				    	}
				    	else{
				    		sendMailButton.set("disabled",true);
				    	}
					}), 500);
			}));

			this.recipientInput.validator = lang.hitch(this, function() {
				var validationTB=dijit.byId("recipientInput");
				var value=validationTB.value;
				var addresses=value.split(";");
				var curAddress="";
				var isValid=false;
				for(var ad=0;ad<addresses.length;ad++){
					curAddress=addresses[ad].trim();

					if(curAddress.length >= 0 && !dojox.validate.isEmailAddress(curAddress)){
						break;
					}
					if(ad===addresses.length-1)
						isValid=true;
				}
				return isValid
		    });

			this.recipientCCInput.store=this.ccMailStore;
			this.recipientCCInput.searchAttr= "name";
			this.recipientCCInput.intermediateChanges=true;
			this.recipientCCInput.set("onChange", lang.hitch(this, function(value){					
			    	var validationTBName = dijit.byId('recipientCCInput');
			    	var isNameValid=validationTBName.validator();

			    	setTimeout(lang.hitch(this,function(){
						var sendMailButton = dijit.byId('sendMailButton');
						sendMailButton.set("disabled",true);
				    	if(isNameValid){
				    		sendMailButton.set("disabled",false);
				    	}
				    	else{
				    		sendMailButton.set("disabled",true);
				    	}
					}), 500);
			}));

			this.recipientCCInput.validator = lang.hitch(this, function() {
				var validationTB=dijit.byId("recipientCCInput");
				var value=validationTB.value;

				//cc is not required field
				if(value==="")
					return true;

				var addresses=value.split(";");
				var curAddress="";
				var isValid=false;
				for(var ad=0;ad<addresses.length;ad++){
					curAddress=addresses[ad].trim();

					if(curAddress.length > 0 && !dojox.validate.isEmailAddress(curAddress)){
						break;
					}
					if(ad===addresses.length-1)
						isValid=true;
				}
				return isValid
		    });

			/* taking out mailFormatCombo for now.  May add back later
			this.mailFormatSelect=dijit.byId('mailFormatCombo');
			var currentOptions=this.mailFormatSelect.options;
			currentOptions[0].label = this.resourceBundle.formatRTF;
			currentOptions[1].label = this.resourceBundle.formatPlainText;
			currentOptions[2].label = this.resourceBundle.formatHTML;
			this.mailFormatSelect.updateOption(currentOptions);*/


			var emailCodeCheckBox = dijit.byId('emailCodeCheckBox');
				emailCodeCheckBox.set("aria-label", this.resourceBundle.emailCodeAriaLabel);
			var emailLogCheckBox = dijit.byId('emailLogCheckBox');
				emailLogCheckBox.set("aria-label", this.resourceBundle.emailLogAriaLabel);
			var emailPDFResultsCheckBox = dijit.byId('emailPDFResultsCheckBox');
				emailPDFResultsCheckBox.set("aria-label", this.resourceBundle.emailPDFResultsAriaLabel);
			var emailRTFResultsCheckBox = dijit.byId('emailRTFResultsCheckBox');
				emailRTFResultsCheckBox.set("aria-label", this.resourceBundle.emailRTFResultsAriaLabel);
			var emailHTMLResultsCheckBox = dijit.byId('emailHTMLResultsCheckBox');
				emailHTMLResultsCheckBox.set("aria-label", this.resourceBundle.emailHTMLResultsAriaLabel);
			var emailSummaryCheckBox = dijit.byId('emailSummaryCheckBox');
				emailSummaryCheckBox.set("aria-label", this.resourceBundle.emailSummaryAriaLabel);
			emailRTFResultsCheckBox.setAttribute('style','display:table-cell');
			emailPDFResultsCheckBox.setAttribute('style','display:table-cell');


			emailHTMLResultsCheckBox.set("onChange", lang.hitch(this.onSendMailDialogChange));
			emailPDFResultsCheckBox.set("onChange", lang.hitch(this.onSendMailDialogChange));
			emailRTFResultsCheckBox.set("onChange", lang.hitch(this.onSendMailDialogChange));
			emailLogCheckBox.set("onChange", lang.hitch(this.onSendMailDialogChange));
			emailCodeCheckBox.set("onChange", lang.hitch(this.onSendMailDialogChange));
			emailSummaryCheckBox.set("onChange", lang.hitch(this.onSendMailDialogChange));

				//only enable checkboxes for the types of results produced
			if (this.currentSubmission.pdfEnabled)
				emailPDFResultsCheckBox.set('disabled',false);
			else{
				emailPDFResultsCheckBox.set('disabled',true);
				emailPDFResultsCheckBox.set('checked',false);
			}

			if (this.currentSubmission.rtfEnabled)
				emailRTFResultsCheckBox.set('disabled',false);
			else{
				emailRTFResultsCheckBox.set('disabled',true);
			    emailRTFResultsCheckBox.set('checked',false);
			}

			if (emailSummaryCheckBox) {
				// 2015-03-20 sasjkx S1125766 summary doesn't work in report
				//	mode because no log available.  Therefore disable it.
				if ((typeof reportApp !== 'undefined') && reportApp) {
					emailSummaryCheckBox.set('disabled', true);
					emailSummaryCheckBox.set('checked', false);
				} else {
					emailSummaryCheckBox.set('disabled', false);
				}
			}


			var sendMailButton = dijit.byId('sendMailButton');
			sendMailButton.set('label', this.resourceBundle.send);
			sendMailButton.set('aria-label', this.resourceBundle.send);
			sendMailButton.set("disabled",true);

			this.sendMailHandle= dojo.connect(sendMailButton, 'onClick', lang.hitch(this, function(){
				var CcRecipient = "";
				var recipient= this.recipientInput.get('value');
				CcRecipient = this.recipientCCInput.get('value');
				//added following encoding for S1087652. they dont need to be decoded at the server side.
				var mailSubject = mailSubjectInput.get('value');
				recipient=recipient.trim();
				CcRecipient=CcRecipient.trim();
				mailSubject=mailSubject.trim();
				mailSubject=encodeValue(mailSubject);
				var mailContent = mailContentInput.get('value');
				mailContent=encodeValue(mailContent);

				var attachTypes = [];
				if (emailCodeCheckBox.get("checked"))
					attachTypes.push("sas");
				if (emailLogCheckBox.get("checked"))
					attachTypes.push("log");
				if (emailPDFResultsCheckBox.get("checked"))
					attachTypes.push("pdf");;
				if (emailRTFResultsCheckBox.get("checked"))
					attachTypes.push("rtf");;
				if (emailHTMLResultsCheckBox.get("checked"))
					attachTypes.push("html");

				var payload = 'to='+recipient+'&cc='+CcRecipient+'&content='+mailContent+'&subject='+mailSubject+'&attachment='+this.currentSubmission.id+'&types='+attachTypes+'&fileName='+encodeValue(this.name.split(".")[0]);

				var summary="";
				if(emailSummaryCheckBox.get("checked")){
					payload = payload +'&summary=true';
					summary=this.generateSummary();
				}

				this.sendMailDialog.hide();

				dojo.xhrPost({
							preventCache : true,
							postData: summary,
							url:  this.baseURL+'/sasexec/share/mail/' + this.sessionId + "?" + payload,
							sync : false,
							handleAs : 'json',
							headers: { 'Content-Type': 'text/html;charset=utf-8'},
							load : lang.hitch(this, function(data, args)
							{
						  	   var theReturned=data;
						  	   this.setCompleteMailPreferences();
							}),
						    error : lang.hitch(this,function(err,args)
							{
						    	var msg="";
						    	var details="";
								try
								{
									msg=err.response.xhr.getResponseHeader("Exception");
									details=JSON.stringify(args.xhr);
								}
								catch(e) {}

						    	if (msg==null || msg=="") msg=this.resourceBundle.unknownSendMailErr;
						    	if (decodeURI(msg).toLowerCase().indexOf("domain contains illegal character") !=-1)
						    		msg=this.resourceBundle.illegalCharinDomain;
						    	if (decodeURI(msg).toLowerCase().indexOf("missing domain") !=-1)
						    		msg=this.resourceBundle.missingDomain;
						    	if (decodeURI(msg).toLowerCase().indexOf("illegal address") !=-1)
						    		msg=this.resourceBundle.illegalAddress;
								if (decodeURI(msg).toLowerCase().indexOf("invalid address") !=-1)
						    		msg=this.resourceBundle.illegalAddress;


						    	if (appDMS.optionPreferencesGeneral.showErrorDetails)
						    			appDMS.dialogs.postFaultDialog(msg,details);
						    	else
						    		appDMS.dialogs.postFaultDialog(msg);
							})
						});	//xhrpost


				}));

			var cancelMailButton = dijit.byId('cancelMailButton');
			cancelMailButton.set('label', this.resourceBundle.cancel);

			this.cancelMailHandle = dojo.connect(cancelMailButton, 'onClick', lang.hitch(this, function(){
				this.sendMailDialog.hide();
			}));

			this.hideMailHandle = dojo.connect(this.sendMailDialog, 'onHide', lang.hitch(this, function() {
				this.recipientInput.reset();
				mailSubjectInput.reset();
				mailContentInput.reset();
				this.recipientCCInput.reset();

				if (this.sendMailHandle) {
					dojo.disconnect(this.sendMailHandle);
					this.sendMailHandle=null;
				}

				if (this.cancelMailHandle) {
					dojo.disconnect(this.cancelMailHandle);
					this.cancelMailHandle=null;
				}

				if (this.hideMailHandle) {
					dojo.disconnect(this.hideMailHandle);
					this.hideMailHandle=null;
				}
			}));

			setDialogKeyHandler(dijit.byId('sendMailDialog'),lang.hitch(this,this.onSendMailDialogChange));

			this.sendMailDialog.show();

		},
		onSendMailDialogChange: function()
		{
			var isSendDisabled = false;
			var sendMailButton = dijit.byId('sendMailButton');
			var isValid = dijit.byId("sendMailForm").get('state');
			if(isValid !== "") {
				isSendDisabled=true;
			}
			
			var validationTBName = dijit.byId('recipientInput');
			var isNameValid=validationTBName.validator();
			if(!isNameValid) {
				isSendDisabled=true;
			}
			
			var validationTBNameCC = dijit.byId('recipientCCInput');
	    	var isNameValid=validationTBNameCC.validator();
	    	if(!isNameValid) {
				isSendDisabled=true;
			}
			
			if(dijit.byId('recipientInput').get('value')==="" && dijit.byId('recipientCCInput').get('value')===""){
				isSendDisabled=true;
			}
			//disable send if no boxes are all checked
			if (!dijit.byId('emailCodeCheckBox').get("checked") && !dijit.byId('emailLogCheckBox').get("checked") && !dijit.byId('emailPDFResultsCheckBox').get("checked")
					&& !dijit.byId('emailRTFResultsCheckBox').get("checked") && !dijit.byId('emailHTMLResultsCheckBox').get("checked") && !dijit.byId('emailSummaryCheckBox').get("checked")){
				isSendDisabled=true;
			}

			setTimeout(lang.hitch(this,function(){
						sendMailButton.set("disabled",isSendDisabled);
					}), 300);
			
		},
		saveSnippet : function()
		{
			try
			{
	 			if (dojo.exists("snippetsAddDialog"))
				{
	 				if(dijit.byId('snippetsAddDialog').open)
	 					return;
				}
			    else
				{
					appDMS.dialogs.postTmplDialog(snippetsAddDialogTemplate,"snippetsAddDialog");
				}

				var snippetsFile;
				var snippetsAddDialog = dijit.byId('snippetsAddDialog');
				snippetsAddDialog.set('title', this.resourceBundle.saveSnippet);
				dom.byId('snippetLocationLabel').innerHTML = this.resourceBundle.locationLabel;
				dom.byId('snippetLocationValue').innerHTML = this.resourceBundle.mySnippets;

				var snippetNameTextBox=dijit.byId('snippetName');
				dom.byId('snippetNameLabel').innerHTML = this.resourceBundle.nameLabel;
				var snippetName;

				snippetNameTextBox.set('invalidMessage', this.resourceBundle.invalidFileNameMsg);// nls
				snippetNameTextBox.set("value","");
				snippetNameTextBox.set("trim",true);
				snippetNameTextBox.set("onFocus", function(){
					this.focusNode.select();
				});

				snippetNameTextBox.intermediateChanges=true;

				var saveFileAsForm = dijit.byId("saveSnippetAsForm");
				var okButton = dijit.byId('okButtonSnippets');
				domClass.add(okButton.domNode, "sasPrimaryButton");
				
				dojo.connect(snippetNameTextBox, "onChange", lang.hitch(this, function(value){
				    var isValid = saveFileAsForm.validate();
				    value = trimString(value);
					if(!isValid || value == "" || value.length==0){
						okButton.set("disabled",true);
					}
					else{
						okButton.set("disabled",false);
					}
				}));

				// hide dialog if cancel is clicked
				var cancelButton = dijit.byId('cancelButtonSnippets');
				cancelButton.set('label', this.resourceBundle.cancel);
				dojo.connect(cancelButton, 'onClick', lang.hitch(this,function()
				{
					if (this.saveSnippetHandle)
					{
						dojo.disconnect(this.saveSnippetHandle);
						this.saveSnippetHandle=null;
					}
					dijit.byId('snippetsAddDialog').hide();
				}));

				dojo.connect(cancelButton, 'onClose', lang.hitch(this,function()
				{
					if (this.saveSnippetHandle)
					{
						dojo.disconnect(this.saveSnippetHandle);
						this.saveSnippetHandle=null;
					}
					dijit.byId('snippetsAddDialog').hide();
				}));

				var hideSnippetHandle = dojo.connect(snippetsAddDialog, 'onHide', lang.hitch(this, function() {
					if (this.saveSnippetHandle)
					{
						dojo.disconnect(this.saveSnippetHandle);
						this.saveSnippetHandle=null;
					}
				}));
				// save the file
				okButton.set("disabled", true);
				okButton.set("label", this.resourceBundle.saveLabel);

				this.saveSnippetHandle = dojo.connect(okButton, 'onClick', lang.hitch(this, function()
				{
					var isNameEmpty=false;
					var isOkDisabled=okButton.get("disabled");
					if(isOkDisabled){
						isNameEmpty=true;
						dojoAlert(this.resourceBundle.enterName);
					}

					var name = snippetNameTextBox.get("value");
					var selcode=this.editor.getSelectedText();
					var code = this.editor.getText(); // this.textarea.getDisplayedValue();
					if (selcode && selcode.length>0) code=selcode;

                    projectPath = studioDataHome + "/snippets";
               //     needToRegisterSnippet = true;

                    var url = this.baseURL + '/sasexec/sessions/' + this.sessionId + '/workspace/' + projectPath + '/' + name;
                    var jsonurl = this.baseURL + '/sasexec/sessions/' + this.sessionId + '/workspace/' + projectPath + '/' + 'mysnippets.json.txt';

					if(!isNameEmpty)
					{
  					    var currentlyOpen = false;
  					    var tabWithSameNameSAS = null;
  					    if(this.appDMS.currentPerspectiveKey == 'editTabContentPane')
  					    {
  					    	if(this.tabs)
  					    		tabWithSameNameSAS = this.tabs.findTab(name, projectPath + '/' + name, 'sas');
  					    }else{
  					    	if(this.appDMS.perspective[this.appDMS.currentPerspectiveKey].findTab)
  					    		tabWithSameNameSAS = this.appDMS.perspective[this.appDMS.currentPerspectiveKey].findTab(name, projectPath+'/'+name, 'sas');
  					    }
                        if (tabWithSameNameSAS != null)
						{
							currentlyOpen = true;
						}
						else
						{
							if(this.appDMS.currentPerspectiveKey == 'editTabContentPane')
							{
								if(this.tabs)
									tabWithSameNameOther = this.tabs.findTab(name, projectPath + '/' + name, 'other');
								if (tabWithSameNameSAS != null)
									 currentlyOpen = true;
							}
						}
						if (currentlyOpen == true)
						{
						     var alreadyOpenMsg = dojo.byId('alreadyOpenMessage');
						     alreadyOpenMsg.innerHTML = this.resourceBundle.fileNameOpen.replace("${0}", name);
						     registry.byId('alreadyOpenDialog').set('title', this.resourceBundle.saveAsTitle);
						     registry.byId('alreadyOpenDialog').set("autofocus",false);
						     registry.byId('alreadyOpenDialog').show();
						     var alreadyOpenOK = dijit.byId('alreadyOpenOK');
						     alreadyOpenOK.set("label", this.resourceBundle.close);

						     var confirmHandle = on.once(alreadyOpenOK, 'click', lang.hitch(this, function()
						     {
							    registry.byId('alreadyOpenDialog').hide();
							    confirmCancelHandle.remove();
						     }));
						}
						else
						{
							// swghan - check if the selected directory already
							// has the file with the same name.
							var alreadyPresent=false;

							dojo.xhrGet({
								url : jsonurl,
								handleAs : "text",
								sync: true,
								load : lang.hitch(this, function(data, args)
										{
											snippetsFile = JSON.parse(data);
											for (var i=0; i < snippetsFile.templatesData.length; i++){
												if ( snippetsFile.templatesData[i].uri.toLowerCase()== (projectPath + '/' + name + '.sas').toLowerCase()){
													alreadyPresent = true;
													break;
												}
											}
											//alreadyPresent=false;
										}),
										error : function(err, args)
										{
											alreadyPresent=false;
										}
							});

							if(alreadyPresent)
							{

								var confirmCB=function()
								{

									this.replaceSnippetDialog.hide();
									alreadyPresent=false;
									this.onSaveSnippet(projectPath, false, name);
									dijit.byId('snippetsAddDialog').hide();
								}

								var cancelCB=function()
								{

									this.replaceSnippetDialog.hide();
								}

								var question=this.resourceBundle.fileNameAlreadyExists.replace("${0}", name);
								this.replaceSnippetDialog=appDMS.dialogs.postDecisionDialog(question, null,
										{label:this.resourceBundle.replace,
										callback:lang.hitch(this,confirmCB),
										primary:true},
										{label:this.resourceBundle.cancel,
										callback:lang.hitch(this,cancelCB)});

								this.replaceSnippetDialog.set("autofocus",false);
							}
							else
							{
								dijit.byId('snippetsAddDialog').hide();
								this.onSaveSnippet(projectPath, true, name);
							}
						}
					}
				}));

				// show the new object dialog
				setDialogKeyHandler(dijit.byId('snippetsAddDialog'),lang.hitch(this,function(event){
					if (event.keyCode == keys.ENTER)
					{
						setPreventDefault(event);
						//The 'onClick' event should not be generated for okButton if a DBCS language is in effect (S1054651)
						if (!dbcsImeMode() && okButton.disabled==false)
						okButton.onClick(event);
					}
			}));
				dijit.byId('snippetsAddDialog').show();
			}
			catch(e)
			{
				dojoAlert(e);
			}
		},

		onPrintCode: function()
		{
            var stylesheet = this.getStyleSheet('sce.css');

			var options=new Object();
			var isShowLineNum = ("true" === appDMS.optionPreferencesEditor.showLineNumbers)
			options.lineNumber=this.editor.lineNumber(isShowLineNum);
		    options.onlyVisible=false;

			var code=this.editor.getHTML(options);

			var link='<link media="all" rel="stylesheet" href="' + stylesheet + '" />';
			this.pw=window.open('');
			this.pw.document.open();
            this.pw.document.write("<!DOCTYPE html>\n<html><head><title>" + appDMS.encodeHtml(this.resourceBundle.summaryCodeHeading + this.name) + "</title>\n" + link + "</head><body><pre>" + code + "</body></html>");
			this.pw.document.close();
			this.pw.document.addEventListener("DOMContentLoaded", lang.hitch(this, setTimeout(lang.hitch(this,this.printWindow),1200)));
		},
		printWindow: function()
		{
 			if (this.pw!=null)
			{
			    console.log('userAgent ' + userAgent);
				if ((userAgent.toLowerCase().indexOf("safari")>-1 && userAgent.toLowerCase().indexOf('macintosh') > -1))
				{
					this.pw.focus();
				}
				else
				{
					appDMS.setBusy(true);
					this.pw.focus();
					this.pw.print();
					this.pw.close();
					this.pw=null;
					appDMS.setBusy(false);
				}
			}
		},

		//----- async support

		//----- job has been submitted
		onAsyncSubmit: function (submitID, args)
		{
			this.log = "";
			this.submitID = submitID;
			this.logURL = this.baseURL + "/sasexec/submissions/" + submitID + "/log";
			this.disableSubmitCancelButtons(true, false);
		},

		//----- job failed
		submitException: function(submission)
		{
			this.running = false;
			this.disableSubmitCancelButtons(false, true);
			if (this.submitDialog == null) return;

			this.removeTabBusyIcon();
			var msg = submission.exceptionMessage;
			if (this.submitDialog) {
				this.submitDialog.hide();
				this.submitDialog=null;
			}
			if (this.killConfirmDialog) {
				this.killConfirmDialog.hide();
				this.killConfirmDialog=null;
			}

			appDMS.submitRequest = null;
			msg = msg ? msg : this.resourceBundle.unknownSubmissionErr;
			appDMS.dialogs.postFaultDialog(msg);
			this.setButtonStates();
		},

		//----- job cancelled.
		submitCancel: function (submission)
		{
			this.disableSubmitCancelButtons(false, true);
			this.logURL=null;
			this.resultsURL=null;
			this.pdfURL=null;
			this.rtfURL=null;
			this.dataURL=null;
			appDMS.submissionCancelAction=false;

			try
			{
				if (this.cancelTimer) clearTimeout(this.cancelTimer);
				this.removeTabBusyIcon();
				this.cancelTimer=null;
			}
			catch(e) {}

			appDMS.clearRunningStatus();

			this.outputAreaContentPane.set("content",this.resourceBundle.cancelOutput);

			if (this.submitDialog) {
				this.submitDialog.hide();
				this.submitDialog=null;
			}
			if (this.killConfirmDialog) {
				this.killConfirmDialog.hide();
				this.killConfirmDialog=null;
			}

		},

		//----- job completed
		submitComplete: function (submission)
		{
			try
			{
				this.disableSubmitCancelButtons(false, true);

				this.running = false;
				var noOutput = (typeof submission.info.NoOutputGenerated !== 'undefined');
				var htmlSize = submission.info.HtmlFileSize;

				if(this.submitDialog) {
					this.submitDialog.hide();
					this.submitDialog=null;
					if (this.selectedTab.id.indexOf("log") !=-1)
					{
						this.setNextFocus();
					}
					else
					{
						var outputTabHeadId = this.editorTabContainer.id+'sasSuiteTabContainer_tablist_'+this.editorTabContainer.id+'output';
						var outputTabHead = dijit.byId(outputTabHeadId);
						this.focus.focus(outputTabHead.focusNode);
					}
				}
				
				if (this.killConfirmDialog) {
					this.killConfirmDialog.hide();
					this.killConfirmDialog=null;
				}

				appDMS.submitRequest=null;

				// Can we just look at the submission status here?
				if (appDMS.submissionCancelAction)
				{
					appDMS.submissionCancelAction=false;
					this.logURL=null;
					this.resultsURL=null;
					this.pdfURL=null;
					this.rtfURL=null;
					this.dataURL=null;
					this.outputAreaContentPane.set("content","");
 	                this.removeDataTab();
	                this.setOutputStates(true, false, false, false);

					return;
				}

				if (appDMS.optionPreferencesGeneral.autoRefreshFiles)
					this.projects.onRefresh();
				
				if (appDMS.optionPreferencesGeneral.autoRefreshLibraries)
					this.libraries.onRefresh();
					
				this.files.onRefresh();
				var submissionId=submission.id;
				this.currentSubmission=submission;
				this.currentSubmission.date=new Date();//this is to get client side date and time to show in ProgramSummary for the submission time instead of server side
				var old_ods_id = this.outputAreaContentPane.domNode.id;
				var new_ods_id = "ods_" + submission.id;
				this.outputAreaContentPane.domNode.id=new_ods_id;
				if (old_ods_id != null && startsWith(old_ods_id, "ods_")){
					domClass.replace(this.outputAreaContentPane.domNode, new_ods_id, old_ods_id);
				} else {
					dojo.addClass(this.outputAreaContentPane.domNode, new_ods_id);
				}
				this.removeTabBusyIcon();

				var bigWarning=false;
				if (appDMS.optionPreferencesResults.promptBeforeOpening &&
						appDMS.optionPreferencesResults.promptBeforeOpening !== "false" &&
						htmlSize > (appDMS.optionPreferencesResults.promptThreshold*1024*1024))
				{
					this.resultsURL=this.baseURL+"/toobig";
					bigWarning=true;
					var question=this.resourceBundle.bigOutputMessage.replace("${0}",appDMS.optionPreferencesResults.promptThreshold);
					appDMS.outputWarningDialog=appDMS.dialogs.postDecisionDialog(question, null,
							{label:this.resourceBundle.bigOutputOpen,
							callback:lang.hitch(appDMS,this.openBigOutput),
							primary:true},
							{label:this.resourceBundle.bigOutputCancel,
							callback:lang.hitch(appDMS,this.openBigOutputCancel)});
				}
				else
				{
					this.resultsURL=this.baseURL+"/sasexec/submissions/" + submissionId + "/results";
				}

				if (bigWarning==false)
				{
					this.outputAreaContentPane.set("open", true);
					this.outputAreaContentPane.set('href', this.resultsURL);
				}

				if (submission.mode!="INTERACTIVE")
				{
					if (submission.pdfEnabled)
						this.pdfURL=this.baseURL+"/sasexec/submissions/" + submissionId + "/pdf";
					else
						this.pdfURL=null;

					if (submission.rtfEnabled)
						this.rtfURL=this.baseURL+"/sasexec/submissions/" + submissionId + "/rtf";
					else
						this.rtfURL=null;

					this.dataURL=this.baseURL+"/sasexec/submissions/" + submissionId + "/data";
					this.submitStack[this.submitStack.length - 1].logURL = this.logURL;
					this.submitStack[this.submitStack.length - 1].resultsURL = this.resultsURL;

					this.submitStack[this.submitStack.length - 1].pdfURL = this.pdfURL;
					this.submitStack[this.submitStack.length - 1].rtfURL = this.rtfURL;
					this.submitStack[this.submitStack.length - 1].dataURL = this.dataURL;
					this.submitStack[this.submitStack.length - 1].submission = submission;

					this.setOutputStates(noOutput, bigWarning, submission.pdfEnabled, submission.rtfEnabled);
					if (!this.submitError)
						this.selectTab(this.outputContentPane);

					if (submission.macros._DATAOUT_URL) {
						window.open(submission.macros._DATAOUT_URL);
					}

                    // Check to see if we should automatically open the output data
					if (appDMS.optionPreferencesResults.autoOpenOutputData) {
						// Figure out expected output data if we are dealing with a task.
						var expectedOutputData = null;
						if (this.taskArea) {
							if (this.taskArea.getTaskOutputsArray) {
								expectedOutputData = {};
								var datalist = this.taskArea.getTaskOutputsArray();
								for (var z = 0; z < datalist.length; z++) {
									// TODO: VALIDMEMNAME???
									var piece = datalist[z];

									//While fixing S1455556, I did a global search for every location that used split(".") that appeared
									//to be related to library/table names.  Using split(".") will not work in the case of
									//ValidMemName="Extend".  I am attempting to fix this issue in all places even though there is
									//no test case.  I will leave the existing code here but commented out so that the original intent
									//can be seen in case there is an issue with my patch attempt.
									//NOTE: SASLibnames cannot contain the '.' character, so we are safe doing this as the indexof
									//      method returns the index of the first character, and the tableName looks like this:
									//      SASHELP.CLASS (as an example)
									//-krkise 8/29/2018

									//ORIGINAL CODE For reference
									// var parts = piece.split(".");
									// var lib = "";
									// var table = "";
									// if (parts.length == 1) {
									// 	lib = "WORK"; // TODO: What if default library isn't work?
									// 	table = parts[0].toUpperCase();
									// } else if (parts.length == 2){
									// 	lib = parts[0].toUpperCase();
									// 	table = parts[1].toUpperCase();
									// } else {
									// 	// This is bad...
									// }

									var lib = "";
									var table = "";
									var periodIndex = piece.indexOf(".");

									if (periodIndex > 0) //NOTE . won't be at 0 because neither libraries nor tables can start with a '.'
									{
										lib = piece.substring(0, periodIndex).toUpperCase();
										table = piece.substring(periodIndex + 1).toUpperCase();
									}
									else
									{
										lib = "WORK"; // TODO: What if default library isn't work?
										table = piece.toUpperCase();
									}

									if (lib && table) {
										// Make sure we have an entry for the library
										if (!expectedOutputData.hasOwnProperty(lib)) {
											expectedOutputData[lib] = {};
										}

										// Make sure we have an entry for library.table
										if (!expectedOutputData[lib].hasOwnProperty(table)) {
											expectedOutputData[lib][table] = {};
										}

									}

								}
							}
						}

					    // Generated data is now returned from the java mid-tier
					    //  after code is submited.  The client doesn't have to do
					    //  anything special to trigger the list of generated data sets
					    var tables = [];
					    var datasets = submission.dataSets;
					    if (datasets != null && datasets.length > 0) {
					        for (var i = 0; i < datasets.length; i++) {
					        	if (expectedOutputData != null) {
					        		// validate the table before adding it.
					        		var upperCaseLibrary = datasets[i].library.toUpperCase();
					        		var upperCaseMember = datasets[i].member.toUpperCase();
					        		if (expectedOutputData.hasOwnProperty(upperCaseLibrary)) {
					        			if (expectedOutputData[upperCaseLibrary].hasOwnProperty(upperCaseMember)) {
					        				tables.push(datasets[i]);
					        		//		tables.push(datasets[i].library + "." + datasets[i].member);
					        			}
					        		}
					        	} else {
					        		// Add everything.
					        		tables.push(datasets[i]);
					        		//tables.push(datasets[i].library + "." + datasets[i].member);
					        	}

					        }
					    }

					    if (tables.length > 0) {
					        this.createDataTab(tables);
					    } else {
					        this.removeDataTab();
					    }
					} else {
					    this.removeDataTab();
					}

					if (submission.macros._DATAOUT_NAME)
					{
						this.outputDataButton.set("disabled",false);
						var question=this.resourceBundle.programGeneratedMacro.replace("${0}", submission.macros._DATAOUT_NAME);
						appDMS.outputDialog=appDMS.dialogs.postDecisionDialog(question, null,
								{label:this.resourceBundle.open,
								callback:lang.hitch(appDMS,this.openOutput),
								primary:true},
								{label:this.resourceBundle.cancel,
								callback:lang.hitch(appDMS,this.openOutputCancel)});
					}
					else
					{
						this.outputDataButton.set("disabled",true);
						this.dataURL=null;
					}

					if (this.fileType=="CPK")
					{
						this.editorChanged(true);
					}
				}
				else
				{
					this.logAreaContentPane.set("href",this.logURL);
				}
				
				appDMS.resumeCommands();
				this.buildLastSubmitMenu();
			}
			catch(e)
			{
				console.warn(e);
				console.warn("Submission handler failed.");
			}
		},

		//swghan S1114459
//		getTableModifiedTime: function(url, oldTime)
//		{
//			var xhrArgs = {
//				url: url,
//				handleAs: "json",
//				preventCache: true,
//				load: lang.hitch(this, function(data, args){
//					data.oldTime=oldTime;
//					return data;
//				}),
//				error: lang.hitch(this, function(err, args){})
//			};
//
//			 var deferred = dojo.xhrGet(xhrArgs);
//			 return deferred;
//
//		},
		
		buildLastSubmitMenu: function () {
			var i=0;
			while (this.lastSubmitMenu.hasChildren())
			{
				this.lastSubmitMenu.removeChild(i);
			}

			for (i = 0; i < this.submitStack.length; i++)
			{
				this.lastSubmitMenu.addChild(new MenuItem({
					 data : this.submitStack[i],
					 label : this.submitStack[i].menuKey,
					 main : this.lastSubmitMenu ,
					 dmsTabs : this.dmsTabs,
					 rsButton : this.rsButton,
					 onClick: this.recall
				}));

			}
			this.lastSubmitMenu.focusFirstChild();
		},

		setOutputStates: function (noOutput, bigWarning, pdfEnabled, rtfEnabled) {

		    if (noOutput == null || noOutput == '') {
		        this.outputSaveButton.set("disabled", false);
		        this.outputPrintButton.set("disabled", false);
		        this.mailResultsButton.set("disabled",false);

		        if (pdfEnabled)
		            this.outputPDFButton.set("disabled", false);
		        else
		            this.outputPDFButton.set("disabled", true);

		        if (rtfEnabled)
		            this.outputRTFButton.set("disabled", false);
		        else
		            this.outputRTFButton.set("disabled", true);

		        this.openResultsInNewBrowserTabButton.set("disabled", false);
		        this.allowCtrlS = true;
		        if (this.clickHandle) {
		            // get rid of the click handle
		            this.clickHandle.remove();
		        }
		        this.clickHandle = on(this.outputAreaContentPane, "click", lang.hitch(this, function (event) {
		            //need keep the selectedTab event listener to maintain focus
		            this.onTabSelect(this.outputContentPane);
		            // opening new window...
		            if (event && !reportApp) setPreventDefault(event);
		            // window.open(this.outputAreaContentPane.get('href'));
		        }))
		    }
		    else {
		        this.allowCtrlS = false;
		        this.outputAreaContentPane.destroyDescendants();
		        this.selectTab(this.logContentPane);
		        this.outputSaveButton.set("disabled", true);
		        this.outputPrintButton.set("disabled", true);
		        this.mailResultsButton.set("disabled",true);
		        this.outputPDFButton.set("disabled", true);
		        this.outputRTFButton.set("disabled", true);
		        this.openResultsInNewBrowserTabButton.set("disabled", true);
		    }
		    this.logSaveButton.set("disabled", false);
		    this.logSaveAsButton.set("disabled", false);
		    this.logPrintButton.set("disabled", false);
		    this.openlogBrowserTabButton.set("disabled",false);
		},

		updateLog: function(logChunk, render, endOfLog)
		{

			
			var tabWidget = this.getTabWidget();

			if (tabWidget.iconNode.getAttribute("class").indexOf("sasSubmittedStatusIcon") > -1)
				this.setTabBusyIcon();

			/**
			 * If we aren't rendering this go around, add to the log fragments we haven't rendered yet.
			 */

			if (!render)
			{
				if (!this.logFragment)
					this.logFragment=logChunk;
				else
					this.logFragment+=logChunk;
				return;
			}

			/**
			 * We are rendering ... Make sure we add the latest chunk to any existing fragments.
			 */

			else
			{
				if (this.logFragment)
					this.logFragment+=logChunk;
			}

			/**
			 * On the very first time around let the control render the content to get the internal
			 * DOM setup on the content pane.
			 */

			if (this.logAreaContentPane.domNode.children.length==0)
			{
				logChunk=logChunk.replaceAll("<meta","<div {'style':display:none;height:0px'}");
				logChunk=logChunk.replaceAll("</meta>","</div>");
				logChunk=logChunk.replaceAll("<link","<div {'style':display:none;height:0px'}");
				logChunk=logChunk.replaceAll("</link>","</div>");
				logChunk=logChunk.replaceAll("<title>","<div {'style':display:none;height:0px'}");
				logChunk=logChunk.replaceAll("</title>","</div>");
				this.logAreaContentPane.set("content", logChunk);
				this.selectTab(this.logContentPane);
				var addTimeStamp = true;
				if (appDMS.optionPreferencesEditor.appendLog){
	            	if (appDMS.optionPreferencesEditor.typeSelection === "Program and Task"){
	            		addTimeStamp = true;
	            	} else if (appDMS.optionPreferencesEditor.typeSelection === "Program only" && typeof (this.taskMode) !== 'undefined' && this.taskMode){
	            		addTimeStamp = false;
	            	} else if (appDMS.optionPreferencesEditor.typeSelection === "Task only" && typeof (this.taskMode) === 'undefined'){
	            		addTimeStamp = false;
	            	}
	            } 
				if (appDMS.optionPreferencesEditor.appendLog && addTimeStamp){
					pre=this.logAreaContentPane.domNode.getElementsByTagName("pre")[0];
					var startTime=new Date();
				    startTime=dojo.date.locale.format(startTime,{formatLength:'medium'} );
				    startTime=startTime.substr(0,startTime.lastIndexOf(","))+startTime.substr(startTime.lastIndexOf(",")+1,startTime.length);
				    var tsId1 = "timeStampDiv_"+generateID();
				    var timeStampDiv = domConstruct.create('div', {id:tsId1,"class":'logTimeStampHeader logTimeStampHeaderFirst'},pre);
				    timeStampDiv.innerText=this.resourceBundle.submissionTimestamp+ startTime;
				    var eventHandle1 = dojo.connect(dojo.byId(tsId1), 'onclick', null,lang.hitch(this,this.onTimeStampHeaderSelected,this,tsId1));
				}
				
			}
			
			/**
			 * After the initial setup render, find the <pre> tag, there should only be one,
			 * dynamically create new DOM elements and append to the <pre> element. That way the
			 * browser is only working on rendering the updates, not the entire log payload.
			 */

			else
			{
				logChunk=logChunk.replaceAll("<meta","<div {'style':display:none;height:0px'}");
				logChunk=logChunk.replaceAll("</meta>","</div>");
				logChunk=logChunk.replaceAll("<link","<div {'style':display:none;height:0px'}");
				logChunk=logChunk.replaceAll("</link>","</div>");
				logChunk=logChunk.replaceAll("<title>","<div {'style':display:none;height:0px'}");
				logChunk=logChunk.replaceAll("</title>","</div>");
				
				pre=this.logAreaContentPane.domNode.getElementsByTagName("pre")[0];
				
				var addTimeStamp = true;
				if (appDMS.optionPreferencesEditor.appendLog){
	            	if (appDMS.optionPreferencesEditor.typeSelection === "Program and Task"){
	            		addTimeStamp = true;
	            	} else if (appDMS.optionPreferencesEditor.typeSelection === "Program only" && typeof (this.taskMode) !== 'undefined' && this.taskMode){
	            		addTimeStamp = false;
	            	} else if (appDMS.optionPreferencesEditor.typeSelection === "Task only" && typeof (this.taskMode) === 'undefined'){
	            		addTimeStamp = false;
	            	}
	            } 
				
				if (appDMS.optionPreferencesEditor.appendLog && addTimeStamp){
					if (logChunk.indexOf("<!DOCTYPE HTML>") == 0) {
						var startTime=new Date();
					    startTime=dojo.date.locale.format(startTime,{formatLength:'medium'} );
					    startTime=startTime.substr(0,startTime.lastIndexOf(","))+startTime.substr(startTime.lastIndexOf(",")+1,startTime.length);
					    var tsId = "timeStampDiv_"+generateID();
					    var timeStampDiv = domConstruct.create('div', {id:tsId,"class":'logTimeStampHeader'},pre);
					    timeStampDiv.innerText=this.resourceBundle.submissionTimestamp+ startTime;
					    var eventHandle2 = dojo.connect(dojo.byId(tsId), 'onclick', null,lang.hitch(this,this.onTimeStampHeaderSelected,this,tsId));
					}
				}

				/** Create a dummy div that will convert the log fragments into DOM nodes, optimally
				 * document.createDocumentFragment() could be used, by it's behaviour is browser specific.
				 */

				div=domConstruct.create('div', {}, pre);
				var preCollection = this.logAreaContentPane.domNode.getElementsByTagName("pre");
				var updatedStyle="display: none";
				for (var i=1;i<preCollection.length; i++){ //skip the first one
					preCollection[i].setAttribute("style",updatedStyle);
				}
				
				var logToRender=logChunk;
				if (this.logFragment)
				{
					logToRender=this.logFragment;
					this.logFragment=null;
				}

				/**
				 * This implicitly triggers the DOM rendering .... this is the most expensive operation in the
				 * entire dynamic log processing. We are rendering in chunks now, which greatly reduces the time.
				 * The one difference between this methodology is that there are <div> tags between log fragments,
				 * they don't get rendered.
				 */

				div.innerHTML=logToRender;
			}

			try
			{
			    this.logAreaContentPane.domNode.scrollTop = this.logAreaContentPane.domNode.scrollHeight;
			    this.logAreaContentPane.resize();
			}
			catch(ex)
			{
				console.warn("Scrolling of the streaming log failed.");
			}

			/**
			 * Update the log tree, which implicitly updates the tab icon and other state information.
			 */

    		if (endOfLog)
    		{
    			this.removeTabBusyIcon();
    		}






			this.updateLogTree();
		//	this.selectTab(this.logContentPane);
		},


		selectTab: function(tab)
		{
			// 2015-03-32 sasjkx S1168067 in report mode allow output (and data)
			//	tabs to be shown.  For report mode, we wish to block log and
			//	code editor.
			if ((typeof reportApp !== 'undefined') && reportApp && tab &&
				(typeof tab.type === 'string') &&
				((tab.type === 'editor') || (tab.type === 'log')))
			{
				return;
			}
		    var index = this.sasSuiteTabContainer.getIndexOfChild(tab);
			if(index > -1)
				this.sasSuiteTabContainer.selectChild(tab);
			else{
				if(this.rightTabs && this.rightTabs.getIndexOfChild(tab) > -1)
					this.rightTabs.selectChild(tab);
				else if(this.bottomTabs && this.bottomTabs.getIndexOfChild(tab) > -1)
					this.bottomTabs.selectChild(tab);
			}
		},
		onTabSelect: function(tab)
		{
			this.selectedTab = tab;
			this.editorActive = false;

//			if (tab.id===this.outputContentPane.id)
//			{
//				this.outputAreaContentPane.domNode.scrollTop=tab.domNode.scrollHeight;
//			}
//			else if (tab.id===this.logContentPane.id)
//			{
//				this.logAreaContentPane.domNode.scrollTop=tab.domNode.scrollHeight;
//			}
			
			if (appDMS.optionPreferencesEditor.appendLog && tab.id===this.logContentPane.id && typeof (this.taskMode) === "undefined")
				this.logAreaContentPane.domNode.scrollTop=100000;

			if (tab.id===this.editContentPane.id)
			{
				this.onResize();
				this.editor.activate();
				this.editorActive = true;
			}
			if (tab.type == "data")
				this.dataView.adjustHeader();

			this.onTabChanged();
		},

		onTabChanged: function () {
		},

		doPrintActive: function()
		{
		    if (this.selectedTab.id == this.editContentPane.id) {
		        this.onPrintCode();
		        return true;
		    } else if (this.selectedTab.id == this.logContentPane.id) {
		        this.onLogPrint();
		        return true;
		    } else if (this.selectedTab.id == this.outputContentPane.id) {
		        this.onOutputPrint();
		        return true;
		    }
		    return false;
		},
		doSaveActive: function(closeAfterSave)
		{
			if (this.isVirgin())
				this.saveFileAs(false);
			else
				this.saveFile();
		},
		doSelectAllActive: function()
		{
			if (this.selectedTab.id == this.editContentPane.id)
				this.selectAll();
			else if (this.selectedTab.id == this.logContentPane.id)
				fnSelect(this.logAreaContentPane.domNode.id);
			else if (this.selectedTab.id == this.outputContentPane.id)
				fnSelect(this.outputAreaContentPane.domNode.id);

		},

		isResultTabActive: function () {
		    return (this.selectedTab.id == this.outputContentPane.id);
		},

		isLogTabActive: function () {
		    return (this.selectedTab.id == this.logContentPane.id);
		},

		isCodeTabActive: function () {
		    return (this.selectedTab.id == this.editContentPane.id);
		},

		onSavePDF: function()
		{
			if (this.pdfURL!=null)
			{
				if (this.iframe==null)
				{
					this.iframe = document.createElement("iframe");
					this.iframe.setAttribute('style', 'visibility:hidden');
					dojo.body().appendChild(this.iframe);
				}
				var name = this.name.replace(".sas","") + "-" + this.resourceBundle.resultsFile + ".pdf";
				var ename = encodeValue(name);
				this.iframe.src=encodeDoubleSlashesInURL(this.pdfURL + "?download=true&filename=" + ename);
			}
		},

		onSaveRTF: function()
		{
			if (this.rtfURL!=null)
			{
				if (this.iframe==null)
				{
					this.iframe = document.createElement("iframe");
					this.iframe.setAttribute('style', 'visibility:hidden');
					dojo.body().appendChild(this.iframe);
				}
				var name = this.name.replace(".sas","") + "-" + this.resourceBundle.resultsFile + ".rtf";
				var ename = encodeValue(name);
				this.iframe.src=encodeDoubleSlashesInURL(this.rtfURL + "?download=true&filename=" + ename);
			}
		},

		onMaxView: function(event)
		{
			this.appDMS.onMaxView();
		},

		resetSessionId: function(id)
        {
           this.sessionId=id;
		   if (this.taskArea){
				this.taskArea.resetSessionId(id);
		   }
           this.logURL=null;
           this.resultsURL=null;
           this.setButtonStates();
           this.logSaveAsButton.set("disabled",true);
           this.logSaveButton.set("disabled",true);
           this.logPrintButton.set("disabled",true);
           this.openlogBrowserTabButton.set("disabled",true);
           this.outputSaveButton.set("disabled",true);
           this.outputPrintButton.set("disabled",true);
           this.outputPDFButton.set("disabled",true);
           this.outputRTFButton.set("disabled",true);
           this.outputDataButton.set("disabled",true);
           this.mailResultsButton.set("disabled",true);
        },
		insertListener: function(event){
			if (event.animationName == "nodeInserted")
			{
				if (this.editorDiv && event.target.id == this.editorDiv.id)
				{
					this.createCodeEditor();
				}
			}
		},
		setTaskMode: function(taskMode)
		{
			this.taskMode=taskMode;
			this.setButtonStates();

			if (taskMode==false && this.editButton)
			{
				this.editButton.set("style","display:none");
			}
			else if (this.editButton && taskMode)
			{
				this.editButton.set("style","display:inline");
			}


		},
		updateToolbarStates: function(/* boolean */flag)
		{
		   this.logURL=null;
           this.resultsURL=null;

			if (flag)
			{
				this.connected = true;
				this.editorContentChanged = true;
				this.setButtonStates();
			}
			else
			{
  			   this.connected = false;
	           this.setButtonStates();
	           this.logSaveAsButton.set("disabled",true);
	           this.logSaveButton.set("disabled",true);
	           this.logPrintButton.set("disabled",true);
	           this.openlogBrowserTabButton.set("disabled",true);
	           this.outputSaveButton.set("disabled",true);
	           this.outputPrintButton.set("disabled",true);
	           this.outputPDFButton.set("disabled",true);
	           this.outputRTFButton.set("disabled",true);
	           this.outputDataButton.set("disabled",true);
	           this.mailResultsButton.set("disabled",true);
			}
		},

		editorIsVisible: function()
		{
			var parent=this.editContentPane.getParent();
		    return(parent!=this.hiddenTabContainer);
		},

		logIsVisible: function()
		{
			var parent=this.logContentPane.getParent();
		    return(parent!=this.hiddenTabContainer);
		},
		// refactored version of setLog|EditorVisible - they were both doing the exact same thing, just
		// on different panes, so I added a "key" field to represent either 'logContentPane' or 'editContentPane'
		// users should use the constants DMSEditor.LOG and DMSEditor.EDITOR
		setPanelVisible: function(key, visible)
		{
			if (reportApp && visible && ((key == this.LOG) || (key == this.EDITOR))) {
				visible = false;
			}

			var parent = this[key].getParent();
			// make the panel represented by the key visible
			if (visible){
				if (parent!=this.hiddenTabContainer) return;  /* Not in the hidden container - already visible */
				this.hiddenTabContainer.removeChild(this[key]);
				if (key === this.LOG){
					// get right logIndex so log is always added between 'code' and 'results'
					this[key].posIndex = this.getLogIndex();
				} else if (key === this.EDITOR) {
					// force 'code' to be the first tab
					this[key].posIndex = 0;
				}
				if (this[key].oldParent && this[key].oldParent.domNode != null){
					this[key].oldParent.addChild(this[key], this[key].posIndex);
					this[key].oldParent.selectChild(this[key]);
					this[key].oldParent = null;
				} else {
					this.sasSuiteTabContainer.addChild(this[key],this[key].posIndex);
					this.sasSuiteTabContainer.selectChild(this[key]);
					this[key].oldParent=null;
				}
			} else {
				// make the tab invisible and put it in the hidden container.
				if (parent==this.hiddenTabContainer) return;  /* In the hidden container - already invisible */
				this[key].oldParent=parent;
				parent.removeChild(this[key]);

				// this tab was the only thing in the current container, so we need to remove it
				if (parent.hasChildren()==false)
				{
					this[key].oldParent=this.sasSuiteTabContainer;

					if (parent!=this.sasSuiteTabContainer)
					{
						parent.getParent().removeChild(parent);
					}

					if (this.bottomTabs==parent)
					{
						if(this.bottomTabs._splitterWidget)
							this.bottomTabs._splitterWidget.destroy();
						this.bottomTabs.destroy();
						this.bottomTabs=null;
					}
					if (this.rightTabs==parent)
					{
						if(this.rightTabs._splitterWidget)
							this.rightTabs._splitterWidget.destroy();
						this.rightTabs.destroy();
						this.rightTabs=null;
					}

					/**
					 * What a pickle ... we are removing the tab and it's the only thing
					 * currently displayed in the main tab suite. In this scenario, let's basically
					 * do a reset and put things back in the main tab suite.
					 */

					if (this.sasSuiteTabContainer==parent || this.sasSuiteTabContainer.region !="center")
					{

						var sasSuiteParent = this.sasSuiteTabContainer.getParent(),
							swapKey = '';
						sasSuiteParent.removeChild(this.sasSuiteTabContainer);
						this.sasSuiteTabContainer.region="center";
						sasSuiteParent.addChild(this.sasSuiteTabContainer);
						if (key === this.LOG){
							swapKey = this.EDITOR;
						} else if (key === this.EDITOR){
							swapKey = this.LOG;
						}

						var p2=this[swapKey].getParent();
						if (p2!=this.hiddenTabContainer)
						{
							this[swapKey].getParent().removeChild(this[swapKey]);
							this[swapKey].posIndex=0;
							this.sasSuiteTabContainer.addChild(this[swapKey],this[swapKey].posIndex);
						}

						var p3=this.outputContentPane.getParent();
						this.outputContentPane.getParent().removeChild(this.outputContentPane);
						this.sasSuiteTabContainer.addChild(this.outputContentPane);

						if (p2!=p3)
						{
							if (p2!==this.hiddenTabContainer && p2 !==this.sasSuiteTabContainer) p2.getParent().removeChild(p2);
							if (p3!==this.hiddenTabContainer && p3 !==this.sasSuiteTabContainer) p3.getParent().removeChild(p3);
						}
						else
						{
							p2.getParent().removeChild(p2);
						}

						if (this.bottomTabs)
						{
							this.bottomTabs.destroy();
							this.bottomTabs=null;
						}

						if (this.rightTabs)
						{
							this.rightTabs.destroy();
							this.rightTabs=null;
						}
						this.resetsasSuiteTab();//this is to make sure that the sassuitetabcontainer's width get's set to 100% and also it's children gets the full width.
					}
					else
					{
						parent.destroy();
					}
					if (this.dndBC)
						this.destroydndBC('log');//this is to move the remaining children of dndBC to sassuitetabcontainer and then to destory dndBC

					setTimeout(dojo.hitch(this,this.onResize),10);
				}
				this.hiddenTabContainer.addChild(this[key]);

			}

		},

		destroydndBC: function(type){
			var parentPane;
			if (this.dndBC.getChildren().length === 1){
				this.editContentPane.posIndex=0;
				this.logContentPane.posIndex = this.getLogIndex();

				if (this.dndBC.getIndexOfChild(this.sasSuiteTabContainer) != -1){
					this.sasSuiteTabContainer.getParent().removeChild(this.sasSuiteTabContainer);
					this.dndBC.getParent().addChild(this.sasSuiteTabContainer);
				} else{
					dndBCChild=this.dndBC.getChildren();
					parentPane=this.outputContentPane.getParent();
					if (parentPane == dndBCChild[0])
						this.sasSuiteTabContainer.addChild(this.outputContentPane);

					if (type=="log"){
						parentPane=this.editContentPane.getParent();
						if (parentPane == dndBCChild[0]){
							this.sasSuiteTabContainer.addChild(this.editContentPane,this.editContentPane.posIndex);
						}
					}

					if (type=="code"){
						parentPane = this.logContentPane.getParent();
						if (parentPane == dndBCChild[0]){
							this.sasSuiteTabContainer.addChild(this.logContentPane,this.logContentPane.posIndex);
						}
					}
					this.dndBC.removeChild(dndBCChild[0]);

				}

				if (this.dndBC._splitterWidget){
						this.dndBC._splitterWidget.destroy();
				}
				this.dndBC.destroy();
				this.dndBC = null;

				this.resetsasSuiteTab();

				if (this.bottomTabs){
					if (this.bottomTabs.hasChildren()){
						bottomTabChildren = this.bottomTabs.getChildren();
						for (var i=0;i<bottomTabChildren.length; i++){
							this.bottomTabs.removeChild(bottomTabChildren[i]);
							this.sasSuiteTabContainer.addChild(bottomTabChildren[i]);
						}
					}
					if(this.bottomTabs._splitterWidget){
						this.bottomTabs._splitterWidget.destroy();
					}
					this.bottomTabs.destroy();
					this.bottomTabs=null;
				}

				if (this.rightTabs){
					if (this.rightTabs.hasChildren()){
						rightTabChildren = this.rightTabs.getChildren();
						for (var i=0;i<rightTabChildren.length; i++){
							this.rightTabs.removeChild(rightTabChildren[i]);
							this.sasSuiteTabContainer.addChild(rightTabChildren[i]);

						}
					}
					if(this.rightTabs._splitterWidget){
						this.rightTabs._splitterWidget.destroy();
					}
					this.rightTabs.destroy();
					this.rightTabs=null;
				}
			} else{
				if (this.dndBC.getChildren().length === 0){
					if(this.dndBC._splitterWidget){
						this.dndBC._splitterWidget.destroy();
					}
					this.dndBC.destroy();
					this.dndBC = null;
				}
			}
		},

	getLogIndex: function(){

			var outputIndex=this.outputContentPane.getParent().getIndexOfChild(this.outputContentPane);
			var editIndex=this.sasSuiteTabContainer.getIndexOfChild(this.editContentPane);
			var logIndex;
			if (outputIndex == 0)
				logIndex = 0;
			if (editIndex == 0)
				logIndex = 1;

			return logIndex;


	},

		resetsasSuiteTab: function(){

				if (this.sasSuiteTabContainer._splitterWidget)
					this.sasSuiteTabContainer._splitterWidget.destroy();

				dojo.setStyle(this.sasSuiteTabContainer.domNode, "width", "100%");
				this.sasSuiteTabContainer.resize();

				sasSuiteTabChildren= this.sasSuiteTabContainer.getChildren();
				for (var i=0;i<sasSuiteTabChildren.length; i++)
				{
					this.sasSuiteTabContainer.removeChild(sasSuiteTabChildren[i]);
					this.sasSuiteTabContainer.addChild(sasSuiteTabChildren[i]);

				}


		},
		setTaskArea: function(taskArea)
		{
			this.autoSaveAllowed = false;
			this.taskArea = taskArea;

			if(this.outputToolbar)
				domClass.add(this.outputToolbar.domNode, "taskRuntimeEditorToolbar");
			if(this.logToolbar)
				domClass.add(this.logToolbar.domNode, 'taskRuntimeEditorToolbar');
			if(this.editToolbar)
				domClass.add(this.editToolbar.domNode, "taskRuntimeEditorToolbar");


			this.logToolbar.removeChild(this.logMaxViewButton);

				// for now, clear the autosave timeout, since we're not autosaving tasks just yet
			clearInterval(this.autoSaveTimeout);

		},

		get saveable(){
		 return this._saveable;
		},
		set saveable(/* bool */ flag){
			this._saveable = flag;
			if (!flag){
				this.saveButton.set('disabled', true);
			}
			else{
				this.saveButton.set('disabled', false);
			}
		},

		getPackage: function()
		{
			var payload=new Object();
			payload.code=this.editor.getText();
			payload.log=this.logAreaContentPane.get("content");
			payload.results=this.outputAreaContentPane.get("content");
			payload.version=1.0;
			payload.id="<none>";
			if (this.saspkgId)
				payload.id=this.saspkgId;
			if (this.currentSubmission)
			{
				payload.id=this.currentSubmission.id;
			}
			payload.summary=this.getSummaryObject();
			return JSON.stringify(payload);
		},

		getSummaryObject: function()
		{
			if (this.currentSubmission)
			{
				var summary=new Object();
				summary.submissionServer=sasHost;
				summary.id=this.currentSubmission.id;
				summary.submissionMode=this.currentSubmission.mode;
				summary.submissionMacros=this.currentSubmission.macros;
				summary.pdfEnabled=this.currentSubmission.pdfEnabled;
				summary.rtfEnabled=this.currentSubmission.rtfEnabled;
				summary.author=userId;
				summary.browser=userAgent;
				summary.sasVersion=sasVersion;
				summary.sasOS=sasOS;
				summary.browserHost=sasWebClient;
				summary.webAppHost=sasWebHost;
				summary.locale=initLocale;
				var locale = initLocale.replaceAll('_','-');
					locale = locale.replaceAll('-XX',"");
				summary.submissionTime=this.currentSubmission.date.toLocaleString(locale);

				return summary;
			}
			else if (this.packageSummary)
			{
				return this.packageSummary;
			}
		},

		setPackage: function(data)
		{
			try
			{
				var payload=JSON.parse(data);
				if (this.editor)
					this.editor.setText(payload.code);
				else
					this.editorContent=payload.code;
				this.logAreaContentPane.set("content",payload.log);
				this.outputAreaContentPane.set("content",payload.results);
				if (payload.id != "<none>")
				{
					dojo.addClass(this.outputAreaContentPane.domNode,"ods_" + payload.id);
					this.saspkgId=payload.id;
				}

				var logCB=function()
				{
					this.updateLogTree(payload.log);
					this.updateTabIcon(payload.log);
					this.logAreaContentPane.domNode.scrollTop=this.logAreaContentPane.domNode.scrollHeight;
				}

				setTimeout(lang.hitch(this,logCB),100);

				if (payload.log.indexOf('sasError') > -1)
				{
					this.selectTab(this.logContentPane);
				}
				else
				{
					this.selectTab(this.outputContentPane);
				}

				if (payload.summary)
				{
					this.packageSummary=payload.summary;
				}

			}
			catch(e)
			{
				this.editorContent="";
				dojoAlert(this.resourceBundle.badPackage,e.toString());
			}
		},

		commonSaveAs: function(targetObject, /*String*/projectPath, /*String*/name, /*Function*/replaceFunc, /*[]*/args)
		{
	//		var destinationType = targetObject.type;
			if(projectPath && projectPath.indexOf("MyTasks")==0){
				projectPath=projectPath.replace("MyTasks", appDMS.session.studioDataDirectory+"/tasks");
			}
			//this is commented for - S1117546
//			if(this.uri == projectPath+"/"+name) {
//				this.saveFile();
//				if(appDMS.dialogs.saveAsDialog)
//					appDMS.dialogs.saveAsDialog.hide();
//				return;
//			}

			var alreadyPresent = appDMS.fileExists(targetObject, projectPath, name);
			// the file with same name is already present. ask user
			// if he wants to replace
			if(alreadyPresent)
			{
				var confirmCB=function()
				{
					alreadyPresent=false;
					replaceFunc.apply(this, args);
					this.saveAsConfirmDialog.hide();
				};

				var cancelCB=function()
				{
					this.saveAsConfirmDialog.hide();
				};

				var question=this.resourceBundle.fileNameAlreadyExists.replace("${0}", name);
				this.saveAsConfirmDialog=appDMS.dialogs.postDecisionDialog(question, null,
						{label:this.resourceBundle.replace,
						callback:lang.hitch(this,confirmCB),
						primary:true},
						{label:this.resourceBundle.cancel,
						callback:lang.hitch(this,cancelCB)});

				this.saveAsConfirmDialog.set("autofocus",false);
			}
			else
			{
				replaceFunc.apply(this, args);
			}

		},

		onSummarizeCode: function(event)
		{
			this.pw=window.open();
			var html=this.generateSummary();
			this.pw.document.write(html);
			this.pw.document.close();
		},
        getStyleSheet: function(styleSheetName){
            var style=null;
            var styleSheets = document.styleSheets, href = "",len = styleSheets.length;
		     for (var i = 0; i < len; i++)
            {
            	if (styleSheets[i].href==null) continue;
                href = styleSheets[i].href.split('/');
                if (href[href.length - 1] === styleSheetName)
                {
                    style=styleSheets[i].href;
                }
            }
            return style;
        },
		generateSummary: function()
		{
            var style = this.getStyleSheet('sce.css');
/*
			dojo.xhrGet({
				preventCache: false,
				url: url,
				sync: true,
				handleAs: "text",
				load:  lang.hitch(this, function (data, args)
						{
					style=data;
						}),
						error: lang.hitch(this, function (err, args)
								{
								})
			});
*/
			var label=this.name;
			if (label==null || label.length==0)
				label=this.resourceBundle.untitled;
			var title=this.resourceBundle.summaryTitle.replace("${0}",label);

			var html="<html>\n";
			html+="<meta charset=\"UTF-8\">\n";
			html+="<style>\n";
			html+="body { \n";
			html+="font-family: 'Lato', sans-serif !important;\n";
			html+="font-size: 14px!important;\n";
			html+="color: #353535;\n";
			html+="background-color: #f0f1f2;\n";
			html+="background: #f0f1f2;\n";
			html+="}\n";
			html+="</style>\n";

			html+="<title>\n";
            html += appDMS.encodeHtml(title);
			html+="\n</title>\n";
			html+="<body>\n";
			html+="<center>\n<h3>\n";
            html += appDMS.encodeHtml(title);
			html+="</center>\n";
			html+="<p><hr>\n";
			html+="<h3>" + this.resourceBundle.summaryExecutionHeading + "</h3>\n";
			var summary=this.getSummaryObject();
			if ((typeof this.uri === 'undefined') || this.uri === null || this.uri === "")
				this.uri="";
			if (summary)
			{
				html+="<table border=0>\n";
				html+="<tr>";
				html+="<td nowrap>" + this.resourceBundle.summaryAuthor + "</td>";
                html += "<td nowrap>" + appDMS.encodeHtml(summary.author) + "</td>";
				html+="</tr>";
				html+="<tr>";
				html+="<td nowrap>" + this.resourceBundle.summaryFile + "</td>";
				if (this.uri !== this.resourceBundle.undefinedLabel)
				{
					var uri = this.uri;
					try  //S1268434 in case already decoded and name contains a %
					{
						uri = decodeURI(uri);
					}
					catch(e)
					{
						//ignore malformed uri error caused by trying to 
						//decode name containing % that is already decoded
					}
                    if (this.storageType == "ftprefs") {
                        uri = convertEncodedPath(uri, "FTP");
                    }
                    html += "<td nowrap>" + appDMS.encodeHtml(uri) + "</td>";
				}
				html+="</tr>";
				html+="<tr>";
				html+="<td nowrap>" + this.resourceBundle.summaryPlatform + "</td>";
                html += "<td nowrap>" + appDMS.encodeHtml(summary.sasOS) + "</td>";
				html+="</tr>";
				html+="<tr>";
				html+="<td nowrap>" + this.resourceBundle.summaryHost + "</td>";
                html += "<td nowrap>" + appDMS.encodeHtml(summary.submissionServer) + "</td>";
				html+="</tr>";
				html+="<tr>";
				html+="<td nowrap>" + this.resourceBundle.summaryVersion + "</td>";
                html += "<td nowrap>" + appDMS.encodeHtml(summary.sasVersion) + "</td>";
				html+="</tr>";
				html+="<tr>";
				html+="<td nowrap>" + this.resourceBundle.summaryLocale + "</td>";
                html += "<td nowrap>" + appDMS.encodeHtml(summary.locale) + "</td>";
				html+="</tr>";
				html+="<tr>";
				html+="<td nowrap>" + this.resourceBundle.summarySubmitTime + "</td>";
                html += "<td nowrap>" + appDMS.encodeHtml(summary.submissionTime) + "</td>";
				html+="</tr>";
				html+="<tr>";
				html+="<td nowrap>" + this.resourceBundle.summaryBrowserHost + "</td>";
                html += "<td nowrap>" + appDMS.encodeHtml(summary.browserHost) + "</td>";
				html+="</tr>";
				html+="<tr>";
				html+="<td nowrap>" + this.resourceBundle.summaryBrowser + "</td>";
                html += "<td>" + appDMS.encodeHtml(summary.browser) + "</td>";
				html+="</tr>";
				html+="<tr>";
				html+="<td nowrap>" + this.resourceBundle.summaryAppServer + "</td>";
                html += "<td nowrap>" + appDMS.encodeHtml(summary.webAppHost) + "</td>";
				html+="</tr>";
				html+="\n</table>";
			}
			else
				html+= this.resourceBundle.summaryNotAvailable;

			html+="\n</h3></center>\n<p><hr></hr>\n";

			if (style!=null)
			{
				html+='<link media="all" rel="stylesheet" href="' + style + '" />'; //<style>\n" + style + "\n</style>\n";
				html+="<div>\n";
                html += "<h3>" + this.resourceBundle.summaryCodeHeading + appDMS.encodeHtml(label) + "</h3>\n";
				html+=this.editor.getHTML();
				html+="</div>\n";
			}
			else
			{
				html+="<div>\n";
                html += "<h3>" + this.resourceBundle.summaryCodeHeading + appDMS.encodeHtml(label) + "</h3>\n";
                html += appDMS.encodeHtml(this.editor.getText());
				html+="</div>\n";
			}

			html += "<div>\n";
			html+="<hr>";
            html += "<h3>" + this.resourceBundle.summaryLogHeading + appDMS.encodeHtml(label) + "</h3>\n";

			var log=this.logAreaContentPane.get("content");
			var logStyle="<style>\n.sasError{color:red}\n.sasMessage{color:#000}\n.sasWarning{color:#008000}\n.sasSource{color:#000}\n.sasNote{color:#00f}\n</style>";
			var logErrors=this.logModel.store.data[1];
			var logWarnings=this.logModel.store.data[2];
			var logNotes=this.logModel.store.data[3];

			html += logStyle;
			if (log.length > 0)
				{
				if(logErrors.name.indexOf("(") > -1)
					html += "<p>" + logErrors.name + "</p>\n";
				if(logWarnings.name.indexOf("(") > -1)
					html += "<p>" + logWarnings.name + "</p>\n";
				if(logNotes.name.indexOf("(") > -1)
					html += "<p>" + logNotes.name + "</p>\n";
				html += log;
				}
			else
				html += this.resourceBundle.summaryNotAvailable;

			html += "</div>\n";
			html += "<p>\n";
			html+="</div>\n";

			var results=this.outputAreaContentPane.get("content");
			html += "<div>\n";
			html += "<hr>";
            html += "<h3>" + this.resourceBundle.summaryResultsHeading + appDMS.encodeHtml(label) + "</h3>\n";

			id="_none";
			if (summary) id=summary.id;

			html += '<div id="div_' + id + '" class="ods_' + id  + '">';

			if (results.length > 0)
				html += results;
			else
				html+= this.resourceBundle.summaryNotAvailable;

			html += "</div>\n";
			html += "<p>\n";
			html+="</div>\n";

			html+="</body>";
			html+="</html>";

			return html;
		},

		autoSave: function(){
			if (this.editorContentChanged && !this.autoSaved){
				if (debug)
					console.log("need to autosave");
				this.saveFile(null, true);
				this.autoSaved = true;
			}
			else {
				if (debug)
					console.log("don't need to autosave");
			}

		},
		setFinalized: function(/* boolean */ flag){
			this.finalized = flag;
		},

        // function for dataset autocompletion
        // id - can be the name
        getLibList: function(id, callback){
            var url = './sasexec/sessions/' + this.sessionId + '/complete';
            if (id){
                url += "/" + id;
            }
    		dojo.xhrGet({
    				handleAs:"json",
    				preventCache:true,
    				url: url,
    				load: dojo.hitch(this, function(data)
    				{
    					callback(data);
    				}),
    				error: dojo.hitch(this,function(err, args)
    				{
    					callback([]);
    				})
    			});
        },
        
		myTaskOrSnippetifyUri:function(uri){
			if(uri.indexOf(".")==0)
				return "";
			if(uri.indexOf(appDMS.session.studioDataDirectory+"/tasks")!=-1)
				uri=uri.replace(appDMS.session.studioDataDirectory+"/tasks", appDMS.tasks.categoriesResourceBundle.MyTasksKey);
			else if(uri.indexOf(appDMS.session.studioDataDirectory+"/snippets")!=-1)
				uri=uri.replace(appDMS.session.studioDataDirectory+"/snippets", appDMS.templates.resourceBundle.mySnippets);
			return uri;
		},
        
        getDecodedURI:function() {
        	var decodedUri = this.uri;
			if(startsWith(decodedUri, "{SAS001}")){
				var splitArr=decodedUri.split("/");
				var path = splitArr[0];
				path=path.substr(8, path.length);
				path=Base64.decode(path);
				decodedUri=path;
				for(var i=1; i<splitArr.length; i++){
					decodedUri+="/"+splitArr[i];
				}
			}
			return decodedUri;
        },
        generateAutoSaveUrl: function(){
            var autoSaveURL = '';
			var storageType = "workspace";
            var passType = '';
			if (this.projects.destinationTree && this.projects.destinationTree.selectedItem)
			{
				// Save As case - there is a "destinationTree" around
				passType = this.projects.destinationTree.selectedItem.type;
				storageType = passType && passType.indexOf("ftpShortcut") != -1 ? "ftprefs/save" : "workspace";
			}
			else
				// Simple Save case - the type of the file system is remebered in the editor
				storageType = this.storageType == "ftprefs" ? "ftprefs/save" : "workspace";
            
			var targetURI = this.tabObject.uri;
			if (typeof targetURI == "undefined")
				targetURI="";

			// The object has fileShortcutName only if it is a FTP file shortcut selected in the File Shortcuts accordion.
			if(storageType == "ftprefs/save" && this.tabObject.fileShortcutName)
			{
				storageType = "ftpfilerefs/save";
				targetURI = this.tabObject.fileShortcutName;
			}

            // extra step for ftp files
            if (storageType === 'ftprefs/save'){
                autoSaveURL=this.baseURL + '/sasexec/' + this.sessionId + '/ftpShortcuts_file~ps~' + targetURI.replaceAll("/", "~ps~") + '~';

            } else {
                /* Need to set up URL to clean up back up file */
            	if(targetURI)
            		autoSaveURL=this.baseURL + '/sasexec/sessions/' + this.sessionId + '/' + storageType + '/' + encodeValue(targetURI).replaceAll("/", "~ps~") + '~';
            }
            
            return autoSaveURL;
        },
        onTimeStampHeaderSelected: function(evt,id) {
        	var timeStampDiv=dojo.byId(id);
        	var timeStamp=timeStampDiv.innerText;
        	var parts = timeStamp.split(this.resourceBundle.submissionTimestamp);
        	var subTime=parts[1];
        	var submitStack=this.lastSubmitMenu.getChildren();
        	for (i=0; i<submitStack.length; i++){
        		if (submitStack[i].data.time === subTime){
        			appDMS.handleWebOneEvent("NewCodeProgram", submitStack[i].data);
        		}
        	}
        }

	});


	return DMSEditor;
});
