@echo off

REM *** ------------------------------------------------------------------------------
REM *** Copyright (c) 2022 by SAS Institute Inc., Cary, NC USA 27513
REM *** ------------------------------------------------------------------------------
REM *** 
REM *** Handle stopping and uninstalling any existing tc Server service for upgrades.
REM *** 
REM *** ------------------------------------------------------------------------------

set INSTANCE=%1
set ACTION=%2

set ERROR_STATE=0

set CATALINA_BASE=%INSTANCE_LEVEL%\%INSTANCE%

REM Derive the service name from %CATALINA_BASE%
set SERVICE_NAME=%CATALINA_BASE%
set SERVICE_NAME=%SERVICE_NAME:\=-%
set SERVICE_NAME=%SERVICE_NAME:/=-%
set SERVICE_NAME=%SERVICE_NAME: =-%
set SERVICE_NAME=%SERVICE_NAME::=%
set SERVICE_NAME=tcruntime-%SERVICE_NAME%
 
if "%1" == "stop" (
	sc stop %SERVICE_NAME%
	if not %ERRORLEVEL% == 0 ( set ERROR_STATE=1 )
	goto END 
)

if "%1" == "uninstall" (
	sc delete %SERVICE_NAME%
	if not %ERRORLEVEL% == 0 ( set ERROR_STATE=1 )
	goto END 
)

:END
exit /b %ERROR_STATE%
