#!/bin/sh

SRC_DIR=`dirname "$(cd "$(dirname "$0")"; pwd -P)/$(basename "$0")"`
TOMCAT_MAJOR=$(ls ${SRC_DIR} | grep apache-tomcat- | sed 's/.*-\([0-9]*\)\.[0-9]*\.[0-9]*/\1/'| sort -n | tail -1)
TOMCAT_MINOR=$(ls ${SRC_DIR} | grep apache-tomcat-${TOMCAT_MAJOR} | sed 's/.*-[0-9]*\.\([0-9]*\)\.[0-9]*/\1/'| sort -n|tail -1)
TOMCAT_PATCH=$(ls ${SRC_DIR} | grep apache-tomcat-${TOMCAT_MAJOR}.${TOMCAT_MINOR} | sed 's/.*-[0-9]*\.[0-9]*\.\([0-9]*\)/\1/'| sort -n|tail -1)
TOMCAT_DIR="apache-tomcat-${TOMCAT_MAJOR}.${TOMCAT_MINOR}.${TOMCAT_PATCH}"

SRC_DIR=`dirname "$(cd "$(dirname "$0")"; pwd -P)/$(basename "$0")"`


# Show script usage
usage() {
	echo "Create tomcat instance shim"
	echo
	echo "Usage: $script_name [-h] [command] [options] [instance]"
	echo "-h: show this help message"
	echo
	echo 
}

create() {
    echo "Command was $command"
    echo "Force: $force"
    echo "Template: $template"
    echo "Properties file: $propfile"
    echo "Instance directory: $instdir"
    echo "Instance name: $instname"


    echo "Calling $SRC_DIR/$TOMCAT_DIR/bin/makebase.sh $instdir/$instname"
    $SRC_DIR/$TOMCAT_DIR/bin/makebase.sh $instdir/$instname

    #### Create a bin/setenv.sh file and make it executable
    cat <<EOF >$instdir/$instname/bin/setenv.sh
#!/bin/sh
# Edit this file to set custom options
# Tomcat accepts two parameters JAVA_OPTS and CATALINA_OPTS
# JAVA_OPTS are used during START/STOP/RUN
# CATALINA_OPTS are used during START/RUN

CATALINA_HOME=$SRC_DIR/$TOMCAT_DIR
CATALINA_BASE=$instdir/$instname
CATALINA_PID="\$CATALINA_BASE/logs/tcserver.pid"
CATALINA_OUT="\$CATALINA_BASE/logs/catalina.out"
JRE_HOME=$SRC_DIR/../../SASPrivateJavaRuntimeEnvironment/9.4/jre
JAVA_HOME=$SRC_DIR/../../SASPrivateJavaRuntimeEnvironment/9.4/jre
JMX_OPTS="-Dcom.sun.management.jmxremote.port=${base_jmx_port} -Dcom.sun.management.jmxremote.ssl=false -Dcom.sun.management.jmxremote.authenticate=true -Dcom.sun.management.jmxremote.password.file=\$CATALINA_BASE/conf/jmxremote.password -Dcom.sun.management.jmxremote.access.file=\$CATALINA_BASE/conf/jmxremote.access"
CATALINA_OPTS="\$CATALINA_OPTS \$JMX_OPTS"
AGENT_PATHS=""
JAVA_AGENTS=""
JAVA_LIBRARY_PATH=""
JVM_OPTS=""
JAVA_OPTS="\$JVM_OPTS \$AGENT_PATHS \$JAVA_AGENTS \$JAVA_LIBRARY_PATH"
EOF
    chmod +x $instdir/$instname/bin/setenv.sh

    #### Create a bin/tcruntime-ctl.sh file and make it executable
    cat <<EOF >$instdir/$instname/bin/tcruntime-ctl.sh
#!/bin/sh

# ------------------------------------------------------------------------------
# Copyright (c) 2021 by SAS Institute Inc., Cary, NC USA 27513
# ------------------------------------------------------------------------------
#
# Invoke Tomcat's catalina shell script to control the web application server.
#
# ------------------------------------------------------------------------------

SRC_DIR=`dirname "$(cd "$(dirname "\$0")"; pwd -P)/$(basename "\$0")"`
\$SRC_DIR/catalina.sh \$@
exit \$?

EOF
    chmod +x $instdir/$instname/bin/tcruntime-ctl.sh

    # Copy catalina.sh to instance
    cp $SRC_DIR/$TOMCAT_DIR/bin/catalina.sh $instdir/$instname/bin/catalina.sh

    # Replace the default HTTP port with the one we were passed in
    sed "s/8080/${nio_http_port}/g" $instdir/$instname/conf/server.xml > $instdir/$instname/conf/server_temp.xml
    mv $instdir/$instname/conf/server_temp.xml $instdir/$instname/conf/server.xml
    # Replace the default shutdown port with the one we were passed in
    sed "s/8005/${base_shutdown_port}/g" $instdir/$instname/conf/server.xml > $instdir/$instname/conf/server_temp.xml
    mv $instdir/$instname/conf/server_temp.xml $instdir/$instname/conf/server.xml

    # Create a jmxremote.access file
cat <<EOF >$instdir/$instname/conf/jmxremote.access
monitorRole readonly
EOF

    # Create a random jmx password
    chars=0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ
    jmxpass=
    i=0
    while [ $i -lt 32 ]; do
        NMBR="$(od -t u2 -N 2 /dev/random | awk '{ print $2 }' | head -1)"
        wrapped_NMBR=$((NMBR % ${#chars}))
        jmxpass="$jmxpass$(expr substr "$chars" $((wrapped_NMBR + 1)) 1)"
        i=$((i + 1))
    done

    # Create a jmxremote.password file
cat <<EOF >$instdir/$instname/conf/jmxremote.password
monitorRole ${jmxpass}
EOF

    # Make jmxremote.* only rw to the current user
    chmod 600 $instdir/$instname/conf/jmxremote.*
}

# Handle the command (pst, we only know about create)
if [ "$#" -gt 0 ]; then
	if [ "$1" = "-h" ];	then
		# Just show the usage and we are done.
		usage
		exit 0
	elif [ "$1" = "create" ]; then
		# Remember then command to apply.
		command=$1
		# Shift off the recognized command argument
		shift
	else
		echo "Unrecognized command: \"$1\""
		usage
		exit 1
	fi
fi

# Handle options and instance name
while [ "$#" -gt 0 ]
do
	if [ "$1" = "--force" ]; then
        force=1
    	# Shift off the recognized command switch
		shift
    elif [ "$1" = "--template" ]; then
    	# Shift off the recognized command switch
		shift
        # Remember and shift off the template name
        template=$1
        shift
    elif [ "$1" = "--properties-file" ]; then
    	# Shift off the recognized command switch
		shift
        # Remember and shift off the property file
        propfile=$1
        shift
    elif [ "$1" = "--instance-directory" ]; then
    	# Shift off the recognized command argument
		shift
        # Remember and shift off the instance directory
        instdir=$1
        shift
	else
		instname=$1
        shift
	fi
done

#TODO: Verify we have required properties

# Read in values from properties file
while IFS='=' read -r key value
    do
       if test "x$key" != "x" ; then
        key=$(echo $key | tr '.' '_')
        eval ${key}=\${value}
       fi
    done < "$propfile"
    unset IFS

  echo "HTTP port: " ${nio_http_port}
  echo "Shutdown port: " ${base_shutdown_port}
  echo "JMX port: " ${base_jmx_port}

# Create the instance
create