@echo off
setlocal ENABLEDELAYEDEXPANSION
set "ScriptDir=%~dp0"

goto :findtomcat

:findtomcat
    rem find the newest tomcat directory like apache-tomcat-9.0.65
    set tcmajor=0
    set tcminor=0
    set tcpatch=0
    pushd %ScriptDir%
    for /D %%s in ("apache-tomcat-*") do (
        set apacheName=%%~nxs
        rem @echo %%~nxs
        rem extract the major.minor.patch version string
        for /f "tokens=1,2,3 delims=- " %%a in ("%%~nxs") do (
            set fullver=%%c
            rem split apart the major.minor.version
            for /f "tokens=1,2,3 delims=. " %%d in ("%%c") do (
                if %%d GTR !tcmajor! (
                    echo Found newer major %%d.%%e.%%f
                    set tcmajor=%%d
                    set tcminor=%%e
                    set tcpatch=%%f
                ) else (
                    if %%d EQU !tcmajor! (
                        if %%e GTR !tcminor! (
                            echo Found newer minor %%d.%%e.%%f
                            set tcminor=%%e
                            set tcpatch=%%f
                        ) else (
                            if %%e EQU !tcminor! (
                                if %%f GTR !tcpatch! (
                                    echo Found newer patch %%d.%%e.%%f
                                    set tcpatch=%%f
                                )
                            )
                        )
                    )
                )
            )
        )
    )
    set "TomcatDir=apache-tomcat-%tcmajor%.%tcminor%.%tcpatch%"
    if not exist %TomcatDir% echo ERROR: Unable to find tomcat & goto :error
    popd
 
    echo Tomcat directory is: %TomcatDir%

:init
    set "Force="
    set "Template="
    set "PropertiesFile="
    set "InstanceDirectory="
    set "Action="
    set "InstanceName="
    set "NamedFlag="

:parse
    if "%~1"=="" goto :validate

    if /i "%~1"=="--force"                  set "Force=1"               & shift & goto :parse
    if /i "%~1"=="--template"               set "Template=%~2"          & shift & shift & goto :parse
    if /i "%~1"=="--properties-file"        set "PropertiesFile=%~2"    & shift & shift & goto :parse
    if /i "%~1"=="--instance-directory"     set "InstanceDirectory=%~2" & shift & shift & goto :parse

    if not defined Action                   set "Action=%~1"            & shift & goto :parse
    if not defined InstanceName             set "InstanceName=%~1"      & shift & goto :parse

    shift
    goto :parse

:validate
    if not defined Action echo ERROR: action required & goto :error
    if not defined InstanceName echo ERROR: instance name required & goto :error
    if not defined InstanceDirectory echo ERROR: instance directory required & goto :error
    if not defined PropertiesFile echo ERROR: properties file required & goto :error

:main
    echo Action: "%Action%"
    echo InstanceName: "%InstanceName%"
    echo InstanceDirectory: "%InstanceDirectory%"
    echo PropertiesFile: "%PropertiesFile%"
    echo Force: "%Force%"
    echo Template: "%Template%"
    echo ScriptDir: "%ScriptDir%"
    echo TomcatDir: "%TomcatDir%"

    rem NOTE: We are expecting JAVA_HOME to have been set by the caller of this script. There is a --java-home argument, but we didn't use that approach.
    set CATALINA_HOME=%ScriptDir%%TomcatDir%
    set CATALINA_BASE=%InstanceDirectory%\%InstanceName%
    powershell -f "%ScriptDir%tcshim.ps1" -action %Action% -PropertiesFile "%PropertiesFile%" -Debug
    exit /b %ERRORLEVEL%

:error
    exit /b 1