#!/bin/sh

# ------------------------------------------------------------------------------
# Copyright (c) 2021 by SAS Institute Inc., Cary, NC USA 27513
# ------------------------------------------------------------------------------
#
# Invoke Tomcat's catalina shell script to control the web application server.
#
# ------------------------------------------------------------------------------

# Read the instance name
if [ "$#" -gt 0 ]; then
	name=$1
	shift
else
	echo "Invalid sytax."
	exit 1
fi

# Read the command
if [ "$#" -gt 0 ]; then
        command=$1
        shift
else
        echo "Invalid sytax."
        exit 1
fi

# Read the path to the instance
if [ "$#" -gt 1 ]; then
	if [ "$1" = "-n" ]; then
    		# Shift off the recognized command switch
		shift
        	# Remember and shift off the template name
        	instancedir=$1
        	shift
	else
		echo "Invalid syntax."
		exit 1
	fi
else
        echo "Invalid sytax."
        exit 1
fi

if [ "$command" = "status" ]; then
	# tomcat doesn't support a status, so look for the pid file and see if it's running.
	pidfile=$instancedir/$name/logs/tcserver.pid
	if [ -r $pidfile ];	then
		saved_pid=`cat $pidfile`
		
		# this doesn't actually kill the pid, it just checks if it is running.
		if kill -0 $saved_pid >/dev/null 2>&1 ;	then
			echo "Status:                RUNNING as PID=${saved_pid}"
		else
			echo "Status:                NOT RUNNING"
		fi
	else
		echo "Status:                NOT RUNNING"
	fi

elif [ "$command" = "restart" ]; then
	# tomcat doesn't support a restart, so just stop and start, so simulate that.
	$instancedir/$name/bin/catalina.sh stop
	sleep 5
	$instancedir/$name/bin/catalina.sh start
	exit $?
else
	$instancedir/$name/bin/catalina.sh $command
	exit $?
fi

