#!/bin/sh

# uninstall_service.sh
# Used as a wrapper for ant code uninstall_service.xml. 
# This script updates various binaries and config files associated with the Web Application Server.

# The first parameter is SASHome, and it must be set.
if [ -n "$1" ]
  then
    # The second parameter is SASConfig
    if [ -n "$2" ]
      then
        SAS_CONFIG_PARAM="-DSASCONFIG=$2"
    fi
    echo "Searching for SAS delivered JRE"
    privatejre_tmp=`grep -i "PRIVATEJREHOME" $1/sassw.config`
    echo "sassw.config = ${privatejre_tmp}"
    privatejre=`echo ${privatejre_tmp} | cut -c16-`
    echo "privatejre = ${privatejre}"

    echo "Searching for SASDeploymentManager in this SASHome location '$1'"
    deploywizpath=$1/SASDeploymentManager/9.4/products
    deploypath=`find ${deploywizpath} -name 'deploywiz__*' | sort | tail -1`
    numofdeploywizdirs=`find ${deploywizpath} -name 'deploywiz__*' | wc -l`
    echo "number of deploywiz versions = ${numofdeploywizdirs}"
    buildfilepath=uninstall_service.xml
    echo "Using ${deploypath}/deploywiz/ant-launcher.jar to launch ant scripts"
    #execute ant script
    ${privatejre} -jar ${deploypath}/deploywiz/ant-launcher.jar -buildfile ${buildfilepath} -DSASHOME=$1 $SAS_CONFIG_PARAM -DPLAT=UNIX -verbose -debug
  else
    #no params set
    echo "No parameter(SASHOME) was specified. Please try again"
fi