<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="http://www.sas.com/taglib/sas-html" prefix="sas-html"%>

<%
    //added to get around the current x-frame-options being returned
    //without this iframes don't work
    response.setHeader( "X-FRAME-OPTIONS", "SAMEORIGIN" );
%>

<sas-html:Application jsViewClass="sas.admin.Application" applicationId="sas-admin" applicationName="SAS Web Administration Console"
    configFile="config.js" htmlCommonsExternalized="true" applicationSwitcherEnabled="false" themeDecentralized="true">

    <sas-html:config-property name="sas.admin" value="{}" quote="false" />
    <sas-html:config-property name="sas.admin.serverInfo" value="<%= getServerInfo(session) %>" />
    <sas-html:config-property name="sas.admin.jvmVersion" value="<%= getJavaVersion() %>" />
    <sas-html:config-property name="sas.copyrightStartYear" value="2008"/> 
    <sas-html:config-property name="sas.copyrightEndYear" value="2023"/> 

</sas-html:Application>
<%!
    public static String getJavaVersion()
    {
        return System.getProperty("java.version");
    }

    public static String getServerInfo(HttpSession session)
    {
        return session.getServletContext().getServerInfo();
    }
 %>
