sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./AbstractTracker", "sas/ltjs/transport/depot/ReportStatus"], function (require, exports, ltjsEnvironment_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportStatusTracker = ltjsEnvironment_1.createModule([50004, 50222], EventDispatcher_1.default);
    /**
     * @param {Depot| null} depot
     * @param {BaseReport| null} baseReport
     *
     */
    ReportStatusTracker._create = function (depot, baseReport) {
        //-- Convert abstract(transport::Depot) from js(Depot) to jni(size_t)
        var depot_jni = ClosetObject_1.default._getValidClosetAddress(depot);
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var baseReport_jni = ClosetObject_1.default._getValidClosetAddress(baseReport);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportStatusTracker_create(depot_jni, baseReport_jni);
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportStatusTracker)", "static", "new", "(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(depot), "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(baseReport), "-->", "(transport::ReportStatusTracker)", rc);
        return rc;
    };
    /**
     * @return {ReportStatus}
     */
    ReportStatusTracker.prototype.getCurrentValue = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportStatusTracker_getCurrentValue(this._getValidClosetAddress());
        //-- Convert abstract(transport::ReportStatus) from jni(int) to js(ReportStatus)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportStatusTracker)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getCurrentValue", "-->", "(transport::ReportStatus::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    exports.default = ReportStatusTracker;
});
