sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var MapsSettingsAttributes = ltjsEnvironment_1.createModule([114, 13, 50265, 50158], EventDispatcher_1.default);
    /**
     *
     */
    MapsSettingsAttributes._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_MapsSettingsAttributes_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::MapsSettingsAttributes)", "static", "new", "-->", "(transport::MapsSettingsAttributes)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    MapsSettingsAttributes.prototype.getDefaultOSMCommunicationProtocol = function () {
        var defaultOSMCommunicationProtocol_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("defaultOSMCommunicationProtocol");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), defaultOSMCommunicationProtocol_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::MapsSettingsAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#defaultOSMCommunicationProtocol", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    MapsSettingsAttributes.prototype.setDefaultOSMCommunicationProtocol = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var defaultOSMCommunicationProtocol_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("defaultOSMCommunicationProtocol");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, defaultOSMCommunicationProtocol_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::MapsSettingsAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#defaultOSMCommunicationProtocol", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    MapsSettingsAttributes.prototype.getLocalEsriServicesUrl = function () {
        var localEsriServicesUrl_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("localEsriServicesUrl");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), localEsriServicesUrl_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::MapsSettingsAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#localEsriServicesUrl", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    MapsSettingsAttributes.prototype.setLocalEsriServicesUrl = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var localEsriServicesUrl_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("localEsriServicesUrl");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, localEsriServicesUrl_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::MapsSettingsAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#localEsriServicesUrl", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    MapsSettingsAttributes.prototype.getLocalEsriServicesRequiresAuthentication = function () {
        var localEsriServicesRequiresAuthentication_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("localEsriServicesRequiresAuthentication");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), localEsriServicesRequiresAuthentication_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::MapsSettingsAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#localEsriServicesRequiresAuthentication", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    MapsSettingsAttributes.prototype.setLocalEsriServicesRequiresAuthentication = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var localEsriServicesRequiresAuthentication_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("localEsriServicesRequiresAuthentication");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, localEsriServicesRequiresAuthentication_name_jni);
        Module.deps['TraceUtil'].log("(transport::MapsSettingsAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#localEsriServicesRequiresAuthentication", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    MapsSettingsAttributes.prototype.getUseArcGISOnlineMaps = function () {
        var useArcGISOnlineMaps_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("useArcGISOnlineMaps");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), useArcGISOnlineMaps_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::MapsSettingsAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#useArcGISOnlineMaps", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    MapsSettingsAttributes.prototype.setUseArcGISOnlineMaps = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var useArcGISOnlineMaps_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("useArcGISOnlineMaps");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, useArcGISOnlineMaps_name_jni);
        Module.deps['TraceUtil'].log("(transport::MapsSettingsAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#useArcGISOnlineMaps", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    exports.default = MapsSettingsAttributes;
});
