sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./NLUExpression"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var NLUPartition = ltjsEnvironment_1.createModule([114, 13, 50265, 50176], EventDispatcher_1.default);
    /**
     *
     */
    NLUPartition._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_NLUPartition_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUPartition)", "static", "new", "-->", "(transport::NLUPartition)", rc);
        return rc;
    };
    /**
     * @return {number}
     */
    NLUPartition.prototype.getVersion = function () {
        var version_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("version");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), version_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUPartition)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#version", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    NLUPartition.prototype.setVersion = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var version_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("version");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, version_name_jni);
        Module.deps['TraceUtil'].log("(transport::NLUPartition)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#version", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {Array.<NLUExpression| null> | null}
     */
    NLUPartition.prototype.getExpressions = function () {
        var expressions_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("expressions");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), expressions_jni);
        //-- Convert abstract(<transport::NLUExpression>) from jni(size_t) to js(NLUExpression)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUPartition)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#expressions", "-->", "(MONITORED_VECTOR<transport::NLUExpression>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<NLUExpression| null> | null} value
     *
     */
    NLUPartition.prototype.setExpressions = function (value) {
        //-- Convert abstract(<transport::NLUExpression>) from js(NLUExpression) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var expressions_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("expressions");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, expressions_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUPartition)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#expressions", "(MONITORED_VECTOR<transport::NLUExpression>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = NLUPartition;
});
