sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./NLUMatch"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var NLUMatcherMetadataAttributes = ltjsEnvironment_1.createModule([114, 13, 50265, 50175], EventDispatcher_1.default);
    /**
     *
     */
    NLUMatcherMetadataAttributes._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_NLUMatcherMetadataAttributes_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUMatcherMetadataAttributes)", "static", "new", "-->", "(transport::NLUMatcherMetadataAttributes)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    NLUMatcherMetadataAttributes.prototype.getScoreDistribution = function () {
        var scoreDistribution_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("scoreDistribution");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), scoreDistribution_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUMatcherMetadataAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#scoreDistribution", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    NLUMatcherMetadataAttributes.prototype.setScoreDistribution = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var scoreDistribution_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("scoreDistribution");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, scoreDistribution_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUMatcherMetadataAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#scoreDistribution", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    NLUMatcherMetadataAttributes.prototype.getNumberValue = function () {
        var numberValue_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("numberValue");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getDoubleProperty(this._getValidClosetAddress(), numberValue_jni);
        //-- Convert abstract(commons::DOUBLE) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUMatcherMetadataAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#numberValue", "-->", "(commons::DOUBLE)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    NLUMatcherMetadataAttributes.prototype.setNumberValue = function (value) {
        //-- Convert abstract(commons::DOUBLE) from js(number) to jni(double)
        var value_jni = value;
        var numberValue_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("numberValue");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setDoubleProperty(this._getValidClosetAddress(), value_jni, numberValue_name_jni);
        Module.deps['TraceUtil'].log("(transport::NLUMatcherMetadataAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#numberValue", "(commons::DOUBLE)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    NLUMatcherMetadataAttributes.prototype.getNormalizedNumberString = function () {
        var normalizedNumberString_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("normalizedNumberString");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), normalizedNumberString_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUMatcherMetadataAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#normalizedNumberString", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    NLUMatcherMetadataAttributes.prototype.setNormalizedNumberString = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var normalizedNumberString_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("normalizedNumberString");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, normalizedNumberString_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUMatcherMetadataAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#normalizedNumberString", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {Array.<NLUMatch| null> | null}
     */
    NLUMatcherMetadataAttributes.prototype.getMatches = function () {
        var matches_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("matches");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), matches_jni);
        //-- Convert abstract(<transport::NLUMatch>) from jni(size_t) to js(NLUMatch)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUMatcherMetadataAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#matches", "-->", "(MONITORED_VECTOR<transport::NLUMatch>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<NLUMatch| null> | null} value
     *
     */
    NLUMatcherMetadataAttributes.prototype.setMatches = function (value) {
        //-- Convert abstract(<transport::NLUMatch>) from js(NLUMatch) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var matches_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("matches");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, matches_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUMatcherMetadataAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#matches", "(MONITORED_VECTOR<transport::NLUMatch>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = NLUMatcherMetadataAttributes;
});
