sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var NLUMatch = ltjsEnvironment_1.createModule([114, 13, 50265, 50173], EventDispatcher_1.default);
    /**
     *
     */
    NLUMatch._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_NLUMatch_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUMatch)", "static", "new", "-->", "(transport::NLUMatch)", rc);
        return rc;
    };
    /**
     * @return {number}
     */
    NLUMatch.prototype.getScore = function () {
        var score_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("score");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getDoubleProperty(this._getValidClosetAddress(), score_jni);
        //-- Convert abstract(commons::DOUBLE) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUMatch)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#score", "-->", "(commons::DOUBLE)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    NLUMatch.prototype.setScore = function (value) {
        //-- Convert abstract(commons::DOUBLE) from js(number) to jni(double)
        var value_jni = value;
        var score_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("score");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setDoubleProperty(this._getValidClosetAddress(), value_jni, score_name_jni);
        Module.deps['TraceUtil'].log("(transport::NLUMatch)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#score", "(commons::DOUBLE)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    NLUMatch.prototype.getOriginText = function () {
        var originText_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("originText");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), originText_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUMatch)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#originText", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    NLUMatch.prototype.setOriginText = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var originText_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("originText");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, originText_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUMatch)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#originText", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    NLUMatch.prototype.getMatchedText = function () {
        var matchedText_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("matchedText");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), matchedText_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUMatch)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#matchedText", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    NLUMatch.prototype.setMatchedText = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var matchedText_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("matchedText");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, matchedText_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUMatch)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#matchedText", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    exports.default = NLUMatch;
});
