sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/media/MediaType", "./NLUExpression", "./NLUInterpretation", "sas/ltjs/commons/models/particles/Link"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var NLUInterpretationsResponseBody = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50172], EventDispatcher_1.default);
    /**
     *
     */
    NLUInterpretationsResponseBody._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_NLUInterpretationsResponseBody_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", "static", "new", "-->", "(transport::NLUInterpretationsResponseBody)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    NLUInterpretationsResponseBody.prototype.getCreatedBy = function () {
        var createdBy_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("createdBy");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), createdBy_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#createdBy", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    NLUInterpretationsResponseBody.prototype.setCreatedBy = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var createdBy_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("createdBy");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, createdBy_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#createdBy", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    NLUInterpretationsResponseBody.prototype.getCreationTimeStamp = function () {
        var creationTimeStamp_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("creationTimeStamp");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), creationTimeStamp_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#creationTimeStamp", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    NLUInterpretationsResponseBody.prototype.setCreationTimeStamp = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var creationTimeStamp_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("creationTimeStamp");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, creationTimeStamp_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#creationTimeStamp", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    NLUInterpretationsResponseBody.prototype.getId = function () {
        var id_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), id_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    NLUInterpretationsResponseBody.prototype.setId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var id_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, id_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    NLUInterpretationsResponseBody.prototype.getDomainId = function () {
        var domainId_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("domainId");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), domainId_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#domainId", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    NLUInterpretationsResponseBody.prototype.setDomainId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var domainId_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("domainId");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, domainId_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#domainId", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    NLUInterpretationsResponseBody.prototype.getText = function () {
        var text_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("text");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), text_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#text", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    NLUInterpretationsResponseBody.prototype.setText = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var text_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("text");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, text_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#text", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {Array.<NLUExpression| null> | null}
     */
    NLUInterpretationsResponseBody.prototype.getExpressions = function () {
        var expressions_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("expressions");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), expressions_jni);
        //-- Convert abstract(<transport::NLUExpression>) from jni(size_t) to js(NLUExpression)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#expressions", "-->", "(MONITORED_VECTOR<transport::NLUExpression>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<NLUExpression| null> | null} value
     *
     */
    NLUInterpretationsResponseBody.prototype.setExpressions = function (value) {
        //-- Convert abstract(<transport::NLUExpression>) from js(NLUExpression) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var expressions_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("expressions");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, expressions_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#expressions", "(MONITORED_VECTOR<transport::NLUExpression>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {NLUInterpretation| null}
     */
    NLUInterpretationsResponseBody.prototype.getInterpretation = function () {
        var interpretation_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("interpretation");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), interpretation_jni);
        //-- Convert abstract(transport::NLUInterpretation) from jni(size_t) to js(NLUInterpretation)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#interpretation", "-->", "(transport::NLUInterpretation)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {NLUInterpretation| null} value
     *
     */
    NLUInterpretationsResponseBody.prototype.setInterpretation = function (value) {
        //-- Convert abstract(transport::NLUInterpretation) from js(NLUInterpretation) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var interpretation_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("interpretation");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, interpretation_name_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#interpretation", "(transport::NLUInterpretation)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {Array.<NLUInterpretation| null> | null}
     */
    NLUInterpretationsResponseBody.prototype.getAlternatives = function () {
        var alternatives_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("alternatives");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), alternatives_jni);
        //-- Convert abstract(<transport::NLUInterpretation>) from jni(size_t) to js(NLUInterpretation)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#alternatives", "-->", "(MONITORED_VECTOR<transport::NLUInterpretation>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<NLUInterpretation| null> | null} value
     *
     */
    NLUInterpretationsResponseBody.prototype.setAlternatives = function (value) {
        //-- Convert abstract(<transport::NLUInterpretation>) from js(NLUInterpretation) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var alternatives_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("alternatives");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, alternatives_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#alternatives", "(MONITORED_VECTOR<transport::NLUInterpretation>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {Array.<Link| null> | null}
     */
    NLUInterpretationsResponseBody.prototype.getLinks = function () {
        var links_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), links_jni);
        //-- Convert abstract(<commons::Link>) from jni(size_t) to js(Link)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "-->", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<Link| null> | null} value
     *
     */
    NLUInterpretationsResponseBody.prototype.setLinks = function (value) {
        //-- Convert abstract(<commons::Link>) from js(Link) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var links_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, links_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {number}
     */
    NLUInterpretationsResponseBody.prototype.getErrorCode = function () {
        var errorCode_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("errorCode");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), errorCode_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#errorCode", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    NLUInterpretationsResponseBody.prototype.setErrorCode = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var errorCode_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("errorCode");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, errorCode_name_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#errorCode", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    NLUInterpretationsResponseBody.prototype.getHttpStatusCode = function () {
        var httpStatusCode_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("httpStatusCode");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), httpStatusCode_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#httpStatusCode", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    NLUInterpretationsResponseBody.prototype.setHttpStatusCode = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var httpStatusCode_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("httpStatusCode");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, httpStatusCode_name_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#httpStatusCode", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    NLUInterpretationsResponseBody.prototype.getMessage = function () {
        var message_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("message");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), message_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#message", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    NLUInterpretationsResponseBody.prototype.setMessage = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var message_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("message");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, message_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#message", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    NLUInterpretationsResponseBody.prototype.getDetails = function () {
        var details_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("details");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), details_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#details", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    NLUInterpretationsResponseBody.prototype.setDetails = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var details_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("details");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, details_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationsResponseBody)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#details", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    exports.default = NLUInterpretationsResponseBody;
});
