sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./NLUDomainTerm"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var NLUInterpretationNode = ltjsEnvironment_1.createModule([114, 13, 50265, 50170], EventDispatcher_1.default);
    /**
     *
     */
    NLUInterpretationNode._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_NLUInterpretationNode_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationNode)", "static", "new", "-->", "(transport::NLUInterpretationNode)", rc);
        return rc;
    };
    /**
     * @return {number}
     */
    NLUInterpretationNode.prototype.getVersion = function () {
        var version_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("version");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), version_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationNode)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#version", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    NLUInterpretationNode.prototype.setVersion = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var version_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("version");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, version_name_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationNode)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#version", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    NLUInterpretationNode.prototype.getNodeId = function () {
        var nodeId_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("nodeId");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), nodeId_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationNode)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#nodeId", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    NLUInterpretationNode.prototype.setNodeId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var nodeId_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("nodeId");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, nodeId_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationNode)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#nodeId", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    NLUInterpretationNode.prototype.getArgs = function () {
        var args_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("args");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), args_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationNode)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#args", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    NLUInterpretationNode.prototype.setArgs = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var args_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("args");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, args_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationNode)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#args", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {NLUDomainTerm| null}
     */
    NLUInterpretationNode.prototype.getDomainTerm = function () {
        var domainTerm_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("domainTerm");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), domainTerm_jni);
        //-- Convert abstract(transport::NLUDomainTerm) from jni(size_t) to js(NLUDomainTerm)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationNode)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#domainTerm", "-->", "(transport::NLUDomainTerm)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {NLUDomainTerm| null} value
     *
     */
    NLUInterpretationNode.prototype.setDomainTerm = function (value) {
        //-- Convert abstract(transport::NLUDomainTerm) from js(NLUDomainTerm) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var domainTerm_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("domainTerm");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, domainTerm_name_jni);
        Module.deps['TraceUtil'].log("(transport::NLUInterpretationNode)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#domainTerm", "(transport::NLUDomainTerm)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    exports.default = NLUInterpretationNode;
});
