sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./NLUInterpretationNode"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var NLUExpression = ltjsEnvironment_1.createModule([114, 13, 50265, 50168], EventDispatcher_1.default);
    /**
     *
     */
    NLUExpression._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_NLUExpression_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUExpression)", "static", "new", "-->", "(transport::NLUExpression)", rc);
        return rc;
    };
    /**
     * @return {number}
     */
    NLUExpression.prototype.getVersion = function () {
        var version_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("version");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), version_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUExpression)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#version", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    NLUExpression.prototype.setVersion = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var version_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("version");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, version_name_jni);
        Module.deps['TraceUtil'].log("(transport::NLUExpression)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#version", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    NLUExpression.prototype.getRuleName = function () {
        var ruleName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("ruleName");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), ruleName_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUExpression)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#ruleName", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    NLUExpression.prototype.setRuleName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var ruleName_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("ruleName");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, ruleName_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUExpression)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#ruleName", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {Array.<NLUInterpretationNode| null> | null}
     */
    NLUExpression.prototype.getInterpretationNodes = function () {
        var interpretationNodes_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("interpretationNodes");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), interpretationNodes_jni);
        //-- Convert abstract(<transport::NLUInterpretationNode>) from jni(size_t) to js(NLUInterpretationNode)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUExpression)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#interpretationNodes", "-->", "(MONITORED_VECTOR<transport::NLUInterpretationNode>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<NLUInterpretationNode| null> | null} value
     *
     */
    NLUExpression.prototype.setInterpretationNodes = function (value) {
        //-- Convert abstract(<transport::NLUInterpretationNode>) from js(NLUInterpretationNode) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var interpretationNodes_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("interpretationNodes");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, interpretationNodes_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUExpression)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#interpretationNodes", "(MONITORED_VECTOR<transport::NLUInterpretationNode>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = NLUExpression;
});
