sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./NLUMatcherMetadata", "./NLUDataSourceMetadata"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var NLUDomainTerm = ltjsEnvironment_1.createModule([114, 13, 50265, 50167], EventDispatcher_1.default);
    /**
     *
     */
    NLUDomainTerm._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_NLUDomainTerm_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUDomainTerm)", "static", "new", "-->", "(transport::NLUDomainTerm)", rc);
        return rc;
    };
    /**
     * @return {number}
     */
    NLUDomainTerm.prototype.getVersion = function () {
        var version_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("version");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), version_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUDomainTerm)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#version", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    NLUDomainTerm.prototype.setVersion = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var version_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("version");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, version_name_jni);
        Module.deps['TraceUtil'].log("(transport::NLUDomainTerm)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#version", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    NLUDomainTerm.prototype.getScore = function () {
        var score_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("score");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getDoubleProperty(this._getValidClosetAddress(), score_jni);
        //-- Convert abstract(commons::DOUBLE) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::NLUDomainTerm)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#score", "-->", "(commons::DOUBLE)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    NLUDomainTerm.prototype.setScore = function (value) {
        //-- Convert abstract(commons::DOUBLE) from js(number) to jni(double)
        var value_jni = value;
        var score_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("score");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setDoubleProperty(this._getValidClosetAddress(), value_jni, score_name_jni);
        Module.deps['TraceUtil'].log("(transport::NLUDomainTerm)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#score", "(commons::DOUBLE)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    NLUDomainTerm.prototype.getLexeme = function () {
        var lexeme_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lexeme");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), lexeme_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUDomainTerm)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lexeme", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    NLUDomainTerm.prototype.setLexeme = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var lexeme_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lexeme");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, lexeme_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUDomainTerm)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lexeme", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    NLUDomainTerm.prototype.getMatchedInputText = function () {
        var matchedInputText_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("matchedInputText");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), matchedInputText_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUDomainTerm)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#matchedInputText", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    NLUDomainTerm.prototype.setMatchedInputText = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var matchedInputText_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("matchedInputText");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, matchedInputText_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUDomainTerm)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#matchedInputText", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    NLUDomainTerm.prototype.getMatchedDataSourceText = function () {
        var matchedDataSourceText_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("matchedDataSourceText");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), matchedDataSourceText_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUDomainTerm)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#matchedDataSourceText", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    NLUDomainTerm.prototype.setMatchedDataSourceText = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var matchedDataSourceText_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("matchedDataSourceText");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, matchedDataSourceText_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::NLUDomainTerm)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#matchedDataSourceText", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {NLUMatcherMetadata| null}
     */
    NLUDomainTerm.prototype.getMatcherMetadata = function () {
        var matcherMetadata_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("matcherMetadata");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), matcherMetadata_jni);
        //-- Convert abstract(transport::NLUMatcherMetadata) from jni(size_t) to js(NLUMatcherMetadata)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUDomainTerm)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#matcherMetadata", "-->", "(transport::NLUMatcherMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {NLUMatcherMetadata| null} value
     *
     */
    NLUDomainTerm.prototype.setMatcherMetadata = function (value) {
        //-- Convert abstract(transport::NLUMatcherMetadata) from js(NLUMatcherMetadata) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var matcherMetadata_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("matcherMetadata");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, matcherMetadata_name_jni);
        Module.deps['TraceUtil'].log("(transport::NLUDomainTerm)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#matcherMetadata", "(transport::NLUMatcherMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {NLUDataSourceMetadata| null}
     */
    NLUDomainTerm.prototype.getDataSourceMetadata = function () {
        var dataSourceMetadata_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("dataSourceMetadata");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), dataSourceMetadata_jni);
        //-- Convert abstract(transport::NLUDataSourceMetadata) from jni(size_t) to js(NLUDataSourceMetadata)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::NLUDomainTerm)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#dataSourceMetadata", "-->", "(transport::NLUDataSourceMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {NLUDataSourceMetadata| null} value
     *
     */
    NLUDomainTerm.prototype.setDataSourceMetadata = function (value) {
        //-- Convert abstract(transport::NLUDataSourceMetadata) from js(NLUDataSourceMetadata) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var dataSourceMetadata_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("dataSourceMetadata");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, dataSourceMetadata_name_jni);
        Module.deps['TraceUtil'].log("(transport::NLUDomainTerm)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#dataSourceMetadata", "(transport::NLUDataSourceMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    exports.default = NLUDomainTerm;
});
