sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/media/MediaType"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CASColumnItem = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50034], EventDispatcher_1.default);
    /**
     *
     */
    CASColumnItem._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CASColumnItem_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", "static", "new", "-->", "(transport::CASColumnItem)", rc);
        return rc;
    };
    /**
     * @return {number}
     */
    CASColumnItem.prototype.getIndex = function () {
        var index_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("index");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), index_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#index", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    CASColumnItem.prototype.setIndex = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var index_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("index");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, index_name_jni);
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#index", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    CASColumnItem.prototype.getFormat = function () {
        var format_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("format");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), format_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#format", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    CASColumnItem.prototype.setFormat = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var format_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("format");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, format_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#format", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    CASColumnItem.prototype.getFormattedLength = function () {
        var formattedLength_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("formattedLength");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), formattedLength_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#formattedLength", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    CASColumnItem.prototype.setFormattedLength = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var formattedLength_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("formattedLength");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, formattedLength_name_jni);
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#formattedLength", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    CASColumnItem.prototype.getLabel = function () {
        var label_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("label");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), label_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#label", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    CASColumnItem.prototype.setLabel = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var label_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("label");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, label_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#label", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    CASColumnItem.prototype.getName = function () {
        var name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("name");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), name_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#name", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    CASColumnItem.prototype.setName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var name_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("name");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, name_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#name", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    CASColumnItem.prototype.getNumberFormatDecimals = function () {
        var numberFormatDecimals_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("numberFormatDecimals");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), numberFormatDecimals_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#numberFormatDecimals", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    CASColumnItem.prototype.setNumberFormatDecimals = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var numberFormatDecimals_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("numberFormatDecimals");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, numberFormatDecimals_name_jni);
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#numberFormatDecimals", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    CASColumnItem.prototype.getNumberFormatLength = function () {
        var numberFormatLength_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("numberFormatLength");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), numberFormatLength_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#numberFormatLength", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    CASColumnItem.prototype.setNumberFormatLength = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var numberFormatLength_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("numberFormatLength");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, numberFormatLength_name_jni);
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#numberFormatLength", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    CASColumnItem.prototype.getRawLength = function () {
        var rawLength_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("rawLength");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), rawLength_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#rawLength", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    CASColumnItem.prototype.setRawLength = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var rawLength_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("rawLength");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, rawLength_name_jni);
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#rawLength", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    CASColumnItem.prototype.getType = function () {
        var type_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("type");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), type_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#type", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    CASColumnItem.prototype.setType = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var type_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("type");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, type_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#type", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    CASColumnItem.prototype.getIndexed = function () {
        var indexed_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("indexed");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), indexed_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#indexed", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    CASColumnItem.prototype.setIndexed = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var indexed_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("indexed");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, indexed_name_jni);
        Module.deps['TraceUtil'].log("(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#indexed", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    exports.default = CASColumnItem;
});
