sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "./particles/IdResources"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var SelectionById = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50240], EventDispatcher_1.default);
    /**
     *
     */
    SelectionById._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_SelectionById_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::SelectionById)", "static", "new", "-->", "(transport::SelectionById)", rc);
        return rc;
    };
    /**
     * @return {IdResources| null}
     */
    SelectionById.prototype.getResources = function () {
        var resources_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("resources");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), resources_jni);
        //-- Convert abstract(transport::IdResources) from jni(size_t) to js(IdResources)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::SelectionById)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#resources", "-->", "(transport::IdResources)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {IdResources| null} value
     *
     */
    SelectionById.prototype.setResources = function (value) {
        //-- Convert abstract(transport::IdResources) from js(IdResources) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var resources_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("resources");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, resources_name_jni);
        Module.deps['TraceUtil'].log("(transport::SelectionById)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#resources", "(transport::IdResources)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    SelectionById.prototype.getMatchTemplate = function () {
        var matchTemplate_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("matchTemplate");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), matchTemplate_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::SelectionById)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#matchTemplate", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    SelectionById.prototype.setMatchTemplate = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var matchTemplate_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("matchTemplate");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, matchTemplate_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::SelectionById)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#matchTemplate", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    SelectionById.prototype.getType = function () {
        var type_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("type");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), type_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::SelectionById)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#type", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    SelectionById.prototype.setType = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var type_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("type");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, type_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::SelectionById)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#type", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    exports.default = SelectionById;
});
