sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "./ReportMetadata"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var SearchMetadata = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50237], EventDispatcher_1.default);
    /**
     *
     */
    SearchMetadata._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_SearchMetadata_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::SearchMetadata)", "static", "new", "-->", "(transport::SearchMetadata)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    SearchMetadata.prototype.getMatchingFields = function () {
        var matchingFields_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("matchingFields");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), matchingFields_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::SearchMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#matchingFields", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    SearchMetadata.prototype.setMatchingFields = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var matchingFields_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("matchingFields");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, matchingFields_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::SearchMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#matchingFields", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {ReportMetadata| null}
     */
    SearchMetadata.prototype.getReportMetadata = function () {
        var reportMetadata_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportMetadata");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), reportMetadata_jni);
        //-- Convert abstract(transport::ReportMetadata) from jni(size_t) to js(ReportMetadata)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::SearchMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportMetadata", "-->", "(transport::ReportMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {ReportMetadata| null} value
     *
     */
    SearchMetadata.prototype.setReportMetadata = function (value) {
        //-- Convert abstract(transport::ReportMetadata) from js(ReportMetadata) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var reportMetadata_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportMetadata");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, reportMetadata_name_jni);
        Module.deps['TraceUtil'].log("(transport::SearchMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportMetadata", "(transport::ReportMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    exports.default = SearchMetadata;
});
