sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportPackagesConfigProperties = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50215], EventDispatcher_1.default);
    /**
     *
     */
    ReportPackagesConfigProperties._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportPackagesConfigProperties_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportPackagesConfigProperties)", "static", "new", "-->", "(transport::ReportPackagesConfigProperties)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    ReportPackagesConfigProperties.prototype.getServerVersion = function () {
        var serverVersion_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("serverVersion");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), serverVersion_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportPackagesConfigProperties)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#serverVersion", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportPackagesConfigProperties.prototype.setServerVersion = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var serverVersion_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("serverVersion");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, serverVersion_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportPackagesConfigProperties)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#serverVersion", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    exports.default = ReportPackagesConfigProperties;
});
