sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "./particles/MicroserviceJobState", "./particles/ServiceError", "./ReportImageDetail", "sas/ltjs/commons/models/particles/Link"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportImageJob = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50202], EventDispatcher_1.default);
    /**
     *
     */
    ReportImageJob._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportImageJob_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageJob)", "static", "new", "-->", "(transport::ReportImageJob)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    ReportImageJob.prototype.getId = function () {
        var id_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), id_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportImageJob.prototype.setId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var id_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, id_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {MicroserviceJobState}
     */
    ReportImageJob.prototype.getState = function () {
        var state_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("state");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), state_jni);
        //-- Convert abstract(transport::MicroserviceJobState) from jni(int) to js(MicroserviceJobState)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#state", "-->", "(transport::MicroserviceJobState::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {MicroserviceJobState} value
     *
     */
    ReportImageJob.prototype.setState = function (value) {
        //-- Convert abstract(transport::MicroserviceJobState) from js(MicroserviceJobState) to jni(int)
        var value_jni = value;
        var state_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("state");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, state_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#state", "(transport::MicroserviceJobState::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {number}
     */
    ReportImageJob.prototype.getDuration = function () {
        var duration_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("duration");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getFloatProperty(this._getValidClosetAddress(), duration_jni);
        //-- Convert abstract(commons::FLOAT) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#duration", "-->", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ReportImageJob.prototype.setDuration = function (value) {
        //-- Convert abstract(commons::FLOAT) from js(number) to jni(double)
        var value_jni = value;
        var duration_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("duration");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setFloatProperty(this._getValidClosetAddress(), value_jni, duration_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#duration", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportImageJob.prototype.getCreationTimeStamp = function () {
        var creationTimeStamp_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("creationTimeStamp");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), creationTimeStamp_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#creationTimeStamp", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportImageJob.prototype.setCreationTimeStamp = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var creationTimeStamp_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("creationTimeStamp");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, creationTimeStamp_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#creationTimeStamp", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    ReportImageJob.prototype.getCreationDatetime = function () {
        var creationDatetime_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("creationDatetime");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getSASDatetimeProperty(this._getValidClosetAddress(), creationDatetime_jni);
        //-- Convert abstract(commons::SASDATETIME) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#creationDatetime", "-->", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ReportImageJob.prototype.setCreationDatetime = function (value) {
        //-- Convert abstract(commons::SASDATETIME) from js(number) to jni(double)
        var value_jni = value;
        var creationDatetime_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("creationDatetime");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setSASDatetimeProperty(this._getValidClosetAddress(), value_jni, creationDatetime_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#creationDatetime", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @return {ServiceError| null}
     */
    ReportImageJob.prototype.getError = function () {
        var error_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("error");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), error_jni);
        //-- Convert abstract(transport::ServiceError) from jni(size_t) to js(ServiceError)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#error", "-->", "(transport::ServiceError)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {ServiceError| null} value
     *
     */
    ReportImageJob.prototype.setError = function (value) {
        //-- Convert abstract(transport::ServiceError) from js(ServiceError) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var error_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("error");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, error_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#error", "(transport::ServiceError)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {Array.<ReportImageDetail| null> | null}
     */
    ReportImageJob.prototype.getImages = function () {
        var images_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("images");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), images_jni);
        //-- Convert abstract(<transport::ReportImageDetail>) from jni(size_t) to js(ReportImageDetail)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#images", "-->", "(MONITORED_VECTOR<transport::ReportImageDetail>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<ReportImageDetail| null> | null} value
     *
     */
    ReportImageJob.prototype.setImages = function (value) {
        //-- Convert abstract(<transport::ReportImageDetail>) from js(ReportImageDetail) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var images_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("images");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, images_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#images", "(MONITORED_VECTOR<transport::ReportImageDetail>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {Array.<Link| null> | null}
     */
    ReportImageJob.prototype.getLinks = function () {
        var links_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), links_jni);
        //-- Convert abstract(<commons::Link>) from jni(size_t) to js(Link)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "-->", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<Link| null> | null} value
     *
     */
    ReportImageJob.prototype.setLinks = function (value) {
        //-- Convert abstract(<commons::Link>) from js(Link) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var links_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, links_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageJob)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = ReportImageJob;
});
