sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "./particles/ReportImageSize"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportImageInfo = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50201], EventDispatcher_1.default);
    /**
     *
     */
    ReportImageInfo._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportImageInfo_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", "static", "new", "-->", "(transport::ReportImageInfo)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    ReportImageInfo.prototype.getReportUrl = function () {
        var reportUrl_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportUrl");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), reportUrl_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportUrl", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportImageInfo.prototype.setReportUrl = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var reportUrl_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportUrl");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, reportUrl_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportUrl", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    ReportImageInfo.prototype.getReportImage = function () {
        var reportImage_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportImage");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), reportImage_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportImage", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    ReportImageInfo.prototype.setReportImage = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var reportImage_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportImage");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, reportImage_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportImage", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {number}
     */
    ReportImageInfo.prototype.getSectionIndex = function () {
        var sectionIndex_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sectionIndex");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), sectionIndex_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sectionIndex", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ReportImageInfo.prototype.setSectionIndex = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var sectionIndex_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sectionIndex");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, sectionIndex_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sectionIndex", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportImageInfo.prototype.getSectionName = function () {
        var sectionName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sectionName");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), sectionName_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sectionName", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportImageInfo.prototype.setSectionName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var sectionName_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sectionName");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, sectionName_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sectionName", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportImageInfo.prototype.getSectionLabel = function () {
        var sectionLabel_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sectionLabel");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), sectionLabel_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sectionLabel", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportImageInfo.prototype.setSectionLabel = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var sectionLabel_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sectionLabel");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, sectionLabel_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sectionLabel", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportImageInfo.prototype.getElementName = function () {
        var elementName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("elementName");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), elementName_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#elementName", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportImageInfo.prototype.setElementName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var elementName_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("elementName");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, elementName_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#elementName", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportImageInfo.prototype.getVisualType = function () {
        var visualType_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("visualType");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), visualType_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#visualType", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportImageInfo.prototype.setVisualType = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var visualType_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("visualType");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, visualType_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#visualType", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {ReportImageSize}
     */
    ReportImageInfo.prototype.getSize = function () {
        var size_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("size");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), size_jni);
        //-- Convert abstract(transport::ReportImageSize) from jni(int) to js(ReportImageSize)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#size", "-->", "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {ReportImageSize} value
     *
     */
    ReportImageInfo.prototype.setSize = function (value) {
        //-- Convert abstract(transport::ReportImageSize) from js(ReportImageSize) to jni(int)
        var value_jni = value;
        var size_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("size");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, size_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#size", "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportImageInfo.prototype.getUrl = function () {
        var url_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("url");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), url_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#url", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportImageInfo.prototype.setUrl = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var url_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("url");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, url_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#url", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportImageInfo.prototype.getDownloadPath = function () {
        var downloadPath_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("downloadPath");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), downloadPath_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#downloadPath", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportImageInfo.prototype.setDownloadPath = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var downloadPath_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("downloadPath");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, downloadPath_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#downloadPath", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    exports.default = ReportImageInfo;
});
