sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "./particles/ReportImageSize", "./particles/MicroserviceJobState", "./particles/ServiceError", "sas/ltjs/commons/models/particles/Link"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportImageDetail = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50200], EventDispatcher_1.default);
    /**
     *
     */
    ReportImageDetail._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportImageDetail_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", "static", "new", "-->", "(transport::ReportImageDetail)", rc);
        return rc;
    };
    /**
     * @return {boolean}
     */
    ReportImageDetail.prototype.getReportImage = function () {
        var reportImage_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportImage");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), reportImage_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportImage", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    ReportImageDetail.prototype.setReportImage = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var reportImage_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportImage");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, reportImage_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportImage", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {number}
     */
    ReportImageDetail.prototype.getSectionIndex = function () {
        var sectionIndex_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sectionIndex");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), sectionIndex_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sectionIndex", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ReportImageDetail.prototype.setSectionIndex = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var sectionIndex_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sectionIndex");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, sectionIndex_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sectionIndex", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportImageDetail.prototype.getSectionName = function () {
        var sectionName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sectionName");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), sectionName_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sectionName", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportImageDetail.prototype.setSectionName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var sectionName_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sectionName");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, sectionName_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sectionName", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportImageDetail.prototype.getSectionLabel = function () {
        var sectionLabel_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sectionLabel");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), sectionLabel_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sectionLabel", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportImageDetail.prototype.setSectionLabel = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var sectionLabel_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sectionLabel");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, sectionLabel_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sectionLabel", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportImageDetail.prototype.getElementName = function () {
        var elementName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("elementName");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), elementName_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#elementName", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportImageDetail.prototype.setElementName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var elementName_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("elementName");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, elementName_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#elementName", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportImageDetail.prototype.getVisualType = function () {
        var visualType_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("visualType");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), visualType_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#visualType", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportImageDetail.prototype.setVisualType = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var visualType_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("visualType");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, visualType_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#visualType", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {ReportImageSize}
     */
    ReportImageDetail.prototype.getSize = function () {
        var size_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("size");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), size_jni);
        //-- Convert abstract(transport::ReportImageSize) from jni(int) to js(ReportImageSize)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#size", "-->", "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {ReportImageSize} value
     *
     */
    ReportImageDetail.prototype.setSize = function (value) {
        //-- Convert abstract(transport::ReportImageSize) from js(ReportImageSize) to jni(int)
        var value_jni = value;
        var size_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("size");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, size_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#size", "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {MicroserviceJobState}
     */
    ReportImageDetail.prototype.getState = function () {
        var state_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("state");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), state_jni);
        //-- Convert abstract(transport::MicroserviceJobState) from jni(int) to js(MicroserviceJobState)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#state", "-->", "(transport::MicroserviceJobState::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {MicroserviceJobState} value
     *
     */
    ReportImageDetail.prototype.setState = function (value) {
        //-- Convert abstract(transport::MicroserviceJobState) from js(MicroserviceJobState) to jni(int)
        var value_jni = value;
        var state_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("state");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, state_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#state", "(transport::MicroserviceJobState::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {ServiceError| null}
     */
    ReportImageDetail.prototype.getError = function () {
        var error_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("error");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), error_jni);
        //-- Convert abstract(transport::ServiceError) from jni(size_t) to js(ServiceError)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#error", "-->", "(transport::ServiceError)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {ServiceError| null} value
     *
     */
    ReportImageDetail.prototype.setError = function (value) {
        //-- Convert abstract(transport::ServiceError) from js(ServiceError) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var error_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("error");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, error_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#error", "(transport::ServiceError)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {Array.<Link| null> | null}
     */
    ReportImageDetail.prototype.getLinks = function () {
        var links_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), links_jni);
        //-- Convert abstract(<commons::Link>) from jni(size_t) to js(Link)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "-->", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<Link| null> | null} value
     *
     */
    ReportImageDetail.prototype.setLinks = function (value) {
        //-- Convert abstract(<commons::Link>) from js(Link) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var links_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, links_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageDetail)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = ReportImageDetail;
});
