sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "./particles/PrintOrientation", "./particles/PaperType", "./particles/PrintFitOption", "./particles/PrintTableOfContentsDisplayOption", "./particles/PrintDestination"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var PrintSetup = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50180], EventDispatcher_1.default);
    /**
     *
     */
    PrintSetup._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_PrintSetup_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", "static", "new", "-->", "(transport::PrintSetup)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    PrintSetup.prototype.getLocale = function () {
        var locale_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("locale");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), locale_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#locale", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    PrintSetup.prototype.setLocale = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var locale_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("locale");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, locale_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#locale", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    PrintSetup.prototype.getFormatterLocale = function () {
        var formatterLocale_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("formatterLocale");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), formatterLocale_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#formatterLocale", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    PrintSetup.prototype.setFormatterLocale = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var formatterLocale_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("formatterLocale");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, formatterLocale_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#formatterLocale", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    PrintSetup.prototype.getUtcOffsetInSeconds = function () {
        var utcOffsetInSeconds_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("utcOffsetInSeconds");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), utcOffsetInSeconds_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#utcOffsetInSeconds", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    PrintSetup.prototype.setUtcOffsetInSeconds = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var utcOffsetInSeconds_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("utcOffsetInSeconds");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, utcOffsetInSeconds_name_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#utcOffsetInSeconds", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {PrintOrientation}
     */
    PrintSetup.prototype.getOrientation = function () {
        var orientation_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("orientation");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), orientation_jni);
        //-- Convert abstract(transport::PrintOrientation) from jni(int) to js(PrintOrientation)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#orientation", "-->", "(transport::PrintOrientation::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {PrintOrientation} value
     *
     */
    PrintSetup.prototype.setOrientation = function (value) {
        //-- Convert abstract(transport::PrintOrientation) from js(PrintOrientation) to jni(int)
        var value_jni = value;
        var orientation_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("orientation");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, orientation_name_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#orientation", "(transport::PrintOrientation::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {PaperType}
     */
    PrintSetup.prototype.getPaperType = function () {
        var paperType_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("paperType");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), paperType_jni);
        //-- Convert abstract(transport::PaperType) from jni(int) to js(PaperType)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#paperType", "-->", "(transport::PaperType::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {PaperType} value
     *
     */
    PrintSetup.prototype.setPaperType = function (value) {
        //-- Convert abstract(transport::PaperType) from js(PaperType) to jni(int)
        var value_jni = value;
        var paperType_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("paperType");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, paperType_name_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#paperType", "(transport::PaperType::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    PrintSetup.prototype.getPaperHeight = function () {
        var paperHeight_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("paperHeight");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), paperHeight_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#paperHeight", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    PrintSetup.prototype.setPaperHeight = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var paperHeight_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("paperHeight");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, paperHeight_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#paperHeight", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    PrintSetup.prototype.getPaperWidth = function () {
        var paperWidth_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("paperWidth");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), paperWidth_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#paperWidth", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    PrintSetup.prototype.setPaperWidth = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var paperWidth_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("paperWidth");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, paperWidth_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#paperWidth", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    PrintSetup.prototype.getMarginTop = function () {
        var marginTop_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("marginTop");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), marginTop_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#marginTop", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    PrintSetup.prototype.setMarginTop = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var marginTop_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("marginTop");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, marginTop_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#marginTop", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    PrintSetup.prototype.getMarginBottom = function () {
        var marginBottom_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("marginBottom");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), marginBottom_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#marginBottom", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    PrintSetup.prototype.setMarginBottom = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var marginBottom_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("marginBottom");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, marginBottom_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#marginBottom", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    PrintSetup.prototype.getMarginLeft = function () {
        var marginLeft_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("marginLeft");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), marginLeft_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#marginLeft", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    PrintSetup.prototype.setMarginLeft = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var marginLeft_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("marginLeft");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, marginLeft_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#marginLeft", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    PrintSetup.prototype.getMarginRight = function () {
        var marginRight_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("marginRight");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), marginRight_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#marginRight", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    PrintSetup.prototype.setMarginRight = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var marginRight_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("marginRight");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, marginRight_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#marginRight", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {PrintFitOption}
     */
    PrintSetup.prototype.getFitOption = function () {
        var fitOption_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("fitOption");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), fitOption_jni);
        //-- Convert abstract(transport::PrintFitOption) from jni(int) to js(PrintFitOption)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#fitOption", "-->", "(transport::PrintFitOption::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {PrintFitOption} value
     *
     */
    PrintSetup.prototype.setFitOption = function (value) {
        //-- Convert abstract(transport::PrintFitOption) from js(PrintFitOption) to jni(int)
        var value_jni = value;
        var fitOption_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("fitOption");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, fitOption_name_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#fitOption", "(transport::PrintFitOption::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {PrintTableOfContentsDisplayOption}
     */
    PrintSetup.prototype.getTableOfContentsDisplay = function () {
        var tableOfContentsDisplay_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("tableOfContentsDisplay");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), tableOfContentsDisplay_jni);
        //-- Convert abstract(transport::PrintTableOfContentsDisplayOption) from jni(int) to js(PrintTableOfContentsDisplayOption)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#tableOfContentsDisplay", "-->", "(transport::PrintTableOfContentsDisplayOption::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {PrintTableOfContentsDisplayOption} value
     *
     */
    PrintSetup.prototype.setTableOfContentsDisplay = function (value) {
        //-- Convert abstract(transport::PrintTableOfContentsDisplayOption) from js(PrintTableOfContentsDisplayOption) to jni(int)
        var value_jni = value;
        var tableOfContentsDisplay_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("tableOfContentsDisplay");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, tableOfContentsDisplay_name_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#tableOfContentsDisplay", "(transport::PrintTableOfContentsDisplayOption::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    PrintSetup.prototype.getShowPageNumbers = function () {
        var showPageNumbers_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("showPageNumbers");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), showPageNumbers_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#showPageNumbers", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    PrintSetup.prototype.setShowPageNumbers = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var showPageNumbers_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("showPageNumbers");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, showPageNumbers_name_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#showPageNumbers", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    PrintSetup.prototype.getShowEmptyRowsAndColumns = function () {
        var showEmptyRowsAndColumns_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("showEmptyRowsAndColumns");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), showEmptyRowsAndColumns_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#showEmptyRowsAndColumns", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    PrintSetup.prototype.setShowEmptyRowsAndColumns = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var showEmptyRowsAndColumns_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("showEmptyRowsAndColumns");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, showEmptyRowsAndColumns_name_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#showEmptyRowsAndColumns", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    PrintSetup.prototype.getShowAppendix = function () {
        var showAppendix_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("showAppendix");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), showAppendix_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#showAppendix", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    PrintSetup.prototype.setShowAppendix = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var showAppendix_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("showAppendix");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, showAppendix_name_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#showAppendix", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    PrintSetup.prototype.getAppendixDisplay = function () {
        var appendixDisplay_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("appendixDisplay");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), appendixDisplay_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#appendixDisplay", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    PrintSetup.prototype.setAppendixDisplay = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var appendixDisplay_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("appendixDisplay");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, appendixDisplay_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#appendixDisplay", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    PrintSetup.prototype.getShowCoverPage = function () {
        var showCoverPage_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("showCoverPage");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), showCoverPage_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#showCoverPage", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    PrintSetup.prototype.setShowCoverPage = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var showCoverPage_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("showCoverPage");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, showCoverPage_name_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#showCoverPage", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    PrintSetup.prototype.getCoverPageText = function () {
        var coverPageText_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("coverPageText");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), coverPageText_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#coverPageText", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    PrintSetup.prototype.setCoverPageText = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var coverPageText_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("coverPageText");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, coverPageText_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#coverPageText", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    PrintSetup.prototype.getCoverPageDateTime = function () {
        var coverPageDateTime_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("coverPageDateTime");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), coverPageDateTime_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#coverPageDateTime", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    PrintSetup.prototype.setCoverPageDateTime = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var coverPageDateTime_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("coverPageDateTime");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, coverPageDateTime_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#coverPageDateTime", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    PrintSetup.prototype.getReportElements = function () {
        var reportElements_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportElements");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), reportElements_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportElements", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    PrintSetup.prototype.setReportElements = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var reportElements_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportElements");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, reportElements_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportElements", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    PrintSetup.prototype.getUseHighContrastReportStyle = function () {
        var useHighContrastReportStyle_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("useHighContrastReportStyle");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), useHighContrastReportStyle_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#useHighContrastReportStyle", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    PrintSetup.prototype.setUseHighContrastReportStyle = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var useHighContrastReportStyle_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("useHighContrastReportStyle");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, useHighContrastReportStyle_name_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#useHighContrastReportStyle", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {number}
     */
    PrintSetup.prototype.getDpi = function () {
        var dpi_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("dpi");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), dpi_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#dpi", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    PrintSetup.prototype.setDpi = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var dpi_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("dpi");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, dpi_name_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#dpi", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    PrintSetup.prototype.getShowPrintedTableOfContents = function () {
        var showPrintedTableOfContents_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("showPrintedTableOfContents");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), showPrintedTableOfContents_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#showPrintedTableOfContents", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    PrintSetup.prototype.setShowPrintedTableOfContents = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var showPrintedTableOfContents_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("showPrintedTableOfContents");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, showPrintedTableOfContents_name_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#showPrintedTableOfContents", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {PrintDestination}
     */
    PrintSetup.prototype.getDestination = function () {
        var destination_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("destination");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), destination_jni);
        //-- Convert abstract(transport::PrintDestination) from jni(int) to js(PrintDestination)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#destination", "-->", "(transport::PrintDestination::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {PrintDestination} value
     *
     */
    PrintSetup.prototype.setDestination = function (value) {
        //-- Convert abstract(transport::PrintDestination) from js(PrintDestination) to jni(int)
        var value_jni = value;
        var destination_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("destination");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, destination_name_jni);
        Module.deps['TraceUtil'].log("(transport::PrintSetup)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#destination", "(transport::PrintDestination::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    exports.default = PrintSetup;
});
