sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./particles/MapsSettingsAttributes", "sas/ltjs/commons/models/particles/Link"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var MapsSettings = ltjsEnvironment_1.createModule([114, 13, 50265, 50157], EventDispatcher_1.default);
    /**
     *
     */
    MapsSettings._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_MapsSettings_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::MapsSettings)", "static", "new", "-->", "(transport::MapsSettings)", rc);
        return rc;
    };
    /**
     * @return {MapsSettingsAttributes| null}
     */
    MapsSettings.prototype.getAttributes = function () {
        var attributes_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("attributes");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), attributes_jni);
        //-- Convert abstract(transport::MapsSettingsAttributes) from jni(size_t) to js(MapsSettingsAttributes)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::MapsSettings)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#attributes", "-->", "(transport::MapsSettingsAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {MapsSettingsAttributes| null} value
     *
     */
    MapsSettings.prototype.setAttributes = function (value) {
        //-- Convert abstract(transport::MapsSettingsAttributes) from js(MapsSettingsAttributes) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var attributes_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("attributes");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, attributes_name_jni);
        Module.deps['TraceUtil'].log("(transport::MapsSettings)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#attributes", "(transport::MapsSettingsAttributes)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {Array.<Link| null> | null}
     */
    MapsSettings.prototype.getLinks = function () {
        var links_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), links_jni);
        //-- Convert abstract(<commons::Link>) from jni(size_t) to js(Link)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::MapsSettings)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "-->", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<Link| null> | null} value
     *
     */
    MapsSettings.prototype.setLinks = function (value) {
        //-- Convert abstract(<commons::Link>) from js(Link) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var links_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, links_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::MapsSettings)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = MapsSettings;
});
