sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "./particles/FolderType"], function (require, exports, ltjsEnvironment_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var FolderMetadata = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50118], EventDispatcher_1.default);
    /**
     *
     */
    FolderMetadata._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FolderMetadata_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", "static", "new", "-->", "(transport::FolderMetadata)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    FolderMetadata.prototype.getDescription = function () {
        var description_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("description");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), description_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#description", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    FolderMetadata.prototype.setDescription = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var description_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("description");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, description_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#description", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    FolderMetadata.prototype.getDisplayName = function () {
        var displayName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("displayName");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), displayName_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#displayName", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    FolderMetadata.prototype.setDisplayName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var displayName_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("displayName");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, displayName_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#displayName", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    FolderMetadata.prototype.getShortName = function () {
        var shortName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shortName");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), shortName_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shortName", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    FolderMetadata.prototype.setShortName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var shortName_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shortName");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, shortName_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shortName", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    FolderMetadata.prototype.getResourceId = function () {
        var resourceId_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("resourceId");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), resourceId_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#resourceId", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    FolderMetadata.prototype.setResourceId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var resourceId_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("resourceId");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, resourceId_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#resourceId", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {FolderType}
     */
    FolderMetadata.prototype.getType = function () {
        var type_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("type");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), type_jni);
        //-- Convert abstract(transport::FolderType) from jni(int) to js(FolderType)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#type", "-->", "(transport::FolderType::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {FolderType} value
     *
     */
    FolderMetadata.prototype.setType = function (value) {
        //-- Convert abstract(transport::FolderType) from js(FolderType) to jni(int)
        var value_jni = value;
        var type_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("type");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, type_name_jni);
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#type", "(transport::FolderType::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    FolderMetadata.prototype.getLastModified = function () {
        var lastModified_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastModified");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), lastModified_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastModified", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    FolderMetadata.prototype.setLastModified = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var lastModified_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastModified");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, lastModified_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastModified", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    FolderMetadata.prototype.getLastModifiedDatetime = function () {
        var lastModifiedDatetime_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastModifiedDatetime");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getSASDatetimeProperty(this._getValidClosetAddress(), lastModifiedDatetime_jni);
        //-- Convert abstract(commons::SASDATETIME) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastModifiedDatetime", "-->", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    FolderMetadata.prototype.setLastModifiedDatetime = function (value) {
        //-- Convert abstract(commons::SASDATETIME) from js(number) to jni(double)
        var value_jni = value;
        var lastModifiedDatetime_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastModifiedDatetime");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setSASDatetimeProperty(this._getValidClosetAddress(), value_jni, lastModifiedDatetime_name_jni);
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastModifiedDatetime", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    FolderMetadata.prototype.getCreated = function () {
        var created_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("created");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), created_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#created", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    FolderMetadata.prototype.setCreated = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var created_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("created");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, created_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#created", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    FolderMetadata.prototype.getCreatedDatetime = function () {
        var createdDatetime_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("createdDatetime");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getSASDatetimeProperty(this._getValidClosetAddress(), createdDatetime_jni);
        //-- Convert abstract(commons::SASDATETIME) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#createdDatetime", "-->", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    FolderMetadata.prototype.setCreatedDatetime = function (value) {
        //-- Convert abstract(commons::SASDATETIME) from js(number) to jni(double)
        var value_jni = value;
        var createdDatetime_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("createdDatetime");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setSASDatetimeProperty(this._getValidClosetAddress(), value_jni, createdDatetime_name_jni);
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#createdDatetime", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @param {PortableEvent| null} pEvent
     *
     */
    FolderMetadata.prototype.lastModifiedUpdated = function (pEvent) {
        //-- Convert abstract(commons::PortableEvent) from js(PortableEvent) to jni(size_t)
        var pEvent_jni = ClosetObject_1.default._getValidClosetAddress(pEvent);
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FolderMetadata_lastModifiedUpdated(this._getValidClosetAddress(), pEvent_jni);
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "lastModifiedUpdated", "(commons::PortableEvent)", Module.deps['TraceUtil'].traceConversions.convertModel(pEvent));
        return this;
    };
    /**
     * @param {PortableEvent| null} pEvent
     *
     */
    FolderMetadata.prototype.createdUpdated = function (pEvent) {
        //-- Convert abstract(commons::PortableEvent) from js(PortableEvent) to jni(size_t)
        var pEvent_jni = ClosetObject_1.default._getValidClosetAddress(pEvent);
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FolderMetadata_createdUpdated(this._getValidClosetAddress(), pEvent_jni);
        Module.deps['TraceUtil'].log("(transport::FolderMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "createdUpdated", "(commons::PortableEvent)", Module.deps['TraceUtil'].traceConversions.convertModel(pEvent));
        return this;
    };
    exports.default = FolderMetadata;
});
