sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "sas/ltjs/commons/models/particles/Link"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var FolderItem = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50115], EventDispatcher_1.default);
    /**
     *
     */
    FolderItem._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FolderItem_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::FolderItem)", "static", "new", "-->", "(transport::FolderItem)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    FolderItem.prototype.getId = function () {
        var id_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), id_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    FolderItem.prototype.setId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var id_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, id_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    FolderItem.prototype.getName = function () {
        var name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("name");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), name_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#name", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    FolderItem.prototype.setName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var name_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("name");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, name_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#name", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    FolderItem.prototype.getDescription = function () {
        var description_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("description");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), description_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#description", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    FolderItem.prototype.setDescription = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var description_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("description");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, description_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#description", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    FolderItem.prototype.getCreationTimeStamp = function () {
        var creationTimeStamp_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("creationTimeStamp");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), creationTimeStamp_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#creationTimeStamp", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    FolderItem.prototype.setCreationTimeStamp = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var creationTimeStamp_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("creationTimeStamp");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, creationTimeStamp_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#creationTimeStamp", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    FolderItem.prototype.getModifiedTimeStamp = function () {
        var modifiedTimeStamp_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("modifiedTimeStamp");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), modifiedTimeStamp_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#modifiedTimeStamp", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    FolderItem.prototype.setModifiedTimeStamp = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var modifiedTimeStamp_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("modifiedTimeStamp");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, modifiedTimeStamp_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#modifiedTimeStamp", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    FolderItem.prototype.getAdded = function () {
        var added_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("added");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), added_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#added", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    FolderItem.prototype.setAdded = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var added_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("added");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, added_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#added", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    FolderItem.prototype.getModifiedBy = function () {
        var modifiedBy_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("modifiedBy");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), modifiedBy_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#modifiedBy", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    FolderItem.prototype.setModifiedBy = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var modifiedBy_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("modifiedBy");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, modifiedBy_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#modifiedBy", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    FolderItem.prototype.getCreatedBy = function () {
        var createdBy_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("createdBy");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), createdBy_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#createdBy", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    FolderItem.prototype.setCreatedBy = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var createdBy_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("createdBy");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, createdBy_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#createdBy", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    FolderItem.prototype.getType = function () {
        var type_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("type");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), type_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#type", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    FolderItem.prototype.setType = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var type_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("type");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, type_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#type", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    FolderItem.prototype.getContentType = function () {
        var contentType_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("contentType");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), contentType_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#contentType", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    FolderItem.prototype.setContentType = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var contentType_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("contentType");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, contentType_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#contentType", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    FolderItem.prototype.getIconUri = function () {
        var iconUri_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("iconUri");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), iconUri_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#iconUri", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    FolderItem.prototype.setIconUri = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var iconUri_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("iconUri");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, iconUri_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#iconUri", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    FolderItem.prototype.getMemberCount = function () {
        var memberCount_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("memberCount");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), memberCount_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#memberCount", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    FolderItem.prototype.setMemberCount = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var memberCount_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("memberCount");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, memberCount_name_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#memberCount", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {Array.<Link| null> | null}
     */
    FolderItem.prototype.getLinks = function () {
        var links_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), links_jni);
        //-- Convert abstract(<commons::Link>) from jni(size_t) to js(Link)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "-->", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<Link| null> | null} value
     *
     */
    FolderItem.prototype.setLinks = function (value) {
        //-- Convert abstract(<commons::Link>) from js(Link) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var links_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, links_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {string| null}
     */
    FolderItem.prototype.getUri = function () {
        var uri_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("uri");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), uri_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#uri", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    FolderItem.prototype.setUri = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var uri_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("uri");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, uri_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderItem)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#uri", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    exports.default = FolderItem;
});
