sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var DeviceManagementProperties = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50085], EventDispatcher_1.default);
    /**
     *
     */
    DeviceManagementProperties._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_DeviceManagementProperties_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DeviceManagementProperties)", "static", "new", "-->", "(transport::DeviceManagementProperties)", rc);
        return rc;
    };
    /**
     * @return {number}
     */
    DeviceManagementProperties.prototype.getPasscodeAttempts = function () {
        var passcodeAttempts_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("passcodeAttempts");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), passcodeAttempts_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DeviceManagementProperties)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#passcodeAttempts", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DeviceManagementProperties.prototype.setPasscodeAttempts = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var passcodeAttempts_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("passcodeAttempts");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, passcodeAttempts_name_jni);
        Module.deps['TraceUtil'].log("(transport::DeviceManagementProperties)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#passcodeAttempts", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    DeviceManagementProperties.prototype.getPasscodeTimeoutMinutes = function () {
        var passcodeTimeoutMinutes_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("passcodeTimeoutMinutes");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), passcodeTimeoutMinutes_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DeviceManagementProperties)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#passcodeTimeoutMinutes", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DeviceManagementProperties.prototype.setPasscodeTimeoutMinutes = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var passcodeTimeoutMinutes_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("passcodeTimeoutMinutes");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, passcodeTimeoutMinutes_name_jni);
        Module.deps['TraceUtil'].log("(transport::DeviceManagementProperties)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#passcodeTimeoutMinutes", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    DeviceManagementProperties.prototype.getOfflineLimitDays = function () {
        var offlineLimitDays_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("offlineLimitDays");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), offlineLimitDays_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DeviceManagementProperties)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#offlineLimitDays", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DeviceManagementProperties.prototype.setOfflineLimitDays = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var offlineLimitDays_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("offlineLimitDays");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, offlineLimitDays_name_jni);
        Module.deps['TraceUtil'].log("(transport::DeviceManagementProperties)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#offlineLimitDays", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    exports.default = DeviceManagementProperties;
});
