sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "./particles/CredentialProperties", "./particles/CredentialSecrets"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Credentials = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50075], EventDispatcher_1.default);
    /**
     *
     */
    Credentials._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Credentials_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Credentials)", "static", "new", "-->", "(transport::Credentials)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    Credentials.prototype.getDomainId = function () {
        var domainId_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("domainId");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), domainId_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Credentials)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#domainId", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Credentials.prototype.setDomainId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var domainId_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("domainId");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, domainId_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Credentials)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#domainId", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Credentials.prototype.getDomainType = function () {
        var domainType_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("domainType");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), domainType_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Credentials)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#domainType", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Credentials.prototype.setDomainType = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var domainType_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("domainType");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, domainType_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Credentials)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#domainType", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Credentials.prototype.getIdentityType = function () {
        var identityType_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("identityType");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), identityType_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Credentials)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#identityType", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Credentials.prototype.setIdentityType = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var identityType_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("identityType");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, identityType_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Credentials)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#identityType", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Credentials.prototype.getIdentityId = function () {
        var identityId_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("identityId");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), identityId_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Credentials)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#identityId", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Credentials.prototype.setIdentityId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var identityId_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("identityId");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, identityId_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Credentials)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#identityId", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Credentials.prototype.getCredentialType = function () {
        var credentialType_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("credentialType");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), credentialType_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Credentials)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#credentialType", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Credentials.prototype.setCredentialType = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var credentialType_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("credentialType");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, credentialType_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Credentials)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#credentialType", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {CredentialProperties| null}
     */
    Credentials.prototype.getProperties = function () {
        var properties_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("properties");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), properties_jni);
        //-- Convert abstract(transport::CredentialProperties) from jni(size_t) to js(CredentialProperties)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Credentials)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#properties", "-->", "(transport::CredentialProperties)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {CredentialProperties| null} value
     *
     */
    Credentials.prototype.setProperties = function (value) {
        //-- Convert abstract(transport::CredentialProperties) from js(CredentialProperties) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var properties_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("properties");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, properties_name_jni);
        Module.deps['TraceUtil'].log("(transport::Credentials)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#properties", "(transport::CredentialProperties)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {CredentialSecrets| null}
     */
    Credentials.prototype.getSecrets = function () {
        var secrets_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("secrets");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), secrets_jni);
        //-- Convert abstract(transport::CredentialSecrets) from jni(size_t) to js(CredentialSecrets)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Credentials)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#secrets", "-->", "(transport::CredentialSecrets)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {CredentialSecrets| null} value
     *
     */
    Credentials.prototype.setSecrets = function (value) {
        //-- Convert abstract(transport::CredentialSecrets) from js(CredentialSecrets) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var secrets_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("secrets");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, secrets_name_jni);
        Module.deps['TraceUtil'].log("(transport::Credentials)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#secrets", "(transport::CredentialSecrets)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    exports.default = Credentials;
});
