sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "./CommentThread"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CommentTree = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50068], EventDispatcher_1.default);
    /**
     *
     */
    CommentTree._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CommentTree_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CommentTree)", "static", "new", "-->", "(transport::CommentTree)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    CommentTree.prototype.getXmlElementName = function () {
        var xmlElementName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("xmlElementName");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), xmlElementName_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentTree)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#xmlElementName", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    CommentTree.prototype.setXmlElementName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var xmlElementName_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("xmlElementName");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, xmlElementName_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CommentTree)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#xmlElementName", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    CommentTree.prototype.getGuid = function () {
        var guid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("guid");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), guid_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentTree)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#guid", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    CommentTree.prototype.setGuid = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var guid_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("guid");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, guid_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CommentTree)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#guid", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {Array.<CommentThread| null> | null}
     */
    CommentTree.prototype.getThreads = function () {
        var threads_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("threads");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), threads_jni);
        //-- Convert abstract(<transport::CommentThread>) from jni(size_t) to js(CommentThread)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentTree)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#threads", "-->", "(MONITORED_VECTOR<transport::CommentThread>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<CommentThread| null> | null} value
     *
     */
    CommentTree.prototype.setThreads = function (value) {
        //-- Convert abstract(<transport::CommentThread>) from js(CommentThread) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var threads_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("threads");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, threads_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CommentTree)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#threads", "(MONITORED_VECTOR<transport::CommentThread>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {boolean}
     */
    CommentTree.prototype.getUserAdmin = function () {
        var userAdmin_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("userAdmin");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), userAdmin_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::CommentTree)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#userAdmin", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    CommentTree.prototype.setUserAdmin = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var userAdmin_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("userAdmin");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, userAdmin_name_jni);
        Module.deps['TraceUtil'].log("(transport::CommentTree)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#userAdmin", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    exports.default = CommentTree;
});
