sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "./Comment"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CommentThread = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50067], EventDispatcher_1.default);
    /**
     *
     */
    CommentThread._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CommentThread_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CommentThread)", "static", "new", "-->", "(transport::CommentThread)", rc);
        return rc;
    };
    /**
     * @return {Array.<Comment| null> | null}
     */
    CommentThread.prototype.getComments = function () {
        var comments_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("comments");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), comments_jni);
        //-- Convert abstract(<transport::Comment>) from jni(size_t) to js(Comment)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentThread)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#comments", "-->", "(MONITORED_VECTOR<transport::Comment>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<Comment| null> | null} value
     *
     */
    CommentThread.prototype.setComments = function (value) {
        //-- Convert abstract(<transport::Comment>) from js(Comment) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var comments_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("comments");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, comments_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CommentThread)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#comments", "(MONITORED_VECTOR<transport::Comment>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {string| null}
     */
    CommentThread.prototype.getDuid = function () {
        var duid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("duid");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), duid_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentThread)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#duid", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    CommentThread.prototype.setDuid = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var duid_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("duid");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, duid_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CommentThread)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#duid", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    CommentThread.prototype.getSubject = function () {
        var subject_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("subject");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), subject_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CommentThread)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#subject", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    CommentThread.prototype.setSubject = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var subject_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("subject");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, subject_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CommentThread)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#subject", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    CommentThread.prototype.getThreadId = function () {
        var threadId_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("threadId");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), threadId_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CommentThread)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#threadId", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    CommentThread.prototype.setThreadId = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var threadId_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("threadId");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, threadId_name_jni);
        Module.deps['TraceUtil'].log("(transport::CommentThread)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#threadId", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    exports.default = CommentThread;
});
