sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "./particles/CommentAttachment", "./particles/CommentAttachmentInfo", "sas/ltjs/commons/models/particles/Link"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Comment = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50061], EventDispatcher_1.default);
    /**
     *
     */
    Comment._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Comment_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Comment)", "static", "new", "-->", "(transport::Comment)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    Comment.prototype.getXmlElementName = function () {
        var xmlElementName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("xmlElementName");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), xmlElementName_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#xmlElementName", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Comment.prototype.setXmlElementName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var xmlElementName_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("xmlElementName");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, xmlElementName_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#xmlElementName", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Comment.prototype.getAuthor = function () {
        var author_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("author");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), author_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#author", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Comment.prototype.setAuthor = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var author_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("author");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, author_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#author", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Comment.prototype.getCreatedOn = function () {
        var createdOn_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("createdOn");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), createdOn_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#createdOn", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Comment.prototype.setCreatedOn = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var createdOn_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("createdOn");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, createdOn_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#createdOn", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    Comment.prototype.getCreatedOnDatetime = function () {
        var createdOnDatetime_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("createdOnDatetime");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getSASDatetimeProperty(this._getValidClosetAddress(), createdOnDatetime_jni);
        //-- Convert abstract(commons::SASDATETIME) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#createdOnDatetime", "-->", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    Comment.prototype.setCreatedOnDatetime = function (value) {
        //-- Convert abstract(commons::SASDATETIME) from js(number) to jni(double)
        var value_jni = value;
        var createdOnDatetime_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("createdOnDatetime");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setSASDatetimeProperty(this._getValidClosetAddress(), value_jni, createdOnDatetime_name_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#createdOnDatetime", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Comment.prototype.getElementId = function () {
        var elementId_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("elementId");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), elementId_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#elementId", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Comment.prototype.setElementId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var elementId_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("elementId");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, elementId_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#elementId", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    Comment.prototype.getCommentId = function () {
        var commentId_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("commentId");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), commentId_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#commentId", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    Comment.prototype.setCommentId = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var commentId_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("commentId");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, commentId_name_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#commentId", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Comment.prototype.getObjectId = function () {
        var objectId_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("objectId");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), objectId_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#objectId", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Comment.prototype.setObjectId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var objectId_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("objectId");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, objectId_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#objectId", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    Comment.prototype.getObjectType = function () {
        var objectType_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("objectType");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), objectType_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#objectType", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    Comment.prototype.setObjectType = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var objectType_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("objectType");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, objectType_name_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#objectType", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    Comment.prototype.getParentId = function () {
        var parentId_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("parentId");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), parentId_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#parentId", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    Comment.prototype.setParentId = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var parentId_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("parentId");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, parentId_name_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#parentId", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    Comment.prototype.getPriority = function () {
        var priority_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("priority");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), priority_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#priority", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    Comment.prototype.setPriority = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var priority_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("priority");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, priority_name_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#priority", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Comment.prototype.getSubject = function () {
        var subject_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("subject");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), subject_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#subject", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Comment.prototype.setSubject = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var subject_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("subject");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, subject_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#subject", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Comment.prototype.getText = function () {
        var text_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("text");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), text_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#text", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Comment.prototype.setText = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var text_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("text");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, text_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#text", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {Array.<CommentAttachment| null> | null}
     */
    Comment.prototype.getAttachments = function () {
        var attachments_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("attachments");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), attachments_jni);
        //-- Convert abstract(<transport::CommentAttachment>) from jni(size_t) to js(CommentAttachment)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#attachments", "-->", "(MONITORED_VECTOR<transport::CommentAttachment>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<CommentAttachment| null> | null} value
     *
     */
    Comment.prototype.setAttachments = function (value) {
        //-- Convert abstract(<transport::CommentAttachment>) from js(CommentAttachment) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var attachments_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("attachments");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, attachments_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#attachments", "(MONITORED_VECTOR<transport::CommentAttachment>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {Array.<CommentAttachmentInfo| null> | null}
     */
    Comment.prototype.getInfos = function () {
        var infos_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("infos");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), infos_jni);
        //-- Convert abstract(<transport::CommentAttachmentInfo>) from jni(size_t) to js(CommentAttachmentInfo)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#infos", "-->", "(MONITORED_VECTOR<transport::CommentAttachmentInfo>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<CommentAttachmentInfo| null> | null} value
     *
     */
    Comment.prototype.setInfos = function (value) {
        //-- Convert abstract(<transport::CommentAttachmentInfo>) from js(CommentAttachmentInfo) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var infos_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("infos");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, infos_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#infos", "(MONITORED_VECTOR<transport::CommentAttachmentInfo>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {string| null}
     */
    Comment.prototype.getModifiedBy = function () {
        var modifiedBy_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("modifiedBy");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), modifiedBy_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#modifiedBy", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Comment.prototype.setModifiedBy = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var modifiedBy_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("modifiedBy");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, modifiedBy_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#modifiedBy", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Comment.prototype.getCreatedBy = function () {
        var createdBy_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("createdBy");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), createdBy_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#createdBy", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Comment.prototype.setCreatedBy = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var createdBy_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("createdBy");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, createdBy_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#createdBy", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {Array.<Link| null> | null}
     */
    Comment.prototype.getLinks = function () {
        var links_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), links_jni);
        //-- Convert abstract(<commons::Link>) from jni(size_t) to js(Link)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "-->", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<Link| null> | null} value
     *
     */
    Comment.prototype.setLinks = function (value) {
        //-- Convert abstract(<commons::Link>) from js(Link) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var links_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, links_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {string| null}
     */
    Comment.prototype.getCreationTimeStamp = function () {
        var creationTimeStamp_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("creationTimeStamp");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), creationTimeStamp_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#creationTimeStamp", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Comment.prototype.setCreationTimeStamp = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var creationTimeStamp_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("creationTimeStamp");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, creationTimeStamp_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#creationTimeStamp", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Comment.prototype.getModifiedTimeStamp = function () {
        var modifiedTimeStamp_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("modifiedTimeStamp");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), modifiedTimeStamp_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#modifiedTimeStamp", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Comment.prototype.setModifiedTimeStamp = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var modifiedTimeStamp_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("modifiedTimeStamp");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, modifiedTimeStamp_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#modifiedTimeStamp", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    Comment.prototype.getModifiedOnDatetime = function () {
        var modifiedOnDatetime_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("modifiedOnDatetime");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getSASDatetimeProperty(this._getValidClosetAddress(), modifiedOnDatetime_jni);
        //-- Convert abstract(commons::SASDATETIME) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#modifiedOnDatetime", "-->", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    Comment.prototype.setModifiedOnDatetime = function (value) {
        //-- Convert abstract(commons::SASDATETIME) from js(number) to jni(double)
        var value_jni = value;
        var modifiedOnDatetime_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("modifiedOnDatetime");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setSASDatetimeProperty(this._getValidClosetAddress(), value_jni, modifiedOnDatetime_name_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#modifiedOnDatetime", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Comment.prototype.getCommentUUID = function () {
        var commentUUID_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("commentUUID");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), commentUUID_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#commentUUID", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Comment.prototype.setCommentUUID = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var commentUUID_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("commentUUID");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, commentUUID_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#commentUUID", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Comment.prototype.getParentUUID = function () {
        var parentUUID_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("parentUUID");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), parentUUID_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#parentUUID", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Comment.prototype.setParentUUID = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var parentUUID_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("parentUUID");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, parentUUID_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#parentUUID", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Comment.prototype.getResourceUri = function () {
        var resourceUri_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("resourceUri");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), resourceUri_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#resourceUri", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Comment.prototype.setResourceUri = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var resourceUri_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("resourceUri");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, resourceUri_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#resourceUri", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Comment.prototype.getAuthorAvatarPath = function () {
        var authorAvatarPath_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("authorAvatarPath");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), authorAvatarPath_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#authorAvatarPath", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Comment.prototype.setAuthorAvatarPath = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var authorAvatarPath_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("authorAvatarPath");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, authorAvatarPath_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#authorAvatarPath", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    Comment.prototype.getAuthorAvatarIsDefault = function () {
        var authorAvatarIsDefault_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("authorAvatarIsDefault");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), authorAvatarIsDefault_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#authorAvatarIsDefault", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    Comment.prototype.setAuthorAvatarIsDefault = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var authorAvatarIsDefault_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("authorAvatarIsDefault");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, authorAvatarIsDefault_name_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#authorAvatarIsDefault", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @param {PortableEvent| null} pEvent
     *
     */
    Comment.prototype.createdOnUpdated = function (pEvent) {
        //-- Convert abstract(commons::PortableEvent) from js(PortableEvent) to jni(size_t)
        var pEvent_jni = ClosetObject_1.default._getValidClosetAddress(pEvent);
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Comment_createdOnUpdated(this._getValidClosetAddress(), pEvent_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "createdOnUpdated", "(commons::PortableEvent)", Module.deps['TraceUtil'].traceConversions.convertModel(pEvent));
        return this;
    };
    /**
     * @param {PortableEvent| null} pEvent
     *
     */
    Comment.prototype.modifiedTimeStampUpdated = function (pEvent) {
        //-- Convert abstract(commons::PortableEvent) from js(PortableEvent) to jni(size_t)
        var pEvent_jni = ClosetObject_1.default._getValidClosetAddress(pEvent);
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Comment_modifiedTimeStampUpdated(this._getValidClosetAddress(), pEvent_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "modifiedTimeStampUpdated", "(commons::PortableEvent)", Module.deps['TraceUtil'].traceConversions.convertModel(pEvent));
        return this;
    };
    /**
     * @param {PortableEvent| null} pEvent
     *
     */
    Comment.prototype.creationTimeStampUpdated = function (pEvent) {
        //-- Convert abstract(commons::PortableEvent) from js(PortableEvent) to jni(size_t)
        var pEvent_jni = ClosetObject_1.default._getValidClosetAddress(pEvent);
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Comment_creationTimeStampUpdated(this._getValidClosetAddress(), pEvent_jni);
        Module.deps['TraceUtil'].log("(transport::Comment)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "creationTimeStampUpdated", "(commons::PortableEvent)", Module.deps['TraceUtil'].traceConversions.convertModel(pEvent));
        return this;
    };
    exports.default = Comment;
});
