sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var AuthorizationContext = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50025], EventDispatcher_1.default);
    /**
     *
     */
    AuthorizationContext._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_AuthorizationContext_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", "static", "new", "-->", "(transport::AuthorizationContext)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getAccessComments = function () {
        var accessComments_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessComments");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), accessComments_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessComments", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setAccessComments = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var accessComments_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessComments");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, accessComments_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessComments", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getAccessEsriPremiumServices = function () {
        var accessEsriPremiumServices_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessEsriPremiumServices");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), accessEsriPremiumServices_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessEsriPremiumServices", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setAccessEsriPremiumServices = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var accessEsriPremiumServices_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessEsriPremiumServices");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, accessEsriPremiumServices_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessEsriPremiumServices", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getAccessMobileBI = function () {
        var accessMobileBI_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessMobileBI");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), accessMobileBI_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessMobileBI", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setAccessMobileBI = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var accessMobileBI_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessMobileBI");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, accessMobileBI_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessMobileBI", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getAccessVisualAnalyticsViewer = function () {
        var accessVisualAnalyticsViewer_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessVisualAnalyticsViewer");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), accessVisualAnalyticsViewer_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessVisualAnalyticsViewer", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setAccessVisualAnalyticsViewer = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var accessVisualAnalyticsViewer_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessVisualAnalyticsViewer");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, accessVisualAnalyticsViewer_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessVisualAnalyticsViewer", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getAccessVisualAnalytics = function () {
        var accessVisualAnalytics_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessVisualAnalytics");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), accessVisualAnalytics_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessVisualAnalytics", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setAccessVisualAnalytics = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var accessVisualAnalytics_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("accessVisualAnalytics");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, accessVisualAnalytics_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#accessVisualAnalytics", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getCacheMobileReportData = function () {
        var cacheMobileReportData_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("cacheMobileReportData");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), cacheMobileReportData_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#cacheMobileReportData", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setCacheMobileReportData = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var cacheMobileReportData_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("cacheMobileReportData");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, cacheMobileReportData_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#cacheMobileReportData", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getExemptFromOfflineTimeLimit = function () {
        var exemptFromOfflineTimeLimit_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exemptFromOfflineTimeLimit");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), exemptFromOfflineTimeLimit_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exemptFromOfflineTimeLimit", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setExemptFromOfflineTimeLimit = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var exemptFromOfflineTimeLimit_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exemptFromOfflineTimeLimit");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, exemptFromOfflineTimeLimit_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exemptFromOfflineTimeLimit", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getExemptFromPasscodeRequirements = function () {
        var exemptFromPasscodeRequirements_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exemptFromPasscodeRequirements");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), exemptFromPasscodeRequirements_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exemptFromPasscodeRequirements", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setExemptFromPasscodeRequirements = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var exemptFromPasscodeRequirements_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exemptFromPasscodeRequirements");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, exemptFromPasscodeRequirements_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exemptFromPasscodeRequirements", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getExportPDF = function () {
        var exportPDF_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exportPDF");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), exportPDF_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exportPDF", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setExportPDF = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var exportPDF_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exportPDF");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, exportPDF_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exportPDF", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getGetPreferences = function () {
        var getPreferences_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getPreferences");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), getPreferences_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getPreferences", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setGetPreferences = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var getPreferences_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getPreferences");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, getPreferences_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getPreferences", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getPutPreferences = function () {
        var putPreferences_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("putPreferences");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), putPreferences_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#putPreferences", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setPutPreferences = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var putPreferences_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("putPreferences");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, putPreferences_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#putPreferences", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getDeletePreferences = function () {
        var deletePreferences_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deletePreferences");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), deletePreferences_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deletePreferences", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setDeletePreferences = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var deletePreferences_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deletePreferences");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, deletePreferences_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deletePreferences", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getGetRecents = function () {
        var getRecents_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getRecents");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), getRecents_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getRecents", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setGetRecents = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var getRecents_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getRecents");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, getRecents_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getRecents", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getPostRecents = function () {
        var postRecents_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postRecents");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), postRecents_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postRecents", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setPostRecents = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var postRecents_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postRecents");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, postRecents_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postRecents", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getDeleteRecents = function () {
        var deleteRecents_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deleteRecents");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), deleteRecents_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deleteRecents", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setDeleteRecents = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var deleteRecents_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deleteRecents");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, deleteRecents_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deleteRecents", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getGetFavorites = function () {
        var getFavorites_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getFavorites");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), getFavorites_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getFavorites", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setGetFavorites = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var getFavorites_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getFavorites");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, getFavorites_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getFavorites", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getPostFavorites = function () {
        var postFavorites_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postFavorites");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), postFavorites_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postFavorites", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setPostFavorites = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var postFavorites_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postFavorites");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, postFavorites_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postFavorites", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getDeleteFavorites = function () {
        var deleteFavorites_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deleteFavorites");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), deleteFavorites_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deleteFavorites", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setDeleteFavorites = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var deleteFavorites_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deleteFavorites");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, deleteFavorites_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deleteFavorites", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getPostComments = function () {
        var postComments_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postComments");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), postComments_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postComments", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setPostComments = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var postComments_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postComments");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, postComments_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postComments", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getPostReportImages = function () {
        var postReportImages_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postReportImages");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), postReportImages_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postReportImages", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setPostReportImages = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var postReportImages_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postReportImages");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, postReportImages_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postReportImages", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getPostReportRenderer = function () {
        var postReportRenderer_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postReportRenderer");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), postReportRenderer_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postReportRenderer", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setPostReportRenderer = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var postReportRenderer_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postReportRenderer");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, postReportRenderer_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postReportRenderer", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getGetReportAlerts = function () {
        var getReportAlerts_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getReportAlerts");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), getReportAlerts_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getReportAlerts", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setGetReportAlerts = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var getReportAlerts_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getReportAlerts");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, getReportAlerts_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getReportAlerts", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getPostReportAlerts = function () {
        var postReportAlerts_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postReportAlerts");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), postReportAlerts_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postReportAlerts", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setPostReportAlerts = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var postReportAlerts_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postReportAlerts");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, postReportAlerts_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postReportAlerts", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getDeleteReportAlerts = function () {
        var deleteReportAlerts_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deleteReportAlerts");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), deleteReportAlerts_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deleteReportAlerts", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setDeleteReportAlerts = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var deleteReportAlerts_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deleteReportAlerts");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, deleteReportAlerts_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deleteReportAlerts", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getExportData = function () {
        var exportData_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exportData");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), exportData_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exportData", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setExportData = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var exportData_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exportData");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, exportData_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exportData", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getExportDetailData = function () {
        var exportDetailData_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exportDetailData");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), exportDetailData_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exportDetailData", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setExportDetailData = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var exportDetailData_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exportDetailData");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, exportDetailData_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exportDetailData", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getExportImages = function () {
        var exportImages_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exportImages");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), exportImages_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exportImages", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setExportImages = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var exportImages_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("exportImages");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, exportImages_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#exportImages", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getShareReport = function () {
        var shareReport_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shareReport");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), shareReport_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shareReport", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setShareReport = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var shareReport_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shareReport");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, shareReport_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shareReport", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getAllowWebContent = function () {
        var allowWebContent_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("allowWebContent");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), allowWebContent_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#allowWebContent", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setAllowWebContent = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var allowWebContent_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("allowWebContent");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, allowWebContent_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#allowWebContent", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getPostInterpretations = function () {
        var postInterpretations_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postInterpretations");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), postInterpretations_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postInterpretations", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setPostInterpretations = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var postInterpretations_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postInterpretations");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, postInterpretations_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postInterpretations", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getGetTextTemplatesOutput = function () {
        var getTextTemplatesOutput_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getTextTemplatesOutput");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), getTextTemplatesOutput_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getTextTemplatesOutput", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setGetTextTemplatesOutput = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var getTextTemplatesOutput_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getTextTemplatesOutput");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, getTextTemplatesOutput_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getTextTemplatesOutput", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getGetShares = function () {
        var getShares_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getShares");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), getShares_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getShares", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setGetShares = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var getShares_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("getShares");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, getShares_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#getShares", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AuthorizationContext.prototype.getPostShares = function () {
        var postShares_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postShares");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), postShares_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postShares", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AuthorizationContext.prototype.setPostShares = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var postShares_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("postShares");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, postShares_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AuthorizationContext)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#postShares", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    exports.default = AuthorizationContext;
});
