sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./MediaType", "sas/ltjs/commons/models/particles/Link", "./particles/AlertSubscriber", "./particles/AlertReportReference", "./particles/AlertSubscriptionInterval"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var AlertSubscription = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50016], EventDispatcher_1.default);
    /**
     *
     */
    AlertSubscription._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_AlertSubscription_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", "static", "new", "-->", "(transport::AlertSubscription)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    AlertSubscription.prototype.getId = function () {
        var id_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), id_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AlertSubscription.prototype.setId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var id_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("id");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, id_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#id", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {Array.<Link| null> | null}
     */
    AlertSubscription.prototype.getLinks = function () {
        var links_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), links_jni);
        //-- Convert abstract(<commons::Link>) from jni(size_t) to js(Link)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "-->", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<Link| null> | null} value
     *
     */
    AlertSubscription.prototype.setLinks = function (value) {
        //-- Convert abstract(<commons::Link>) from js(Link) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var links_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("links");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, links_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#links", "(MONITORED_VECTOR<commons::Link>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {string| null}
     */
    AlertSubscription.prototype.getCreatedBy = function () {
        var createdBy_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("createdBy");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), createdBy_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#createdBy", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AlertSubscription.prototype.setCreatedBy = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var createdBy_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("createdBy");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, createdBy_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#createdBy", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AlertSubscription.prototype.getCreationTimeStamp = function () {
        var creationTimeStamp_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("creationTimeStamp");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), creationTimeStamp_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#creationTimeStamp", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AlertSubscription.prototype.setCreationTimeStamp = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var creationTimeStamp_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("creationTimeStamp");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, creationTimeStamp_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#creationTimeStamp", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AlertSubscription.prototype.getModifiedBy = function () {
        var modifiedBy_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("modifiedBy");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), modifiedBy_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#modifiedBy", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AlertSubscription.prototype.setModifiedBy = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var modifiedBy_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("modifiedBy");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, modifiedBy_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#modifiedBy", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AlertSubscription.prototype.getModifiedTimeStamp = function () {
        var modifiedTimeStamp_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("modifiedTimeStamp");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), modifiedTimeStamp_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#modifiedTimeStamp", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AlertSubscription.prototype.setModifiedTimeStamp = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var modifiedTimeStamp_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("modifiedTimeStamp");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, modifiedTimeStamp_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#modifiedTimeStamp", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AlertSubscription.prototype.getLastQueriedTimeStamp = function () {
        var lastQueriedTimeStamp_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastQueriedTimeStamp");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), lastQueriedTimeStamp_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastQueriedTimeStamp", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AlertSubscription.prototype.setLastQueriedTimeStamp = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var lastQueriedTimeStamp_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastQueriedTimeStamp");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, lastQueriedTimeStamp_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastQueriedTimeStamp", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {Array.<AlertSubscriber| null> | null}
     */
    AlertSubscription.prototype.getSubscribers = function () {
        var subscribers_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("subscribers");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), subscribers_jni);
        //-- Convert abstract(<transport::AlertSubscriber>) from jni(size_t) to js(AlertSubscriber)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#subscribers", "-->", "(MONITORED_VECTOR<transport::AlertSubscriber>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<AlertSubscriber| null> | null} value
     *
     */
    AlertSubscription.prototype.setSubscribers = function (value) {
        //-- Convert abstract(<transport::AlertSubscriber>) from js(AlertSubscriber) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var subscribers_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("subscribers");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, subscribers_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#subscribers", "(MONITORED_VECTOR<transport::AlertSubscriber>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {AlertReportReference| null}
     */
    AlertSubscription.prototype.getReport = function () {
        var report_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("report");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::AlertReportReference) from jni(size_t) to js(AlertReportReference)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#report", "-->", "(transport::AlertReportReference)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {AlertReportReference| null} value
     *
     */
    AlertSubscription.prototype.setReport = function (value) {
        //-- Convert abstract(transport::AlertReportReference) from js(AlertReportReference) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var report_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("report");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, report_name_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#report", "(transport::AlertReportReference)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    AlertSubscription.prototype.getAlertableConditionName = function () {
        var alertableConditionName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("alertableConditionName");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), alertableConditionName_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#alertableConditionName", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    AlertSubscription.prototype.setAlertableConditionName = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var alertableConditionName_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("alertableConditionName");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, alertableConditionName_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#alertableConditionName", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {AlertSubscriptionInterval| null}
     */
    AlertSubscription.prototype.getEvaluation = function () {
        var evaluation_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("evaluation");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), evaluation_jni);
        //-- Convert abstract(transport::AlertSubscriptionInterval) from jni(size_t) to js(AlertSubscriptionInterval)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#evaluation", "-->", "(transport::AlertSubscriptionInterval)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {AlertSubscriptionInterval| null} value
     *
     */
    AlertSubscription.prototype.setEvaluation = function (value) {
        //-- Convert abstract(transport::AlertSubscriptionInterval) from js(AlertSubscriptionInterval) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var evaluation_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("evaluation");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, evaluation_name_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#evaluation", "(transport::AlertSubscriptionInterval)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {AlertSubscriptionInterval| null}
     */
    AlertSubscription.prototype.getNotification = function () {
        var notification_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("notification");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), notification_jni);
        //-- Convert abstract(transport::AlertSubscriptionInterval) from jni(size_t) to js(AlertSubscriptionInterval)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#notification", "-->", "(transport::AlertSubscriptionInterval)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {AlertSubscriptionInterval| null} value
     *
     */
    AlertSubscription.prototype.setNotification = function (value) {
        //-- Convert abstract(transport::AlertSubscriptionInterval) from js(AlertSubscriptionInterval) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var notification_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("notification");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, notification_name_jni);
        Module.deps['TraceUtil'].log("(transport::AlertSubscription)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#notification", "(transport::AlertSubscriptionInterval)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    exports.default = AlertSubscription;
});
