sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./Connection"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var SubscribedCollection = ltjsEnvironment_1.createModule([114, 13, 50265, 50256], EventDispatcher_1.default);
    SubscribedCollection.COLLECTION_DELETED = 60076;
    SubscribedCollection.COLLECTION_UPDATED = 60077;
    /**
     *
     */
    SubscribedCollection._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_SubscribedCollection_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::SubscribedCollection)", "static", "new", "-->", "(transport::SubscribedCollection)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    SubscribedCollection.prototype.getUuid = function () {
        var uuid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("uuid");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), uuid_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::SubscribedCollection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#uuid", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    SubscribedCollection.prototype.setUuid = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var uuid_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("uuid");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, uuid_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::SubscribedCollection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#uuid", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    SubscribedCollection.prototype.getLocation = function () {
        var location_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("location");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), location_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::SubscribedCollection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#location", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    SubscribedCollection.prototype.setLocation = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var location_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("location");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, location_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::SubscribedCollection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#location", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {Connection| null}
     */
    SubscribedCollection.prototype.getConnection = function () {
        var connection_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("connection");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::Connection) from jni(size_t) to js(Connection)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::SubscribedCollection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#connection", "-->", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} value
     *
     */
    SubscribedCollection.prototype.setConnection = function (value) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var connection_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("connection");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, connection_name_jni);
        Module.deps['TraceUtil'].log("(transport::SubscribedCollection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#connection", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    SubscribedCollection.prototype.getIsZombie = function () {
        var isZombie_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isZombie");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), isZombie_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::SubscribedCollection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isZombie", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    SubscribedCollection.prototype.setIsZombie = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var isZombie_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isZombie");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, isZombie_name_jni);
        Module.deps['TraceUtil'].log("(transport::SubscribedCollection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isZombie", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    exports.default = SubscribedCollection;
});
