sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "sas/ltjs/transport/models/media/ReportStateInfo"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportStateContainer = ltjsEnvironment_1.createModule([114, 13, 50265, 50218], EventDispatcher_1.default);
    /**
     *
     */
    ReportStateContainer._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportStateContainer_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportStateContainer)", "static", "new", "-->", "(transport::ReportStateContainer)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    ReportStateContainer.prototype.getState = function () {
        var state_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("state");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), state_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportStateContainer)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#state", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportStateContainer.prototype.setState = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var state_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("state");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, state_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportStateContainer)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#state", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {ReportStateInfo| null}
     */
    ReportStateContainer.prototype.getStateInfo = function () {
        var stateInfo_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("stateInfo");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), stateInfo_jni);
        //-- Convert abstract(transport::ReportStateInfo) from jni(size_t) to js(ReportStateInfo)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportStateContainer)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#stateInfo", "-->", "(transport::ReportStateInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {ReportStateInfo| null} value
     *
     */
    ReportStateContainer.prototype.setStateInfo = function (value) {
        //-- Convert abstract(transport::ReportStateInfo) from js(ReportStateInfo) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var stateInfo_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("stateInfo");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, stateInfo_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportStateContainer)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#stateInfo", "(transport::ReportStateInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportStateContainer.prototype.getStateUri = function () {
        var stateUri_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("stateUri");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), stateUri_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportStateContainer)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#stateUri", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportStateContainer.prototype.setStateUri = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var stateUri_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("stateUri");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, stateUri_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportStateContainer)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#stateUri", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    exports.default = ReportStateContainer;
});
