sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./TransportModelReference"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportCollectionOwner = ltjsEnvironment_1.createModule([114, 13, 50265, 50191], EventDispatcher_1.default);
    /**
     *
     */
    ReportCollectionOwner._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportCollectionOwner_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportCollectionOwner)", "static", "new", "-->", "(transport::ReportCollectionOwner)", rc);
        return rc;
    };
    /**
     * @return {Array.<TransportModelReference| null> | null}
     */
    ReportCollectionOwner.prototype.getReportReferences = function () {
        var reportReferences_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportReferences");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), reportReferences_jni);
        //-- Convert abstract(<transport::TransportModelReference>) from jni(size_t) to js(TransportModelReference)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportCollectionOwner)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportReferences", "-->", "(MONITORED_VECTOR<transport::TransportModelReference>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<TransportModelReference| null> | null} value
     *
     */
    ReportCollectionOwner.prototype.setReportReferences = function (value) {
        //-- Convert abstract(<transport::TransportModelReference>) from js(TransportModelReference) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var reportReferences_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportReferences");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, reportReferences_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportCollectionOwner)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportReferences", "(MONITORED_VECTOR<transport::TransportModelReference>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @param {Report| null} report
     * @return {TransportModelReference| null}
     */
    ReportCollectionOwner.prototype.getReferenceToReport = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportCollectionOwner_getReferenceToReport(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::TransportModelReference) from jni(size_t) to js(TransportModelReference)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportCollectionOwner)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getReferenceToReport", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(transport::TransportModelReference)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {BaseReport| null} report
     * @return {TransportModelReference| null}
     */
    ReportCollectionOwner.prototype.getReferenceToBaseReport = function (report) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportCollectionOwner_getReferenceToBaseReport(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::TransportModelReference) from jni(size_t) to js(TransportModelReference)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportCollectionOwner)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getReferenceToBaseReport", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(transport::TransportModelReference)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    exports.default = ReportCollectionOwner;
});
