sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportAuxiliary = ltjsEnvironment_1.createModule([114, 13, 50265, 50189], EventDispatcher_1.default);
    /**
     *
     */
    ReportAuxiliary._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportAuxiliary_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportAuxiliary)", "static", "new", "-->", "(transport::ReportAuxiliary)", rc);
        return rc;
    };
    /**
     * @return {number}
     */
    ReportAuxiliary.prototype.getSectionCount = function () {
        var sectionCount_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sectionCount");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), sectionCount_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportAuxiliary)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sectionCount", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ReportAuxiliary.prototype.setSectionCount = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var sectionCount_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sectionCount");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, sectionCount_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAuxiliary)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sectionCount", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ReportAuxiliary.prototype.getSectionNames = function () {
        var sectionNames_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sectionNames");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), sectionNames_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAuxiliary)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sectionNames", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    ReportAuxiliary.prototype.setSectionNames = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var sectionNames_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sectionNames");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, sectionNames_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAuxiliary)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sectionNames", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {number}
     */
    ReportAuxiliary.prototype.getGeneratedPreviewCount = function () {
        var generatedPreviewCount_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("generatedPreviewCount");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), generatedPreviewCount_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportAuxiliary)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#generatedPreviewCount", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ReportAuxiliary.prototype.setGeneratedPreviewCount = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var generatedPreviewCount_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("generatedPreviewCount");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, generatedPreviewCount_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAuxiliary)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#generatedPreviewCount", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    ReportAuxiliary.prototype.getFinishedGeneratingPreviews = function () {
        var finishedGeneratingPreviews_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("finishedGeneratingPreviews");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), finishedGeneratingPreviews_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportAuxiliary)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#finishedGeneratingPreviews", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    ReportAuxiliary.prototype.setFinishedGeneratingPreviews = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var finishedGeneratingPreviews_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("finishedGeneratingPreviews");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, finishedGeneratingPreviews_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAuxiliary)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#finishedGeneratingPreviews", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    ReportAuxiliary.prototype.getSerializeToFile = function () {
        var serializeToFile_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("serializeToFile");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), serializeToFile_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportAuxiliary)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#serializeToFile", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    ReportAuxiliary.prototype.setSerializeToFile = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var serializeToFile_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("serializeToFile");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, serializeToFile_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAuxiliary)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#serializeToFile", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportAuxiliary.prototype.getTextTemplateSummary = function () {
        var textTemplateSummary_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("textTemplateSummary");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), textTemplateSummary_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAuxiliary)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#textTemplateSummary", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportAuxiliary.prototype.setTextTemplateSummary = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var textTemplateSummary_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("textTemplateSummary");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, textTemplateSummary_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAuxiliary)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#textTemplateSummary", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    exports.default = ReportAuxiliary;
});
