sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "sas/ltjs/transport/models/media/particles/ReportAssetURL", "./Report"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportAsset = ltjsEnvironment_1.createModule([114, 13, 50265, 50187], EventDispatcher_1.default);
    /**
     *
     */
    ReportAsset._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportAsset_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportAsset)", "static", "new", "-->", "(transport::ReportAsset)", rc);
        return rc;
    };
    /**
     * @return {ReportAssetURL| null}
     */
    ReportAsset.prototype.getUrl = function () {
        var url_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("url");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), url_jni);
        //-- Convert abstract(transport::ReportAssetURL) from jni(size_t) to js(ReportAssetURL)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAsset)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#url", "-->", "(transport::ReportAssetURL)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {ReportAssetURL| null} value
     *
     */
    ReportAsset.prototype.setUrl = function (value) {
        //-- Convert abstract(transport::ReportAssetURL) from js(ReportAssetURL) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var url_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("url");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, url_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAsset)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#url", "(transport::ReportAssetURL)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportAsset.prototype.getLocalPath = function () {
        var localPath_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("localPath");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), localPath_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAsset)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#localPath", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportAsset.prototype.setLocalPath = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var localPath_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("localPath");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, localPath_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAsset)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#localPath", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    ReportAsset.prototype.getNumberOfDownloadAttempts = function () {
        var numberOfDownloadAttempts_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("numberOfDownloadAttempts");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), numberOfDownloadAttempts_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportAsset)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#numberOfDownloadAttempts", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ReportAsset.prototype.setNumberOfDownloadAttempts = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var numberOfDownloadAttempts_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("numberOfDownloadAttempts");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, numberOfDownloadAttempts_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAsset)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#numberOfDownloadAttempts", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    ReportAsset.prototype.getIsDownloadInProgress = function () {
        var isDownloadInProgress_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isDownloadInProgress");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), isDownloadInProgress_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportAsset)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isDownloadInProgress", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    ReportAsset.prototype.setIsDownloadInProgress = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var isDownloadInProgress_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isDownloadInProgress");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, isDownloadInProgress_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAsset)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isDownloadInProgress", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {number}
     */
    ReportAsset.prototype.getDownloadSize = function () {
        var downloadSize_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("downloadSize");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), downloadSize_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportAsset)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#downloadSize", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ReportAsset.prototype.setDownloadSize = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var downloadSize_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("downloadSize");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, downloadSize_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAsset)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#downloadSize", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    ReportAsset.prototype.getDownloadedAmount = function () {
        var downloadedAmount_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("downloadedAmount");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), downloadedAmount_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportAsset)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#downloadedAmount", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ReportAsset.prototype.setDownloadedAmount = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var downloadedAmount_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("downloadedAmount");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, downloadedAmount_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAsset)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#downloadedAmount", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportAsset.prototype.getLastContentKey = function () {
        var lastContentKey_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastContentKey");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), lastContentKey_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAsset)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastContentKey", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportAsset.prototype.setLastContentKey = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var lastContentKey_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastContentKey");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, lastContentKey_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAsset)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastContentKey", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    ReportAsset.prototype.getLastAttemptTime = function () {
        var lastAttemptTime_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastAttemptTime");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getSASDatetimeProperty(this._getValidClosetAddress(), lastAttemptTime_jni);
        //-- Convert abstract(commons::SASDATETIME) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportAsset)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastAttemptTime", "-->", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ReportAsset.prototype.setLastAttemptTime = function (value) {
        //-- Convert abstract(commons::SASDATETIME) from js(number) to jni(double)
        var value_jni = value;
        var lastAttemptTime_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastAttemptTime");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setSASDatetimeProperty(this._getValidClosetAddress(), value_jni, lastAttemptTime_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAsset)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastAttemptTime", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @return {Report| null}
     */
    ReportAsset.prototype.getReport = function () {
        var report_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("report");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::Report) from jni(size_t) to js(Report)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAsset)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#report", "-->", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Report| null} value
     *
     */
    ReportAsset.prototype.setReport = function (value) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var report_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("report");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, report_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportAsset)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#report", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    exports.default = ReportAsset;
});
