sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./BaseReport", "sas/ltjs/transport/models/media/ReportManifest", "./DownloadStatus", "./DisplayRecord", "./UpdateCharacteristic", "sas/ltjs/transport/models/media/AlertableElement", "sas/ltjs/transport/models/media/particles/Duid", "./ReportAuxiliary"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Report = ltjsEnvironment_1.createModule([114, 13, 50265, 50029, 50186], EventDispatcher_1.default);
    Report.DOWNLOAD_COMPLETED = 60064;
    Report.DOWNLOAD_STARTED = 60065;
    Report.THUMBNAIL_GENERATED = 60066;
    /**
     *
     */
    Report._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Report_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Report)", "static", "new", "-->", "(transport::Report)", rc);
        return rc;
    };
    /**
     * @return {boolean}
     */
    Report.prototype.getIsFavorite = function () {
        var isFavorite_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isFavorite");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), isFavorite_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isFavorite", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    Report.prototype.setIsFavorite = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var isFavorite_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isFavorite");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, isFavorite_name_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isFavorite", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {number}
     */
    Report.prototype.getFavoritesCounter = function () {
        var favoritesCounter_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("favoritesCounter");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getUnsignedProperty(this._getValidClosetAddress(), favoritesCounter_jni);
        //-- Convert abstract(commons::UNSIGNED) from jni(int) to js(number)
        var rc = rc_jni >>> 0;
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#favoritesCounter", "-->", "(commons::UNSIGNED)", Module.deps['TraceUtil'].traceConversions.convertUnsigned(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    Report.prototype.setFavoritesCounter = function (value) {
        //-- Convert abstract(commons::UNSIGNED) from js(number) to jni(int)
        var value_jni = value;
        var favoritesCounter_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("favoritesCounter");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setUnsignedProperty(this._getValidClosetAddress(), value_jni, favoritesCounter_name_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#favoritesCounter", "(commons::UNSIGNED)", Module.deps['TraceUtil'].traceConversions.convertUnsigned(value));
        return this;
    };
    /**
     * @return {ReportManifest| null}
     */
    Report.prototype.getManifest = function () {
        var manifest_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("manifest");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), manifest_jni);
        //-- Convert abstract(transport::ReportManifest) from jni(size_t) to js(ReportManifest)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#manifest", "-->", "(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {ReportManifest| null} value
     *
     */
    Report.prototype.setManifest = function (value) {
        //-- Convert abstract(transport::ReportManifest) from js(ReportManifest) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var manifest_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("manifest");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, manifest_name_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#manifest", "(transport::ReportManifest)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {DownloadStatus| null}
     */
    Report.prototype.getDownloadStatus = function () {
        var downloadStatus_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("downloadStatus");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), downloadStatus_jni);
        //-- Convert abstract(transport::DownloadStatus) from jni(size_t) to js(DownloadStatus)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#downloadStatus", "-->", "(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {DownloadStatus| null} value
     *
     */
    Report.prototype.setDownloadStatus = function (value) {
        //-- Convert abstract(transport::DownloadStatus) from js(DownloadStatus) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var downloadStatus_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("downloadStatus");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, downloadStatus_name_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#downloadStatus", "(transport::DownloadStatus)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {DisplayRecord| null}
     */
    Report.prototype.getDisplayRecord = function () {
        var displayRecord_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("displayRecord");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), displayRecord_jni);
        //-- Convert abstract(transport::DisplayRecord) from jni(size_t) to js(DisplayRecord)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#displayRecord", "-->", "(transport::DisplayRecord)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {DisplayRecord| null} value
     *
     */
    Report.prototype.setDisplayRecord = function (value) {
        //-- Convert abstract(transport::DisplayRecord) from js(DisplayRecord) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var displayRecord_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("displayRecord");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, displayRecord_name_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#displayRecord", "(transport::DisplayRecord)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {UpdateCharacteristic}
     */
    Report.prototype.getUpdateCharacteristic = function () {
        var updateCharacteristic_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("updateCharacteristic");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), updateCharacteristic_jni);
        //-- Convert abstract(transport::UpdateCharacteristic) from jni(int) to js(UpdateCharacteristic)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#updateCharacteristic", "-->", "(transport::UpdateCharacteristic::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {UpdateCharacteristic} value
     *
     */
    Report.prototype.setUpdateCharacteristic = function (value) {
        //-- Convert abstract(transport::UpdateCharacteristic) from js(UpdateCharacteristic) to jni(int)
        var value_jni = value;
        var updateCharacteristic_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("updateCharacteristic");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, updateCharacteristic_name_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#updateCharacteristic", "(transport::UpdateCharacteristic::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {Array.<AlertableElement| null> | null}
     */
    Report.prototype.getAlertableItems = function () {
        var alertableItems_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("alertableItems");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), alertableItems_jni);
        //-- Convert abstract(<transport::AlertableElement>) from jni(size_t) to js(AlertableElement)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#alertableItems", "-->", "(MONITORED_VECTOR<transport::AlertableElement>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<AlertableElement| null> | null} value
     *
     */
    Report.prototype.setAlertableItems = function (value) {
        //-- Convert abstract(<transport::AlertableElement>) from js(AlertableElement) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var alertableItems_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("alertableItems");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, alertableItems_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#alertableItems", "(MONITORED_VECTOR<transport::AlertableElement>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {Array.<Duid| null> | null}
     */
    Report.prototype.getDuids = function () {
        var duids_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("duids");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), duids_jni);
        //-- Convert abstract(<transport::Duid>) from jni(size_t) to js(Duid)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#duids", "-->", "(MONITORED_VECTOR<transport::Duid>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<Duid| null> | null} value
     *
     */
    Report.prototype.setDuids = function (value) {
        //-- Convert abstract(<transport::Duid>) from js(Duid) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var duids_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("duids");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, duids_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#duids", "(MONITORED_VECTOR<transport::Duid>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {ReportAuxiliary| null}
     */
    Report.prototype.getAuxiliary = function () {
        var auxiliary_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("auxiliary");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), auxiliary_jni);
        //-- Convert abstract(transport::ReportAuxiliary) from jni(size_t) to js(ReportAuxiliary)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#auxiliary", "-->", "(transport::ReportAuxiliary)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {ReportAuxiliary| null} value
     *
     */
    Report.prototype.setAuxiliary = function (value) {
        //-- Convert abstract(transport::ReportAuxiliary) from js(ReportAuxiliary) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var auxiliary_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("auxiliary");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, auxiliary_name_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#auxiliary", "(transport::ReportAuxiliary)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    Report.prototype.getIsZombie = function () {
        var isZombie_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isZombie");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), isZombie_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isZombie", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    Report.prototype.setIsZombie = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var isZombie_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("isZombie");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, isZombie_name_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#isZombie", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    Report.prototype.getParentCollections = function () {
        var parentCollections_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("parentCollections");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringVectorProperty(this._getValidClosetAddress(), parentCollections_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#parentCollections", "-->", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {Array.<string| null> | null} value
     *
     */
    Report.prototype.setParentCollections = function (value) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(value);
        var parentCollections_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("parentCollections");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringVectorProperty(this._getValidClosetAddress(), value_jni, parentCollections_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(value_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#parentCollections", "(MONITORED_VECTOR<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertString));
        return this;
    };
    /**
     * @return {number}
     */
    Report.prototype.getGlobalLastViewed = function () {
        var globalLastViewed_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("globalLastViewed");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getSASDatetimeProperty(this._getValidClosetAddress(), globalLastViewed_jni);
        //-- Convert abstract(commons::SASDATETIME) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#globalLastViewed", "-->", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    Report.prototype.setGlobalLastViewed = function (value) {
        //-- Convert abstract(commons::SASDATETIME) from js(number) to jni(double)
        var value_jni = value;
        var globalLastViewed_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("globalLastViewed");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setSASDatetimeProperty(this._getValidClosetAddress(), value_jni, globalLastViewed_name_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#globalLastViewed", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    Report.prototype.getHasIgnoredChange = function () {
        var hasIgnoredChange_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("hasIgnoredChange");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), hasIgnoredChange_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#hasIgnoredChange", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    Report.prototype.setHasIgnoredChange = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var hasIgnoredChange_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("hasIgnoredChange");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, hasIgnoredChange_name_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#hasIgnoredChange", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {any| null}
     */
    Report.prototype.getOriginReport = function () {
        var originReport_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("originReport");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), originReport_jni);
        //-- Convert abstract(transport::Report) from jni(size_t) to js(Report)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#originReport", "-->", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {any| null} value
     *
     */
    Report.prototype.setOriginReport = function (value) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var originReport_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("originReport");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, originReport_name_jni);
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#originReport", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @param {string| null} destinationPath
     * @return {boolean}
     */
    Report.prototype.saveManifest = function (destinationPath) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var destinationPath_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(destinationPath);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Report_saveManifest(this._getValidClosetAddress(), destinationPath_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(destinationPath_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "saveManifest", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(destinationPath), "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {string| null} sourcePath
     * @return {boolean}
     */
    Report.prototype.restoreManifest = function (sourcePath) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var sourcePath_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(sourcePath);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Report_restoreManifest(this._getValidClosetAddress(), sourcePath_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(sourcePath_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "restoreManifest", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(sourcePath), "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    exports.default = Report;
});
