sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./Folder"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var FolderCollection = ltjsEnvironment_1.createModule([114, 13, 50265, 50113], EventDispatcher_1.default);
    /**
     *
     */
    FolderCollection._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FolderCollection_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::FolderCollection)", "static", "new", "-->", "(transport::FolderCollection)", rc);
        return rc;
    };
    /**
     * @return {Array.<Folder| null> | null}
     */
    FolderCollection.prototype.getFolders = function () {
        var folders_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("folders");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), folders_jni);
        //-- Convert abstract(<transport::Folder>) from jni(size_t) to js(Folder)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderCollection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#folders", "-->", "(MONITORED_VECTOR<transport::Folder>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<Folder| null> | null} value
     *
     */
    FolderCollection.prototype.setFolders = function (value) {
        //-- Convert abstract(<transport::Folder>) from js(Folder) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var folders_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("folders");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, folders_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::FolderCollection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#folders", "(MONITORED_VECTOR<transport::Folder>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = FolderCollection;
});
