sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./Server", "sas/ltjs/transport/models/media/UserInfo", "sas/ltjs/transport/models/media/particles/LogonStatus", "sas/ltjs/transport/models/media/particles/EsriLogonStatus", "sas/ltjs/transport/models/media/particles/EsriPortalLogonStatus", "sas/ltjs/transport/models/media/particles/ReportImageSize"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Connection = ltjsEnvironment_1.createModule([114, 13, 50265, 50069], EventDispatcher_1.default);
    /**
     *
     */
    Connection._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Connection_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Connection)", "static", "new", "-->", "(transport::Connection)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    Connection.prototype.getUuid = function () {
        var uuid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("uuid");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), uuid_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#uuid", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Connection.prototype.setUuid = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var uuid_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("uuid");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, uuid_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#uuid", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {Server| null}
     */
    Connection.prototype.getServer = function () {
        var server_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("server");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), server_jni);
        //-- Convert abstract(transport::Server) from jni(size_t) to js(Server)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#server", "-->", "(transport::Server)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Server| null} value
     *
     */
    Connection.prototype.setServer = function (value) {
        //-- Convert abstract(transport::Server) from js(Server) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var server_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("server");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, server_name_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#server", "(transport::Server)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Connection.prototype.getUserId = function () {
        var userId_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("userId");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), userId_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#userId", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Connection.prototype.setUserId = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var userId_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("userId");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, userId_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#userId", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Connection.prototype.getPasswordKey = function () {
        var passwordKey_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("passwordKey");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), passwordKey_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#passwordKey", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Connection.prototype.setPasswordKey = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var passwordKey_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("passwordKey");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, passwordKey_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#passwordKey", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Connection.prototype.getPassword = function () {
        var password_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("password");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), password_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#password", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Connection.prototype.setPassword = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var password_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("password");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, password_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#password", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Connection.prototype.getAuthToken = function () {
        var authToken_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("authToken");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), authToken_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#authToken", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Connection.prototype.setAuthToken = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var authToken_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("authToken");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, authToken_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#authToken", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    Connection.prototype.getUseGuestCredentials = function () {
        var useGuestCredentials_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("useGuestCredentials");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), useGuestCredentials_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#useGuestCredentials", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    Connection.prototype.setUseGuestCredentials = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var useGuestCredentials_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("useGuestCredentials");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, useGuestCredentials_name_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#useGuestCredentials", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    Connection.prototype.getShouldAutoConnect = function () {
        var shouldAutoConnect_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldAutoConnect");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), shouldAutoConnect_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldAutoConnect", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    Connection.prototype.setShouldAutoConnect = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var shouldAutoConnect_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldAutoConnect");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, shouldAutoConnect_name_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldAutoConnect", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Connection.prototype.getDescription = function () {
        var description_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("description");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), description_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#description", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Connection.prototype.setDescription = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var description_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("description");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, description_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#description", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {UserInfo| null}
     */
    Connection.prototype.getUserInfo = function () {
        var userInfo_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("userInfo");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), userInfo_jni);
        //-- Convert abstract(transport::UserInfo) from jni(size_t) to js(UserInfo)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#userInfo", "-->", "(transport::UserInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {UserInfo| null} value
     *
     */
    Connection.prototype.setUserInfo = function (value) {
        //-- Convert abstract(transport::UserInfo) from js(UserInfo) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var userInfo_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("userInfo");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, userInfo_name_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#userInfo", "(transport::UserInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    Connection.prototype.getSessionToken = function () {
        var sessionToken_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sessionToken");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), sessionToken_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sessionToken", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    Connection.prototype.setSessionToken = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var sessionToken_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("sessionToken");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, sessionToken_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#sessionToken", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {LogonStatus}
     */
    Connection.prototype.getLogonStatus = function () {
        var logonStatus_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("logonStatus");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), logonStatus_jni);
        //-- Convert abstract(transport::LogonStatus) from jni(int) to js(LogonStatus)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#logonStatus", "-->", "(transport::LogonStatus::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {LogonStatus} value
     *
     */
    Connection.prototype.setLogonStatus = function (value) {
        //-- Convert abstract(transport::LogonStatus) from js(LogonStatus) to jni(int)
        var value_jni = value;
        var logonStatus_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("logonStatus");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, logonStatus_name_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#logonStatus", "(transport::LogonStatus::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {EsriLogonStatus}
     */
    Connection.prototype.getEsriLogonStatus = function () {
        var esriLogonStatus_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("esriLogonStatus");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), esriLogonStatus_jni);
        //-- Convert abstract(transport::EsriLogonStatus) from jni(int) to js(EsriLogonStatus)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#esriLogonStatus", "-->", "(transport::EsriLogonStatus::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {EsriLogonStatus} value
     *
     */
    Connection.prototype.setEsriLogonStatus = function (value) {
        //-- Convert abstract(transport::EsriLogonStatus) from js(EsriLogonStatus) to jni(int)
        var value_jni = value;
        var esriLogonStatus_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("esriLogonStatus");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, esriLogonStatus_name_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#esriLogonStatus", "(transport::EsriLogonStatus::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {EsriPortalLogonStatus}
     */
    Connection.prototype.getEsriPortalLogonStatus = function () {
        var esriPortalLogonStatus_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("esriPortalLogonStatus");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), esriPortalLogonStatus_jni);
        //-- Convert abstract(transport::EsriPortalLogonStatus) from jni(int) to js(EsriPortalLogonStatus)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#esriPortalLogonStatus", "-->", "(transport::EsriPortalLogonStatus::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {EsriPortalLogonStatus} value
     *
     */
    Connection.prototype.setEsriPortalLogonStatus = function (value) {
        //-- Convert abstract(transport::EsriPortalLogonStatus) from js(EsriPortalLogonStatus) to jni(int)
        var value_jni = value;
        var esriPortalLogonStatus_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("esriPortalLogonStatus");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, esriPortalLogonStatus_name_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#esriPortalLogonStatus", "(transport::EsriPortalLogonStatus::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {number}
     */
    Connection.prototype.getLastSuccessfulLogon = function () {
        var lastSuccessfulLogon_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastSuccessfulLogon");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getSASDatetimeProperty(this._getValidClosetAddress(), lastSuccessfulLogon_jni);
        //-- Convert abstract(commons::SASDATETIME) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastSuccessfulLogon", "-->", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    Connection.prototype.setLastSuccessfulLogon = function (value) {
        //-- Convert abstract(commons::SASDATETIME) from js(number) to jni(double)
        var value_jni = value;
        var lastSuccessfulLogon_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastSuccessfulLogon");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setSASDatetimeProperty(this._getValidClosetAddress(), value_jni, lastSuccessfulLogon_name_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastSuccessfulLogon", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @return {number}
     */
    Connection.prototype.getLastSuccessfulServerCommunication = function () {
        var lastSuccessfulServerCommunication_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastSuccessfulServerCommunication");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getSASDatetimeProperty(this._getValidClosetAddress(), lastSuccessfulServerCommunication_jni);
        //-- Convert abstract(commons::SASDATETIME) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastSuccessfulServerCommunication", "-->", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    Connection.prototype.setLastSuccessfulServerCommunication = function (value) {
        //-- Convert abstract(commons::SASDATETIME) from js(number) to jni(double)
        var value_jni = value;
        var lastSuccessfulServerCommunication_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("lastSuccessfulServerCommunication");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setSASDatetimeProperty(this._getValidClosetAddress(), value_jni, lastSuccessfulServerCommunication_name_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#lastSuccessfulServerCommunication", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    Connection.prototype.getUseEsriPremiumServices = function () {
        var useEsriPremiumServices_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("useEsriPremiumServices");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), useEsriPremiumServices_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#useEsriPremiumServices", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    Connection.prototype.setUseEsriPremiumServices = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var useEsriPremiumServices_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("useEsriPremiumServices");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, useEsriPremiumServices_name_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#useEsriPremiumServices", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {number}
     */
    Connection.prototype.getCredentialStorageVersion = function () {
        var credentialStorageVersion_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("credentialStorageVersion");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), credentialStorageVersion_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#credentialStorageVersion", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    Connection.prototype.setCredentialStorageVersion = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var credentialStorageVersion_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("credentialStorageVersion");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, credentialStorageVersion_name_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#credentialStorageVersion", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    Connection.prototype.getOverrideReportImageSizes = function () {
        var overrideReportImageSizes_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("overrideReportImageSizes");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), overrideReportImageSizes_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#overrideReportImageSizes", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    Connection.prototype.setOverrideReportImageSizes = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var overrideReportImageSizes_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("overrideReportImageSizes");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, overrideReportImageSizes_name_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#overrideReportImageSizes", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {ReportImageSize}
     */
    Connection.prototype.getReportImageDefaultSize = function () {
        var reportImageDefaultSize_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportImageDefaultSize");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), reportImageDefaultSize_jni);
        //-- Convert abstract(transport::ReportImageSize) from jni(int) to js(ReportImageSize)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportImageDefaultSize", "-->", "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {ReportImageSize} value
     *
     */
    Connection.prototype.setReportImageDefaultSize = function (value) {
        //-- Convert abstract(transport::ReportImageSize) from js(ReportImageSize) to jni(int)
        var value_jni = value;
        var reportImageDefaultSize_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportImageDefaultSize");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, reportImageDefaultSize_name_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportImageDefaultSize", "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {ReportImageSize}
     */
    Connection.prototype.getReportSectionImageDefaultSize = function () {
        var reportSectionImageDefaultSize_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportSectionImageDefaultSize");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), reportSectionImageDefaultSize_jni);
        //-- Convert abstract(transport::ReportImageSize) from jni(int) to js(ReportImageSize)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportSectionImageDefaultSize", "-->", "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {ReportImageSize} value
     *
     */
    Connection.prototype.setReportSectionImageDefaultSize = function (value) {
        //-- Convert abstract(transport::ReportImageSize) from js(ReportImageSize) to jni(int)
        var value_jni = value;
        var reportSectionImageDefaultSize_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportSectionImageDefaultSize");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, reportSectionImageDefaultSize_name_jni);
        Module.deps['TraceUtil'].log("(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportSectionImageDefaultSize", "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    exports.default = Connection;
});
