sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "sas/ltjs/transport/models/media/cas/CASServerItem", "./CASLibrary"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CASServer = ltjsEnvironment_1.createModule([114, 13, 50265, 50040], EventDispatcher_1.default);
    /**
     *
     */
    CASServer._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CASServer_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CASServer)", "static", "new", "-->", "(transport::CASServer)", rc);
        return rc;
    };
    /**
     * @return {CASServerItem| null}
     */
    CASServer.prototype.getDetails = function () {
        var details_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("details");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), details_jni);
        //-- Convert abstract(transport::CASServerItem) from jni(size_t) to js(CASServerItem)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CASServer)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#details", "-->", "(transport::CASServerItem)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {CASServerItem| null} value
     *
     */
    CASServer.prototype.setDetails = function (value) {
        //-- Convert abstract(transport::CASServerItem) from js(CASServerItem) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var details_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("details");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, details_name_jni);
        Module.deps['TraceUtil'].log("(transport::CASServer)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#details", "(transport::CASServerItem)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {Array.<CASLibrary| null> | null}
     */
    CASServer.prototype.getLibs = function () {
        var libs_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("libs");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), libs_jni);
        //-- Convert abstract(<transport::CASLibrary>) from jni(size_t) to js(CASLibrary)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CASServer)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#libs", "-->", "(MONITORED_VECTOR<transport::CASLibrary>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<CASLibrary| null> | null} value
     *
     */
    CASServer.prototype.setLibs = function (value) {
        //-- Convert abstract(<transport::CASLibrary>) from js(CASLibrary) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var libs_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("libs");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, libs_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CASServer)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#libs", "(MONITORED_VECTOR<transport::CASLibrary>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = CASServer;
});
