sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./CASServer"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CASInstance = ltjsEnvironment_1.createModule([114, 13, 50265, 50035], EventDispatcher_1.default);
    /**
     *
     */
    CASInstance._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CASInstance_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CASInstance)", "static", "new", "-->", "(transport::CASInstance)", rc);
        return rc;
    };
    /**
     * @return {Array.<CASServer| null> | null}
     */
    CASInstance.prototype.getServers = function () {
        var servers_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("servers");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), servers_jni);
        //-- Convert abstract(<transport::CASServer>) from jni(size_t) to js(CASServer)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CASInstance)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#servers", "-->", "(MONITORED_VECTOR<transport::CASServer>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<CASServer| null> | null} value
     *
     */
    CASInstance.prototype.setServers = function (value) {
        //-- Convert abstract(<transport::CASServer>) from js(CASServer) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var servers_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("servers");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, servers_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CASInstance)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#servers", "(MONITORED_VECTOR<transport::CASServer>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = CASInstance;
});
