sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "sas/ltjs/transport/models/media/cas/CASColumnItem"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CASColumn = ltjsEnvironment_1.createModule([114, 13, 50265, 50032], EventDispatcher_1.default);
    /**
     *
     */
    CASColumn._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CASColumn_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CASColumn)", "static", "new", "-->", "(transport::CASColumn)", rc);
        return rc;
    };
    /**
     * @return {CASColumnItem| null}
     */
    CASColumn.prototype.getDetails = function () {
        var details_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("details");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), details_jni);
        //-- Convert abstract(transport::CASColumnItem) from jni(size_t) to js(CASColumnItem)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CASColumn)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#details", "-->", "(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {CASColumnItem| null} value
     *
     */
    CASColumn.prototype.setDetails = function (value) {
        //-- Convert abstract(transport::CASColumnItem) from js(CASColumnItem) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var details_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("details");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, details_name_jni);
        Module.deps['TraceUtil'].log("(transport::CASColumn)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#details", "(transport::CASColumnItem)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    exports.default = CASColumn;
});
